/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantProbability;
import dk.aau.cs.model.tapn.ConstantWeight;
import dk.aau.cs.model.tapn.Probability;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.Weight;
import dk.aau.cs.util.StringComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tapaal.gui.petrinet.undo.AddConstantEditCommand;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.gui.petrinet.undo.RemoveConstantEditCommand;
import net.tapaal.gui.petrinet.undo.UpdateConstantEditCommand;

public class ConstantStore {
    private List<Constant> constants = new ArrayList<Constant>();
    private int largest = -1;

    public ConstantStore() {
    }

    public ConstantStore(List<Constant> constants) {
        this.constants = constants;
    }

    public Collection<Constant> getConstants() {
        return this.constants;
    }

    public void buildConstraints(TimedArcPetriNetNetwork model) {
        for (Constant c : this.constants) {
            c.reset();
        }
        for (TimedArcPetriNet tapn : model.allTemplates()) {
            for (TimedPlace place : tapn.places()) {
                this.buildConstraints(place);
            }
            for (TimedTransition transition : tapn.transitions()) {
                this.buildConstraints(transition);
            }
            for (TimedInputArc inputArc : tapn.inputArcs()) {
                this.buildConstraints(inputArc);
            }
            for (TransportArc transArc : tapn.transportArcs()) {
                this.buildConstraints(transArc);
            }
            for (TimedInhibitorArc inhibArc : tapn.inhibitorArcs()) {
                this.buildConstraints(inhibArc);
            }
            for (TimedOutputArc outputArc : tapn.outputArcs()) {
                this.buildConstraints(outputArc);
            }
        }
    }

    private void buildConstraints(TimedPlace place) {
        TimeInvariant invariant = place.invariant();
        Bound bound = invariant.upperBound();
        if (bound instanceof ConstantBound) {
            ConstantBound cb = (ConstantBound)bound;
            if (this.containsConstantByName(cb.name())) {
                Constant constant = this.getConstantByName(cb.name());
                constant.setIsUsed(true);
                if (!invariant.isUpperNonstrict()) {
                    constant.setLowerBound(1);
                }
            } else {
                throw new RuntimeException("An undefined constant " + cb.name() + " was used in an invariant.");
            }
        }
        for (ColoredTimeInvariant cti : place.getCtiList()) {
            ConstantBound ctiCb;
            if (!(cti.upperBound() instanceof ConstantBound) || !this.containsConstantByName((ctiCb = (ConstantBound)cti.upperBound()).name())) continue;
            Constant ctiConstant = this.getConstantByName(ctiCb.name());
            ctiConstant.setIsUsed(true);
            if (cti.isUpperNonstrict()) continue;
            ctiConstant.setLowerBound(1);
        }
    }

    public void buildConstraints(TimedTransition transition) {
        Probability weight = transition.getWeight();
        if (weight instanceof ConstantProbability) {
            Constant constant = ((ConstantProbability)weight).constant();
            constant.setIsUsed(true);
        }
    }

    public boolean containsConstantByName(String name) {
        for (Constant c : this.constants) {
            if (!c.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Constant getConstantByName(String name) {
        for (Constant c : this.constants) {
            if (!c.name().equals(name)) continue;
            return c;
        }
        return null;
    }

    private void buildConstraints(TimedInputArc inputArc) {
        this.buildConstraintsFromTimeInterval(inputArc.interval());
        for (ColoredTimeInterval cti : inputArc.getColorTimeIntervals()) {
            this.buildConstraintsFromTimeInterval(cti);
        }
        this.buildConstraintsFromWeight(inputArc.getWeight());
    }

    private void buildConstraints(TransportArc transArc) {
        this.buildConstraintsFromTimeInterval(transArc.interval());
        for (ColoredTimeInterval cti : transArc.getColorTimeIntervals()) {
            this.buildConstraintsFromTimeInterval(cti);
        }
        this.buildConstraintsFromWeight(transArc.getWeight());
    }

    private void buildConstraints(TimedInhibitorArc inhibArc) {
        this.buildConstraintsFromTimeInterval(inhibArc.interval());
        this.buildConstraintsFromWeight(inhibArc.getWeight());
    }

    private void buildConstraints(TimedOutputArc outputArc) {
        this.buildConstraintsFromWeight(outputArc.getWeight());
    }

    private void buildConstraintsFromTimeInterval(TimeInterval interval) {
        int diff;
        Bound lower = interval.lowerBound();
        Bound upper = interval.upperBound();
        int n = diff = interval.isLowerBoundNonStrict() && interval.isUpperBoundNonStrict() ? 0 : 1;
        if (lower instanceof ConstantBound && upper instanceof ConstantBound) {
            Constant lowerConstant = this.getConstantByName(((ConstantBound)lower).name());
            Constant upperConstant = this.getConstantByName(((ConstantBound)upper).name());
            lowerConstant.setIsUsed(true);
            upperConstant.setIsUsed(true);
            if (!lower.equals(upper)) {
                if (lowerConstant.value() + diff > upperConstant.lowerBound()) {
                    upperConstant.setLowerBound(lowerConstant.value() + diff);
                }
                if (upperConstant.value() - diff < lowerConstant.upperBound()) {
                    lowerConstant.setUpperBound(upperConstant.value() - diff);
                }
            }
        } else if (lower instanceof ConstantBound) {
            Constant lowerConstant = this.getConstantByName(((ConstantBound)lower).name());
            lowerConstant.setIsUsed(true);
            if (upper.value() - diff < lowerConstant.upperBound()) {
                lowerConstant.setUpperBound(upper.value() - diff);
            }
        } else if (upper instanceof ConstantBound) {
            Constant upperConstant = this.getConstantByName(((ConstantBound)upper).name());
            upperConstant.setIsUsed(true);
            if (lower.value() + diff > upperConstant.lowerBound()) {
                upperConstant.setLowerBound(lower.value() + diff);
            }
        }
    }

    private void buildConstraintsFromWeight(Weight weight) {
        Constant weightConstant;
        if (weight instanceof ConstantWeight && (weightConstant = this.getConstantByName(((ConstantWeight)weight).constant().name())).lowerBound() < 1) {
            weightConstant.setIsUsed(true);
            weightConstant.setLowerBound(1);
        }
    }

    public Command addConstant(String name, int val) {
        if (this.isNameInf(name)) {
            return null;
        }
        if (!this.containsConstantByName(name)) {
            Constant c = new Constant(name, val);
            this.add(c);
            return new AddConstantEditCommand(c, this);
        }
        return null;
    }

    public void add(Constant constant) {
        if (!this.containsConstantByName(constant.name())) {
            this.constants.add(constant);
            if (constant.value() > this.largest) {
                this.largest = constant.value();
            }
        }
    }

    public Command removeConstant(String name) {
        if (!this.isConstantInUse(name) && this.containsConstantByName(name)) {
            Constant c = this.getConstantByName(name);
            this.remove(c);
            this.findLargestConstantValue();
            return new RemoveConstantEditCommand(c, this);
        }
        return null;
    }

    public boolean isConstantInUse(String name) {
        if (this.containsConstantByName(name)) {
            return this.getConstantByName(name).isUsed();
        }
        return false;
    }

    public void remove(Constant constant) {
        this.constants.remove(constant);
        this.findLargestConstantValue();
    }

    private void findLargestConstantValue() {
        this.largest = -1;
        for (Constant c : this.constants) {
            if (c.value() <= this.largest) continue;
            this.largest = c.value();
        }
    }

    public int getLargestConstantValue() {
        return this.largest;
    }

    private boolean isNameInf(String name) {
        return name.equals("inf");
    }

    public Command updateConstant(String oldName, Constant updatedConstant, TimedArcPetriNetNetwork model) {
        if ((oldName.equals(updatedConstant.name()) || !this.containsConstantByName(updatedConstant.name())) && this.containsConstantByName(oldName)) {
            Constant old = this.getConstantByName(oldName);
            updatedConstant.setLowerBound(old.lowerBound());
            updatedConstant.setUpperBound(old.upperBound());
            updatedConstant.setIsUsed(old.isUsed());
            int index = this.constants.indexOf(old);
            this.constants.remove(old);
            this.constants.add(index, updatedConstant);
            this.findLargestConstantValue();
            return new UpdateConstantEditCommand(old, updatedConstant, this, model);
        }
        return null;
    }

    public Set<String> getConstantNames() {
        HashSet<String> names = new HashSet<String>();
        for (Constant c : this.constants) {
            names.add(c.name());
        }
        return names;
    }

    public void swapConstants(int currentIndex, int newIndex) {
        Constant temp = this.constants.get(currentIndex);
        this.constants.set(currentIndex, this.constants.get(newIndex));
        this.constants.set(newIndex, temp);
    }

    public Constant[] sortConstants() {
        Constant[] oldOrder = this.constants.toArray(new Constant[0]);
        this.constants.sort(new StringComparator());
        return oldOrder;
    }

    public void undoSort(Constant[] oldOrder) {
        this.constants.clear();
        this.constants.addAll(Arrays.asList(oldOrder));
    }

    public void clear() {
        this.constants.clear();
        this.largest = -1;
    }

    public Constant getConstantByIndex(int index) {
        return this.constants.get(index);
    }

    public int getIndexOf(Constant constant) {
        return this.constants.indexOf(constant);
    }
}

