/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.util.Require;
import java.util.regex.Pattern;

public class Constant {
    private static final Pattern namePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private String name;
    private int value;
    private int lowerBound;
    private int upperBound;
    private boolean isUsed;
    private boolean isFocused;
    private boolean visible = true;

    public Constant(String name, int value) {
        this.setName(name);
        this.setValue(value);
        this.setIsUsed(false);
        this.setFocused(false);
        this.reset();
    }

    public Constant(Constant constant) {
        Require.that(constant != null, "Constant cannot be null");
        this.name = constant.name;
        this.value = constant.value;
        this.lowerBound = constant.lowerBound;
        this.upperBound = constant.upperBound;
        this.isUsed = constant.isUsed;
        this.isFocused = constant.isFocused;
    }

    public void setName(String newName) {
        Require.that(newName != null && !newName.isEmpty(), "A constant must have a name");
        Require.that(this.isValid(newName), "name must match regular expression [a-zA-Z_][a-zA-Z0-9_]*");
        this.name = newName;
    }

    private boolean isValid(String newName) {
        return namePattern.matcher(newName).matches();
    }

    public boolean hasFocus() {
        return this.isFocused;
    }

    public void setFocused(boolean focused) {
        this.isFocused = focused;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public String name() {
        return this.name;
    }

    public void setValue(int value) {
        Require.that(value >= 0, "value must be non-negative");
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public int lowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(int value) {
        if (value > this.lowerBound) {
            this.lowerBound = value;
        }
    }

    public int upperBound() {
        return this.upperBound;
    }

    public void setUpperBound(int value) {
        if (value >= 0 && value < this.upperBound) {
            this.upperBound = value;
        }
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void setIsUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public void reset() {
        this.lowerBound = 0;
        this.upperBound = Integer.MAX_VALUE;
        this.isUsed = false;
    }

    public Constant copy() {
        return new Constant(this);
    }

    public String toString() {
        return this.name + " = " + this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Constant)) {
            return false;
        }
        Constant other = (Constant)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

