/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.NTA.trace;

import dk.aau.cs.model.NTA.trace.SymbolicState;
import dk.aau.cs.model.NTA.trace.TAFiringAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UppaalTrace
implements Iterable<TAFiringAction> {
    private final List<TAFiringAction> firingActions = new ArrayList<TAFiringAction>();
    private final List<SymbolicState> states = new ArrayList<SymbolicState>();

    public void addState(SymbolicState state) {
        this.states.add(state);
    }

    public void addFiringAction(TAFiringAction action) {
        this.firingActions.add(action);
    }

    @Override
    @NotNull
    public Iterator<TAFiringAction> iterator() {
        return this.firingActions.iterator();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Trace:\n");
        for (int i = 0; i < this.states.size() - 1; ++i) {
            buffer.append(this.states.get(i).toString());
            buffer.append("\n\n");
            buffer.append(this.firingActions.get(i).toString());
            buffer.append("\n\n");
        }
        buffer.append(this.states.get(this.states.size() - 1).toString());
        return buffer.toString();
    }

    public int length() {
        return this.firingActions.size();
    }

    public int numberOfStates() {
        return this.states.size();
    }

    public boolean isEmpty() {
        return this.length() == 0 && this.numberOfStates() == 0;
    }

    public List<SymbolicState> getStates() {
        return this.states;
    }

    public boolean isConcreteTrace() {
        for (SymbolicState state : this.states) {
            if (state.isConcreteState()) continue;
            return false;
        }
        return true;
    }
}

