/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.NTA;

import dk.aau.cs.model.NTA.Edge;
import dk.aau.cs.model.NTA.Location;
import java.util.ArrayList;

public class TimedAutomaton {
    private ArrayList<Edge> transitions = new ArrayList();
    private ArrayList<Location> locations = new ArrayList();
    private String declarations = "";
    private String parameters = "";
    private String name = "";
    private Location initialLocation;

    public TimedAutomaton() {
    }

    public TimedAutomaton(String name, ArrayList<Edge> transitions, ArrayList<Location> locations, Location initLocation, String parameters) {
        this(name, transitions, locations, initLocation);
        this.parameters = parameters;
    }

    public TimedAutomaton(String name, ArrayList<Edge> transitions, ArrayList<Location> locations, Location initLocation) {
        this.name = name;
        this.transitions = transitions;
        this.locations = locations;
        this.initialLocation = initLocation;
    }

    public Location getInitLocation() {
        return this.initialLocation;
    }

    public void setInitLocation(Location initLocation) {
        this.initialLocation = initLocation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public ArrayList<Edge> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(ArrayList<Edge> transitions) {
        this.transitions = transitions;
    }

    public ArrayList<Location> getLocations() {
        return this.locations;
    }

    public void setLocations(ArrayList<Location> locations) {
        this.locations = locations;
    }

    public String getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(String declarations) {
        this.declarations = declarations;
    }

    public void addLocation(Location l) {
        this.locations.add(l);
    }

    public void addTransition(Edge e) {
        this.transitions.add(e);
    }

    public StringBuffer toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<template>\n");
        res.append("<name x=\"5\" y=\"5\">" + this.name + "</name>\n");
        if (!this.parameters.equals("")) {
            res.append("<parameter>" + this.parameters + "</parameter>\n");
        }
        if (!this.declarations.equals("")) {
            res.append("<declaration>" + this.declarations + "</declaration>\n");
        }
        StringBuffer a = new StringBuffer();
        for (Location l : this.locations) {
            a = l.toXML();
            res.append(a);
        }
        res.append("<init ref=\"a" + this.initialLocation.getID() + "\" />\n");
        for (Edge t : this.transitions) {
            a = t.toXML();
            res.append(a);
        }
        res.append("</template>\n");
        return res;
    }
}

