/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import java.util.HashMap;
import java.util.Vector;

public class ProductType
extends ColorType {
    private Vector<ColorType> constituents = new Vector();
    private final String name;
    private final HashMap<Vector<Color>, Color> colorCache = new HashMap();

    @Override
    public Integer size() {
        return this.constituents.size();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ProductType)) {
            return false;
        }
        ProductType object = (ProductType)o;
        if (!object.name.equals(this.name)) {
            return false;
        }
        if (!object.size().equals(this.size())) {
            return false;
        }
        for (int i = 0; i < this.constituents.size(); ++i) {
            if (this.constituents.get(i).equals(object.constituents.get(i))) continue;
            return false;
        }
        return true;
    }

    public ProductType(String name) {
        super(name);
        this.name = name;
    }

    public boolean contains(ColorType colorType) {
        for (ColorType ct : this.constituents) {
            if (!ct.equals(colorType)) continue;
            return true;
        }
        return false;
    }

    public Vector<ColorType> getColorTypes() {
        return this.constituents;
    }

    public void addType(ColorType colortype) {
        this.constituents.add(colortype);
    }

    @Override
    public void addColor(String colorName) {
        assert (false);
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder("<html>" + this.name + "<b> is </b> &lt;");
        for (ColorType element : this.constituents) {
            out.append(element.getName()).append(", ");
        }
        out = new StringBuilder(out.substring(0, out.length() - 2));
        out.append("&gt; </html>");
        return out.toString();
    }

    private int getConstituentCombinationSize() {
        int result = 1;
        for (ColorType ct : this.constituents) {
            result *= ct.size().intValue();
        }
        return result;
    }

    @Override
    public boolean contains(Color color) {
        Vector<Color> tupleColors = color.getTuple();
        if (tupleColors != null) {
            if (this.constituents.size() == tupleColors.size()) {
                for (int i = 0; i < this.constituents.size(); ++i) {
                    if (this.constituents.elementAt(i).contains(tupleColors.elementAt(i))) continue;
                    return false;
                }
                return true;
            }
        } else {
            for (ColorType ct : this.constituents) {
                if (!ct.contains(color)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Vector<Color> getColors() {
        if (this.getConstituentCombinationSize() != this.colorCache.size()) {
            Vector tupleColors = new Vector();
            for (ColorType colorType : this.constituents) {
                if (tupleColors.isEmpty()) {
                    for (Color color : colorType.getColors()) {
                        Vector<Color> tupleColor = new Vector<Color>();
                        tupleColor.add(color);
                        tupleColors.add(tupleColor);
                    }
                    continue;
                }
                Vector newTupleColors = new Vector();
                for (Color color : colorType.getColors()) {
                    for (Vector vector : tupleColors) {
                        Vector<Color> newTupleColor = new Vector<Color>(vector);
                        newTupleColor.add(color);
                        newTupleColors.add(newTupleColor);
                    }
                }
                tupleColors = newTupleColors;
            }
            for (Vector vector : tupleColors) {
                this.colorCache.putIfAbsent(vector, new Color((ColorType)this, (Integer)0, vector));
            }
        }
        return new Vector<Color>(this.colorCache.values());
    }

    public boolean containsTypes(Vector<ColorType> colorTypes) {
        if (this.constituents.equals(colorTypes)) {
            return true;
        }
        boolean containsType = false;
        for (ColorType constituent : this.constituents) {
            for (ColorType ct : colorTypes) {
                if (!constituent.getName().equals(ct.getName())) continue;
                containsType = true;
                break;
            }
            if (containsType) continue;
            return false;
        }
        return true;
    }

    public Color getColor(Vector<Color> colors) {
        Color result = this.colorCache.get(colors);
        if (result == null) {
            result = new Color((ColorType)this, (Integer)0, colors);
            this.colorCache.put(colors, result);
        }
        return result;
    }

    @Override
    public Color getFirstColor() {
        Vector<Color> colors = new Vector<Color>();
        for (ColorType ct : this.constituents) {
            colors.add(ct.getFirstColor());
        }
        return this.getColor(colors);
    }

    public Vector<ColorType> getConstituents() {
        return this.constituents;
    }

    public void setConstituents(Vector<ColorType> constituents) {
        this.constituents = constituents;
    }

    public void replaceColorType(ColorType newColorType, ColorType oldColorType) {
        boolean changed = false;
        for (ColorType ct : this.constituents) {
            if (!ct.equals(oldColorType)) continue;
            int index = this.constituents.indexOf(ct);
            this.constituents.set(index, newColorType);
            changed = true;
        }
        if (changed) {
            this.colorCache.clear();
        }
    }

    @Override
    public ColorExpression createColorExpressionForFirstColor() {
        Vector<ColorExpression> tempVec = new Vector<ColorExpression>();
        for (ColorType colorType : this.getColorTypes()) {
            tempVec.add(colorType.createColorExpressionForFirstColor());
        }
        return new TupleExpression(tempVec, this);
    }
}

