/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.SuccessorExpression;
import dk.aau.cs.model.CPN.Variable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class PredecessorExpression
extends ColorExpression {
    private final ColorExpression color;

    public ColorExpression getPredecessorExpression() {
        return this.color;
    }

    public PredecessorExpression(ColorExpression color) {
        super(color.colorType);
        this.color = color;
    }

    @Override
    public List<Color> eval(ExpressionContext context) {
        return Collections.singletonList(this.color.eval(context).get(0).predecessor());
    }

    @Override
    public boolean containsColor(Color color) {
        return this.color.containsColor(color);
    }

    @Override
    public ColorExpression updateColor(Color color, ColorType newColorType) {
        ColorExpression expr = this.color.updateColor(color, newColorType);
        if (expr != null) {
            return new SuccessorExpression(expr);
        }
        return null;
    }

    @Override
    public boolean hasVariable(List<Variable> variables) {
        return this.color.hasVariable(variables);
    }

    @Override
    public ColorExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (this.equals(object1) && object2 instanceof ColorExpression) {
            ColorExpression obj2 = (ColorExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        return new PredecessorExpression(this.color.replace(object1, object2));
    }

    @Override
    public ColorExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public ColorExpression copy() {
        return new PredecessorExpression(this.color);
    }

    @Override
    public ColorExpression deepCopy() {
        return new PredecessorExpression(this.color.deepCopy());
    }

    @Override
    public boolean containsPlaceHolder() {
        return this.color.containsPlaceHolder();
    }

    @Override
    public ColorExpression findFirstPlaceHolder() {
        return this.color.findFirstPlaceHolder();
    }

    @Override
    public void getValues(ExprValues exprValues) {
        this.color.getValues(exprValues);
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        this.color.getVariables(variables);
    }

    public String toString() {
        return this.color.toString() + "--";
    }

    @Override
    public ExprStringPosition[] getChildren() {
        ExprStringPosition pos = new ExprStringPosition(0, this.color.toString().length(), this.color);
        return new ExprStringPosition[]{pos};
    }

    @Override
    public boolean isSimpleProperty() {
        return false;
    }

    @Override
    public boolean isComparable(ColorExpression otherExpr) {
        return this.color.isComparable(otherExpr);
    }

    @Override
    public ColorExpression getBottomColorExpression() {
        return this.color.getBottomColorExpression();
    }

    @Override
    public Vector<ColorType> getColorTypes() {
        return this.color.getColorTypes();
    }

    @Override
    public ColorExpression getExprWithNewColorType(ColorType ct) {
        return new PredecessorExpression(this.color.getExprWithNewColorType(ct));
    }
}

