/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Variable;
import java.util.Set;

public class OrExpression
extends GuardExpression {
    private GuardExpression left;
    private GuardExpression right;
    private boolean isSimpleProperty;
    private String word = "or";

    public OrExpression(GuardExpression left, GuardExpression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean containsColor(Color color) {
        return this.left.containsColor(color) || this.right.containsColor(color);
    }

    public GuardExpression getLeftExpression() {
        return this.left;
    }

    public GuardExpression getRightExpression() {
        return this.right;
    }

    @Override
    public boolean isSimpleProperty() {
        return this.isSimpleProperty;
    }

    public void setSimpleProperty(boolean isSimpleProperty) {
        this.isSimpleProperty = isSimpleProperty;
    }

    @Override
    public ExprStringPosition[] getChildren() {
        ExprStringPosition pos;
        int end;
        ExprStringPosition[] children = new ExprStringPosition[2];
        int start = this.isSimpleProperty ? 0 : 1;
        int endPrev = end = start + this.left.toString().length();
        children[0] = pos = new ExprStringPosition(start, end, this.left);
        start = endPrev + 4;
        end = start + this.right.toString().length();
        children[1] = pos = new ExprStringPosition(start, end, this.right);
        return children;
    }

    public boolean equals(Object o) {
        if (o instanceof OrExpression) {
            OrExpression expr = (OrExpression)o;
            return this.left.equals(expr.left) && this.right.equals(expr.right);
        }
        return false;
    }

    @Override
    public GuardExpression copy() {
        OrExpression copy = new OrExpression(this.left, this.right);
        copy.setSimpleProperty(this.isSimpleProperty());
        return copy;
    }

    @Override
    public GuardExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (this == object1 && object2 instanceof GuardExpression) {
            GuardExpression ge = (GuardExpression)object2;
            ge.setParent(this.parent);
            return ge;
        }
        this.left = this.left.replace(object1, object2, replaceAllInstances);
        this.right = this.right.replace(object1, object2, replaceAllInstances);
        return this;
    }

    @Override
    public GuardExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public boolean containsPlaceHolder() {
        return this.left.containsPlaceHolder() || this.right.containsPlaceHolder();
    }

    @Override
    public Expression findFirstPlaceHolder() {
        if (this.left.containsPlaceHolder()) {
            return this.left.findFirstPlaceHolder();
        }
        return this.right.findFirstPlaceHolder();
    }

    @Override
    public void getValues(ExprValues exprValues) {
        this.left.getValues(exprValues);
        this.right.getValues(exprValues);
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        this.left.getVariables(variables);
        this.right.getVariables(variables);
    }

    @Override
    public Boolean eval(ExpressionContext context) {
        return null;
    }

    public String toString() {
        String text = this.left.toString() + " " + this.word + " " + this.right.toString();
        return this.isSimpleProperty ? text : "(" + text + ")";
    }

    public String getWord() {
        return this.word;
    }
}

