/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Variable;
import java.util.Set;

public class NotExpression
extends GuardExpression {
    GuardExpression expr;

    public NotExpression(GuardExpression expr) {
        this.expr = expr;
        this.colorType = expr.getColorType();
    }

    public GuardExpression getExpression() {
        return this.expr;
    }

    @Override
    public boolean containsColor(Color color) {
        return this.expr.containsColor(color);
    }

    @Override
    public GuardExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (this == object1 && object2 instanceof GuardExpression) {
            GuardExpression obj2 = (GuardExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        this.expr = this.expr.replace(object1, object2, replaceAllInstances);
        this.colorType = this.expr.getColorType();
        return this;
    }

    @Override
    public GuardExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public GuardExpression copy() {
        return new NotExpression(this.expr);
    }

    @Override
    public boolean containsPlaceHolder() {
        return this.expr.containsPlaceHolder();
    }

    @Override
    public Expression findFirstPlaceHolder() {
        return this.expr.findFirstPlaceHolder();
    }

    @Override
    public void getValues(ExprValues exprValues) {
        this.expr.getValues(exprValues);
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        this.expr.getVariables(variables);
    }

    @Override
    public Boolean eval(ExpressionContext context) {
        return this.expr.eval(context) == false;
    }

    public String toString() {
        return "!(" + this.expr.toString() + ")";
    }

    @Override
    public ExprStringPosition[] getChildren() {
        int start = 2;
        int end = start + this.expr.toString().length();
        ExprStringPosition pos = new ExprStringPosition(start, end, this.expr);
        return new ExprStringPosition[]{pos};
    }

    @Override
    public boolean isSimpleProperty() {
        return false;
    }
}

