/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.Variable;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class DotConstantExpression
extends UserOperatorExpression {
    public DotConstantExpression() {
        super(ColorType.COLORTYPE_DOT.getFirstColor());
    }

    @Override
    public List<Color> eval(ExpressionContext context) {
        return Collections.singletonList(ColorType.COLORTYPE_DOT.getFirstColor());
    }

    @Override
    public boolean containsColor(Color color) {
        return color.getColorName().equals("dot");
    }

    @Override
    public ColorExpression updateColor(Color color, ColorType newColorType) {
        return this;
    }

    @Override
    public boolean hasVariable(List<Variable> variables) {
        return false;
    }

    @Override
    public ColorType getColorType() {
        return ColorType.COLORTYPE_DOT;
    }

    @Override
    public ColorExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public ColorExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (this == object1 && object2 instanceof ColorExpression) {
            ColorExpression obj2 = (ColorExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        return this;
    }

    @Override
    public ColorExpression copy() {
        return null;
    }

    @Override
    public DotConstantExpression deepCopy() {
        return new DotConstantExpression();
    }

    @Override
    public boolean containsPlaceHolder() {
        return false;
    }

    @Override
    public ColorExpression findFirstPlaceHolder() {
        return null;
    }

    @Override
    public void getValues(ExprValues exprValues) {
    }

    @Override
    public String toString() {
        return "dot";
    }

    @Override
    public boolean isComparable(ColorExpression otherExpr) {
        otherExpr = otherExpr.getBottomColorExpression();
        return otherExpr instanceof DotConstantExpression;
    }

    @Override
    public ColorExpression getBottomColorExpression() {
        return this;
    }

    @Override
    public Vector<ColorType> getColorTypes() {
        return new Vector<ColorType>(Collections.singletonList(this.colorType));
    }

    @Override
    public ColorExpression getExprWithNewColorType(ColorType ct) {
        return this.deepCopy();
    }
}

