/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Variable;
import java.util.Set;

public class AndExpression
extends GuardExpression {
    private GuardExpression left;
    private GuardExpression right;
    private boolean isSimpleProperty;
    private String word = "and";

    public AndExpression(GuardExpression left, GuardExpression right) {
        this.left = left;
        this.right = right;
    }

    public GuardExpression getLeftExpression() {
        return this.left;
    }

    public GuardExpression getRightExpression() {
        return this.right;
    }

    @Override
    public GuardExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public GuardExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (this == object1 && object2 instanceof GuardExpression) {
            GuardExpression obj2 = (GuardExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        this.left = this.left.replace(object1, object2, replaceAllInstances);
        this.right = this.right.replace(object1, object2, replaceAllInstances);
        return this;
    }

    @Override
    public boolean containsPlaceHolder() {
        return this.left.containsPlaceHolder() || this.right.containsPlaceHolder();
    }

    @Override
    public Expression findFirstPlaceHolder() {
        if (this.left.containsPlaceHolder()) {
            return this.left.findFirstPlaceHolder();
        }
        if (this.right.containsPlaceHolder()) {
            return this.right.findFirstPlaceHolder();
        }
        return null;
    }

    @Override
    public void getValues(ExprValues exprValues) {
        this.left.getValues(exprValues);
        this.right.getValues(exprValues);
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        this.left.getVariables(variables);
        this.right.getVariables(variables);
    }

    @Override
    public Boolean eval(ExpressionContext context) {
        return null;
    }

    @Override
    public boolean containsColor(Color color) {
        return this.left.containsColor(color) || this.right.containsColor(color);
    }

    @Override
    public boolean isSimpleProperty() {
        return this.isSimpleProperty;
    }

    public void setSimpleProperty(boolean isSimpleProperty) {
        this.isSimpleProperty = isSimpleProperty;
    }

    @Override
    public ExprStringPosition[] getChildren() {
        ExprStringPosition pos;
        int end;
        ExprStringPosition[] children = new ExprStringPosition[2];
        int start = this.isSimpleProperty ? 0 : 1;
        int endPrev = end = start + this.left.toString().length();
        children[0] = pos = new ExprStringPosition(start, end, this.left);
        start = endPrev + 5;
        end = start + this.right.toString().length();
        children[1] = pos = new ExprStringPosition(start, end, this.right);
        return children;
    }

    public boolean equals(Object o) {
        if (o instanceof AndExpression) {
            AndExpression expr = (AndExpression)o;
            return this.left.equals(expr.left) && this.right.equals(expr.right);
        }
        return false;
    }

    @Override
    public GuardExpression copy() {
        AndExpression copy = new AndExpression(this.left, this.right);
        copy.setSimpleProperty(this.isSimpleProperty());
        return copy;
    }

    public String toString() {
        String text = this.left.toString() + " " + this.word + " " + this.right.toString();
        return this.isSimpleProperty ? text : "(" + text + ")";
    }

    public String getWord() {
        return this.word;
    }
}

