/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.util.Require;
import java.util.Set;
import java.util.Vector;

public class AddExpression
extends ArcExpression {
    private final Vector<ArcExpression> constituents;

    public AddExpression(ArcExpression left, ArcExpression right) {
        Require.notNull(left);
        Require.notNull(right);
        Vector<ArcExpression> constituents = new Vector<ArcExpression>();
        constituents.add(left);
        constituents.add(right);
        this.constituents = constituents;
    }

    public AddExpression(Vector<ArcExpression> constituents) {
        Require.notNull(constituents);
        Require.that(constituents.size() > 0, "Constituents can't be empty");
        Require.notNull(constituents, "Constituents can not container null");
        this.constituents = constituents;
    }

    public AddExpression(AddExpression otherExpr) {
        super(otherExpr);
        Vector<ArcExpression> constituents = otherExpr.constituents;
        Require.notNull(constituents);
        Require.that(constituents.size() > 0, "Constituents can't be empty");
        Require.notNull(constituents, "Constituents can not container null");
        this.constituents = new Vector<ArcExpression>(otherExpr.constituents);
    }

    public Vector<ArcExpression> getAddExpression() {
        return this.constituents;
    }

    @Override
    public ColorMultiset eval(ExpressionContext context) {
        ColorMultiset result = null;
        for (ArcExpression constituent : this.constituents) {
            if (result == null) {
                result = constituent.eval(context);
                continue;
            }
            ColorMultiset cm = constituent.eval(context);
            if (constituent instanceof NumberOfExpression) {
                result.addAll(cm, ((NumberOfExpression)constituent).getColor(), ((NumberOfExpression)constituent).getNumber());
                continue;
            }
            result.addAll(cm, null, 1);
        }
        assert (result != null);
        return result;
    }

    @Override
    public Integer weight() {
        Integer res = 0;
        for (ArcExpression element : this.constituents) {
            res = res + element.weight();
        }
        return res;
    }

    @Override
    public ArcExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public ArcExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (object1 == this && object2 instanceof ArcExpression) {
            ArcExpression obj2 = (ArcExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        for (int i = 0; i < this.constituents.size(); ++i) {
            ArcExpression newConstituent = this.constituents.get(i).replace(object1, object2, replaceAllInstances);
            this.constituents.set(i, newConstituent);
            newConstituent.setParent(this);
        }
        return this;
    }

    @Override
    public ArcExpression copy() {
        return new AddExpression(this.constituents);
    }

    @Override
    public ArcExpression deepCopy() {
        Vector<ArcExpression> constituentsCopy = new Vector<ArcExpression>();
        for (ArcExpression expr : this.constituents) {
            constituentsCopy.add(expr.deepCopy());
        }
        AddExpression copy = new AddExpression(constituentsCopy);
        copy.setParent(this.parent);
        return copy;
    }

    @Override
    public boolean containsPlaceHolder() {
        for (ArcExpression constituent : this.constituents) {
            if (!constituent.containsPlaceHolder()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression findFirstPlaceHolder() {
        for (ArcExpression constituent : this.constituents) {
            if (!constituent.containsPlaceHolder()) continue;
            return constituent.findFirstPlaceHolder();
        }
        return null;
    }

    @Override
    public void getValues(ExprValues exprValues) {
        for (ArcExpression constituent : this.constituents) {
            constituent.getValues(exprValues);
        }
    }

    @Override
    public boolean isSimpleProperty() {
        return false;
    }

    @Override
    public ExprStringPosition[] getChildren() {
        ExprStringPosition[] children = new ExprStringPosition[this.constituents.size()];
        int currentPosition = this.addParentheses() ? 1 : 0;
        for (int i = 0; i < this.constituents.size(); ++i) {
            ArcExpression constituent = this.constituents.get(i);
            if (i > 0) {
                currentPosition += 3;
            }
            int constituentEnd = currentPosition + constituent.toString().length();
            children[i] = new ExprStringPosition(currentPosition, constituentEnd, constituent);
            currentPosition = constituentEnd;
        }
        return children;
    }

    public boolean equals(Object o) {
        if (o instanceof AddExpression) {
            AddExpression expr = (AddExpression)o;
            return this.constituents.equals(expr.constituents);
        }
        return false;
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        for (ArcExpression element : this.constituents) {
            element.getVariables(variables);
        }
    }

    @Override
    public boolean containsColor(Color color) {
        for (ArcExpression c : this.constituents) {
            if (!c.containsColor(color)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder res = new StringBuilder((String)(this.addParentheses() ? "(" + this.constituents.get(0).toString() : this.constituents.get(0).toString()));
        for (int i = 1; i < this.constituents.size(); ++i) {
            res.append(" + ").append(this.constituents.get(i).toString());
        }
        return this.addParentheses() ? res.append(")").toString() : res.toString();
    }

    public String toTokenString() {
        StringBuilder res = new StringBuilder();
        for (ArcExpression constituent : this.constituents) {
            res.append(constituent.toString()).append("\n");
        }
        return res.toString();
    }

    @Override
    public AddExpression getExprWithNewColorType(ColorType ct) {
        Vector<ArcExpression> arcExpressions = new Vector<ArcExpression>();
        for (ArcExpression expr : this.constituents) {
            arcExpressions.add(expr.getExprWithNewColorType(ct));
        }
        return new AddExpression(arcExpressions);
    }

    @Override
    public ArcExpression getExprConverted(ColorType oldCt, ColorType newCt) {
        Vector<ArcExpression> arcExpressions = new Vector<ArcExpression>();
        for (ArcExpression expr : this.constituents) {
            arcExpressions.add(expr.getExprConverted(oldCt, newCt));
        }
        return new AddExpression(arcExpressions);
    }
}

