/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.ConstantsParser;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.ConstantsParser.ConstantsParserConstants;
import dk.aau.cs.model.CPN.ConstantsParser.ConstantsParserTokenManager;
import dk.aau.cs.model.CPN.ConstantsParser.ParseException;
import dk.aau.cs.model.CPN.ConstantsParser.SimpleCharStream;
import dk.aau.cs.model.CPN.ConstantsParser.Token;
import dk.aau.cs.model.CPN.ConstantsParser.TokenMgrError;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import pipe.gui.TAPAALGUI;

public class ConstantsParser
implements ConstantsParserConstants {
    private static final Map<String, Constant> constants = new LinkedHashMap<String, Constant>();
    private static final Map<String, ColorType> colorTypes = new LinkedHashMap<String, ColorType>();
    private static final Map<String, Variable> variables = new LinkedHashMap<String, Variable>();
    private static TimedArcPetriNetNetwork network;
    public ConstantsParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static boolean parse(String constantsToParse, TimedArcPetriNetNetwork network) throws ParseException, TokenMgrError {
        ArrayList<String> messagesList;
        ConstantsParser.network = network;
        ConstantsParser parser = new ConstantsParser(new StringReader(constantsToParse));
        constants.clear();
        colorTypes.clear();
        variables.clear();
        parser.startParsing();
        List<Constant> constantsList = constants.values().stream().collect(Collectors.toList());
        List<ColorType> colorTypesList = colorTypes.values().stream().collect(Collectors.toList());
        List<Variable> variablesList = variables.values().stream().collect(Collectors.toList());
        ColorType dot = new ColorType("dot");
        dot.addColor("dot");
        colorTypesList.add(0, dot);
        HashMap<String, Object> constantsMap = new HashMap<String, Object>();
        HashMap<String, Boolean> canBeRemovedBitMap = new HashMap<String, Boolean>();
        HashMap messages = new HashMap();
        for (Constant c : network.constants()) {
            constantsMap.put(c.name(), c);
            canBeRemovedBitMap.put(c.name(), !network.getConstantStore().isConstantInUse(c.name()));
        }
        for (ColorType ct : network.colorTypes()) {
            messagesList = new ArrayList<String>();
            constantsMap.put(ct.getName(), ct);
            canBeRemovedBitMap.put(ct.getName(), network.canColorTypeBeRemoved(ct, messagesList));
            messages.put(ct.getName(), messagesList);
        }
        for (Variable v : network.variables()) {
            messagesList = new ArrayList();
            constantsMap.put(v.getName(), v);
            boolean canBeEdited = true;
            if (variables.containsKey(v.getName())) {
                ColorType ct = variables.get(v.getName()).getColorType();
                canBeEdited = ct.equals(v.getColorType());
            }
            canBeRemovedBitMap.put(v.getName(), network.canVariableBeRemoved(v, messagesList) && canBeEdited);
            messages.put(v.getName(), messagesList);
        }
        for (String key : canBeRemovedBitMap.keySet()) {
            Object obj;
            ColorType ct;
            if (constants.containsKey(key) || variables.containsKey(key) && ((Boolean)canBeRemovedBitMap.get(key)).booleanValue() || key.equals("dot")) continue;
            if (variables.containsKey(key) && !((Boolean)canBeRemovedBitMap.get(key)).booleanValue()) {
                boolean skip = false;
                for (Variable v : network.variables()) {
                    if (!v.getName().equals(key)) continue;
                    skip = v.getColorType().getName().equals(variables.get(key).getColorType().getName());
                    break;
                }
                if (skip) {
                    continue;
                }
            } else if (colorTypes.containsKey(key)) {
                if (colorTypes.get(key).equals(constantsMap.get(key))) continue;
                ColorType newCt = colorTypes.get(key);
                ct = (ColorType)constantsMap.get(key);
                if (ct instanceof ProductType) {
                    boolean isSimiliar;
                    ProductType pct = (ProductType)ct;
                    ProductType newPct = (ProductType)newCt;
                    boolean bl = isSimiliar = pct.getProductColorTypes().size() == newPct.getProductColorTypes().size() && pct.containsTypes(newPct.getColorTypes());
                    if (isSimiliar) {
                        ConstantsParser.updateColorTypes(pct, newPct);
                        continue;
                    }
                } else {
                    ArrayList<Color> removedColors = new ArrayList<Color>();
                    for (Color color : ct.getColors()) {
                        if (newCt.contains(color)) continue;
                        removedColors.add(color);
                    }
                    int removeableColors = 0;
                    for (Color c : removedColors) {
                        ArrayList<String> newMessagesList;
                        boolean colorCanBeRemoved = network.canColorBeRemoved(c, newMessagesList = new ArrayList<String>());
                        if (colorCanBeRemoved) {
                            ++removeableColors;
                            continue;
                        }
                        ArrayList<String> messagesList2 = new ArrayList<String>();
                        messagesList2.addAll(newMessagesList);
                        messages.put(key, messagesList2);
                    }
                    if (removeableColors >= removedColors.size()) {
                        ConstantsParser.updateColorTypes(ct, newCt);
                        continue;
                    }
                }
            }
            if ((obj = constantsMap.get(key)) instanceof ColorType) {
                ct = (ColorType)obj;
                boolean allDependentVariablesBeingRemoved = true;
                for (Variable v : network.variables()) {
                    if (!v.getColorType().equals(ct) || !variables.containsKey(v.getName())) continue;
                    allDependentVariablesBeingRemoved = false;
                    break;
                }
                if (allDependentVariablesBeingRemoved) {
                    boolean isUsedInPlace = false;
                    for (TimedArcPetriNet tapn : network.allTemplates()) {
                        for (TimedPlace place : tapn.places()) {
                            if (!place.getColorType().getName().equals(ct.getName())) continue;
                            isUsedInPlace = true;
                            break;
                        }
                        if (!isUsedInPlace) continue;
                        break;
                    }
                    if (!isUsedInPlace) continue;
                }
            }
            if (((Boolean)canBeRemovedBitMap.get(key)).booleanValue()) continue;
            Object message = "Could not ";
            Object title = "Could not ";
            if (obj instanceof ColorType && colorTypes.containsKey(key) || obj instanceof Variable && variables.containsKey(key)) {
                message = (String)message + "modify ";
                title = (String)title + "modify constant";
            } else {
                message = (String)message + "remove ";
                title = (String)title + "remove constant";
            }
            message = obj instanceof ColorType ? (String)message + "color type" : (obj instanceof Variable ? (String)message + "variable" : (String)message + "constant");
            message = (String)message + " \"" + key + "\"";
            if (!(obj instanceof Constant)) {
                message = (String)message + " for the following reasons:  \n\n";
                message = (String)message + String.join((CharSequence)"", (Iterable)messages.get(key));
            } else {
                message = (String)message + " because it is in use";
            }
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message, (String)title, 2);
            return false;
        }
        network.getConstantStore().clear();
        network.setConstants(constantsList);
        if (network.isColored()) {
            network.setColorTypes(colorTypesList);
            network.setVariables(variablesList);
        }
        return true;
    }

    private static void idExists(String id) throws ParseException {
        if (id.equals("dot")) {
            throw new ParseException("Name \"dot\" is reserved");
        }
        if (constants.containsKey(id)) {
            throw new ParseException("Constant with name \"" + id + "\" already exists");
        }
        if (colorTypes.containsKey(id)) {
            throw new ParseException("Color type with name \"" + id + "\" already exists");
        }
        if (variables.containsKey(id)) {
            throw new ParseException("Variable with name \"" + id + "\" already exists");
        }
        for (ColorType ct : colorTypes.values()) {
            for (Color c : ct.getColors()) {
                if (!c.getName().equals(id)) continue;
                throw new ParseException("The name \"" + id + "\" is already used as a color in type \"" + ct.getName() + "\"");
            }
        }
    }

    private static Expression updateGuardTypes(Expression expr, ColorType oldCt, ColorType newCt) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof UserOperatorExpression) {
            UserOperatorExpression uoe = (UserOperatorExpression)expr;
            if (uoe.getUserOperator().getColorType().getName().equals(oldCt.getName())) {
                return uoe.getExprWithNewColorType(newCt);
            }
            return expr;
        }
        Expression result = expr;
        for (ExprStringPosition pos : expr.getChildren()) {
            Expression child = pos.getObject();
            Expression updatedChild = ConstantsParser.updateGuardTypes(child, oldCt, newCt);
            if (updatedChild == child) continue;
            result = result.replace(child, updatedChild);
        }
        return result;
    }

    private static Color getNewColor(Color oldColor, ColorType newCt) {
        if (newCt instanceof ProductType) {
            ProductType newPt = (ProductType)newCt;
            if (oldColor.getTuple() == null) {
                return null;
            }
            Vector<Color> newTupleColors = new Vector<Color>();
            Vector<ColorType> newConstituents = newPt.getColorTypes();
            Vector<Color> oldTupleColors = oldColor.getTuple();
            if (newConstituents.size() != oldTupleColors.size()) {
                return null;
            }
            for (int i = 0; i < oldTupleColors.size(); ++i) {
                Color componentColor = ConstantsParser.getNewColor(oldTupleColors.get(i), newConstituents.get(i));
                if (componentColor == null) {
                    return null;
                }
                newTupleColors.add(componentColor);
            }
            return newPt.getColor(newTupleColors);
        }
        return newCt.getColorByName(oldColor.getColorName());
    }

    private static void updateColorTypes(ColorType ct, ColorType newCt) {
        for (TimedArcPetriNet tapn : network.allTemplates()) {
            for (TimedPlace timedPlace : tapn.places()) {
                ColorMultiset cm;
                ArcExpression expression;
                if (timedPlace.getColorType().equals(ct)) {
                    if (timedPlace.getTokensAsExpression() != null) {
                        timedPlace.setTokenExpression(timedPlace.getTokensAsExpression().getExprConverted(ct, newCt));
                    }
                    ArrayList<TimedToken> oldTokens = new ArrayList<TimedToken>(timedPlace.tokens());
                    timedPlace.setColorType(newCt);
                    for (TimedToken token : oldTokens) {
                        if (token.getColor() == null || !newCt.contains(token.getColor())) continue;
                        timedPlace.addToken(new TimedToken(timedPlace, token.age(), ConstantsParser.getNewColor(token.getColor(), newCt)));
                    }
                }
                if ((expression = timedPlace.getExprWithNewColorType(newCt)) != timedPlace.getTokensAsExpression() && (cm = expression.eval(network.getContext())) != null) {
                    ArrayList<TimedToken> tokensToAdd = new ArrayList<TimedToken>(timedPlace.tokens());
                    for (TimedToken token : cm.getTokens(timedPlace)) {
                        tapn.marking().remove(token);
                    }
                    timedPlace.updateTokens(tokensToAdd, expression);
                }
                ArrayList<ColoredTimeInvariant> invariantsToAdd = new ArrayList<ColoredTimeInvariant>();
                for (ColoredTimeInvariant invariant : timedPlace.getCtiList()) {
                    if (ct.contains(invariant.getColor())) {
                        invariantsToAdd.add(new ColoredTimeInvariant(invariant.isUpperNonstrict(), invariant.upperBound(), ConstantsParser.getNewColor(invariant.getColor(), newCt)));
                        continue;
                    }
                    invariantsToAdd.add(invariant);
                }
                timedPlace.setCtiList(invariantsToAdd);
            }
            for (TimedInputArc timedInputArc : tapn.inputArcs()) {
                if (timedInputArc.getArcExpression() == null) continue;
                timedInputArc.setExpression(timedInputArc.getArcExpression().getExprWithNewColorType(newCt));
            }
            for (TimedOutputArc timedOutputArc : tapn.outputArcs()) {
                if (timedOutputArc.getExpression() == null) continue;
                timedOutputArc.setExpression(timedOutputArc.getExpression().getExprWithNewColorType(newCt));
            }
            for (TimedTransition timedTransition : tapn.transitions()) {
                if (timedTransition.getGuard() == null) continue;
                Expression updatedGuardExpr = ConstantsParser.updateGuardTypes(timedTransition.getGuard(), ct, newCt);
                GuardExpression newGuard = (GuardExpression)updatedGuardExpr;
                newGuard.setColorType(newCt);
                timedTransition.setGuard(newGuard);
            }
        }
    }

    public final void startParsing() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.values();
            this.jj_consume_token(1);
        }
        this.jj_consume_token(0);
    }

    public final void values() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                this.constants();
                break;
            }
            case 12: {
                this.colorTypes();
                break;
            }
            case 11: {
                this.variables();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void constants() throws ParseException {
        this.jj_consume_token(10);
        Token id = this.jj_consume_token(16);
        this.jj_consume_token(2);
        Token value = this.jj_consume_token(15);
        ConstantsParser.idExists(id.image);
        constants.put(id.image, new Constant(id.image, Integer.parseInt(value.image)));
    }

    public final void colorTypes() throws ParseException {
        ArrayList<String> values = new ArrayList<String>();
        BoolRef isIntList = new BoolRef(false);
        BoolRef isProductList = new BoolRef(false);
        this.jj_consume_token(12);
        Token id = this.jj_consume_token(16);
        this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.idList(values);
                        break;
                    }
                    case 15: {
                        this.intList(values, isIntList);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(5);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                this.productList(values, isProductList);
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ColorType ct = null;
        if (!network.isColored()) {
            throw new ParseException("Color types are not allowed in uncolored networks");
        }
        ConstantsParser.idExists(id.image);
        if (isProductList.value) {
            ProductType pct = new ProductType(id.image);
            for (String product : values) {
                if (product.equals("dot")) {
                    ColorType dot = new ColorType("dot");
                    dot.addColor("dot");
                    pct.addType(dot);
                    continue;
                }
                if (!colorTypes.containsKey(product)) {
                    throw new ParseException("Color type with name \"" + product + "\" does not exist");
                }
                pct.addType(colorTypes.get(product));
            }
            ct = pct;
        } else if (isIntList.value) {
            int upperBound;
            ct = new ColorType(id.image);
            int lowerBound = Integer.parseInt((String)values.get(0));
            if (lowerBound > (upperBound = Integer.parseInt((String)values.get(1)))) {
                throw new ParseException("Lower bound must be lower than or equal to upper bound");
            }
            for (int i = lowerBound; i <= upperBound; ++i) {
                ct.addColor(Integer.toString(i));
            }
        } else {
            ct = new ColorType(id.image);
            HashSet<String> uniqueVals = new HashSet<String>();
            for (String color : values) {
                if (!isIntList.value && !uniqueVals.add(color)) {
                    throw new ParseException("Color type with name \"" + id.image + "\" contains duplicate colors");
                }
                if (color.equals(id.image)) {
                    throw new ParseException("Color type with name \"" + id.image + "\" contains a color with the same name");
                }
                ConstantsParser.idExists(color);
            }
            ct.addColors(values);
        }
        colorTypes.put(id.image, ct);
    }

    public final void idList(List<String> values) throws ParseException {
        Token id = this.jj_consume_token(16);
        values.add(id.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(3);
            id = this.jj_consume_token(16);
            values.add(id.image);
        }
    }

    public final void intList(List<String> values, BoolRef isIntList) throws ParseException {
        Token val = this.jj_consume_token(15);
        values.add(val.image);
        isIntList.value = true;
        this.jj_consume_token(3);
        val = this.jj_consume_token(15);
        values.add(val.image);
    }

    public final void productList(List<String> values, BoolRef isProductList) throws ParseException {
        Token type = this.jj_consume_token(16);
        values.add(type.image);
        isProductList.value = true;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(3);
            type = this.jj_consume_token(16);
            values.add(type.image);
        }
    }

    public final void variables() throws ParseException {
        ArrayList<String> ids = new ArrayList<String>();
        this.jj_consume_token(11);
        this.idList(ids);
        this.jj_consume_token(9);
        Token type = this.jj_consume_token(16);
        if (!network.isColored()) {
            throw new ParseException("Variables are not allowed in uncolored networks");
        }
        for (String id : ids) {
            ConstantsParser.idExists(id);
            if (type.image.equals("dot")) {
                throw new ParseException("Can not create a variable of color type \"dot\"");
            }
            if (!colorTypes.containsKey(type.image)) {
                throw new ParseException("Color type with name \"" + type.image + "\" does not exist");
            }
            variables.put(id, new Variable(id, colorTypes.get(type.image)));
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{7168, 7168, 98304, 80, 8, 8};
    }

    public ConstantsParser(InputStream stream) {
        this(stream, null);
    }

    public ConstantsParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ConstantsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConstantsParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ConstantsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ConstantsParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConstantsParser(ConstantsParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ConstantsParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[21];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 6; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 21; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ConstantsParser.jj_la1_init_0();
    }

    private static class BoolRef {
        public boolean value;

        public BoolRef(boolean value) {
            this.value = value;
        }
    }
}

