/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.TimeInvariant;
import java.util.Vector;

public class ColoredTimeInvariant
extends TimeInvariant {
    private Color color;
    public static final ColoredTimeInvariant LESS_THAN_INFINITY_AND_STAR = new ColoredTimeInvariant(false, Bound.Infinity, Color.STAR_COLOR);

    public ColoredTimeInvariant(boolean isUpperIncluded, Bound upper, Color color) {
        super(isUpperIncluded, upper);
        this.color = color;
    }

    public static ColoredTimeInvariant LESS_THAN_INFINITY_DYN_COLOR(Color color) {
        return new ColoredTimeInvariant(false, Bound.Infinity, color);
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public String toString() {
        if (this.color.getTuple() != null) {
            return this.color.getTuple().toString() + " " + super.toString();
        }
        return this.color.toString() + " " + super.toString();
    }

    public static ColoredTimeInvariant parse(String invariant, ConstantStore constants, Vector<Color> colors) {
        Bound bound;
        Color color = colors.size() == 1 ? colors.get(0) : new Color(colors.get(0).getColorType(), (Integer)0, colors);
        String[] split = invariant.split(" ");
        String operator = split[0];
        String boundAsString = split[1];
        if (operator.equals("<") && boundAsString.equals("0")) {
            return null;
        }
        if (operator.equals("<=") && boundAsString.equals("inf")) {
            return null;
        }
        if (boundAsString.equals("inf")) {
            bound = Bound.Infinity;
        } else {
            try {
                int intBound = Integer.parseInt(boundAsString);
                bound = new IntBound(intBound);
            }
            catch (NumberFormatException e) {
                if (constants.containsConstantByName(boundAsString)) {
                    bound = new ConstantBound(constants.getConstantByName(boundAsString));
                }
                throw new RuntimeException("A constant which was not declared was used in an invariant.");
            }
        }
        return new ColoredTimeInvariant(operator.equals("<="), bound, color);
    }

    public String getInvariantString() {
        return super.toString();
    }

    public String getInvariantString(boolean displayConstantNames) {
        return super.toString(displayConstantNames);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ColoredTimeInvariant)) {
            return false;
        }
        ColoredTimeInvariant cti = (ColoredTimeInvariant)o;
        if (!cti.color.equals(this.color)) {
            return false;
        }
        if (cti.isUpperNonstrict() != this.isUpperNonstrict()) {
            return false;
        }
        return cti.upperBound().value() == this.upperBound().value();
    }

    public boolean equalsOnlyColor(Object o) {
        if (!(o instanceof ColoredTimeInvariant)) {
            return false;
        }
        ColoredTimeInvariant cti = (ColoredTimeInvariant)o;
        return cti.color.equals(this.color);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.upperBound().hashCode();
        result = 31 * result + this.color.hashCode();
        return result;
    }

    @Override
    public ColoredTimeInvariant copy() {
        return new ColoredTimeInvariant(this.isUpperIncluded, this.upperBound().copy(), this.color);
    }
}

