/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.TimeInterval;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColoredTimeInterval
extends TimeInterval {
    private Color color;

    public ColoredTimeInterval(boolean isLowerIncluded, Bound lower, Bound upper, boolean isUpperIncluded, Color color) {
        super(isLowerIncluded, lower, upper, isUpperIncluded);
        this.color = color;
    }

    public static ColoredTimeInterval ZERO_INF_DYN_COLOR(Color color) {
        return new ColoredTimeInterval(true, new IntBound(0), Bound.Infinity, false, color);
    }

    public Color getColor() {
        return this.color;
    }

    public static ColoredTimeInterval parse(String interval, ConstantStore constants, Vector<Color> colors) {
        Bound upperBound;
        Bound lowerBound;
        Color color = colors.size() == 1 ? colors.get(0) : new Color(colors.get(0).getColorType(), (Integer)0, colors);
        Pattern pattern = Pattern.compile("^(\\[|\\()\\s*(\\w+)\\s*,\\s*(\\w+)(\\]|\\))$");
        Matcher matcher = pattern.matcher(interval);
        matcher.find();
        String leftBracket = matcher.group(1);
        String lowerBoundAsString = matcher.group(2);
        String upperBoundAsString = matcher.group(3);
        String rightBracket = matcher.group(4);
        if (!leftBracket.equals("[") && !leftBracket.equals("(")) {
            return null;
        }
        if (!rightBracket.equals("]") && !rightBracket.equals(")")) {
            return null;
        }
        try {
            int intLower = Integer.parseInt(lowerBoundAsString);
            lowerBound = new IntBound(intLower);
        }
        catch (NumberFormatException e) {
            if (constants.containsConstantByName(lowerBoundAsString)) {
                lowerBound = new ConstantBound(constants.getConstantByName(lowerBoundAsString));
            }
            throw new RuntimeException("A constant which was not declared was used in an time interval of an arc.");
        }
        if (upperBoundAsString.equals("inf")) {
            upperBound = Bound.Infinity;
        } else {
            try {
                int intBound = Integer.parseInt(upperBoundAsString);
                upperBound = new IntBound(intBound);
            }
            catch (NumberFormatException e) {
                if (constants.containsConstantByName(upperBoundAsString)) {
                    upperBound = new ConstantBound(constants.getConstantByName(upperBoundAsString));
                }
                throw new RuntimeException("A constant which was not declared was used in an time interval of an arc.");
            }
        }
        return new ColoredTimeInterval(leftBracket.equals("["), lowerBound, upperBound, rightBracket.equals("]"), color);
    }

    @Override
    public String toString() {
        StringBuilder print = new StringBuilder();
        if (this.color != null) {
            if (this.color.getTuple() != null) {
                print.append("[");
                for (Color color1 : this.color.getTuple()) {
                    print.append(color1.getColorName()).append(", ");
                }
                print.delete(print.length() - 2, print.length());
                print.append("]");
                print.append(" \u2192 ").append(super.toString());
            } else {
                print.append(this.color.getColorName()).append(" \u2192 ").append(super.toString());
            }
            return print.toString();
        }
        print.append(super.toString());
        return print.toString();
    }

    public String getInterval() {
        return super.toString();
    }

    public String getInterval(boolean displayConstantNames) {
        return super.toString(displayConstantNames);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ColoredTimeInterval)) {
            return false;
        }
        ColoredTimeInterval cti = (ColoredTimeInterval)o;
        if (cti.isLowerIncluded != this.isLowerIncluded) {
            return false;
        }
        if (cti.lowerBound().value() != this.lowerBound().value()) {
            return false;
        }
        if (cti.upperBound().value() != this.upperBound().value()) {
            return false;
        }
        if (cti.isUpperIncluded != this.isUpperIncluded) {
            return false;
        }
        return cti.color.equals(this.color);
    }

    public boolean equalsOnlyColor(Object o) {
        if (!(o instanceof ColoredTimeInterval)) {
            return false;
        }
        ColoredTimeInterval cti = (ColoredTimeInterval)o;
        return cti.color.equals(this.color);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.lowerBound().hashCode();
        result = 31 * result + this.upperBound().hashCode();
        result = 31 * result + this.color.hashCode();
        return result;
    }
}

