/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io.queries;

import dk.aau.cs.TCTL.HyperLTLPathScopeNode;
import dk.aau.cs.TCTL.LTLANode;
import dk.aau.cs.TCTL.LTLENode;
import dk.aau.cs.TCTL.LTLFNode;
import dk.aau.cs.TCTL.LTLGNode;
import dk.aau.cs.TCTL.LTLUNode;
import dk.aau.cs.TCTL.LTLXNode;
import dk.aau.cs.TCTL.Parsing.TAPAALQueryParser;
import dk.aau.cs.TCTL.StringPosition;
import dk.aau.cs.TCTL.TCTLAUNode;
import dk.aau.cs.TCTL.TCTLAXNode;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLEUNode;
import dk.aau.cs.TCTL.TCTLEXNode;
import dk.aau.cs.TCTL.TCTLPathToStateConverter;
import dk.aau.cs.TCTL.TCTLPlusListNode;
import dk.aau.cs.TCTL.TCTLStateToPathConverter;
import dk.aau.cs.TCTL.TCTLTransitionNode;
import dk.aau.cs.TCTL.XMLParsing.XMLCTLQueryParser;
import dk.aau.cs.TCTL.XMLParsing.XMLHyperLTLQueryParser;
import dk.aau.cs.TCTL.XMLParsing.XMLLTLQueryParser;
import dk.aau.cs.TCTL.XMLParsing.XMLQueryParseException;
import dk.aau.cs.io.queries.QueryLoader;
import dk.aau.cs.io.queries.XMLQueryLoader;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.verification.SMCSettings;
import dk.aau.cs.verification.SMCTraceType;
import dk.aau.cs.verification.observations.Observation;
import dk.aau.cs.verification.observations.expressions.ObsAdd;
import dk.aau.cs.verification.observations.expressions.ObsConstant;
import dk.aau.cs.verification.observations.expressions.ObsExpression;
import dk.aau.cs.verification.observations.expressions.ObsMultiply;
import dk.aau.cs.verification.observations.expressions.ObsOperator;
import dk.aau.cs.verification.observations.expressions.ObsPlace;
import dk.aau.cs.verification.observations.expressions.ObsSubtract;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TAPNQueryLoader
extends QueryLoader {
    private final Document doc;

    public TAPNQueryLoader(Document doc, TimedArcPetriNetNetwork network) {
        super(network);
        this.doc = doc;
    }

    @Override
    protected ArrayList<TAPNQuery> getQueries() {
        NodeList queryNodes = this.doc.getElementsByTagName("query");
        ArrayList<TAPNQuery> queries = new ArrayList<TAPNQuery>();
        for (int i = 0; i < queryNodes.getLength(); ++i) {
            Node q = queryNodes.item(i);
            if (!(q instanceof Element)) continue;
            TAPNQuery query = this.parseTAPNQuery((Element)q, this.network);
            queries.add(query);
        }
        return queries;
    }

    private TAPNQuery parseTAPNQuery(Element queryElement, TimedArcPetriNetNetwork network) {
        TCTLAbstractProperty query;
        int numberOfTraces;
        String comment = this.getQueryComment(queryElement);
        TAPNQuery.TraceOption traceOption = this.getQueryTraceOption(queryElement);
        TAPNQuery.SearchOption searchOption = this.getQuerySearchOption(queryElement);
        TAPNQuery.HashTableSize hashTableSize = this.getQueryHashTableSize(queryElement);
        TAPNQuery.ExtrapolationOption extrapolationOption = this.getQueryExtrapolationOption(queryElement);
        ReductionOption reductionOption = this.getQueryReductionOption(queryElement);
        boolean coloredReduction = this.getColoredReductionOption(queryElement);
        int capacity = Integer.parseInt(queryElement.getAttribute("capacity"));
        boolean symmetry = this.getReductionOption(queryElement, "symmetry", true);
        boolean gcd = this.getReductionOption(queryElement, "gcd", true);
        boolean timeDarts = this.getReductionOption(queryElement, "timeDarts", true);
        boolean pTrie = this.getReductionOption(queryElement, "pTrie", true);
        boolean overApproximation = this.getReductionOption(queryElement, "overApproximation", true);
        boolean isOverApproximationEnabled = this.getApproximationOption(queryElement, "enableOverApproximation", false);
        boolean isUnderApproximationEnabled = this.getApproximationOption(queryElement, "enableUnderApproximation", false);
        int approximationDenominator = this.getApproximationValue(queryElement, "approximationDenominator", 2);
        boolean discreteInclusion = this.getDiscreteInclusionOption(queryElement);
        boolean active = this.getActiveStatus(queryElement);
        InclusionPlaces inclusionPlaces = this.getInclusionPlaces(queryElement, network);
        boolean reduction = this.getReductionOption(queryElement, "reduction", true);
        String algorithmOption = queryElement.getAttribute("algorithmOption");
        boolean isCTL = this.isTypeQuery(queryElement, "CTL");
        boolean isLTL = this.isTypeQuery(queryElement, "LTL");
        boolean isHyperLTL = this.isTypeQuery(queryElement, "HyperLTL");
        boolean isSmc = this.isTypeQuery(queryElement, "SMC") || TAPNQueryLoader.hasSmcTag(queryElement);
        boolean siphontrap = this.getReductionOption(queryElement, "useSiphonTrapAnalysis", false);
        boolean queryReduction = this.getReductionOption(queryElement, "useQueryReduction", true);
        boolean stubborn = this.getReductionOption(queryElement, "useStubbornReduction", true);
        boolean useTar = this.getAttributeOption(queryElement, "useTarOption", false);
        boolean useTarjan = this.getAttributeOption(queryElement, "useTarjan", false);
        boolean partitioning = this.getUnfoldingOption(queryElement, "partitioning", true);
        boolean colorFixpoint = this.getUnfoldingOption(queryElement, "colorFixpoint", true);
        boolean symmetricVars = this.getUnfoldingOption(queryElement, "symmetricVars", true);
        boolean useExplicitSearch = this.getUnfoldingOption(queryElement, "useExplicitSearch", false);
        boolean parallel = this.getReductionOption(queryElement, "parallel", true);
        TAPNQuery.VerificationType verificationType = TAPNQuery.VerificationType.fromString(queryElement.getAttribute("verificationType"));
        try {
            numberOfTraces = Integer.parseInt(queryElement.getAttribute("numberOfTraces"));
        }
        catch (NumberFormatException e) {
            numberOfTraces = 1;
        }
        SMCTraceType smcTraceType = new SMCTraceType(queryElement.getAttribute("smcTraceType"));
        SMCSettings smcSettings = SMCSettings.Default();
        ArrayList<String> tracesArr = new ArrayList<String>();
        if (isSmc) {
            NodeList smcTagList = queryElement.getElementsByTagName("smc");
            if (smcTagList.getLength() > 0) {
                Element settingsNode = (Element)smcTagList.item(0);
                smcSettings = TAPNQueryLoader.parseSmcSettings(settingsNode);
                NodeList observationsList = queryElement.getElementsByTagName("observations");
                if (observationsList.getLength() > 0) {
                    Element observationsNode = (Element)observationsList.item(0);
                    NodeList watchList = observationsNode.getElementsByTagName("watch");
                    ArrayList<Observation> observations = new ArrayList<Observation>();
                    for (int i = 0; i < watchList.getLength(); ++i) {
                        Element watch = (Element)watchList.item(i);
                        String name = watch.getAttribute("name");
                        Element root = this.getFirstElementChild(watch);
                        Observation observation = new Observation(name, this.parseObsExpression(root));
                        if (watch.hasAttribute("isEnabled")) {
                            observation.setEnabled(watch.getAttribute("isEnabled").equals("true"));
                        }
                        observations.add(observation);
                    }
                    smcSettings.setObservations(observations);
                }
            } else {
                smcSettings = SMCSettings.Default();
            }
            query = this.parseLTLQueryProperty(queryElement);
        } else if (queryElement.hasAttribute("type") && queryElement.getAttribute("type").equals("LTL")) {
            query = this.parseLTLQueryProperty(queryElement);
        } else if (queryElement.hasAttribute("type") && queryElement.getAttribute("type").equals("HyperLTL")) {
            query = this.parseHyperLTLQueryProperty(queryElement);
            if (queryElement.hasAttribute("traces")) {
                tracesArr.addAll(this.getTraces(queryElement));
            }
        } else {
            query = queryElement.getElementsByTagName("formula").item(0) != null ? this.parseCTLQueryProperty(queryElement) : this.parseQueryProperty(queryElement.getAttribute("query"));
        }
        if (query != null) {
            TAPNQuery parsedQuery = new TAPNQuery(comment, capacity, query, traceOption, searchOption, reductionOption, symmetry, gcd, timeDarts, pTrie, overApproximation, reduction, hashTableSize, extrapolationOption, inclusionPlaces, isOverApproximationEnabled, isUnderApproximationEnabled, approximationDenominator, partitioning, colorFixpoint, symmetricVars, network.isColored(), coloredReduction);
            parsedQuery.setActive(active);
            parsedQuery.setDiscreteInclusion(discreteInclusion);
            parsedQuery.setCategory(TAPNQueryLoader.detectCategory(query, isCTL, isLTL, isHyperLTL, isSmc));
            parsedQuery.setUseSiphontrap(siphontrap);
            parsedQuery.setUseQueryReduction(queryReduction);
            parsedQuery.setUseStubbornReduction(stubborn);
            parsedQuery.setUseTarOption(useTar);
            parsedQuery.setUseTarjan(useTarjan);
            if (parsedQuery.getCategory() == TAPNQuery.QueryCategory.CTL) {
                parsedQuery.setUseExplicitSearch(useExplicitSearch);
                parsedQuery.setAlgorithmOption(TAPNQuery.AlgorithmOption.valueOf(algorithmOption));
            } else if (parsedQuery.getCategory() == TAPNQuery.QueryCategory.HyperLTL) {
                parsedQuery.setTraceList(tracesArr);
            } else if (parsedQuery.getCategory() == TAPNQuery.QueryCategory.SMC) {
                parsedQuery.setSmcSettings(smcSettings);
                parsedQuery.setParallel(parallel);
                parsedQuery.setVerificationType(verificationType);
                parsedQuery.setNumberOfTraces(numberOfTraces);
                parsedQuery.setSmcTraceType(smcTraceType);
            }
            return parsedQuery;
        }
        return null;
    }

    public static boolean hasSmcTag(Node queryElement) {
        NodeList children = queryElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("smc")) continue;
            return true;
        }
        return false;
    }

    private Element getFirstElementChild(Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    private Element getSecondElementChild(Element parent) {
        NodeList children = parent.getChildNodes();
        int elementCount = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || ++elementCount != 2) continue;
            return (Element)child;
        }
        return null;
    }

    private ObsExpression parseObsExpression(Element element) {
        String tagName;
        switch (tagName = element.getTagName()) {
            case "integer-sum": {
                return this.createOperatorExpression(element, ObsAdd::new);
            }
            case "integer-difference": {
                return this.createOperatorExpression(element, ObsSubtract::new);
            }
            case "integer-product": {
                return this.createOperatorExpression(element, ObsMultiply::new);
            }
            case "integer-constant": {
                return new ObsConstant(Integer.parseInt(element.getTextContent()));
            }
            case "place": {
                return this.createPlaceExpression(element);
            }
        }
        throw new IllegalArgumentException("Unknown expression type: " + tagName);
    }

    private ObsExpression createOperatorExpression(Element element, BiFunction<ObsExpression, ObsExpression, ObsOperator> constructor) {
        ObsExpression left = this.parseObsExpression(this.getFirstElementChild(element));
        ObsExpression right = this.parseObsExpression(this.getSecondElementChild(element));
        ObsOperator operator = constructor.apply(left, right);
        left.setParent(operator);
        right.setParent(operator);
        return operator;
    }

    private ObsExpression createPlaceExpression(Element element) {
        String name = element.getTextContent();
        String[] parts = name.split("_", 2);
        String templateName = parts[0];
        String placeName = parts[1];
        return new ObsPlace(templateName, placeName, this.network);
    }

    public static SMCSettings parseSmcSettings(Element smcTag) {
        SMCSettings settings = SMCSettings.Default();
        if (smcTag.hasAttribute("time-bound")) {
            settings.timeBound = Integer.parseInt(smcTag.getAttribute("time-bound"));
        }
        if (smcTag.hasAttribute("step-bound")) {
            settings.stepBound = Integer.parseInt(smcTag.getAttribute("step-bound"));
        }
        if (smcTag.hasAttribute("compare-to")) {
            settings.compareToFloat = true;
            settings.geqThan = Float.parseFloat(smcTag.getAttribute("compare-to"));
        }
        if (smcTag.hasAttribute("confidence")) {
            settings.confidence = Float.parseFloat(smcTag.getAttribute("confidence"));
        }
        if (smcTag.hasAttribute("interval-width")) {
            settings.estimationIntervalWidth = Float.parseFloat(smcTag.getAttribute("interval-width"));
        }
        if (smcTag.hasAttribute("false-positives")) {
            settings.falsePositives = Float.parseFloat(smcTag.getAttribute("false-positives"));
        }
        if (smcTag.hasAttribute("false-negatives")) {
            settings.falseNegatives = Float.parseFloat(smcTag.getAttribute("false-negatives"));
        }
        if (smcTag.hasAttribute("indifference")) {
            settings.indifferenceWidth = Float.parseFloat(smcTag.getAttribute("indifference"));
        }
        if (smcTag.hasAttribute("numeric-precision")) {
            settings.setNumericPrecision(Long.parseUnsignedLong(smcTag.getAttribute("numeric-precision")));
        }
        return settings;
    }

    public static TAPNQuery.QueryCategory detectCategory(TCTLAbstractProperty query, boolean isCTL, boolean isLTL, boolean isHyperLTL, boolean isSmc) {
        if (isCTL) {
            return TAPNQuery.QueryCategory.CTL;
        }
        if (isLTL) {
            return TAPNQuery.QueryCategory.LTL;
        }
        if (isHyperLTL) {
            return TAPNQuery.QueryCategory.HyperLTL;
        }
        if (isSmc) {
            return TAPNQuery.QueryCategory.SMC;
        }
        StringPosition[] children = query.getChildren();
        if (query instanceof TCTLAbstractStateProperty && ((TCTLAbstractStateProperty)query).getParent() == null) {
            return TAPNQuery.QueryCategory.CTL;
        }
        if (query instanceof TCTLStateToPathConverter || query instanceof TCTLPathToStateConverter) {
            return TAPNQuery.QueryCategory.CTL;
        }
        if (query instanceof LTLGNode || query instanceof LTLFNode || query instanceof LTLUNode || query instanceof LTLXNode || query instanceof LTLANode || query instanceof LTLENode) {
            return TAPNQuery.QueryCategory.LTL;
        }
        if (query instanceof TCTLEUNode || query instanceof TCTLEXNode || query instanceof TCTLAUNode || query instanceof TCTLAXNode) {
            return TAPNQuery.QueryCategory.CTL;
        }
        if (query instanceof HyperLTLPathScopeNode) {
            return TAPNQuery.QueryCategory.HyperLTL;
        }
        if (query instanceof TCTLTransitionNode) {
            return TAPNQuery.QueryCategory.CTL;
        }
        if (query instanceof TCTLPlusListNode) {
            for (TCTLAbstractStateProperty sp : ((TCTLPlusListNode)query).getProperties()) {
                if (TAPNQueryLoader.detectCategory(sp, isCTL, isLTL, isHyperLTL, isSmc) != TAPNQuery.QueryCategory.CTL) continue;
                return TAPNQuery.QueryCategory.CTL;
            }
        }
        for (StringPosition child : children) {
            if (TAPNQueryLoader.detectCategory(child.getObject(), isCTL, isLTL, isHyperLTL, isSmc) != TAPNQuery.QueryCategory.CTL) continue;
            return TAPNQuery.QueryCategory.CTL;
        }
        return TAPNQuery.QueryCategory.Default;
    }

    /*
     * WARNING - void declaration
     */
    private InclusionPlaces getInclusionPlaces(Element queryElement, TimedArcPetriNetNetwork network) {
        String[] placeNames;
        String inclusionPlaces;
        ArrayList<TimedPlace> places = new ArrayList<TimedPlace>();
        try {
            inclusionPlaces = queryElement.getAttribute("inclusionPlaces");
        }
        catch (Exception e) {
            inclusionPlaces = "*ALL*";
        }
        if (!queryElement.hasAttribute("inclusionPlaces") || inclusionPlaces.equals("*ALL*")) {
            return new InclusionPlaces();
        }
        if (inclusionPlaces.isEmpty() || inclusionPlaces.equals("*NONE*")) {
            return new InclusionPlaces(InclusionPlaces.InclusionPlacesOption.UserSpecified, new ArrayList<TimedPlace>());
        }
        for (String string : placeNames = inclusionPlaces.split(",")) {
            void var9_10;
            if (string.contains(".")) {
                String templateName = string.split("\\.")[0];
                Object placeName = string.split("\\.")[1];
                if (((String)placeName).equalsIgnoreCase("false") || ((String)placeName).equalsIgnoreCase("true")) {
                    placeName = "_" + (String)placeName;
                }
                TimedPlace p = network.getTAPNByName(templateName).getPlaceByName((String)placeName);
                places.add(p);
                continue;
            }
            if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("true")) {
                String string2 = "_" + string;
            }
            TimedPlace p = network.getSharedPlaceByName((String)var9_10);
            places.add(p);
        }
        return new InclusionPlaces(InclusionPlaces.InclusionPlacesOption.UserSpecified, places);
    }

    private boolean isTypeQuery(Element queryElement, String type) {
        boolean result;
        if (!queryElement.hasAttribute("type")) {
            if (type.equals("CTL")) {
                return XMLQueryLoader.canBeCTL(queryElement) && !XMLQueryLoader.canBeLTL(queryElement);
            }
            if (type.equals("LTL")) {
                return !XMLQueryLoader.canBeCTL(queryElement) && XMLQueryLoader.canBeLTL(queryElement);
            }
            return false;
        }
        try {
            result = queryElement.getAttribute("type").equals(type);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private boolean getReductionOption(Element queryElement, String attributeName, boolean defaultValue) {
        boolean result;
        if (!queryElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        try {
            result = queryElement.getAttribute(attributeName).equals("true");
        }
        catch (Exception e) {
            result = defaultValue;
        }
        return result;
    }

    private boolean getUnfoldingOption(Element queryElement, String attributeName, boolean defaultValue) {
        boolean result;
        if (!queryElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        try {
            result = queryElement.getAttribute(attributeName).equals("true");
        }
        catch (Exception e) {
            result = defaultValue;
        }
        return result;
    }

    private boolean getAttributeOption(Element queryElement, String attributeName, boolean defaultValue) {
        boolean result;
        if (!queryElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        try {
            result = queryElement.getAttribute(attributeName).equals("true");
        }
        catch (Exception e) {
            result = defaultValue;
        }
        return result;
    }

    private int getApproximationValue(Element queryElement, String attributeName, int defaultValue) {
        int result;
        if (!queryElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        try {
            result = Integer.parseInt(queryElement.getAttribute(attributeName));
        }
        catch (Exception e) {
            result = defaultValue;
        }
        return result;
    }

    private boolean getApproximationOption(Element queryElement, String attributeName, boolean defaultValue) {
        boolean result;
        if (!queryElement.hasAttribute(attributeName)) {
            return defaultValue;
        }
        try {
            result = queryElement.getAttribute(attributeName).equals("true");
        }
        catch (Exception e) {
            result = defaultValue;
        }
        return result;
    }

    private boolean getDiscreteInclusionOption(Element queryElement) {
        boolean discreteInclusion;
        try {
            discreteInclusion = queryElement.getAttribute("discreteInclusion").equals("true");
        }
        catch (Exception e) {
            discreteInclusion = false;
        }
        return discreteInclusion;
    }

    private TCTLAbstractProperty parseCTLQueryProperty(Node queryElement) {
        TCTLAbstractProperty query = null;
        try {
            query = XMLCTLQueryParser.parse(queryElement);
        }
        catch (XMLQueryParseException e) {
            this.messages.add("TAPAAL encountered an error trying to parse one or more of the queries in the model.\n\nThe queries that could not be parsed will not show up in the query list.");
        }
        return query;
    }

    private TCTLAbstractProperty parseLTLQueryProperty(Node queryElement) {
        TCTLAbstractProperty query = null;
        try {
            query = XMLLTLQueryParser.parse(queryElement);
        }
        catch (XMLQueryParseException e) {
            this.messages.add("TAPAAL encountered an error trying to parse one or more of the queries in the model.\n\nThe queries that could not be parsed will not show up in the query list.");
        }
        return query;
    }

    private TCTLAbstractProperty parseHyperLTLQueryProperty(Node queryElement) {
        TCTLAbstractProperty query = null;
        try {
            query = XMLHyperLTLQueryParser.parse(queryElement);
        }
        catch (XMLQueryParseException e) {
            this.messages.add("TAPAAL encountered an error trying to parse one or more of the queries in the model.\n\nThe queries that could not be parsed will not show up in the query list.");
        }
        return query;
    }

    private TCTLAbstractProperty parseQueryProperty(String queryToParse) {
        TCTLAbstractProperty query;
        block2: {
            query = null;
            try {
                query = TAPAALQueryParser.parse(queryToParse);
            }
            catch (Exception e) {
                if (!this.firstQueryParsingWarning) break block2;
                this.messages.add("TAPAAL encountered an error trying to parse one or more of the queries in the model.\n\nThe queries that could not be parsed will not show up in the query list.");
                this.firstQueryParsingWarning = false;
            }
        }
        return query;
    }

    private ReductionOption getQueryReductionOption(Element queryElement) {
        ReductionOption reductionOption;
        String redName = queryElement.getAttribute("reductionOption");
        try {
            reductionOption = redName.equals("VerifyTAPNdiscreteVerification") ? ReductionOption.VerifyDTAPN : ReductionOption.valueOf(redName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown Query reduction option: " + redName);
        }
        return reductionOption;
    }

    private boolean getColoredReductionOption(Element queryElement) {
        boolean coloredReduction;
        try {
            coloredReduction = queryElement.getAttribute("coloredReduction").equals("true");
        }
        catch (Exception e) {
            coloredReduction = false;
        }
        return coloredReduction;
    }

    private TAPNQuery.ExtrapolationOption getQueryExtrapolationOption(Element queryElement) {
        TAPNQuery.ExtrapolationOption extrapolationOption;
        try {
            extrapolationOption = TAPNQuery.ExtrapolationOption.valueOf(queryElement.getAttribute("extrapolationOption"));
        }
        catch (Exception e) {
            extrapolationOption = TAPNQuery.ExtrapolationOption.AUTOMATIC;
        }
        return extrapolationOption;
    }

    private TAPNQuery.HashTableSize getQueryHashTableSize(Element queryElement) {
        TAPNQuery.HashTableSize hashTableSize;
        try {
            hashTableSize = TAPNQuery.HashTableSize.valueOf(queryElement.getAttribute("hashTableSize"));
        }
        catch (Exception e) {
            hashTableSize = TAPNQuery.HashTableSize.MB_16;
        }
        return hashTableSize;
    }

    private TAPNQuery.SearchOption getQuerySearchOption(Element queryElement) {
        TAPNQuery.SearchOption searchOption;
        try {
            searchOption = TAPNQuery.SearchOption.valueOf(queryElement.getAttribute("searchOption"));
        }
        catch (Exception e) {
            searchOption = TAPNQuery.SearchOption.BFS;
        }
        return searchOption;
    }

    private TAPNQuery.TraceOption getQueryTraceOption(Element queryElement) {
        TAPNQuery.TraceOption traceOption;
        try {
            traceOption = TAPNQuery.TraceOption.valueOf(queryElement.getAttribute("traceOption"));
        }
        catch (Exception e) {
            traceOption = TAPNQuery.TraceOption.NONE;
        }
        return traceOption;
    }

    private String getQueryComment(Element queryElement) {
        String comment;
        try {
            comment = queryElement.getAttribute("name");
        }
        catch (Exception e) {
            comment = "No comment specified";
        }
        return comment;
    }

    private boolean getActiveStatus(Element element) {
        String activeString = element.getAttribute("active");
        if (activeString == null || activeString.equals("")) {
            return true;
        }
        return activeString.equals("true");
    }

    private List<String> getTraces(Element element) {
        List<String> traces = new ArrayList<String>();
        try {
            String[] tracesArr = element.getAttribute("traces").split(",");
            traces = Arrays.asList(tracesArr);
        }
        catch (Exception e) {
            traces.add("T1");
        }
        return traces;
    }
}

