/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io;

import dk.aau.cs.io.IdResolver;
import dk.aau.cs.io.LoadTACPN;
import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.LoadedQueries;
import dk.aau.cs.io.XmlUtil;
import dk.aau.cs.io.queries.TAPNQueryLoader;
import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.DotConstantExpression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.DoubleProbability;
import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.Probability;
import dk.aau.cs.model.tapn.SMCDistribution;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.Weight;
import dk.aau.cs.model.tapn.simulation.FiringMode;
import dk.aau.cs.model.tapn.simulation.OldestFiringMode;
import dk.aau.cs.model.tapn.simulation.RandomFiringMode;
import dk.aau.cs.model.tapn.simulation.YoungestFiringMode;
import dk.aau.cs.util.FormatException;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.RequireException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Pair;
import net.tapaal.gui.petrinet.NameGenerator;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.Template;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.AnnotationNote;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.PetriNetObjectWithLabel;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;

public class TapnXmlLoader {
    private static final String PLACENAME_ERROR_MESSAGE = "The keywords \"true\" and \"false\" are reserved and can not be used as place names.\nPlaces with these names will be renamed to \"_true\" and \"_false\" respectively.\n\n Note that any queries using these places may not be parsed correctly.";
    private final HashMap<TimedTransitionComponent, TimedTransportArcComponent> presetArcs = new HashMap();
    private final HashMap<TimedTransitionComponent, TimedTransportArcComponent> postsetArcs = new HashMap();
    private final HashMap<TimedTransportArcComponent, TimeInterval> transportArcsTimeIntervals = new HashMap();
    private final HashMap<TimedTransportArcComponent, List<ColoredTimeInterval>> coloredTransportArcsTimeIntervals = new HashMap();
    private ArcExpression transportExpr;
    private final NameGenerator nameGenerator = new NameGenerator();
    private boolean firstInhibitorIntervalWarning = true;
    private boolean firstPlaceRenameWarning = true;
    private final IdResolver idResolver = new IdResolver();
    private final Collection<String> messages = new ArrayList<String>(10);
    int groupPlaceHolder = 1;
    private final LoadTACPN loadTACPN = new LoadTACPN();
    boolean hasFeatureTag = false;
    private TAPNLens lens = TAPNLens.Default;

    public TAPNLens loadLens(InputStream file) throws FormatException {
        Require.that(file != null, "file must be non-null and exist");
        Document doc = this.loadDocument(file);
        if (doc == null) {
            return null;
        }
        this.idResolver.clear();
        this.parseFeature(doc);
        if (this.hasFeatureTag) {
            return this.lens;
        }
        return null;
    }

    public LoadedModel load(InputStream file) throws Exception {
        Require.that(file != null, "file must be non-null and exist");
        Document doc = this.loadDocument(file);
        if (doc == null) {
            return null;
        }
        try {
            return this.parse(doc);
        }
        catch (FormatException | RequireException | NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception("One or more necessary attributes were not found\n  - One or more attribute values have an incorrect type", e);
        }
    }

    public LoadedModel load(File file) throws Exception {
        Require.that(file != null && file.exists(), "file must be non-null and exist");
        Document doc = this.loadDocument(file);
        if (doc == null) {
            return null;
        }
        try {
            return this.parse(doc);
        }
        catch (FormatException | NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Exception("One or more necessary attributes were not found\n  - One or more attribute values have an incorrect type");
        }
    }

    private Document loadDocument(InputStream file) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }

    private Document loadDocument(File file) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }

    private LoadedModel parse(Document doc) throws FormatException {
        this.idResolver.clear();
        ConstantStore constants = new ConstantStore(this.parseConstants(doc));
        TimedArcPetriNetNetwork network = new TimedArcPetriNetNetwork(constants, new ArrayList<ColorType>());
        NodeList declarations = doc.getElementsByTagName("declaration");
        if (declarations.getLength() > 0) {
            for (int i = 0; i < declarations.getLength(); ++i) {
                Node node = declarations.item(i);
                if (!node.getNodeName().equals("declaration")) continue;
                this.loadTACPN.parseDeclarations(node, network);
            }
            for (String message : this.loadTACPN.getMessages()) {
                this.messages.add(message);
            }
        } else {
            network.add(ColorType.COLORTYPE_DOT);
        }
        this.parseSharedPlaces(doc, network, constants);
        this.parseSharedTransitions(doc, network, constants);
        this.parseFeature(doc, network);
        Collection<Template> templates = this.parseTemplates(doc, network, constants);
        LoadedQueries loadedQueries = new TAPNQueryLoader(doc, network).parseQueries();
        if (loadedQueries != null) {
            for (String message : loadedQueries.getMessages()) {
                this.messages.add(message);
            }
        }
        network.buildConstraints();
        network.setDefaultBound(3);
        if (this.hasFeatureTag) {
            return new LoadedModel(network, templates, loadedQueries.getQueries(), this.messages, this.lens);
        }
        return new LoadedModel(network, templates, loadedQueries.getQueries(), this.messages, null);
    }

    private void parseFeature(Document doc, TimedArcPetriNetNetwork network) {
        if (doc.getElementsByTagName("feature").getLength() > 0) {
            NodeList nodeList = doc.getElementsByTagName("feature");
            this.hasFeatureTag = true;
            Node isTimedElement = nodeList.item(0).getAttributes().getNamedItem("isTimed");
            boolean isTimed = isTimedElement == null ? network.isTimed() : Boolean.parseBoolean(isTimedElement.getNodeValue());
            Node isGameElement = nodeList.item(0).getAttributes().getNamedItem("isGame");
            boolean isGame = isGameElement == null ? network.hasUncontrollableTransitions() : Boolean.parseBoolean(isGameElement.getNodeValue());
            Node isColoredElement = nodeList.item(0).getAttributes().getNamedItem("isColored");
            boolean isColored = isColoredElement == null ? network.isColored() : Boolean.parseBoolean(isColoredElement.getNodeValue());
            Node isStochasticElement = nodeList.item(0).getAttributes().getNamedItem("isStochastic");
            boolean isStochastic = isStochasticElement == null ? network.isStochastic() : Boolean.parseBoolean(isStochasticElement.getNodeValue());
            this.lens = new TAPNLens(isTimed, isGame, isColored, isStochastic);
        }
    }

    private void parseFeature(Document doc) {
        if (doc.getElementsByTagName("feature").getLength() > 0) {
            NodeList nodeList = doc.getElementsByTagName("feature");
            this.hasFeatureTag = true;
            boolean isTimed = Boolean.parseBoolean(nodeList.item(0).getAttributes().getNamedItem("isTimed").getNodeValue());
            boolean isGame = Boolean.parseBoolean(nodeList.item(0).getAttributes().getNamedItem("isGame").getNodeValue());
            boolean isColored = Boolean.parseBoolean(nodeList.item(0).getAttributes().getNamedItem("isColored").getNodeValue());
            Node stochasticElement = nodeList.item(0).getAttributes().getNamedItem("isStochastic");
            boolean isStochastic = stochasticElement != null && Boolean.parseBoolean(stochasticElement.getNodeValue());
            this.lens = new TAPNLens(isTimed, isGame, isColored, isStochastic);
        }
    }

    private void parseSharedPlaces(Document doc, TimedArcPetriNetNetwork network, ConstantStore constants) throws FormatException {
        NodeList sharedPlaceNodes = doc.getElementsByTagName("shared-place");
        for (int i = 0; i < sharedPlaceNodes.getLength(); ++i) {
            Node node = sharedPlaceNodes.item(i);
            if (!(node instanceof Element)) continue;
            SharedPlace place = this.parseSharedPlace((Element)node, network, constants);
            network.add(place);
        }
    }

    private SharedPlace parseSharedPlace(Element element, TimedArcPetriNetNetwork network, ConstantStore constants) throws FormatException {
        Object name = element.getAttribute("name");
        TimeInvariant invariant = TimeInvariant.parse(element.getAttribute("invariant"), constants);
        if (((String)name).equalsIgnoreCase("true") || ((String)name).equalsIgnoreCase("false")) {
            name = "_" + (String)name;
            if (this.firstPlaceRenameWarning) {
                this.messages.add(PLACENAME_ERROR_MESSAGE);
                this.firstPlaceRenameWarning = false;
            }
        }
        SharedPlace place = new SharedPlace((String)name, invariant);
        place.setCurrentMarking(network.marking());
        place.setColorType(this.parsePlaceColorType(element));
        this.addColoredDependencies(place, element, network, constants);
        return place;
    }

    private void parseSharedTransitions(Document doc, TimedArcPetriNetNetwork network, ConstantStore constants) {
        NodeList sharedTransitionNodes = doc.getElementsByTagName("shared-transition");
        for (int i = 0; i < sharedTransitionNodes.getLength(); ++i) {
            Node node = sharedTransitionNodes.item(i);
            if (!(node instanceof Element)) continue;
            SharedTransition transition = this.parseSharedTransition((Element)node, constants);
            network.add(transition);
        }
    }

    private SharedTransition parseSharedTransition(Element element, ConstantStore constants) {
        String name = element.getAttribute("name");
        boolean urgent = Boolean.parseBoolean(element.getAttribute("urgent"));
        boolean isUncontrollable = element.getAttribute("player").equals("1");
        String distrib = element.getAttribute("distribution");
        String weightStr = element.getAttribute("weight");
        String firingModeStr = element.getAttribute("firingMode");
        SMCDistribution distribution = SMCDistribution.defaultDistribution();
        Probability weight = new DoubleProbability(1.0);
        FiringMode firingMode = new RandomFiringMode();
        if (!distrib.isEmpty()) {
            distribution = SMCDistribution.parseXml(element);
        }
        if (!weightStr.isEmpty()) {
            weight = Probability.parseProbability(weightStr, constants);
        }
        if (!firingModeStr.isEmpty()) {
            firingMode = this.getFiringMode(firingModeStr);
        }
        SharedTransition st = new SharedTransition(name);
        st.setUrgent(urgent);
        st.setUncontrollable(isUncontrollable);
        st.setDistribution(distribution);
        st.setWeight(weight);
        st.setFiringMode(firingMode);
        return st;
    }

    private FiringMode getFiringMode(String firingModeStr) {
        switch (firingModeStr) {
            case "Oldest": {
                return new OldestFiringMode();
            }
            case "Youngest": {
                return new YoungestFiringMode();
            }
            case "Random": {
                return new RandomFiringMode();
            }
        }
        return null;
    }

    private Collection<Template> parseTemplates(Document doc, TimedArcPetriNetNetwork network, ConstantStore constants) throws FormatException {
        ArrayList<Template> templates = new ArrayList<Template>();
        NodeList nets = doc.getElementsByTagName("net");
        if (nets.getLength() <= 0) {
            throw new FormatException("File did not contain any TAPN components.");
        }
        for (int i = 0; i < nets.getLength(); ++i) {
            Template template = this.parseTimedArcPetriNet(nets.item(i), network, constants);
            template.setHasPositionalInfo(this.hasPositionalInfo(nets.item(i)));
            templates.add(template);
        }
        return templates;
    }

    private boolean hasPositionalInfo(Node netNode) {
        if (netNode instanceof Element) {
            NodeList children = netNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element element;
                Node child = children.item(i);
                if (!(child instanceof Element) || !(element = (Element)child).getNodeName().equals("place") && !element.getNodeName().equals("transition") || !element.hasAttribute("positionX")) continue;
                return true;
            }
        }
        return false;
    }

    private List<Constant> parseConstants(Document doc) {
        ArrayList<Constant> constants = new ArrayList<Constant>();
        NodeList constantNodes = doc.getElementsByTagName("constant");
        for (int i = 0; i < constantNodes.getLength(); ++i) {
            Node c = constantNodes.item(i);
            if (XmlUtil.isDescendantOfTag(c, "watch") || !(c instanceof Element)) continue;
            Constant constant = this.parseConstant((Element)c);
            constants.add(constant);
        }
        return constants;
    }

    private Template parseTimedArcPetriNet(Node tapnNode, TimedArcPetriNetNetwork network, ConstantStore constants) throws FormatException {
        String name = this.getTAPNName(tapnNode);
        boolean active = this.getActiveStatus(tapnNode);
        TimedArcPetriNet tapn = new TimedArcPetriNet(name);
        tapn.setActive(active);
        network.add(tapn);
        this.nameGenerator.add(tapn);
        DataLayer guiModel = new DataLayer();
        Template template = new Template(tapn, guiModel, new Zoomer());
        NodeList nodeList = tapnNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            this.parseElement((Element)node, template, network, constants);
        }
        return template;
    }

    private boolean getActiveStatus(Node tapnNode) {
        if (tapnNode instanceof Element) {
            Element element = (Element)tapnNode;
            String activeString = element.getAttribute("active");
            if (activeString == null || activeString.equals("")) {
                return true;
            }
            return activeString.equals("true");
        }
        return true;
    }

    private void parseElement(Element element, Template template, TimedArcPetriNetNetwork network, ConstantStore constants) throws FormatException {
        if ("labels".equals(element.getNodeName())) {
            AnnotationNote note = this.parseAnnotation(element);
            template.guiModel().addPetriNetObject(note);
        } else if ("place".equals(element.getNodeName())) {
            TimedPlaceComponent place = this.parsePlace(element, network, template.model(), constants);
            template.guiModel().addPetriNetObject(place);
        } else if ("transition".equals(element.getNodeName())) {
            TimedTransitionComponent transition = this.parseTransition(element, network, template.model(), constants);
            template.guiModel().addPetriNetObject(transition);
        } else if (element.getNodeName().matches("arc|outputArc|inputArc|inhibitorArc|transportArc")) {
            this.parseAndAddArc(element, template, constants, network);
        }
    }

    private boolean isNameAllowed(String name) {
        Require.that(name != null, "name was null");
        return !name.isEmpty() && Pattern.matches("[a-zA-Z]([_a-zA-Z0-9])*", name);
    }

    private String getTAPNName(Node tapnNode) {
        if (tapnNode instanceof Element) {
            Element element = (Element)tapnNode;
            String name = element.getAttribute("name");
            if (name == null || name.equals("")) {
                name = element.getAttribute("id");
            }
            if (!this.isNameAllowed(name)) {
                name = this.nameGenerator.getNewTemplateName();
            }
            this.nameGenerator.updateTemplateIndex(name);
            return name;
        }
        return this.nameGenerator.getNewTemplateName();
    }

    private AnnotationNote parseAnnotation(Element annotation) {
        int positionXInput = 0;
        int positionYInput = 0;
        int widthInput = 0;
        int heightInput = 0;
        boolean borderInput = true;
        String positionXTempStorage = annotation.getAttribute("positionX");
        String positionYTempStorage = annotation.getAttribute("positionY");
        String widthTemp = annotation.getAttribute("width");
        String heightTemp = annotation.getAttribute("height");
        String borderTemp = annotation.getAttribute("border");
        String text = annotation.getTextContent();
        if (positionXTempStorage.length() > 0) {
            positionXInput = Integer.parseInt(positionXTempStorage) + 1;
        }
        if (positionYTempStorage.length() > 0) {
            positionYInput = Integer.parseInt(positionYTempStorage) + 1;
        }
        if (widthTemp.length() > 0) {
            widthInput = Integer.parseInt(widthTemp) + 1;
        }
        if (heightTemp.length() > 0) {
            heightInput = Integer.parseInt(heightTemp) + 1;
        }
        borderInput = borderTemp.length() > 0 ? Boolean.parseBoolean(borderTemp) : true;
        return new AnnotationNote(text, positionXInput, positionYInput, widthInput, heightInput, borderInput);
    }

    private TimedTransitionComponent parseTransition(Element transition, TimedArcPetriNetNetwork network, TimedArcPetriNet tapn, ConstantStore constants) {
        boolean displayName;
        String posX = transition.getAttribute("positionX");
        String posY = transition.getAttribute("positionY");
        String nameOffsetX = transition.getAttribute("nameOffsetX");
        String nameOffsetY = transition.getAttribute("nameOffsetY");
        String angleStr = transition.getAttribute("angle");
        String priorityStr = transition.getAttribute("priority");
        String distrib = transition.getAttribute("distribution");
        String weightStr = transition.getAttribute("weight");
        String firingModeStr = transition.getAttribute("firingMode");
        int positionXInput = 0;
        int positionYInput = 0;
        int nameOffsetXInput = 0;
        int nameOffsetYInput = 0;
        int angle = 0;
        int priority = 0;
        SMCDistribution distribution = SMCDistribution.defaultDistribution();
        Probability weight = new DoubleProbability(1.0);
        FiringMode firingMode = new RandomFiringMode();
        if (!posX.isEmpty()) {
            positionXInput = (int)Double.parseDouble(posX);
        }
        if (!posY.isEmpty()) {
            positionYInput = (int)Double.parseDouble(posY);
        }
        if (!nameOffsetX.isEmpty()) {
            nameOffsetXInput = (int)Double.parseDouble(nameOffsetX);
        }
        if (!nameOffsetY.isEmpty()) {
            nameOffsetYInput = (int)Double.parseDouble(nameOffsetY);
        }
        if (!angleStr.isEmpty()) {
            angle = Integer.parseInt(angleStr);
        }
        if (!priorityStr.isEmpty()) {
            priority = Integer.parseInt(priorityStr);
        }
        if (!distrib.isEmpty()) {
            distribution = SMCDistribution.parseXml(transition);
        }
        if (!weightStr.isEmpty()) {
            weight = Probability.parseProbability(weightStr, constants);
        }
        if (!firingModeStr.isEmpty()) {
            firingMode = this.getFiringMode(firingModeStr);
        }
        String idInput = transition.getAttribute("id");
        String nameInput = transition.getAttribute("name");
        boolean isUrgent = Boolean.parseBoolean(transition.getAttribute("urgent"));
        String player = transition.getAttribute("player");
        this.idResolver.add(tapn.name(), idInput, nameInput);
        boolean infiniteServer = transition.getAttribute("infiniteServer").equals("true");
        boolean bl = displayName = !transition.getAttribute("displayName").equals("false");
        if (idInput.length() == 0 && nameInput.length() > 0) {
            idInput = nameInput;
        }
        if (nameInput.length() == 0 && idInput.length() > 0) {
            nameInput = idInput;
        }
        GuardExpression guardExpr = null;
        Node conditionNode = this.getFirstDirectChild(transition, "condition");
        if (conditionNode != null) {
            try {
                guardExpr = this.loadTACPN.parseGuardExpression(this.getFirstDirectChild(conditionNode, "structure"));
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        }
        TimedTransition t = new TimedTransition(nameInput, guardExpr);
        t.setUrgent(isUrgent);
        t.setUncontrollable(player.equals("1"));
        t.setDistribution(distribution);
        t.setWeight(weight);
        t.setFiringMode(firingMode);
        if (network.isNameUsedForShared(nameInput)) {
            t.setName(this.nameGenerator.getNewTransitionName(tapn));
            tapn.add(t);
            network.getSharedTransitionByName(nameInput).makeShared(t);
        } else {
            tapn.add(t);
        }
        this.nameGenerator.updateIndicesForAllModels(nameInput);
        TimedTransitionComponent transitionComponent = new TimedTransitionComponent(positionXInput, positionYInput, idInput, nameOffsetXInput, nameOffsetYInput, angle, this.lens);
        transitionComponent.setUnderlyingTransition(t);
        if (!displayName) {
            transitionComponent.setAttributesVisible(false);
        }
        return transitionComponent;
    }

    private TimedPlaceComponent parsePlace(Element place, TimedArcPetriNetNetwork network, TimedArcPetriNet tapn, ConstantStore constants) throws FormatException {
        TimedPlace p;
        boolean displayName;
        String placePosX = place.getAttribute("positionX");
        String placePosY = place.getAttribute("positionY");
        String nameOffsetX = place.getAttribute("nameOffsetX");
        String nameOffsetY = place.getAttribute("nameOffsetY");
        int positionXInput = 0;
        int positionYInput = 0;
        if (!placePosX.isEmpty()) {
            positionXInput = (int)Double.parseDouble(placePosX);
        }
        if (!placePosY.isEmpty()) {
            positionYInput = (int)Double.parseDouble(placePosY);
        }
        String idInput = place.getAttribute("id");
        Object nameInput = place.getAttribute("name");
        int nameOffsetXInput = 0;
        int nameOffsetYInput = 0;
        if (!nameOffsetX.isEmpty()) {
            nameOffsetXInput = (int)Double.parseDouble(nameOffsetX);
        }
        if (!nameOffsetY.isEmpty()) {
            nameOffsetYInput = (int)Double.parseDouble(nameOffsetY);
        }
        String invariant = place.getAttribute("invariant");
        boolean bl = displayName = !place.getAttribute("displayName").equals("false");
        if (idInput.length() == 0 && ((String)nameInput).length() > 0) {
            idInput = nameInput;
        }
        if (((String)nameInput).length() == 0 && idInput.length() > 0) {
            nameInput = idInput;
        }
        if (((String)nameInput).equalsIgnoreCase("true") || ((String)nameInput).equalsIgnoreCase("false")) {
            nameInput = "_" + (String)nameInput;
            if (this.firstPlaceRenameWarning) {
                this.messages.add(PLACENAME_ERROR_MESSAGE);
                this.firstPlaceRenameWarning = false;
            }
        }
        this.idResolver.add(tapn.name(), idInput, (String)nameInput);
        if (network.isNameUsedForShared((String)nameInput)) {
            p = network.getSharedPlaceByName((String)nameInput);
            tapn.add(p);
        } else {
            p = new LocalTimedPlace((String)nameInput, TimeInvariant.parse(invariant, constants), this.parsePlaceColorType(place));
            tapn.add(p);
            this.addColoredDependencies(p, place, network, constants);
        }
        this.nameGenerator.updateIndicesForAllModels((String)nameInput);
        TimedPlaceComponent placeComponent = new TimedPlaceComponent(positionXInput, positionYInput, idInput, nameOffsetXInput, nameOffsetYInput, this.lens);
        placeComponent.setUnderlyingPlace(p);
        if (!displayName) {
            placeComponent.setAttributesVisible(false);
        }
        return placeComponent;
    }

    private ColorType parsePlaceColorType(Element element) {
        ColorType ct = ColorType.COLORTYPE_DOT;
        Node typeNode = element.getElementsByTagName("type").item(0);
        if (typeNode != null) {
            try {
                ct = this.loadTACPN.parseUserSort(typeNode);
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        }
        return ct;
    }

    private void addColoredDependencies(TimedPlace p, Element place, TimedArcPetriNetNetwork network, ConstantStore constants) throws FormatException {
        Node hlInitialMarkingNode;
        ArrayList<ColoredTimeInvariant> ctiList = new ArrayList<ColoredTimeInvariant>();
        int initialMarkingInput = Integer.parseInt(place.getAttribute("initialMarking"));
        ArcExpression colorMarking = null;
        NodeList nodes = place.getElementsByTagName("colorinvariant");
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Pair<String, Vector<Color>> pair = this.parseColorInvariant((Element)nodes.item(i), network);
                ColoredTimeInvariant cti = ColoredTimeInvariant.parse((String)pair.getFirst(), constants, (Vector)pair.getSecond());
                ctiList.add(cti);
            }
        }
        if (place.getAttribute("inscription").length() > 0) {
            ctiList.add(ColoredTimeInvariant.parse(place.getAttribute("inscription"), constants, new Vector<Color>(){
                {
                    this.add(Color.STAR_COLOR);
                }
            }));
        }
        if ((hlInitialMarkingNode = place.getElementsByTagName("hlinitialMarking").item(0)) instanceof Element) {
            try {
                colorMarking = this.loadTACPN.parseArcExpression(((Element)hlInitialMarkingNode).getElementsByTagName("structure").item(0));
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        }
        p.setCtiList(ctiList);
        ExpressionContext context = new ExpressionContext(new HashMap<String, Color>(), this.loadTACPN.getColortypes());
        if (colorMarking != null) {
            ColorMultiset cm = colorMarking.eval(context);
            p.setTokenExpression(colorMarking, this.loadTACPN.constructCleanAddExpression(colorMarking));
            for (TimedToken ctElement : cm.getTokens(p)) {
                network.marking().add(ctElement);
            }
        } else {
            for (int i = 0; i < initialMarkingInput; ++i) {
                network.marking().add(new TimedToken(p, ColorType.COLORTYPE_DOT.getFirstColor()));
            }
            if (initialMarkingInput > 1) {
                Vector<ColorExpression> v = new Vector<ColorExpression>();
                v.add(new DotConstantExpression());
                Vector<ArcExpression> numbOfExpression = new Vector<ArcExpression>();
                numbOfExpression.add(new NumberOfExpression(initialMarkingInput, v));
                p.setTokenExpression(new AddExpression(numbOfExpression));
            }
        }
    }

    private void parseAndAddArc(Element arc, Template template, ConstantStore constants, TimedArcPetriNetNetwork network) throws FormatException {
        Arc tempArc;
        NodeList intervalNodes;
        int nameOffsetYInput;
        int nameOffsetXInput;
        String idInput = arc.getAttribute("id");
        String sourceInput = arc.getAttribute("source");
        String targetInput = arc.getAttribute("target");
        boolean taggedArc = arc.getAttribute("tagged").equals("true");
        String inscriptionTempStorage = arc.getAttribute("inscription");
        String type = arc.getAttribute("type");
        if (type.isEmpty()) {
            switch (arc.getNodeName()) {
                case "transportArc": {
                    type = "transport";
                    break;
                }
                case "inhibitorArc": {
                    type = "inhibitor";
                    break;
                }
                case "inputArc": {
                    type = "timed";
                    break;
                }
                default: {
                    type = "";
                }
            }
        }
        if (!arc.getAttribute("nameOffsetX").equals("") && !arc.getAttribute("nameOffsetY").equals("")) {
            nameOffsetXInput = (int)Double.parseDouble(arc.getAttribute("nameOffsetX"));
            nameOffsetYInput = (int)Double.parseDouble(arc.getAttribute("nameOffsetY"));
        } else {
            nameOffsetXInput = 0;
            nameOffsetYInput = 0;
        }
        sourceInput = this.idResolver.get(template.model().name(), sourceInput);
        targetInput = this.idResolver.get(template.model().name(), targetInput);
        PlaceTransitionObject sourceIn = template.guiModel().getPlaceTransitionObject(sourceInput);
        PlaceTransitionObject targetIn = template.guiModel().getPlaceTransitionObject(targetInput);
        int _startx = sourceIn.getX() + sourceIn.centreOffsetLeft();
        int _starty = sourceIn.getY() + sourceIn.centreOffsetTop();
        int _endx = targetIn.getX() + targetIn.centreOffsetLeft();
        int _endy = targetIn.getY() + targetIn.centreOffsetTop();
        Weight weight = new IntWeight(1);
        if (arc.hasAttribute("weight")) {
            weight = Weight.parseWeight(arc.getAttribute("weight"), constants);
        }
        ArcExpression arcExpr = null;
        ArrayList<ColoredTimeInterval> ctiList = new ArrayList<ColoredTimeInterval>();
        Node hlInscription = this.getFirstDirectChild(arc, "hlinscription");
        if (hlInscription != null) {
            hlInscription = this.getFirstDirectChild(hlInscription, "structure");
        }
        if (hlInscription != null) {
            arcExpr = this.loadTACPN.parseArcExpression(hlInscription);
        }
        if ((intervalNodes = arc.getElementsByTagName("colorinterval")) != null) {
            for (int i = 0; i < intervalNodes.getLength(); ++i) {
                if (!(intervalNodes.item(i) instanceof Element)) continue;
                Element interval = (Element)intervalNodes.item(i);
                Pair<String, Vector<Color>> pair = this.parseColorInvariant(interval, network);
                ColoredTimeInterval coloredinterval = ColoredTimeInterval.parse((String)pair.getFirst(), constants, (Vector)pair.getSecond());
                ctiList.add(coloredinterval);
            }
        }
        PetriNetObjectWithLabel tempArc2 = null;
        if (type.equals("tapnInhibitor") || type.equals("inhibitor")) {
            tempArc = this.parseAndAddTimedInhibitorArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, targetIn, _endx, _endy, template, constants, weight, arcExpr);
        } else if (type.equals("timed")) {
            tempArc = this.parseAndAddTimedInputArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, targetIn, _endx, _endy, template, constants, weight, ctiList, arcExpr);
        } else if (type.equals("transport")) {
            String transition = arc.getAttribute("transition");
            if (transition.isEmpty()) {
                tempArc = this.parseAndAddTransportArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, targetIn, _endx, _endy, template, constants, weight, ctiList, arcExpr);
            } else {
                transition = this.idResolver.get(template.model().name(), transition);
                PlaceTransitionObject transitionIn = template.guiModel().getPlaceTransitionObject(transition);
                tempArc = this.parseAndAddTransportArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, transitionIn, _endx, _endy, template, constants, weight, ctiList, arcExpr);
                tempArc2 = this.parseAndAddTransportArc(idInput, taggedArc, inscriptionTempStorage, transitionIn, targetIn, _endx, _endy, template, constants, weight, ctiList, arcExpr);
            }
        } else {
            tempArc = this.parseAndAddTimedOutputArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, targetIn, _endx, _endy, template, weight, arcExpr);
        }
        tempArc.setNameOffsetX(nameOffsetXInput);
        tempArc.setNameOffsetY(nameOffsetYInput);
        this.parseArcPath(arc, tempArc);
        if (tempArc2 != null) {
            tempArc2.setNameOffsetX(nameOffsetXInput);
            tempArc2.setNameOffsetY(nameOffsetYInput);
            this.parseArcPath(arc, (Arc)tempArc2);
        }
    }

    private TimedOutputArcComponent parseAndAddTimedOutputArc(String idInput, boolean taggedArc, String inscriptionTempStorage, PlaceTransitionObject sourceIn, PlaceTransitionObject targetIn, int _endx, int _endy, Template template, Weight weight, ArcExpression expr) throws FormatException {
        TimedOutputArcComponent tempArc = new TimedOutputArcComponent(sourceIn, targetIn, !inscriptionTempStorage.equals("") ? Integer.parseInt(inscriptionTempStorage) : 1, idInput);
        TimedPlace place = template.model().getPlaceByName(targetIn.getName());
        TimedTransition transition = template.model().getTransitionByName(sourceIn.getName());
        TimedOutputArc outputArc = new TimedOutputArc(transition, place, weight, expr);
        tempArc.setUnderlyingArc(outputArc);
        if (template.model().hasArcFromTransitionToPlace(outputArc.source(), outputArc.destination())) {
            throw new FormatException("Multiple arcs between a place and a transition is not allowed");
        }
        template.guiModel().addPetriNetObject(tempArc);
        template.model().add(outputArc);
        return tempArc;
    }

    private TimedTransportArcComponent parseAndAddTransportArc(String idInput, boolean taggedArc, String inscriptionTempStorage, PlaceTransitionObject sourceIn, PlaceTransitionObject targetIn, int _endx, int _endy, Template template, ConstantStore constants, Weight weight, List<ColoredTimeInterval> ctiList, ArcExpression expr) {
        String[] inscriptionSplit = new String[]{};
        inscriptionSplit = inscriptionTempStorage.contains(":") ? inscriptionTempStorage.split(":") : new String[]{inscriptionTempStorage};
        boolean isInPreSet = false;
        if (sourceIn instanceof Place) {
            isInPreSet = true;
        }
        TimedTransportArcComponent tempArc = new TimedTransportArcComponent(new TimedInputArcComponent(new TimedOutputArcComponent(sourceIn, targetIn, 1, idInput)), -1, isInPreSet);
        if (isInPreSet) {
            if (this.postsetArcs.containsKey(targetIn)) {
                TimedTransportArcComponent postsetTransportArc = this.postsetArcs.get(targetIn);
                TimedPlace sourcePlace = template.model().getPlaceByName(sourceIn.getName());
                TimedTransition trans = template.model().getTransitionByName(targetIn.getName());
                TimedPlace destPlace = template.model().getPlaceByName(postsetTransportArc.getTarget().getName());
                TimeInterval timeInterval = TimeInterval.parse(inscriptionSplit[0], constants);
                assert (sourcePlace != null);
                assert (trans != null);
                assert (destPlace != null);
                int groupNr = 1;
                if (inscriptionSplit.length < 2) {
                    for (Arc pt : tempArc.getTarget().getPostset()) {
                        if (!(pt instanceof TimedTransportArcComponent) || ((TimedTransportArcComponent)pt).getGroupNr() <= groupNr) continue;
                        groupNr = ((TimedTransportArcComponent)pt).getGroupNr();
                    }
                } else {
                    groupNr = Integer.parseInt(inscriptionSplit[1]);
                }
                tempArc.setGroupNr(groupNr);
                postsetTransportArc.setGroupNr(groupNr);
                TransportArc transArc = new TransportArc(sourcePlace, trans, destPlace, timeInterval, weight, expr, this.transportExpr);
                transArc.setColorTimeIntervals(ctiList);
                tempArc.setUnderlyingArc(transArc);
                postsetTransportArc.setUnderlyingArc(transArc);
                template.guiModel().addPetriNetObject(tempArc);
                template.guiModel().addPetriNetObject(postsetTransportArc);
                template.model().add(transArc);
                this.postsetArcs.remove(targetIn);
            } else {
                this.transportExpr = expr;
                this.presetArcs.put((TimedTransitionComponent)targetIn, tempArc);
                this.transportArcsTimeIntervals.put(tempArc, TimeInterval.parse(inscriptionSplit[0], constants));
                this.coloredTransportArcsTimeIntervals.put(tempArc, ctiList);
            }
        } else if (this.presetArcs.containsKey(sourceIn)) {
            TimedTransportArcComponent presetTransportArc = this.presetArcs.get(sourceIn);
            TimedPlace sourcePlace = template.model().getPlaceByName(presetTransportArc.getSource().getName());
            TimedTransition trans = template.model().getTransitionByName(sourceIn.getName());
            TimedPlace destPlace = template.model().getPlaceByName(targetIn.getName());
            TimeInterval interval = this.transportArcsTimeIntervals.get(presetTransportArc);
            List<ColoredTimeInterval> timeIntervals = this.coloredTransportArcsTimeIntervals.get(presetTransportArc);
            assert (sourcePlace != null);
            assert (trans != null);
            assert (destPlace != null);
            int groupNr = 1;
            if (inscriptionSplit.length < 2) {
                for (Arc pt : tempArc.getSource().getPostset()) {
                    if (!(pt instanceof TimedTransportArcComponent) || ((TimedTransportArcComponent)pt).getGroupNr() <= groupNr) continue;
                    groupNr = ((TimedTransportArcComponent)pt).getGroupNr();
                }
            } else {
                groupNr = Integer.parseInt(inscriptionSplit[1]);
            }
            tempArc.setGroupNr(groupNr);
            presetTransportArc.setGroupNr(groupNr);
            TransportArc transArc = new TransportArc(sourcePlace, trans, destPlace, interval, weight, this.transportExpr, expr);
            transArc.setColorTimeIntervals(timeIntervals);
            this.transportExpr = null;
            tempArc.setUnderlyingArc(transArc);
            presetTransportArc.setUnderlyingArc(transArc);
            template.guiModel().addPetriNetObject(presetTransportArc);
            template.guiModel().addPetriNetObject(tempArc);
            template.model().add(transArc);
            this.presetArcs.remove(sourceIn);
            this.transportArcsTimeIntervals.remove(presetTransportArc);
        } else {
            this.postsetArcs.put((TimedTransitionComponent)sourceIn, tempArc);
            this.transportExpr = expr;
        }
        return tempArc;
    }

    private Arc parseAndAddTimedInputArc(String idInput, boolean taggedArc, String inscriptionTempStorage, PlaceTransitionObject sourceIn, PlaceTransitionObject targetIn, int _endx, int _endy, Template template, ConstantStore constants, Weight weight, List<ColoredTimeInterval> ctiList, ArcExpression expr) throws FormatException {
        TimedInputArcComponent tempArc = new TimedInputArcComponent(new TimedOutputArcComponent(sourceIn, targetIn, 1, idInput), this.lens);
        TimedPlace place = template.model().getPlaceByName(sourceIn.getName());
        TimedTransition transition = template.model().getTransitionByName(targetIn.getName());
        TimeInterval timeInterval = TimeInterval.parse(inscriptionTempStorage, constants);
        TimedInputArc inputArc = new TimedInputArc(place, transition, timeInterval, weight, expr);
        inputArc.setColorTimeIntervals(ctiList);
        tempArc.setUnderlyingArc(inputArc);
        if (template.model().hasArcFromPlaceToTransition(inputArc.source(), inputArc.destination())) {
            throw new FormatException("Multiple arcs between a place and a transition is not allowed");
        }
        template.guiModel().addPetriNetObject(tempArc);
        template.model().add(inputArc);
        return tempArc;
    }

    private Arc parseAndAddTimedInhibitorArc(String idInput, boolean taggedArc, String inscriptionTempStorage, PlaceTransitionObject sourceIn, PlaceTransitionObject targetIn, int _endx, int _endy, Template template, ConstantStore constants, Weight weight, ArcExpression arcExpr) {
        TimedPlace place = template.model().getPlaceByName(sourceIn.getName());
        TimedTransition transition = template.model().getTransitionByName(targetIn.getName());
        TimeInterval interval = TimeInterval.parse(inscriptionTempStorage, constants);
        if (!interval.equals(TimeInterval.ZERO_INF) && this.firstInhibitorIntervalWarning) {
            this.messages.add("The chosen model contained inhibitor arcs with unsupported intervals.\n\nTAPAAL only supports inhibitor arcs with intervals [0,inf).\n\nAny other interval on inhibitor arcs will be replaced with [0,inf).");
            this.firstInhibitorIntervalWarning = false;
        }
        TimedInhibitorArc inhibArc = new TimedInhibitorArc(place, transition, interval, weight, arcExpr);
        TimedInhibitorArcComponent tempArc = new TimedInhibitorArcComponent((TimedPlaceComponent)sourceIn, (TimedTransitionComponent)targetIn, inhibArc);
        tempArc.setUnderlyingArc(inhibArc);
        template.guiModel().addPetriNetObject(tempArc);
        template.model().add(inhibArc);
        return tempArc;
    }

    private void parseArcPath(Element arc, Arc tempArc) {
        NodeList nodelist = arc.getElementsByTagName("arcpath");
        if (nodelist.getLength() > 0) {
            tempArc.getArcPath().purgePathPoints();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Element element;
                Node node = nodelist.item(i);
                if (!(node instanceof Element) || !"arcpath".equals((element = (Element)node).getNodeName())) continue;
                String arcTempX = element.getAttribute("xCoord");
                String arcTempY = element.getAttribute("yCoord");
                String arcTempType = element.getAttribute("arcPointType");
                double arcPointX = Double.parseDouble(arcTempX);
                double arcPointY = Double.parseDouble(arcTempY);
                boolean arcPointType = Boolean.parseBoolean(arcTempType);
                tempArc.getArcPath().addPoint(arcPointX, arcPointY, arcPointType);
            }
        }
    }

    private Constant parseConstant(Element constantElement) {
        String name = constantElement.getAttribute("name");
        int value = Integer.parseInt(constantElement.getAttribute("value"));
        return new Constant(name, value);
    }

    private Pair<String, Vector<Color>> parseColorInvariant(Element colorinvariant, TimedArcPetriNetNetwork network) throws FormatException {
        Vector<Color> colors = new Vector<Color>();
        Element colorTypeELe = (Element)colorinvariant.getElementsByTagName("colortype").item(0);
        String inscription = colorinvariant.getElementsByTagName("inscription").item(0).getAttributes().getNamedItem("inscription").getNodeValue();
        String colorTypeName = colorTypeELe.getAttributes().getNamedItem("name").getNodeValue();
        if (network.isNameUsedForColorType(colorTypeName)) {
            NodeList colorNodeList = colorTypeELe.getElementsByTagName("color");
            ColorType ct = network.getColorTypeByName(colorTypeName);
            for (int i = 0; i < colorNodeList.getLength(); ++i) {
                String colorName = colorNodeList.item(i).getAttributes().getNamedItem("value").getNodeValue();
                colors.add(new Color(ct, (Integer)0, colorName));
            }
        } else {
            throw new FormatException("The color type used for an invariant does not exist");
        }
        Pair pair = new Pair((Object)inscription, colors);
        return pair;
    }

    Node getFirstDirectChild(Node parent, String tagName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!children.item(i).getNodeName().equals(tagName)) continue;
            return children.item(i);
        }
        return null;
    }
}

