/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io;

import dk.aau.cs.TCTL.Parsing.TAPAALQueryParser;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.visitors.AddTemplateVisitor;
import dk.aau.cs.TCTL.visitors.VerifyPlaceNamesVisitor;
import dk.aau.cs.io.IdResolver;
import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.XmlUtil;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedMarking;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.FormatException;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.Tuple;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.tapaal.gui.petrinet.NameGenerator;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.AnnotationNote;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;

public class TapnLegacyXmlLoader {
    private static final String PLACENAME_ERROR_MESSAGE = "The keywords \"true\" and \"false\" are reserved and can not be used as place names.\nPlaces with these names will be renamed to \"_true\" and \"_false\" respectively.\n\n Note that any queries using these places may not be parsed correctly.";
    private static final String SYMMETRY = "SYMMETRY";
    private static final String ERROR_PARSING_QUERY_MESSAGE = "TAPAAL encountered an error trying to parse one or more of the queries in the model.\n\nThe queries that could not be parsed will not show up in the query list.";
    private final HashMap<TimedTransitionComponent, TimedTransportArcComponent> presetArcs = new HashMap();
    private final HashMap<TimedTransitionComponent, TimedTransportArcComponent> postsetArcs = new HashMap();
    private final HashMap<TimedTransportArcComponent, TimeInterval> transportArcsTimeIntervals = new HashMap();
    private TimedArcPetriNet tapn;
    private DataLayer guiModel;
    private ArrayList<TAPNQuery> queries = new ArrayList();
    private final ConstantStore constants = new ConstantStore();
    private final NameGenerator nameGenerator = new NameGenerator();
    private boolean firstQueryParsingWarning = true;
    private boolean firstInhibitorIntervalWarning = true;
    private boolean firstPlaceRenameWarning = true;
    private final IdResolver idResolver = new IdResolver();
    private final Collection<String> messages = new ArrayList<String>(10);
    private final TAPNLens lens = TAPNLens.Default;

    public LoadedModel load(InputStream file) throws FormatException {
        Require.that(file != null, "file must be non-null and exist");
        Document doc = this.loadDocument(file);
        if (doc == null) {
            return null;
        }
        return this.parse(doc);
    }

    public LoadedModel load(File file) throws FormatException {
        Require.that(file != null && file.exists(), "file must be non-null and exist");
        Document doc = this.loadDocument(file);
        if (doc == null) {
            return null;
        }
        return this.parse(doc);
    }

    private Document loadDocument(InputStream file) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }

    private Document loadDocument(File file) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse(file);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }

    private LoadedModel parse(Document tapnDoc) throws FormatException {
        this.idResolver.clear();
        ArrayList<Template> templates = new ArrayList<Template>();
        NodeList constantNodes = tapnDoc.getElementsByTagName("constant");
        for (int i = 0; i < constantNodes.getLength(); ++i) {
            Node c = constantNodes.item(i);
            if (XmlUtil.isDescendantOfTag(c, "watch") || !(c instanceof Element)) continue;
            this.parseAndAddConstant((Element)c);
        }
        TimedArcPetriNetNetwork network = new TimedArcPetriNetNetwork(this.constants, new ArrayList<ColorType>());
        NodeList nets = tapnDoc.getElementsByTagName("net");
        if (nets.getLength() <= 0) {
            throw new FormatException("File did not contain any TAPN components.");
        }
        templates.add(this.parseTimedArcPetriNetAsOldFormat(nets.item(0), network));
        this.checkThatQueriesUseExistingPlaces(network);
        return new LoadedModel(network, templates, this.queries, this.messages, null);
    }

    private void checkThatQueriesUseExistingPlaces(TimedArcPetriNetNetwork network) {
        ArrayList<TAPNQuery> okQueries = new ArrayList<TAPNQuery>();
        ArrayList<Tuple<String, String>> templatePlaceNames = this.getTemplatePlaceNames(network);
        for (TAPNQuery query : this.queries) {
            if (!this.doesPlacesUsedInQueryExist(query, templatePlaceNames)) {
                if (!this.firstQueryParsingWarning) continue;
                this.messages.add(ERROR_PARSING_QUERY_MESSAGE);
                this.firstQueryParsingWarning = false;
                continue;
            }
            okQueries.add(query);
        }
        this.queries = okQueries;
    }

    private ArrayList<Tuple<String, String>> getTemplatePlaceNames(TimedArcPetriNetNetwork network) {
        ArrayList<Tuple<String, String>> templatePlaceNames = new ArrayList<Tuple<String, String>>();
        for (TimedArcPetriNet tapn : network.allTemplates()) {
            for (TimedPlace p : tapn.places()) {
                templatePlaceNames.add(new Tuple<String, String>(tapn.name(), p.name()));
            }
        }
        Collection<SharedPlace> sharedPlaces = network.sharedPlaces();
        for (TimedPlace timedPlace : sharedPlaces) {
            templatePlaceNames.add(new Tuple<String, String>("", timedPlace.name()));
        }
        return templatePlaceNames;
    }

    private Arc parseAndAddTimedOutputArc(String idInput, boolean taggedArc, String inscriptionTempStorage, PlaceTransitionObject sourceIn, PlaceTransitionObject targetIn, int _endx, int _endy) throws FormatException {
        TimedOutputArcComponent tempArc = new TimedOutputArcComponent(sourceIn, targetIn, Integer.parseInt(inscriptionTempStorage), idInput);
        TimedPlace place = this.tapn.getPlaceByName(targetIn.getName());
        TimedTransition transition = this.tapn.getTransitionByName(sourceIn.getName());
        TimedOutputArc outputArc = new TimedOutputArc(transition, place);
        tempArc.setUnderlyingArc(outputArc);
        if (this.tapn.hasArcFromTransitionToPlace(outputArc.source(), outputArc.destination())) {
            throw new FormatException("Multiple arcs between a place and a transition is not allowed");
        }
        this.guiModel.addPetriNetObject(tempArc);
        this.tapn.add(outputArc);
        return tempArc;
    }

    private Arc parseAndAddTransportArc(String idInput, boolean taggedArc, String inscriptionTempStorage, PlaceTransitionObject sourceIn, PlaceTransitionObject targetIn, int _endx, int _endy) {
        String[] inscriptionSplit = new String[]{};
        if (inscriptionTempStorage.contains(":")) {
            inscriptionSplit = inscriptionTempStorage.split(":");
        }
        boolean isInPreSet = false;
        if (sourceIn instanceof Place) {
            isInPreSet = true;
        }
        TimedTransportArcComponent tempArc = new TimedTransportArcComponent(new TimedInputArcComponent(new TimedOutputArcComponent(sourceIn, targetIn, 1, idInput)), Integer.parseInt(inscriptionSplit[1]), isInPreSet);
        if (isInPreSet) {
            if (this.postsetArcs.containsKey(targetIn)) {
                TimedTransportArcComponent postsetTransportArc = this.postsetArcs.get(targetIn);
                TimedPlace sourcePlace = this.tapn.getPlaceByName(sourceIn.getName());
                TimedTransition trans = this.tapn.getTransitionByName(targetIn.getName());
                TimedPlace destPlace = this.tapn.getPlaceByName(postsetTransportArc.getTarget().getName());
                TimeInterval interval = TimeInterval.parse(inscriptionSplit[0], this.constants);
                assert (sourcePlace != null);
                assert (trans != null);
                assert (destPlace != null);
                TransportArc transArc = new TransportArc(sourcePlace, trans, destPlace, interval);
                tempArc.setUnderlyingArc(transArc);
                postsetTransportArc.setUnderlyingArc(transArc);
                this.guiModel.addPetriNetObject(tempArc);
                this.guiModel.addPetriNetObject(postsetTransportArc);
                this.tapn.add(transArc);
                this.postsetArcs.remove(targetIn);
            } else {
                this.presetArcs.put((TimedTransitionComponent)targetIn, tempArc);
                this.transportArcsTimeIntervals.put(tempArc, TimeInterval.parse(inscriptionSplit[0], this.constants));
            }
        } else if (this.presetArcs.containsKey(sourceIn)) {
            TimedTransportArcComponent presetTransportArc = this.presetArcs.get(sourceIn);
            TimedPlace sourcePlace = this.tapn.getPlaceByName(presetTransportArc.getSource().getName());
            TimedTransition trans = this.tapn.getTransitionByName(sourceIn.getName());
            TimedPlace destPlace = this.tapn.getPlaceByName(targetIn.getName());
            TimeInterval interval = this.transportArcsTimeIntervals.get(presetTransportArc);
            assert (sourcePlace != null);
            assert (trans != null);
            assert (destPlace != null);
            TransportArc transArc = new TransportArc(sourcePlace, trans, destPlace, interval);
            tempArc.setUnderlyingArc(transArc);
            presetTransportArc.setUnderlyingArc(transArc);
            this.guiModel.addPetriNetObject(presetTransportArc);
            this.guiModel.addPetriNetObject(tempArc);
            this.tapn.add(transArc);
            this.presetArcs.remove(sourceIn);
            this.transportArcsTimeIntervals.remove(presetTransportArc);
        } else {
            this.postsetArcs.put((TimedTransitionComponent)sourceIn, tempArc);
        }
        return tempArc;
    }

    private Arc parseAndAddTimedInputArc(String idInput, boolean taggedArc, String inscriptionTempStorage, PlaceTransitionObject sourceIn, PlaceTransitionObject targetIn, int _endx, int _endy) throws FormatException {
        TimedInputArcComponent tempArc = new TimedInputArcComponent(new TimedOutputArcComponent(sourceIn, targetIn, 1, idInput), this.lens);
        TimedPlace place = this.tapn.getPlaceByName(sourceIn.getName());
        TimedTransition transition = this.tapn.getTransitionByName(targetIn.getName());
        TimeInterval interval = TimeInterval.parse(inscriptionTempStorage, this.constants);
        TimedInputArc inputArc = new TimedInputArc(place, transition, interval);
        tempArc.setUnderlyingArc(inputArc);
        if (this.tapn.hasArcFromPlaceToTransition(inputArc.source(), inputArc.destination())) {
            throw new FormatException("Multiple arcs between a place and a transition is not allowed");
        }
        this.guiModel.addPetriNetObject(tempArc);
        this.tapn.add(inputArc);
        return tempArc;
    }

    private Arc parseAndAddTimedInhibitorArc(String idInput, boolean taggedArc, String inscriptionTempStorage, PlaceTransitionObject sourceIn, PlaceTransitionObject targetIn, int _endx, int _endy) {
        TimedInhibitorArcComponent tempArc = new TimedInhibitorArcComponent((TimedOutputArcComponent)new TimedInputArcComponent(new TimedOutputArcComponent(sourceIn, targetIn, 1, idInput)), inscriptionTempStorage != null ? inscriptionTempStorage : "");
        TimedPlace place = this.tapn.getPlaceByName(sourceIn.getName());
        TimedTransition transition = this.tapn.getTransitionByName(targetIn.getName());
        TimeInterval interval = TimeInterval.parse(inscriptionTempStorage, this.constants);
        if (!interval.equals(TimeInterval.ZERO_INF) && this.firstInhibitorIntervalWarning) {
            this.messages.add("The chosen model contained inhibitor arcs with unsupported intervals.\n\nTAPAAL only supports inhibitor arcs with intervals [0,inf).\n\nAny other interval on inhibitor arcs will be replaced with [0,inf).");
            this.firstInhibitorIntervalWarning = false;
        }
        TimedInhibitorArc inhibArc = new TimedInhibitorArc(place, transition, interval, null);
        tempArc.setUnderlyingArc(inhibArc);
        this.guiModel.addPetriNetObject(tempArc);
        this.tapn.add(inhibArc);
        return tempArc;
    }

    private ReductionOption getQueryReductionOption(Element queryElement) {
        ReductionOption reductionOption;
        String reductionString = queryElement.getAttribute("reductionOption");
        String reductionName = "";
        reductionName = reductionString.contains(SYMMETRY) ? reductionString.replace(SYMMETRY, "") : reductionString;
        try {
            reductionOption = ReductionOption.valueOf(reductionName);
        }
        catch (Exception e) {
            reductionOption = ReductionOption.STANDARD;
        }
        return reductionOption;
    }

    private TAPNQuery.ExtrapolationOption getQueryExtrapolationOption(Element queryElement) {
        TAPNQuery.ExtrapolationOption extrapolationOption;
        try {
            extrapolationOption = TAPNQuery.ExtrapolationOption.valueOf(queryElement.getAttribute("extrapolationOption"));
        }
        catch (Exception e) {
            extrapolationOption = TAPNQuery.ExtrapolationOption.AUTOMATIC;
        }
        return extrapolationOption;
    }

    private TAPNQuery.HashTableSize getQueryHashTableSize(Element queryElement) {
        TAPNQuery.HashTableSize hashTableSize;
        try {
            hashTableSize = TAPNQuery.HashTableSize.valueOf(queryElement.getAttribute("hashTableSize"));
        }
        catch (Exception e) {
            hashTableSize = TAPNQuery.HashTableSize.MB_16;
        }
        return hashTableSize;
    }

    private TAPNQuery.SearchOption getQuerySearchOption(Element queryElement) {
        TAPNQuery.SearchOption searchOption;
        try {
            searchOption = TAPNQuery.SearchOption.valueOf(queryElement.getAttribute("searchOption"));
        }
        catch (Exception e) {
            searchOption = TAPNQuery.SearchOption.BFS;
        }
        return searchOption;
    }

    private TAPNQuery.TraceOption getQueryTraceOption(Element queryElement) {
        TAPNQuery.TraceOption traceOption;
        try {
            traceOption = TAPNQuery.TraceOption.valueOf(queryElement.getAttribute("traceOption"));
        }
        catch (Exception e) {
            traceOption = TAPNQuery.TraceOption.NONE;
        }
        return traceOption;
    }

    private String getQueryComment(Element queryElement) {
        String comment;
        try {
            comment = queryElement.getAttribute("name");
        }
        catch (Exception e) {
            comment = "No comment specified";
        }
        return comment;
    }

    private void parseAndAddConstant(Element constantElement) {
        String name = constantElement.getAttribute("name");
        int value = Integer.parseInt(constantElement.getAttribute("value"));
        if (!name.isEmpty() && !name.equals("")) {
            this.constants.add(new Constant(name, value));
        }
    }

    private Template parseTimedArcPetriNetAsOldFormat(Node tapnNode, TimedArcPetriNetNetwork network) throws FormatException {
        this.tapn = new TimedArcPetriNet(this.nameGenerator.getNewTemplateName());
        network.add(this.tapn);
        this.guiModel = new DataLayer();
        Node node = null;
        NodeList nodeList = null;
        nodeList = tapnNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            this.parseElementAsOldFormat(node, this.tapn.name(), network.marking());
        }
        return new Template(this.tapn, this.guiModel, new Zoomer());
    }

    private void parseElementAsOldFormat(Node node, String templateName, TimedMarking marking) throws FormatException {
        if (node instanceof Element) {
            Element element = (Element)node;
            switch (element.getNodeName()) {
                case "labels": {
                    this.parseAndAddAnnotationAsOldFormat(element);
                    break;
                }
                case "place": {
                    this.parseAndAddPlaceAsOldFormat(element, marking);
                    break;
                }
                case "transition": {
                    this.parseAndAddTransitionAsOldFormat(element);
                    break;
                }
                case "arc": {
                    this.parseAndAddArcAsOldFormat(element);
                    break;
                }
                case "queries": {
                    TAPNQuery query = this.parseQueryAsOldFormat(element);
                    if (query == null) break;
                    query.getProperty().accept(new AddTemplateVisitor(templateName), null);
                    this.queries.add(query);
                }
            }
        }
    }

    private boolean doesPlacesUsedInQueryExist(TAPNQuery query, ArrayList<Tuple<String, String>> templatePlaceNames) {
        VerifyPlaceNamesVisitor nameChecker = new VerifyPlaceNamesVisitor(templatePlaceNames);
        VerifyPlaceNamesVisitor.Context c = nameChecker.verifyPlaceNames(query.getProperty());
        return c.getResult();
    }

    private void parseAndAddAnnotationAsOldFormat(Element inputLabelElement) throws FormatException {
        int positionXInput = 0;
        int positionYInput = 0;
        int widthInput = 0;
        int heightInput = 0;
        boolean borderInput = true;
        String positionXTempStorage = inputLabelElement.getAttribute("x");
        String positionYTempStorage = inputLabelElement.getAttribute("y");
        String widthTemp = inputLabelElement.getAttribute("width");
        String heightTemp = inputLabelElement.getAttribute("height");
        String borderTemp = inputLabelElement.getAttribute("border");
        String text = this.getFirstChildNodeByName(inputLabelElement, "text").getTextContent();
        if (positionXTempStorage.length() > 0) {
            positionXInput = Integer.parseInt(positionXTempStorage) + 1;
        }
        if (positionYTempStorage.length() > 0) {
            positionYInput = Integer.parseInt(positionYTempStorage) + 1;
        }
        if (widthTemp.length() > 0) {
            widthInput = Integer.parseInt(widthTemp) + 1;
        }
        if (heightTemp.length() > 0) {
            heightInput = Integer.parseInt(heightTemp) + 1;
        }
        borderInput = borderTemp.length() > 0 ? Boolean.parseBoolean(borderTemp) : true;
        AnnotationNote an = new AnnotationNote(text, positionXInput, positionYInput, widthInput, heightInput, borderInput);
        this.guiModel.addPetriNetObject(an);
    }

    private void parseAndAddTransitionAsOldFormat(Element element) throws FormatException {
        int positionXInput = (int)this.getPositionAttribute(element, "x");
        int positionYInput = (int)this.getPositionAttribute(element, "y");
        String idInput = element.getAttribute("id");
        String nameInput = this.getChildNodesContentOfValueChildNodeAsString(element, "name");
        int nameOffsetXInput = (int)this.getNameOffsetAttribute(element, "x");
        int nameOffsetYInput = (int)this.getNameOffsetAttribute(element, "y");
        boolean timedTransition = this.getContentOfFirstSpecificChildNodesValueChildNodeAsBoolean(element, "timed");
        boolean infiniteServer = this.getContentOfFirstSpecificChildNodesValueChildNodeAsBoolean(element, "infiniteServer");
        int angle = this.getContentOfFirstSpecificChildNodesValueChildNodeAsInt(element, "orientation");
        int priority = this.getContentOfFirstSpecificChildNodesValueChildNodeAsInt(element, "priority");
        this.idResolver.add(this.tapn.name(), idInput, nameInput);
        if (idInput.length() == 0 && nameInput.length() > 0) {
            idInput = nameInput;
        }
        if (nameInput.length() == 0 && idInput.length() > 0) {
            nameInput = idInput;
        }
        TimedTransition t = new TimedTransition(nameInput);
        TimedTransitionComponent transition = new TimedTransitionComponent(positionXInput, positionYInput, idInput, nameOffsetXInput, nameOffsetYInput, angle, this.lens);
        transition.setUnderlyingTransition(t);
        this.guiModel.addPetriNetObject(transition);
        this.tapn.add(t);
    }

    private void parseAndAddPlaceAsOldFormat(Element element, TimedMarking marking) throws FormatException {
        int positionXInput = (int)this.getPositionAttribute(element, "x");
        int positionYInput = (int)this.getPositionAttribute(element, "y");
        String idInput = element.getAttribute("id");
        Object nameInput = this.getChildNodesContentOfValueChildNodeAsString(element, "name");
        int nameOffsetXInput = (int)this.getNameOffsetAttribute(element, "x");
        int nameOffsetYInput = (int)this.getNameOffsetAttribute(element, "y");
        int initialMarkingInput = this.getContentOfFirstSpecificChildNodesValueChildNodeAsInt(element, "initialMarking");
        String invariant = this.getChildNodesContentOfValueChildNodeAsString(element, "invariant");
        if (idInput.length() == 0 && ((String)nameInput).length() > 0) {
            idInput = nameInput;
        }
        if (((String)nameInput).length() == 0 && idInput.length() > 0) {
            nameInput = idInput;
        }
        if (((String)nameInput).equalsIgnoreCase("true") || ((String)nameInput).equalsIgnoreCase("false")) {
            nameInput = "_" + (String)nameInput;
            if (this.firstPlaceRenameWarning) {
                this.messages.add(PLACENAME_ERROR_MESSAGE);
                this.firstPlaceRenameWarning = false;
            }
        }
        this.idResolver.add(this.tapn.name(), idInput, (String)nameInput);
        TimedPlaceComponent place = new TimedPlaceComponent(positionXInput, positionYInput, idInput, nameOffsetXInput, nameOffsetYInput, this.lens);
        LocalTimedPlace p = new LocalTimedPlace((String)nameInput, TimeInvariant.parse(invariant, this.constants), ColorType.COLORTYPE_DOT);
        this.tapn.add(p);
        place.setUnderlyingPlace(p);
        this.guiModel.addPetriNetObject(place);
        for (int i = 0; i < initialMarkingInput; ++i) {
            marking.add(new TimedToken(p, new BigDecimal(0.0), ColorType.COLORTYPE_DOT.getFirstColor()));
        }
    }

    private void parseAndAddArcAsOldFormat(Element inputArcElement) throws FormatException {
        int nameOffsetYInput;
        int nameOffsetXInput;
        String idInput = inputArcElement.getAttribute("id");
        String sourceInput = inputArcElement.getAttribute("source");
        String targetInput = inputArcElement.getAttribute("target");
        boolean taggedArc = this.getContentOfFirstSpecificChildNodesValueChildNodeAsBoolean(inputArcElement, "tagged");
        String inscriptionTempStorage = this.getChildNodesContentOfValueChildNodeAsString(inputArcElement, "inscription");
        if (!inputArcElement.getAttribute("nameOffsetX").equals("") && !inputArcElement.getAttribute("nameOffsetY").equals("")) {
            nameOffsetXInput = (int)Double.parseDouble(inputArcElement.getAttribute("nameOffsetX"));
            nameOffsetYInput = (int)Double.parseDouble(inputArcElement.getAttribute("nameOffsetY"));
        } else {
            nameOffsetXInput = 0;
            nameOffsetYInput = 0;
        }
        sourceInput = this.idResolver.get(this.tapn.name(), sourceInput);
        targetInput = this.idResolver.get(this.tapn.name(), targetInput);
        PlaceTransitionObject sourceIn = this.guiModel.getPlaceTransitionObject(sourceInput);
        PlaceTransitionObject targetIn = this.guiModel.getPlaceTransitionObject(targetInput);
        int aStartx = sourceIn.getX() + sourceIn.centreOffsetLeft();
        int aStarty = sourceIn.getY() + sourceIn.centreOffsetTop();
        int aEndx = targetIn.getX() + targetIn.centreOffsetLeft();
        int aEndy = targetIn.getY() + targetIn.centreOffsetTop();
        String type = "normal";
        type = ((Element)this.getFirstChildNodeByName(inputArcElement, "type")).getAttribute("value");
        Arc tempArc = type.equals("tapnInhibitor") ? this.parseAndAddTimedInhibitorArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, targetIn, aEndx, aEndy) : (type.equals("timed") ? this.parseAndAddTimedInputArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, targetIn, aEndx, aEndy) : (type.equals("transport") ? this.parseAndAddTransportArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, targetIn, aEndx, aEndy) : this.parseAndAddTimedOutputArc(idInput, taggedArc, inscriptionTempStorage, sourceIn, targetIn, aEndx, aEndy)));
        tempArc.setNameOffsetX(nameOffsetXInput);
        tempArc.setNameOffsetY(nameOffsetYInput);
        this.parseArcPathAsOldFormat(inputArcElement, tempArc);
    }

    private void parseArcPathAsOldFormat(Element inputArcElement, Arc tempArc) {
        NodeList nodelist = inputArcElement.getElementsByTagName("arcpath");
        if (nodelist.getLength() > 0) {
            tempArc.getArcPath().purgePathPoints();
            for (int i = 0; i < nodelist.getLength(); ++i) {
                Element element;
                Node node = nodelist.item(i);
                if (!(node instanceof Element) || !"arcpath".equals((element = (Element)node).getNodeName())) continue;
                String arcTempX = element.getAttribute("x");
                String arcTempY = element.getAttribute("y");
                String arcTempType = element.getAttribute("curvePoint");
                double arcPointX = Double.parseDouble(arcTempX);
                double arcPointY = Double.parseDouble(arcTempY);
                boolean arcPointType = Boolean.parseBoolean(arcTempType);
                tempArc.getArcPath().addPoint(arcPointX += 4.0, arcPointY += 4.0, arcPointType);
            }
        }
    }

    private TAPNQuery parseQueryAsOldFormat(Element queryElement) throws FormatException {
        String comment = this.getQueryComment(queryElement);
        TAPNQuery.TraceOption traceOption = this.getQueryTraceOption(queryElement);
        TAPNQuery.SearchOption searchOption = this.getQuerySearchOption(queryElement);
        TAPNQuery.HashTableSize hashTableSize = this.getQueryHashTableSize(queryElement);
        TAPNQuery.ExtrapolationOption extrapolationOption = this.getQueryExtrapolationOption(queryElement);
        ReductionOption reductionOption = this.getQueryReductionOption(queryElement);
        int capacity = this.getQueryCapacityAsOldFormat(queryElement);
        boolean symmetry = this.getSymmetryAsOldFormat(queryElement);
        boolean discreteInclusion = false;
        boolean active = true;
        InclusionPlaces inclusionPlaces = new InclusionPlaces();
        TCTLAbstractProperty query = this.parseQueryPropertyAsOldFormat(queryElement);
        if (query != null) {
            TAPNQuery parsedQuery = new TAPNQuery(comment, capacity, query, traceOption, searchOption, reductionOption, symmetry, true, true, true, false, false, hashTableSize, extrapolationOption, inclusionPlaces, this.lens.isColored());
            parsedQuery.setActive(active);
            parsedQuery.setDiscreteInclusion(discreteInclusion);
            return parsedQuery;
        }
        return null;
    }

    private boolean getSymmetryAsOldFormat(Element queryElement) {
        String reductionString = queryElement.getAttribute("reductionOption");
        return reductionString.contains(SYMMETRY);
    }

    private TCTLAbstractProperty parseQueryPropertyAsOldFormat(Element queryElement) throws FormatException {
        TCTLAbstractProperty query = null;
        String queryToParse = this.getChildNodesContentOfValueChildNodeAsString(queryElement, "query");
        try {
            query = TAPAALQueryParser.parse(queryToParse);
        }
        catch (Exception e) {
            if (this.firstQueryParsingWarning) {
                this.messages.add(ERROR_PARSING_QUERY_MESSAGE);
                this.firstQueryParsingWarning = false;
            }
            System.err.println("No query was specified: ");
            e.printStackTrace();
        }
        return query;
    }

    private int getQueryCapacityAsOldFormat(Element queryElement) throws FormatException {
        return this.getContentOfFirstSpecificChildNodesValueChildNodeAsInt(queryElement, "capacity");
    }

    private boolean getContentOfFirstSpecificChildNodesValueChildNodeAsBoolean(Element element, String childNodeName) throws FormatException {
        Node node = this.getFirstChildNodeByName(element, childNodeName);
        if (node instanceof Element) {
            Element e = (Element)node;
            String value = this.getContentOfValueChildNode(e);
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private double getNameOffsetAttribute(Element element, String coordinateName) throws FormatException {
        Element e;
        Element graphics;
        String offsetCoordinate;
        Node node = this.getFirstChildNodeByName(element, "name");
        if (node instanceof Element && (offsetCoordinate = ((Element)this.getFirstChildNodeByName(graphics = (Element)this.getFirstChildNodeByName(e = (Element)node, "graphics"), "offset")).getAttribute(coordinateName)).length() > 0) {
            return Double.parseDouble(offsetCoordinate);
        }
        return 0.0;
    }

    private Node getFirstChildNodeByName(Element element, String childNodeName) throws FormatException {
        Node node = element.getElementsByTagName(childNodeName).item(0);
        if (node == null) {
            throw new FormatException("TAPAAL could not recognize save format.");
        }
        return node;
    }

    private String getContentOfValueChildNode(Element element) throws FormatException {
        return this.getFirstChildNodeByName(element, "value").getTextContent();
    }

    private String getChildNodesContentOfValueChildNodeAsString(Element element, String childNodeName) throws FormatException {
        Node node = this.getFirstChildNodeByName(element, childNodeName);
        if (node instanceof Element) {
            Element e = (Element)node;
            return this.getContentOfValueChildNode(e);
        }
        return "";
    }

    private double getPositionAttribute(Element element, String coordinateName) throws FormatException {
        Element e;
        String posCoordinate;
        Node node = this.getFirstChildNodeByName(element, "graphics");
        if (node instanceof Element && (posCoordinate = ((Element)this.getFirstChildNodeByName(e = (Element)node, "position")).getAttribute(coordinateName)).length() > 0) {
            return Double.parseDouble(posCoordinate);
        }
        return 0.0;
    }

    private int getContentOfFirstSpecificChildNodesValueChildNodeAsInt(Element element, String childNodeName) throws FormatException {
        Element e;
        String value;
        Node node = this.getFirstChildNodeByName(element, childNodeName);
        if (node instanceof Element && (value = this.getContentOfValueChildNode(e = (Element)node)).length() > 0) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private double getMarkingOffsetAttribute(Element element, String coordinateName) throws FormatException {
        Element e;
        Element graphics;
        String offsetCoordinate;
        Node node = this.getFirstChildNodeByName(element, "initialMarking");
        if (node instanceof Element && (offsetCoordinate = ((Element)this.getFirstChildNodeByName(graphics = (Element)this.getFirstChildNodeByName(e = (Element)node, "graphics"), "offset")).getAttribute(coordinateName)).length() > 0) {
            return Double.parseDouble(offsetCoordinate);
        }
        return 0.0;
    }
}

