/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.io;

import dk.aau.cs.io.batchProcessing.LoadedBatchProcessingModel;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import java.util.Collection;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.verification.TAPNQuery;

public class LoadedModel
implements LoadedBatchProcessingModel {
    private final Collection<Template> templates;
    private final Collection<TAPNQuery> queries;
    private final TimedArcPetriNetNetwork network;
    private final Collection<String> messages;
    private final TAPNLens lens;

    public LoadedModel(TimedArcPetriNetNetwork network, Collection<Template> templates, Collection<TAPNQuery> queries, Collection<String> messages, TAPNLens lens) {
        this.templates = templates;
        this.network = network;
        this.queries = queries;
        this.lens = lens;
        this.messages = messages;
    }

    public Collection<Template> templates() {
        return this.templates;
    }

    @Override
    public Collection<TAPNQuery> queries() {
        return this.queries;
    }

    @Override
    public TimedArcPetriNetNetwork network() {
        return this.network;
    }

    public Collection<String> getMessages() {
        return this.messages;
    }

    public TAPNLens getLens() {
        if (this.lens != null) {
            return this.lens;
        }
        boolean isNetTimed = !this.network().isUntimed();
        boolean isNetGame = this.network().hasUncontrollableTransitions();
        boolean isNetColored = this.network().isColored();
        boolean isNetStochastic = this.network().isStochastic();
        return new TAPNLens(isNetTimed, isNetGame, isNetColored, isNetStochastic);
    }

    public boolean isColored() {
        return this.lens.isColored();
    }
}

