/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.AritmeticOperator;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLAndListNode;
import dk.aau.cs.TCTL.TCTLAtomicPropositionNode;
import dk.aau.cs.TCTL.TCTLConstNode;
import dk.aau.cs.TCTL.TCTLDeadlockNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.TCTL.TCTLFalseNode;
import dk.aau.cs.TCTL.TCTLNotNode;
import dk.aau.cs.TCTL.TCTLOrListNode;
import dk.aau.cs.TCTL.TCTLPlusListNode;
import dk.aau.cs.TCTL.TCTLTermListNode;
import dk.aau.cs.TCTL.TCTLTrueNode;
import dk.aau.cs.TCTL.visitors.VisitorBase;
import dk.aau.cs.model.tapn.TAPNQuery;
import java.util.List;

public abstract class QueryVisitor
extends VisitorBase {
    private StringBuffer uppaalQuery;

    protected void append(String string) {
        this.uppaalQuery.append(string);
    }

    protected void append(int number) {
        this.uppaalQuery.append(number);
    }

    public String getUppaalQueryFor(TAPNQuery tapnQuery) {
        this.uppaalQuery = new StringBuffer();
        tapnQuery.getProperty().accept(this, null);
        return this.uppaalQuery.toString();
    }

    @Override
    public void visit(TCTLAFNode afNode, Object context) {
        this.uppaalQuery.append("A<> ");
        afNode.getProperty().accept(this, context);
        this.addEnding(QueryType.AF);
    }

    @Override
    public void visit(TCTLAGNode agNode, Object context) {
        this.uppaalQuery.append("A[] ");
        agNode.getProperty().accept(this, context);
        this.addEnding(QueryType.AG);
    }

    @Override
    public void visit(TCTLEFNode efNode, Object context) {
        this.uppaalQuery.append("E<> ");
        efNode.getProperty().accept(this, context);
        this.addEnding(QueryType.EF);
    }

    @Override
    public void visit(TCTLEGNode egNode, Object context) {
        this.uppaalQuery.append("E[] ");
        egNode.getProperty().accept(this, context);
        this.addEnding(QueryType.EG);
    }

    @Override
    public void visit(TCTLAndListNode andListNode, Object context) {
        this.createList(andListNode.getProperties(), context, "&&");
    }

    @Override
    public void visit(TCTLOrListNode orListNode, Object context) {
        this.createList(orListNode.getProperties(), context, "||");
    }

    private void createList(List<TCTLAbstractStateProperty> properties, Object context, String seperator) {
        this.uppaalQuery.append('(');
        boolean firstTime = true;
        for (TCTLAbstractStateProperty p : properties) {
            if (!firstTime) {
                this.uppaalQuery.append(" " + seperator + " ");
            }
            p.accept(this, context);
            firstTime = false;
        }
        this.uppaalQuery.append(')');
    }

    @Override
    public void visit(TCTLNotNode notNode, Object context) {
        this.uppaalQuery.append('!');
        this.uppaalQuery.append('(');
        notNode.getProperty().accept(this, context);
        this.uppaalQuery.append(')');
    }

    @Override
    public void visit(TCTLTrueNode tctlTrueNode, Object context) {
        this.uppaalQuery.append(tctlTrueNode.toString());
    }

    @Override
    public void visit(TCTLFalseNode tctlFalseNode, Object context) {
        this.uppaalQuery.append(tctlFalseNode.toString());
    }

    @Override
    public void visit(TCTLDeadlockNode tctlDeadLockNode, Object context) {
        this.uppaalQuery.append(tctlDeadLockNode.toString());
    }

    @Override
    public void visit(AritmeticOperator aritmeticOperator, Object context) {
        this.uppaalQuery.append(aritmeticOperator.toString());
    }

    @Override
    public void visit(TCTLPlusListNode tctlPlusListNode, Object context) {
        this.createArithmeticList(tctlPlusListNode.getProperties(), context);
    }

    @Override
    public void visit(TCTLTermListNode tctlTermListNode, Object context) {
        this.createArithmeticList(tctlTermListNode.getProperties(), context);
    }

    private void createArithmeticList(List<TCTLAbstractStateProperty> properties, Object context) {
        for (TCTLAbstractStateProperty prop : properties) {
            if (prop.isSimpleProperty()) {
                prop.accept(this, context);
            } else {
                this.uppaalQuery.append("(");
                prop.accept(this, context);
                this.uppaalQuery.append(")");
            }
            this.uppaalQuery.append(" ");
        }
    }

    @Override
    public void visit(TCTLConstNode tctlConstNode, Object context) {
        this.append(tctlConstNode.getConstant());
    }

    @Override
    public void visit(TCTLAtomicPropositionNode atomicPropositionNode, Object context) {
        this.append("(");
        atomicPropositionNode.getLeft().accept(this, context);
        this.append(this.operatorConversion(atomicPropositionNode.getOp()));
        this.append(" ");
        atomicPropositionNode.getRight().accept(this, context);
        this.append(")");
    }

    protected String operatorConversion(String op) {
        if (op.equals("=")) {
            return "==";
        }
        return op;
    }

    protected abstract void addEnding(QueryType var1);

    protected static enum QueryType {
        EF,
        EG,
        AF,
        AG;

    }
}

