/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.visitors.QueryVisitor;

public class OptimizedStandardTranslationQueryVisitor
extends QueryVisitor {
    protected static final String ID_TYPE = "pid_t";
    protected static final String LOCK_TEMPLATE = "Lock";
    protected static final String PLOCK = "P_lock";
    protected static final String CONTROL = "Control";
    protected static final String FINISH = "finish";
    protected static final String LOCK_BOOL = "lock";
    protected static final String TOKEN_TEMPLATE_NAME = "Token";
    private final boolean useSymmetry;
    private final int totalTokens;

    public OptimizedStandardTranslationQueryVisitor(int totalTokens, boolean useSymmetry) {
        this.useSymmetry = useSymmetry;
        this.totalTokens = totalTokens;
    }

    @Override
    public void visit(TCTLPlaceNode placeNode, Object context) {
        if (this.useSymmetry) {
            this.append("(sum(i:");
            this.append(ID_TYPE);
            this.append(")");
            this.append(TOKEN_TEMPLATE_NAME);
            this.append("(i).");
            this.append(placeNode.getPlace());
            this.append(")");
        } else {
            this.append(this.createAtomicPropositionSum(placeNode.getPlace()));
        }
    }

    @Override
    protected void addEnding(QueryVisitor.QueryType type) {
        if (type == QueryVisitor.QueryType.EF || type == QueryVisitor.QueryType.AF) {
            this.append(" && ");
        } else {
            this.append(" || !");
        }
        if (this.useSymmetry) {
            this.append(String.format("(%1$s.%2$s == 1 && %3$s.%4$s == 1 && %5$s == 0)", LOCK_TEMPLATE, PLOCK, CONTROL, FINISH, LOCK_BOOL));
        } else {
            this.append(String.format("(%1$s.%2$s == 1)", LOCK_TEMPLATE, PLOCK));
        }
    }

    private String createAtomicPropositionSum(String place) {
        StringBuilder sum = new StringBuilder("(");
        for (int i = 0; i < this.totalTokens; ++i) {
            sum.append(String.format("%1$s%2$s.%3$s", TOKEN_TEMPLATE_NAME, i, place));
            if (i == this.totalTokens - 1) continue;
            sum.append(" + ");
        }
        sum.append(')');
        return sum.toString();
    }
}

