/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.AritmeticOperator;
import dk.aau.cs.TCTL.LTLANode;
import dk.aau.cs.TCTL.LTLENode;
import dk.aau.cs.TCTL.LTLFNode;
import dk.aau.cs.TCTL.LTLGNode;
import dk.aau.cs.TCTL.LTLUNode;
import dk.aau.cs.TCTL.LTLXNode;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLAndListNode;
import dk.aau.cs.TCTL.TCTLAtomicPropositionNode;
import dk.aau.cs.TCTL.TCTLConstNode;
import dk.aau.cs.TCTL.TCTLDeadlockNode;
import dk.aau.cs.TCTL.TCTLFalseNode;
import dk.aau.cs.TCTL.TCTLNotNode;
import dk.aau.cs.TCTL.TCTLOrListNode;
import dk.aau.cs.TCTL.TCTLPathToStateConverter;
import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.TCTLTermListNode;
import dk.aau.cs.TCTL.TCTLTransitionNode;
import dk.aau.cs.TCTL.TCTLTrueNode;
import dk.aau.cs.TCTL.visitors.VisitorBase;
import dk.aau.cs.io.XMLFormatter;
import java.util.List;

public class LTLQueryVisitor
extends VisitorBase {
    protected static final String XML_NS = "xmlns=\"http://tapaal.net/\"";
    protected static final String XML_PROPSET = "property-set";
    protected static final String XML_PROP = "property";
    protected static final String XML_PROPID = "id";
    protected static final String XML_PROPDESC = "description";
    protected static final String XML_FORMULA = "formula";
    protected static final String XML_ALLPATHS = "all-paths";
    protected static final String XML_EXISTSPATH = "exists-path";
    protected static final String XML_NEGATION = "negation";
    protected static final String XML_CONJUNCTION = "conjunction";
    protected static final String XML_DISJUNCTION = "disjunction";
    protected static final String XML_GLOBALLY = "globally";
    protected static final String XML_FINALLY = "finally";
    protected static final String XML_NEXT = "next";
    protected static final String XML_UNTIL = "until";
    protected static final String XML_BEFORE = "before";
    protected static final String XML_REACH = "reach";
    protected static final String XML_DEADLOCK = "deadlock";
    protected static final String XML_TRUE = "true";
    protected static final String XML_FALSE = "false";
    protected static final String XML_INTEGERLT = "integer-lt";
    protected static final String XML_INTEGERLE = "integer-le";
    protected static final String XML_INTEGEREQ = "integer-eq";
    protected static final String XML_INTEGERNE = "integer-ne";
    protected static final String XML_INTEGERGT = "integer-gt";
    protected static final String XML_INTEGERGE = "integer-ge";
    protected static final String XML_ISFIREABLE = "is-fireable";
    protected static final String XML_INTEGERCONSTANT = "integer-constant";
    protected static final String XML_TOKENSCOUNT = "tokens-count";
    protected static final String XML_PLACE = "place";
    protected static final String XML_TRANSITION = "transition";
    protected static final String XML_INTEGERSUM = "integer-sum";
    protected static final String XML_INTEGERPRODUCT = "integer-product";
    protected static final String XML_INTEGERDIFFERENCE = "integer-difference";
    protected final StringBuffer xmlQuery = new StringBuffer();

    public String getXMLQueryFor(TCTLAbstractProperty property, String queryName) {
        this.buildXMLQuery(property, queryName);
        return this.getFormatted();
    }

    public StringBuffer getXMLQuery() {
        return this.xmlQuery;
    }

    public void buildXMLQuery(TCTLAbstractProperty property, String queryName) {
        this.xmlQuery.append(this.startTag(XML_PROP) + this.queryInfo(queryName) + this.startTag(XML_FORMULA));
        property.accept(this, null);
        this.xmlQuery.append(this.endTag(XML_FORMULA) + this.endTag(XML_PROP));
    }

    public String getFormatted() {
        XMLFormatter formatter = new XMLFormatter();
        return formatter.format(this.getStartTag() + this.xmlQuery.toString() + this.getEndTag());
    }

    public String getFormatted(StringBuffer CTLQueries) {
        XMLFormatter formatter = new XMLFormatter();
        this.xmlQuery.append(CTLQueries);
        return formatter.format(this.getStartTag() + this.xmlQuery.toString() + this.getEndTag());
    }

    public String getStartTag() {
        return this.startTag("property-set xmlns=\"http://tapaal.net/\"") + "\n";
    }

    public String getEndTag() {
        return this.endTag(XML_PROPSET) + "\n";
    }

    protected String queryInfo(String queryName) {
        String nameToPrint = queryName == null ? "Query Comment/Name Here" : queryName;
        return this.wrapInTag(nameToPrint, XML_PROPID) + this.wrapInTag(nameToPrint, XML_PROPDESC);
    }

    @Override
    public void visit(LTLANode aNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_ALLPATHS));
        aNode.getProperty().accept(this, context);
        this.xmlQuery.append(this.endTag(XML_ALLPATHS));
    }

    @Override
    public void visit(LTLENode eNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_EXISTSPATH));
        eNode.getProperty().accept(this, context);
        this.xmlQuery.append(this.endTag(XML_EXISTSPATH));
    }

    @Override
    public void visit(LTLFNode afNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_FINALLY));
        afNode.getProperty().accept(this, context);
        this.xmlQuery.append(this.endTag(XML_FINALLY));
    }

    @Override
    public void visit(LTLGNode agNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_GLOBALLY));
        agNode.getProperty().accept(this, context);
        this.xmlQuery.append(this.endTag(XML_GLOBALLY));
    }

    @Override
    public void visit(LTLXNode axNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_NEXT));
        axNode.getProperty().accept(this, context);
        this.xmlQuery.append(this.endTag(XML_NEXT));
    }

    @Override
    public void visit(LTLUNode auNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_UNTIL) + this.startTag(XML_BEFORE));
        auNode.getLeft().accept(this, context);
        this.xmlQuery.append(this.endTag(XML_BEFORE) + this.startTag(XML_REACH));
        auNode.getRight().accept(this, context);
        this.xmlQuery.append(this.endTag(XML_REACH) + this.endTag(XML_UNTIL));
    }

    @Override
    public void visit(TCTLPathToStateConverter pathConverter, Object context) {
        pathConverter.getProperty().accept(this, context);
    }

    @Override
    public void visit(TCTLAndListNode andListNode, Object context) {
        this.createList(andListNode.getProperties(), context, XML_CONJUNCTION);
    }

    @Override
    public void visit(TCTLOrListNode orListNode, Object context) {
        this.createList(orListNode.getProperties(), context, XML_DISJUNCTION);
    }

    @Override
    public void visit(TCTLTermListNode termListNode, Object context) {
        String op;
        assert (termListNode.getProperties().get(1) instanceof AritmeticOperator);
        AritmeticOperator operator = (AritmeticOperator)termListNode.getProperties().get(1);
        switch (op = operator.toString()) {
            case "+": {
                this.createList(termListNode.getProperties(), context, XML_INTEGERSUM);
                break;
            }
            case "*": {
                this.createList(termListNode.getProperties(), context, XML_INTEGERPRODUCT);
                break;
            }
            case "-": {
                this.createList(termListNode.getProperties(), context, XML_INTEGERDIFFERENCE);
            }
        }
    }

    private void createList(List<TCTLAbstractStateProperty> properties, Object context, String seperator) {
        this.xmlQuery.append(this.startTag(seperator));
        for (TCTLAbstractStateProperty p : properties) {
            p.accept(this, context);
        }
        this.xmlQuery.append(this.endTag(seperator));
    }

    @Override
    public void visit(TCTLNotNode notNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_NEGATION));
        notNode.getProperty().accept(this, context);
        this.xmlQuery.append(this.endTag(XML_NEGATION));
    }

    @Override
    public void visit(TCTLTrueNode tctlTrueNode, Object context) {
        this.xmlQuery.append(this.emptyElement(XML_TRUE));
    }

    @Override
    public void visit(TCTLFalseNode tctlFalseNode, Object context) {
        this.xmlQuery.append(this.emptyElement(XML_FALSE));
    }

    @Override
    public void visit(TCTLDeadlockNode tctlDeadLockNode, Object context) {
        this.xmlQuery.append(this.emptyElement(XML_DEADLOCK));
    }

    @Override
    public void visit(TCTLConstNode tctlConstNode, Object context) {
        this.xmlQuery.append(this.wrapInTag("" + tctlConstNode.getConstant(), XML_INTEGERCONSTANT));
    }

    @Override
    public void visit(TCTLPlaceNode tctlPlaceNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_TOKENSCOUNT));
        this.xmlQuery.append(this.wrapInTag(tctlPlaceNode.toString(), XML_PLACE));
        this.xmlQuery.append(this.endTag(XML_TOKENSCOUNT));
    }

    @Override
    public void visit(TCTLTransitionNode tctlTransitionNode, Object context) {
        this.xmlQuery.append(this.startTag(XML_ISFIREABLE));
        this.xmlQuery.append(this.wrapInTag(tctlTransitionNode.toString(), XML_TRANSITION));
        this.xmlQuery.append(this.endTag(XML_ISFIREABLE));
    }

    @Override
    public void visit(TCTLAtomicPropositionNode atomicPropositionNode, Object context) {
        String op;
        String opTest;
        switch (opTest = atomicPropositionNode.getOp()) {
            case "<": {
                op = XML_INTEGERLT;
                break;
            }
            case "<=": {
                op = XML_INTEGERLE;
                break;
            }
            case "=": {
                op = XML_INTEGEREQ;
                break;
            }
            case "!=": {
                op = XML_INTEGERNE;
                break;
            }
            case ">": {
                op = XML_INTEGERGT;
                break;
            }
            case ">=": {
                op = XML_INTEGERGE;
                break;
            }
            default: {
                op = "MISSING_OPERATOR";
            }
        }
        this.xmlQuery.append(this.startTag(op));
        atomicPropositionNode.getLeft().accept(this, context);
        atomicPropositionNode.getRight().accept(this, context);
        this.xmlQuery.append(this.endTag(op));
    }

    protected String wrapInTag(String str, String tag) {
        return this.startTag(tag) + str + this.endTag(tag);
    }

    protected String startTag(String tag) {
        return "<" + tag + ">";
    }

    protected String endTag(String tag) {
        return "</" + tag + ">";
    }

    protected String emptyElement(String tag) {
        return this.startTag(tag + "/");
    }
}

