/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.AritmeticOperator;
import dk.aau.cs.TCTL.HyperLTLPathScopeNode;
import dk.aau.cs.TCTL.LTLANode;
import dk.aau.cs.TCTL.LTLENode;
import dk.aau.cs.TCTL.LTLFNode;
import dk.aau.cs.TCTL.LTLGNode;
import dk.aau.cs.TCTL.LTLUNode;
import dk.aau.cs.TCTL.LTLXNode;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLAndListNode;
import dk.aau.cs.TCTL.TCTLAtomicPropositionNode;
import dk.aau.cs.TCTL.TCTLConstNode;
import dk.aau.cs.TCTL.TCTLDeadlockNode;
import dk.aau.cs.TCTL.TCTLFalseNode;
import dk.aau.cs.TCTL.TCTLNotNode;
import dk.aau.cs.TCTL.TCTLOrListNode;
import dk.aau.cs.TCTL.TCTLPathToStateConverter;
import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.TCTLTermListNode;
import dk.aau.cs.TCTL.TCTLTransitionNode;
import dk.aau.cs.TCTL.TCTLTrueNode;
import dk.aau.cs.TCTL.visitors.VisitorBase;
import dk.aau.cs.io.XMLFormatter;
import java.util.List;

public class HyperLTLQueryVisitor
extends VisitorBase {
    private static final String XML_NS = "xmlns=\"http://tapaal.net/\"";
    private static final String XML_PROPSET = "property-set";
    private static final String XML_PROP = "property";
    private static final String XML_PROPID = "id";
    private static final String XML_PROPDESC = "description";
    private static final String XML_FORMULA = "formula";
    private static final String XML_ALLPATHS = "all-paths";
    private static final String XML_EXISTSPATH = "exists-path";
    private static final String XML_NEGATION = "negation";
    private static final String XML_CONJUNCTION = "conjunction";
    private static final String XML_DISJUNCTION = "disjunction";
    private static final String XML_GLOBALLY = "globally";
    private static final String XML_FINALLY = "finally";
    private static final String XML_NEXT = "next";
    private static final String XML_UNTIL = "until";
    private static final String XML_BEFORE = "before";
    private static final String XML_REACH = "reach";
    private static final String XML_DEADLOCK = "deadlock";
    private static final String XML_TRUE = "true";
    private static final String XML_FALSE = "false";
    private static final String XML_INTEGERLT = "integer-lt";
    private static final String XML_INTEGERLE = "integer-le";
    private static final String XML_INTEGEREQ = "integer-eq";
    private static final String XML_INTEGERNE = "integer-ne";
    private static final String XML_INTEGERGT = "integer-gt";
    private static final String XML_INTEGERGE = "integer-ge";
    private static final String XML_ISFIREABLE = "is-fireable";
    private static final String XML_INTEGERCONSTANT = "integer-constant";
    private static final String XML_TOKENSCOUNT = "tokens-count";
    private static final String XML_PLACE = "place";
    private static final String XML_TRANSITION = "transition";
    private static final String XML_INTEGERSUM = "integer-sum";
    private static final String XML_INTEGERPRODUCT = "integer-product";
    private static final String XML_INTEGERDIFFERENCE = "integer-difference";
    private static final String XML_PATHSCOPE = "path-scope";
    private static final String XML_NAME = "name=";
    private final StringBuffer XMLQuery = new StringBuffer();

    public String getXMLQueryFor(TCTLAbstractProperty property, String queryName) {
        this.buildXMLQuery(property, queryName);
        return this.getFormatted();
    }

    public StringBuffer getXMLQuery() {
        return this.XMLQuery;
    }

    public void buildXMLQuery(TCTLAbstractProperty property, String queryName) {
        this.XMLQuery.append(this.startTag(XML_PROP) + this.queryInfo(queryName) + this.startTag(XML_FORMULA));
        property.accept(this, null);
        this.XMLQuery.append(this.endTag(XML_FORMULA) + this.endTag(XML_PROP));
    }

    public String getFormatted() {
        XMLFormatter formatter = new XMLFormatter();
        return formatter.format(this.getStartTag() + this.XMLQuery.toString() + this.getEndTag());
    }

    public String getFormatted(StringBuffer LTLQueries, StringBuffer CTLQueries) {
        XMLFormatter formatter = new XMLFormatter();
        this.XMLQuery.append(LTLQueries);
        this.XMLQuery.append(CTLQueries);
        return formatter.format(this.getStartTag() + this.XMLQuery.toString() + this.getEndTag());
    }

    public String getStartTag() {
        return this.startTag("property-set xmlns=\"http://tapaal.net/\"") + "\n";
    }

    public String getEndTag() {
        return this.endTag(XML_PROPSET) + "\n";
    }

    private String queryInfo(String queryName) {
        String nameToPrint = queryName == null ? "Query Comment/Name Here" : queryName;
        return this.wrapInTag(nameToPrint, XML_PROPID) + this.wrapInTag(nameToPrint, XML_PROPDESC);
    }

    @Override
    public void visit(HyperLTLPathScopeNode pathScopeNode, Object context) {
        this.XMLQuery.append(this.insertNameAttributeInStartTag(XML_PATHSCOPE, pathScopeNode.getTrace()));
        pathScopeNode.getProperty().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_PATHSCOPE));
    }

    @Override
    public void visit(LTLANode aNode, Object context) {
        this.XMLQuery.append(this.insertNameAttributeInStartTag(XML_ALLPATHS, aNode.getTrace()));
        aNode.getProperty().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_ALLPATHS));
    }

    @Override
    public void visit(LTLENode eNode, Object context) {
        this.XMLQuery.append(this.insertNameAttributeInStartTag(XML_EXISTSPATH, eNode.getTrace()));
        eNode.getProperty().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_EXISTSPATH));
    }

    @Override
    public void visit(LTLFNode afNode, Object context) {
        this.XMLQuery.append(this.startTag(XML_FINALLY));
        afNode.getProperty().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_FINALLY));
    }

    @Override
    public void visit(LTLGNode agNode, Object context) {
        this.XMLQuery.append(this.startTag(XML_GLOBALLY));
        agNode.getProperty().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_GLOBALLY));
    }

    @Override
    public void visit(LTLXNode axNode, Object context) {
        this.XMLQuery.append(this.startTag(XML_NEXT));
        axNode.getProperty().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_NEXT));
    }

    @Override
    public void visit(LTLUNode auNode, Object context) {
        this.XMLQuery.append(this.startTag(XML_UNTIL) + this.startTag(XML_BEFORE));
        auNode.getLeft().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_BEFORE) + this.startTag(XML_REACH));
        auNode.getRight().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_REACH) + this.endTag(XML_UNTIL));
    }

    @Override
    public void visit(TCTLPathToStateConverter pathConverter, Object context) {
        pathConverter.getProperty().accept(this, context);
    }

    @Override
    public void visit(TCTLAndListNode andListNode, Object context) {
        this.createList(andListNode.getProperties(), context, XML_CONJUNCTION);
    }

    @Override
    public void visit(TCTLOrListNode orListNode, Object context) {
        this.createList(orListNode.getProperties(), context, XML_DISJUNCTION);
    }

    @Override
    public void visit(TCTLTermListNode termListNode, Object context) {
        String op;
        assert (termListNode.getProperties().get(1) instanceof AritmeticOperator);
        AritmeticOperator operator = (AritmeticOperator)termListNode.getProperties().get(1);
        switch (op = operator.toString()) {
            case "+": {
                this.createList(termListNode.getProperties(), context, XML_INTEGERSUM);
                break;
            }
            case "*": {
                this.createList(termListNode.getProperties(), context, XML_INTEGERPRODUCT);
                break;
            }
            case "-": {
                this.createList(termListNode.getProperties(), context, XML_INTEGERDIFFERENCE);
            }
        }
    }

    private void createList(List<TCTLAbstractStateProperty> properties, Object context, String seperator) {
        this.XMLQuery.append(this.startTag(seperator));
        for (TCTLAbstractStateProperty p : properties) {
            p.accept(this, context);
        }
        this.XMLQuery.append(this.endTag(seperator));
    }

    @Override
    public void visit(TCTLNotNode notNode, Object context) {
        this.XMLQuery.append(this.startTag(XML_NEGATION));
        notNode.getProperty().accept(this, context);
        this.XMLQuery.append(this.endTag(XML_NEGATION));
    }

    @Override
    public void visit(TCTLTrueNode tctlTrueNode, Object context) {
        this.XMLQuery.append(this.emptyElement(XML_TRUE));
    }

    @Override
    public void visit(TCTLFalseNode tctlFalseNode, Object context) {
        this.XMLQuery.append(this.emptyElement(XML_FALSE));
    }

    @Override
    public void visit(TCTLDeadlockNode tctlDeadLockNode, Object context) {
        this.XMLQuery.append(this.emptyElement(XML_DEADLOCK));
    }

    @Override
    public void visit(TCTLConstNode tctlConstNode, Object context) {
        this.XMLQuery.append(this.wrapInTag("" + tctlConstNode.getConstant(), XML_INTEGERCONSTANT));
    }

    @Override
    public void visit(TCTLPlaceNode tctlPlaceNode, Object context) {
        this.XMLQuery.append(this.startTag(XML_TOKENSCOUNT));
        this.XMLQuery.append(this.wrapInTag(tctlPlaceNode.toString(), XML_PLACE));
        this.XMLQuery.append(this.endTag(XML_TOKENSCOUNT));
    }

    @Override
    public void visit(TCTLTransitionNode tctlTransitionNode, Object context) {
        this.XMLQuery.append(this.startTag(XML_ISFIREABLE));
        this.XMLQuery.append(this.wrapInTag(tctlTransitionNode.toString(), XML_TRANSITION));
        this.XMLQuery.append(this.endTag(XML_ISFIREABLE));
    }

    @Override
    public void visit(TCTLAtomicPropositionNode atomicPropositionNode, Object context) {
        String op;
        String opTest;
        switch (opTest = atomicPropositionNode.getOp()) {
            case "<": {
                op = XML_INTEGERLT;
                break;
            }
            case "<=": {
                op = XML_INTEGERLE;
                break;
            }
            case "=": {
                op = XML_INTEGEREQ;
                break;
            }
            case "!=": {
                op = XML_INTEGERNE;
                break;
            }
            case ">": {
                op = XML_INTEGERGT;
                break;
            }
            case ">=": {
                op = XML_INTEGERGE;
                break;
            }
            default: {
                op = "MISSING_OPERATOR";
            }
        }
        this.XMLQuery.append(this.startTag(op));
        atomicPropositionNode.getLeft().accept(this, context);
        atomicPropositionNode.getRight().accept(this, context);
        this.XMLQuery.append(this.endTag(op));
    }

    private String wrapInTag(String str, String tag) {
        return this.startTag(tag) + str + this.endTag(tag);
    }

    private String insertNameAttributeInStartTag(String tag, String traceName) {
        return "<" + tag + " name=\"" + traceName + "\">";
    }

    private String startTag(String tag) {
        return "<" + tag + ">";
    }

    private String endTag(String tag) {
        return "</" + tag + ">";
    }

    private String emptyElement(String tag) {
        return this.startTag(tag + "/");
    }
}

