/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL.visitors;

import dk.aau.cs.TCTL.TCTLPlaceNode;
import dk.aau.cs.TCTL.visitors.QueryVisitor;

public class BroadcastTranslationQueryVisitor
extends QueryVisitor {
    protected static final String ID_TYPE = "id_t";
    protected static final String PLOCK = "P_lock";
    protected static final String TOKEN_TEMPLATE_NAME = "Token";
    private final boolean useSymmetry;
    private final int totalTokens;

    public BroadcastTranslationQueryVisitor(boolean useSymmetry, int totalTokens) {
        this.useSymmetry = useSymmetry;
        this.totalTokens = totalTokens;
    }

    @Override
    public void visit(TCTLPlaceNode placeNode, Object context) {
        if (this.useSymmetry) {
            this.append("(sum(i:");
            this.append(ID_TYPE);
            this.append(")");
            this.append(TOKEN_TEMPLATE_NAME);
            this.append("(i).");
            this.append(placeNode.getPlace());
            this.append(")");
        } else if (this.totalTokens == 0) {
            this.append("(");
            this.append(TOKEN_TEMPLATE_NAME);
            this.append(".");
            this.append(placeNode.getPlace());
            this.append(")");
        } else {
            this.append("(");
            for (int i = 0; i < this.totalTokens; ++i) {
                if (i > 0) {
                    this.append(" + ");
                }
                this.append(TOKEN_TEMPLATE_NAME);
                this.append(i);
                this.append(".");
                this.append(placeNode.getPlace());
            }
            this.append(")");
        }
    }

    @Override
    protected void addEnding(QueryVisitor.QueryType type) {
        if (type == QueryVisitor.QueryType.EF || type == QueryVisitor.QueryType.AF) {
            this.append(" && ");
        } else {
            this.append(" || !");
        }
        this.append("Control.");
        this.append(PLOCK);
    }
}

