/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.TCTL;

import dk.aau.cs.TCTL.StringPosition;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLAbstractStateProperty;
import dk.aau.cs.TCTL.TCTLPathToStateConverter;
import dk.aau.cs.TCTL.TCTLStatePlaceHolder;
import dk.aau.cs.TCTL.visitors.ITCTLVisitor;
import java.util.ArrayList;
import java.util.List;

public class TCTLOrListNode
extends TCTLAbstractStateProperty {
    private List<TCTLAbstractStateProperty> properties;
    private boolean isSimpleProperty;

    public void setProperties(List<TCTLAbstractStateProperty> properties) {
        this.properties = properties;
        for (TCTLAbstractStateProperty p : properties) {
            p.setParent(this);
        }
    }

    public List<TCTLAbstractStateProperty> getProperties() {
        return this.properties;
    }

    public TCTLOrListNode(List<TCTLAbstractStateProperty> properties) {
        this.properties = properties;
        for (TCTLAbstractStateProperty p : properties) {
            p.setParent(this);
        }
    }

    public TCTLOrListNode(TCTLOrListNode orListNode) {
        this.properties = new ArrayList<TCTLAbstractStateProperty>();
        for (TCTLAbstractStateProperty p : orListNode.properties) {
            this.addDisjunct(p.copy());
        }
    }

    public TCTLOrListNode(TCTLAbstractStateProperty property1, TCTLAbstractStateProperty property2) {
        this.properties = new ArrayList<TCTLAbstractStateProperty>();
        this.addDisjunct(property1);
        this.addDisjunct(property2);
    }

    public TCTLOrListNode() {
        this.properties = new ArrayList<TCTLAbstractStateProperty>();
        TCTLStatePlaceHolder ph = new TCTLStatePlaceHolder();
        ph.setParent(this);
        this.properties.add(ph);
        ph = new TCTLStatePlaceHolder();
        ph.setParent(this);
        this.properties.add(ph);
    }

    public void addDisjunct(TCTLAbstractStateProperty disjunct) {
        disjunct.setParent(this);
        this.properties.add(disjunct);
    }

    @Override
    public boolean isSimpleProperty() {
        return this.isSimpleProperty;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        boolean firstTime = true;
        for (TCTLAbstractStateProperty prop : this.properties) {
            if (!firstTime) {
                s.append(" or ");
            }
            if (prop instanceof TCTLOrListNode) {
                ((TCTLOrListNode)prop).setSimpleProperty(this.isSimpleProperty);
            }
            s.append((String)(prop.isSimpleProperty() ? prop.toString() : "(" + String.valueOf(prop) + ")"));
            firstTime = false;
        }
        return s.toString();
    }

    public void setSimpleProperty(boolean isSimpleProperty) {
        this.isSimpleProperty = isSimpleProperty;
    }

    @Override
    public StringPosition[] getChildren() {
        StringPosition[] children = new StringPosition[this.properties.size()];
        int i = 0;
        int endPrev = 0;
        boolean wasPrevSimple = false;
        for (TCTLAbstractStateProperty p : this.properties) {
            StringPosition pos;
            int start = 0;
            int end = 0;
            if (i == 0) {
                wasPrevSimple = p.isSimpleProperty();
                start = wasPrevSimple ? 0 : 1;
                endPrev = end = start + p.toString().length();
            } else {
                start = endPrev + 4 + (p.isSimpleProperty() ? 0 : 1) + (wasPrevSimple ? 0 : 1);
                endPrev = end = start + p.toString().length();
                wasPrevSimple = p.isSimpleProperty();
            }
            children[i] = pos = new StringPosition(start, end, p);
            ++i;
        }
        return children;
    }

    @Override
    public void convertForReducedNet(String templateName) {
        for (TCTLAbstractProperty tCTLAbstractProperty : this.properties) {
            tCTLAbstractProperty.convertForReducedNet(templateName);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof TCTLOrListNode) {
            TCTLOrListNode node = (TCTLOrListNode)o;
            return this.properties.equals(node.properties);
        }
        return false;
    }

    @Override
    public TCTLAbstractStateProperty copy() {
        ArrayList<TCTLAbstractStateProperty> copy = new ArrayList<TCTLAbstractStateProperty>();
        for (TCTLAbstractStateProperty p : this.properties) {
            copy.add(p.copy());
        }
        TCTLOrListNode orListNode = new TCTLOrListNode(copy);
        orListNode.setSimpleProperty(this.isSimpleProperty());
        return orListNode;
    }

    @Override
    public TCTLAbstractStateProperty replace(TCTLAbstractProperty object1, TCTLAbstractProperty object2) {
        if (this == object1 && object2 instanceof TCTLAbstractStateProperty) {
            TCTLAbstractStateProperty obj2 = (TCTLAbstractStateProperty)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            this.properties.set(i, this.properties.get(i).replace(object1, object2));
        }
        return this;
    }

    @Override
    public void accept(ITCTLVisitor visitor, Object context) {
        visitor.visit(this, context);
    }

    @Override
    public boolean containsAtomicPropositionWithSpecificPlaceInTemplate(String templateName, String placeName) {
        boolean atomicPropFound = false;
        for (TCTLAbstractStateProperty p : this.properties) {
            atomicPropFound = atomicPropFound || p.containsAtomicPropositionWithSpecificPlaceInTemplate(templateName, placeName);
        }
        return atomicPropFound;
    }

    @Override
    public boolean containsAtomicPropositionWithSpecificTransitionInTemplate(String templateName, String transitionName) {
        boolean atomicPropFound = false;
        for (TCTLAbstractStateProperty p : this.properties) {
            atomicPropFound = atomicPropFound || p.containsAtomicPropositionWithSpecificTransitionInTemplate(templateName, transitionName);
        }
        return atomicPropFound;
    }

    @Override
    public boolean containsPlaceHolder() {
        boolean placeHolderFound = false;
        for (TCTLAbstractStateProperty p : this.properties) {
            placeHolderFound = placeHolderFound || p.containsPlaceHolder();
        }
        return placeHolderFound;
    }

    @Override
    public boolean hasNestedPathQuantifiers() {
        boolean foundNestedQuantifier = false;
        for (TCTLAbstractStateProperty p : this.properties) {
            if (!(foundNestedQuantifier = foundNestedQuantifier || p instanceof TCTLPathToStateConverter || p.hasNestedPathQuantifiers())) continue;
            break;
        }
        return foundNestedQuantifier;
    }

    @Override
    public TCTLAbstractProperty findFirstPlaceHolder() {
        TCTLAbstractProperty ph = null;
        for (TCTLAbstractStateProperty p : this.properties) {
            if (!p.containsPlaceHolder()) continue;
            ph = p.findFirstPlaceHolder();
            break;
        }
        return ph;
    }
}

