/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.swingcomponents.filebrowser;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.tapaal.Preferences;
import pipe.gui.TAPAALGUI;

public class FileBrowser {
    public static String userPath = Preferences.getInstance().getFileBrowserLocation();
    static String lastSavePath = ".";
    static String lastOpenPath = ".";
    protected final FileDialog fileDialog;
    private final String[] fileExtensions;
    protected String specifiedPath;

    private FileBrowser(String filetype, String[] extensions, String path) {
        this.fileDialog = new FileDialog((Frame)TAPAALGUI.getApp(), filetype);
        this.fileExtensions = extensions;
        this.specifiedPath = path;
        if (this.fileExtensions.length > 0) {
            this.fileDialog.setFilenameFilter((dir, name) -> {
                for (String fileExtension : this.fileExtensions) {
                    if (name.endsWith("." + fileExtension)) {
                        return true;
                    }
                    if (!fileExtension.isBlank()) continue;
                    return true;
                }
                return false;
            });
            String filter = Arrays.stream(this.fileExtensions).map(ext -> "*." + ext).collect(Collectors.joining(";"));
            this.fileDialog.setFile(filter);
        }
    }

    public static FileBrowser constructor(String filetype, String ext) {
        return FileBrowser.constructor(filetype, ext, null);
    }

    public static FileBrowser constructor(String filetype, String ext, String path) {
        return FileBrowser.constructor(filetype, ext, "", path);
    }

    public static FileBrowser constructor(String filetype, String ext, String optionalExt, String path) {
        return new FileBrowser(filetype, new String[]{ext, optionalExt}, path);
    }

    public static FileBrowser constructor(String[] extensions, String path) {
        return new FileBrowser(null, extensions, path);
    }

    public File openFile() {
        if (this.specifiedPath == null) {
            this.specifiedPath = Preferences.getInstance().getFileBrowserLocation();
        }
        this.fileDialog.setDirectory(this.specifiedPath);
        this.fileDialog.setMode(0);
        this.fileDialog.setMultipleMode(false);
        this.fileDialog.setVisible(true);
        String selectedFile = this.fileDialog.getFile();
        String selectedDir = this.fileDialog.getDirectory();
        Preferences.getInstance().setFileBrowserLocation(selectedDir);
        File file = selectedFile == null ? null : new File(selectedDir + selectedFile);
        return file;
    }

    public File[] openFiles() {
        if (this.specifiedPath == null) {
            this.specifiedPath = Preferences.getInstance().getFileBrowserLocation();
        }
        this.fileDialog.setDirectory(this.specifiedPath);
        this.fileDialog.setMultipleMode(true);
        this.fileDialog.setMode(0);
        this.fileDialog.setVisible(true);
        File[] selectedFiles = this.fileDialog.getFiles();
        Preferences.getInstance().setFileBrowserLocation(this.fileDialog.getDirectory());
        return selectedFiles;
    }

    public String saveFile() {
        if (TAPAALGUI.getAppGui().getCurrentTabName().endsWith(".tapn")) {
            return this.saveFile(TAPAALGUI.getAppGui().getCurrentTabName().replaceAll(".tapn", ""));
        }
        return this.saveFile(TAPAALGUI.getAppGui().getCurrentTabName().replaceAll(".xml", ""));
    }

    public String saveFile(String suggestedName) {
        String ext = this.fileExtensions[0];
        if (this.specifiedPath == null) {
            this.specifiedPath = Preferences.getInstance().getFileBrowserLocation();
        }
        this.fileDialog.setDirectory(this.specifiedPath);
        this.fileDialog.setFile(suggestedName + (String)(suggestedName.endsWith("." + ext) ? "" : "." + ext));
        this.fileDialog.setMode(1);
        this.fileDialog.setVisible(true);
        if (this.fileDialog.getFile() == null) {
            return null;
        }
        if (this.fileDialog.getDirectory().endsWith(suggestedName + "." + ext + "/")) {
            this.fileDialog.setDirectory(this.fileDialog.getDirectory().replaceAll(suggestedName + "." + ext + "/", ""));
        }
        String file = this.fileDialog.getDirectory() + this.fileDialog.getFile();
        Preferences.getInstance().setFileBrowserLocation(this.fileDialog.getDirectory());
        if (!file.endsWith("." + ext)) {
            File destination;
            Pattern p = Pattern.compile(".*\\.(.*)");
            Matcher m = p.matcher(file);
            String newName = file + "." + ext;
            if (m.matches()) {
                newName = file.substring(0, file.length() - m.group(1).length()) + ext;
            }
            if ((destination = new File(newName)).exists()) {
                int overRide = JOptionPane.showConfirmDialog(TAPAALGUI.getApp(), newName + "\nDo you want to overwrite this file?");
                switch (overRide) {
                    case 1: {
                        return this.saveFile(suggestedName);
                    }
                    case 0: {
                        file = newName;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            } else {
                file = newName;
            }
        }
        return file;
    }

    public File saveFileToDir() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            File selectedDir = null;
            if (this.specifiedPath == null) {
                this.specifiedPath = Preferences.getInstance().getFileBrowserLocation();
            }
            JFileChooser c = new JFileChooser(this.specifiedPath);
            c.setFileSelectionMode(1);
            c.setDialogTitle("Choose target directory for export");
            int rVal = c.showSaveDialog(c);
            if (rVal == 0) {
                selectedDir = c.getSelectedFile();
                Preferences.getInstance().setFileBrowserLocation(selectedDir.getPath());
            }
            return selectedDir;
        }
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        String selection = this.saveFile("Choose Directory");
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        if (selection != null) {
            return new File(this.fileDialog.getDirectory());
        }
        return null;
    }
}

