/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.undo;

import java.util.ArrayList;
import net.tapaal.gui.GuiFrameActions;
import net.tapaal.gui.petrinet.undo.Command;
import net.tapaal.helpers.Reference.MutableReference;
import net.tapaal.helpers.Reference.Reference;
import pipe.gui.petrinet.PetriNetTab;

public class UndoManager {
    private static final int UNDO_BUFFER_CAPACITY = 50;
    private final PetriNetTab tab;
    private int normalIndexOfNextAdd = 0;
    private int normalSizeOfBuffer = 0;
    private int normalStartOfBuffer = 0;
    private int normalUndoneEdits = 0;
    private final ArrayList<ArrayList<Command>> normalEdits = new ArrayList(50);
    private int animIndexOfNextAdd = 0;
    private int animSizeOfBuffer = 0;
    private int animStartOfBuffer = 0;
    private int animUndoneEdits = 0;
    private final ArrayList<ArrayList<Command>> animEdits = new ArrayList(50);
    private Reference<GuiFrameActions> app = new MutableReference<GuiFrameActions>();

    public void setApp(Reference<GuiFrameActions> app) {
        this.app = app;
        this.setUndoRedoStatus();
    }

    public UndoManager(PetriNetTab tab) {
        this.tab = tab;
        for (int i = 0; i < 50; ++i) {
            this.normalEdits.add(null);
            this.animEdits.add(null);
        }
    }

    private int getIndexOfNextAdd() {
        return this.tab != null && this.tab.isInAnimationMode() ? this.animIndexOfNextAdd : this.normalIndexOfNextAdd;
    }

    private void setIndexOfNextAdd(int value) {
        if (this.tab != null && this.tab.isInAnimationMode()) {
            this.animIndexOfNextAdd = value;
        } else {
            this.normalIndexOfNextAdd = value;
        }
    }

    private int getSizeOfBuffer() {
        return this.tab != null && this.tab.isInAnimationMode() ? this.animSizeOfBuffer : this.normalSizeOfBuffer;
    }

    private void setSizeOfBuffer(int value) {
        if (this.tab != null && this.tab.isInAnimationMode()) {
            this.animSizeOfBuffer = value;
        } else {
            this.normalSizeOfBuffer = value;
        }
    }

    private int getStartOfBuffer() {
        return this.tab != null && this.tab.isInAnimationMode() ? this.animStartOfBuffer : this.normalStartOfBuffer;
    }

    private void setStartOfBuffer(int value) {
        if (this.tab != null && this.tab.isInAnimationMode()) {
            this.animStartOfBuffer = value;
        } else {
            this.normalStartOfBuffer = value;
        }
    }

    private int getUndoneEdits() {
        return this.tab != null && this.tab.isInAnimationMode() ? this.animUndoneEdits : this.normalUndoneEdits;
    }

    private void setUndoneEdits(int value) {
        if (this.tab != null && this.tab.isInAnimationMode()) {
            this.animUndoneEdits = value;
        } else {
            this.normalUndoneEdits = value;
        }
    }

    private ArrayList<ArrayList<Command>> getEdits() {
        return this.tab != null && this.tab.isInAnimationMode() ? this.animEdits : this.normalEdits;
    }

    public void redo() {
        if (this.getUndoneEdits() > 0) {
            for (Command command : this.getEdits().get(this.getIndexOfNextAdd())) {
                command.redo();
            }
            this.setIndexOfNextAdd((this.getIndexOfNextAdd() + 1) % 50);
            this.setSizeOfBuffer(this.getSizeOfBuffer() + 1);
            this.setUndoneEdits(this.getUndoneEdits() - 1);
        }
        this.setUndoRedoStatus();
    }

    public void setUndoRedoStatus() {
        boolean canUndo = this.getSizeOfBuffer() != 0;
        this.app.ifPresent(a -> a.setUndoActionEnabled(canUndo));
        boolean canRedo = this.getUndoneEdits() != 0;
        this.app.ifPresent(a -> a.setRedoActionEnabled(canRedo));
    }

    public void undo() {
        if (this.getSizeOfBuffer() > 0) {
            int indexOfNextAdd = this.getIndexOfNextAdd();
            if (--indexOfNextAdd < 0) {
                indexOfNextAdd += 50;
            }
            this.setIndexOfNextAdd(indexOfNextAdd);
            this.setSizeOfBuffer(this.getSizeOfBuffer() - 1);
            this.setUndoneEdits(this.getUndoneEdits() + 1);
            ArrayList<Command> currentEdit = this.getEdits().get(indexOfNextAdd);
            for (int i = currentEdit.size() - 1; i >= 0; --i) {
                currentEdit.get(i).undo();
            }
        }
        this.setUndoRedoStatus();
    }

    public void clear() {
        if (this.tab != null && this.tab.isInAnimationMode()) {
            this.animIndexOfNextAdd = 0;
            this.animSizeOfBuffer = 0;
            this.animStartOfBuffer = 0;
            this.animUndoneEdits = 0;
        } else {
            this.normalIndexOfNextAdd = 0;
            this.normalSizeOfBuffer = 0;
            this.normalStartOfBuffer = 0;
            this.normalUndoneEdits = 0;
        }
        this.setUndoRedoStatus();
    }

    public void undoAll() {
        if (this.getSizeOfBuffer() > 0) {
            int indexOfNextAdd = this.getIndexOfNextAdd();
            int originalBufferSize = this.getSizeOfBuffer();
            this.setIndexOfNextAdd(0);
            this.setSizeOfBuffer(0);
            this.setUndoneEdits(this.getUndoneEdits() + originalBufferSize);
            for (int i = indexOfNextAdd - 1; i >= 0; --i) {
                ArrayList<Command> currentEdit = this.getEdits().get(i);
                for (int j = currentEdit.size() - 1; j >= 0; --j) {
                    currentEdit.get(j).undo();
                }
            }
        }
        this.setUndoRedoStatus();
    }

    public void newEdit() {
        ArrayList<Command> lastEdit = this.getEdits().get(this.currentIndex());
        if (lastEdit != null && lastEdit.isEmpty()) {
            return;
        }
        this.setUndoneEdits(0);
        if (this.tab != null) {
            this.tab.setNetChanged(true);
        }
        ArrayList compoundEdit = new ArrayList();
        this.getEdits().set(this.getIndexOfNextAdd(), compoundEdit);
        this.setIndexOfNextAdd((this.getIndexOfNextAdd() + 1) % 50);
        if (this.getSizeOfBuffer() < 50) {
            this.setSizeOfBuffer(this.getSizeOfBuffer() + 1);
        } else {
            this.setStartOfBuffer((this.getStartOfBuffer() + 1) % 50);
        }
        this.setUndoRedoStatus();
    }

    public void addEdit(Command undoableEdit) {
        ArrayList<Command> compoundEdit = this.getEdits().get(this.currentIndex());
        compoundEdit.add(undoableEdit);
    }

    public void addNewEdit(Command undoableEdit) {
        this.newEdit();
        this.addEdit(undoableEdit);
    }

    private int currentIndex() {
        int lastAdd = this.getIndexOfNextAdd() - 1;
        if (lastAdd < 0) {
            lastAdd += 50;
        }
        return lastAdd;
    }

    public void removeCurrentEdit() {
        if (this.getSizeOfBuffer() > 0 && this.currentIndex() >= 0 && this.currentIndex() < this.getEdits().size()) {
            this.getEdits().set(this.currentIndex(), null);
            this.setSizeOfBuffer(this.getSizeOfBuffer() - 1);
            this.setIndexOfNextAdd(this.getIndexOfNextAdd() - 1);
        }
        this.setUndoRedoStatus();
    }

    public void undoAndRemoveCurrentEdit() {
        int currentIdx = this.currentIndex();
        this.undo();
        this.getEdits().set(currentIdx, null);
        if (this.getUndoneEdits() > 0) {
            this.setUndoneEdits(this.getUndoneEdits() - 1);
        }
        this.setUndoRedoStatus();
    }

    public boolean currentEditIsEmpty() {
        return this.getEdits().get(this.currentIndex()).isEmpty();
    }
}

