/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.undo;

import java.awt.Dimension;
import java.awt.Point;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.petrinet.graphicElements.AnnotationNote;

public class AnnotationResizeCommand
implements Command {
    private final AnnotationNote.ResizePoint resizePoint;
    private final Point oldPoint;
    private final Dimension oldSize;
    private final Point newPoint;
    private final Dimension newSize;

    public AnnotationResizeCommand(AnnotationNote.ResizePoint resizePoint, Point oldPoint, Dimension oldSize) {
        this.resizePoint = resizePoint;
        this.oldPoint = oldPoint;
        this.oldSize = oldSize;
        this.newPoint = resizePoint.getNote().getLocation();
        this.newSize = resizePoint.getNote().getNote().getSize();
    }

    @Override
    public void undo() {
        this.update(this.oldPoint, this.oldSize);
    }

    @Override
    public void redo() {
        this.update(this.newPoint, this.newSize);
    }

    private void update(Point point, Dimension size) {
        this.resizePoint.getNote().setPosition(point);
        this.resizePoint.getNote().setInnerNoteSize(size);
        this.resizePoint.getNote().updateBounds();
        this.resizePoint.repaint();
    }
}

