/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements.tapn;

import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantWeight;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.Weight;
import java.awt.Polygon;
import java.util.Hashtable;
import java.util.List;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.Constants;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.undo.ArcTimeIntervalEditCommand;

public class TimedTransportArcComponent
extends TimedInputArcComponent {
    private int group;
    private final boolean isInPreSet;
    private TimedTransportArcComponent connectedTo;
    private TransportArc underlyingTransportArc;

    public TimedTransportArcComponent(PlaceTransitionObject newSource, int groupNr, boolean isInPreSet) {
        super(new TimedOutputArcComponent(newSource));
        this.isInPreSet = isInPreSet;
        this.setGroup(groupNr);
        this.updateLabel(true);
        this.isPrototype = true;
    }

    public TimedTransportArcComponent(TimedInputArcComponent timedArc, int group, boolean isInPreSet) {
        super(timedArc);
        this.isInPreSet = isInPreSet;
        this.setGroup(group);
        this.updateLabel(true);
    }

    public TimedTransportArcComponent(TimedPlaceComponent p, TimedTransitionComponent t, TransportArc model, int group, TAPNLens lens) {
        super(p);
        this.setTarget(t);
        this.isInPreSet = true;
        this.setGroup(group);
        this.setUnderlyingArc(model);
        this.lens = lens;
        this.updateLabel(true);
        this.sealArc();
    }

    public TimedTransportArcComponent(TimedTransitionComponent t, TimedPlaceComponent p, TransportArc model, int group, TAPNLens lens) {
        super(t);
        this.setTarget(p);
        this.isInPreSet = false;
        this.setGroup(group);
        this.lens = lens;
        this.setUnderlyingArc(model);
        this.updateLabel(true);
        this.sealArc();
    }

    public void setUnderlyingArc(TransportArc arc) {
        this.underlyingTransportArc = arc;
        this.updateLabel(true);
    }

    public TransportArc underlyingTransportArc() {
        return this.underlyingTransportArc;
    }

    @Override
    protected void setHead() {
        this.setHead(new Polygon(new int[]{0, 5, 0, -5}, new int[]{0, -11, -18, -11}, 4), true);
    }

    public void setGroupNr(int groupNr) {
        this.setGroup(groupNr);
        this.updateLabel(true);
        this.repaint();
    }

    public void setInputExpression(ArcExpression expression) {
        this.underlyingTransportArc().setInputExpression(expression);
    }

    public void setOutputExpression(ArcExpression expression) {
        this.underlyingTransportArc().setOutputExpression(expression);
    }

    public int getGroupNr() {
        return this.getGroup();
    }

    @Override
    public void updateLabel(boolean displayConstantNames) {
        if (this.isInPreSet && this.underlyingTransportArc != null) {
            if (TAPAALGUI.getApp() != null && TAPAALGUI.getAppGui().showZeroToInfinityIntervals()) {
                this.getNameLabel().setText(this.underlyingTransportArc.interval().toString(displayConstantNames) + " : " + this.getGroup());
                if (this.getNameLabel().getText().contains("inf")) {
                    String intervalStringWithInfSymbol = this.getNameLabel().getText().replace("inf", Character.toString('\u221e'));
                    this.getNameLabel().setText(intervalStringWithInfSymbol);
                }
            } else if (this.underlyingTransportArc.interval().toString(displayConstantNames).equals("[0,inf)")) {
                this.getNameLabel().setText(" : " + this.getGroup());
            } else {
                this.getNameLabel().setText(this.underlyingTransportArc.interval().toString(displayConstantNames) + " : " + this.getGroup());
            }
            boolean focusedConstant = false;
            boolean isvisible = true;
            if (this.underlyingTransportArc.interval().lowerBound() instanceof ConstantBound) {
                if (((ConstantBound)this.underlyingTransportArc.interval().lowerBound()).constant().hasFocus()) {
                    focusedConstant = true;
                }
                if (!((ConstantBound)this.underlyingTransportArc.interval().lowerBound()).constant().getVisible()) {
                    focusedConstant = false;
                }
            }
            if (this.underlyingTransportArc.interval().upperBound() instanceof ConstantBound) {
                if (((ConstantBound)this.underlyingTransportArc.interval().upperBound()).constant().getVisible()) {
                    focusedConstant = true;
                }
                if (!((ConstantBound)this.underlyingTransportArc.interval().upperBound()).constant().getVisible()) {
                    isvisible = false;
                }
            }
            if (this.getWeight() instanceof ConstantWeight) {
                if (((ConstantWeight)this.getWeight()).constant().hasFocus()) {
                    focusedConstant = true;
                }
                if (!((ConstantWeight)this.getWeight()).constant().hasFocus()) {
                    isvisible = false;
                }
            }
            if (focusedConstant) {
                this.getNameLabel().setForeground(Constants.SELECTION_TEXT_COLOUR);
            } else {
                this.getNameLabel().setForeground(Constants.ELEMENT_TEXT_COLOUR);
            }
            this.pnName.setVisible(isvisible);
        } else if (!this.isInPreSet) {
            this.getNameLabel().setText(" : " + this.getGroup());
        } else {
            this.getNameLabel().setText("");
        }
        if (this.underlyingTransportArc != null) {
            this.getNameLabel().setText(this.getWeight().toString(displayConstantNames) + " " + this.getNameLabel().getText());
        }
        if (this.isColored()) {
            String labelText = this.getNameLabel().getText() + "\n";
            if (this.isInPreSet() && this.underlyingTransportArc() != null) {
                if (this.underlyingTransportArc().getInputExpression() != null) {
                    labelText = labelText + this.underlyingTransportArc().getInputExpression().toString() + "\n";
                }
                List<ColoredTimeInterval> ctiList = this.underlyingTransportArc().getColorTimeIntervals();
                for (ColoredTimeInterval timeInterval : ctiList) {
                    if (timeInterval == null) continue;
                    labelText = labelText + String.valueOf(timeInterval) + "\n";
                }
                this.getNameLabel().setText(labelText);
            } else if (!this.isInPreSet() && this.underlyingTransportArc() != null) {
                if (this.underlyingTransportArc().getOutputExpression() != null) {
                    labelText = labelText + this.underlyingTransportArc().getOutputExpression().toString() + "\n";
                }
                this.getNameLabel().setText(labelText);
            }
        }
        this.setLabelPosition();
    }

    public boolean isInPreSet() {
        return this.isInPreSet;
    }

    public TimedTransportArcComponent getConnectedTo() {
        return this.connectedTo;
    }

    public void setConnectedTo(TimedTransportArcComponent connectedTo) {
        this.connectedTo = connectedTo;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public int getGroup() {
        return this.group;
    }

    @Override
    public TimeInterval getGuard() {
        return this.underlyingTransportArc.interval();
    }

    @Override
    public boolean isUrgentTransition() {
        return this.underlyingTransportArc.transition().isUrgent();
    }

    @Override
    public Command setGuardAndWeight(TimeInterval guard, Weight weight) {
        TimeInterval oldTimeInterval = this.underlyingTransportArc.interval();
        this.underlyingTransportArc.setTimeInterval(guard);
        Weight oldWeight = this.getWeight();
        this.setWeight(weight);
        this.connectedTo.setWeight(weight);
        this.updateLabel(true);
        this.connectedTo.updateLabel(true);
        this.repaint();
        return new ArcTimeIntervalEditCommand(this, oldTimeInterval, this.underlyingTransportArc.interval(), oldWeight, weight);
    }

    @Override
    public TimedTransportArcComponent copy(TimedArcPetriNet tapn, Hashtable<PlaceTransitionObject, PlaceTransitionObject> oldToNewMapping) {
        TimedTransportArcComponent arc = new TimedTransportArcComponent(this, this.group, this.isInPreSet);
        arc.setSource(oldToNewMapping.get(this.getSource()));
        arc.setTarget(oldToNewMapping.get(this.getTarget()));
        arc.setUnderlyingArc(tapn.getTransportArcFromPlaceTransitionAndPlace(tapn.getPlaceByName(this.underlyingTransportArc.source().name()), tapn.getTransitionByName(this.underlyingTransportArc.transition().name()), tapn.getPlaceByName(this.underlyingTransportArc.destination().name())));
        return arc;
    }

    @Override
    public void setWeight(Weight weight) {
        this.underlyingTransportArc.setWeight(weight);
        this.connectedTo.underlyingTransportArc.setWeight(weight);
    }

    @Override
    public Weight getWeight() {
        return this.underlyingTransportArc.getWeight();
    }

    @Override
    public List<ColoredTimeInterval> getCtiList() {
        return this.underlyingTransportArc.getColorTimeIntervals();
    }

    @Override
    public void setCtiList(List<ColoredTimeInterval> ctiList) {
        this.underlyingTransportArc.setColorTimeIntervals(ctiList);
    }
}

