/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements.tapn;

import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.event.TimedPlaceEvent;
import dk.aau.cs.model.tapn.event.TimedPlaceListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JTextArea;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.TAPNLens;
import pipe.gui.Constants;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.editor.PlaceEditorPanel;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.swingcomponents.EscapableDialog;

public class TimedPlaceComponent
extends Place {
    private TimedPlace place;
    private final TimedPlaceListener listener = this.timedPlaceListener();
    private Window ageOfTokensWindow;
    private final Shape dashedOutline = TimedPlaceComponent.createDashedOutline();

    public TimedPlaceComponent(int positionXInput, int positionYInput, TimedPlace place, TAPNLens lens) {
        super(positionXInput, positionYInput);
        this.place = place;
        this.place.addTimedPlaceListener(this.listener);
        this.lens = lens;
        this.attributesVisible = true;
    }

    public TimedPlaceComponent(int positionXInput, int positionYInput, String idInput, int nameOffsetXInput, int nameOffsetYInput, TAPNLens lens) {
        super(positionXInput, positionYInput, idInput, nameOffsetXInput, nameOffsetYInput);
        this.attributesVisible = true;
        this.lens = lens;
    }

    private TimedPlaceListener timedPlaceListener() {
        return new TimedPlaceListener(){

            @Override
            public void nameChanged(TimedPlaceEvent e) {
                TimedPlace place = e.source();
                TimedPlaceComponent.super.setName(place.name());
            }

            @Override
            public void invariantChanged(TimedPlaceEvent e) {
                TimedPlaceComponent.this.update(true);
            }

            @Override
            public void markingChanged(TimedPlaceEvent e) {
                TimedPlaceComponent.this.repaint();
            }
        };
    }

    public String getInvariantAsString() {
        return this.getInvariant().toString();
    }

    public TimeInvariant getInvariant() {
        return this.place.invariant();
    }

    public boolean hasInvariant() {
        return !(this.place.invariant().upperBound() instanceof Bound.InfBound);
    }

    public boolean hasAnyColorInvariant() {
        if (this.place.getCtiList() != null) {
            for (ColoredTimeInvariant cti : this.place.getCtiList()) {
                if (cti == null || cti.upperBound().value() < 0) continue;
                return true;
            }
        }
        return false;
    }

    private String getStringOfTokens() {
        StringBuilder buffer = new StringBuilder("{");
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        boolean first = true;
        for (TimedToken token : this.place.tokens()) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(df.format(token.age()));
            first = false;
        }
        buffer.append('}');
        return buffer.toString();
    }

    private String getStringOfColoredTimedTokens() {
        StringBuilder buffer = new StringBuilder("{");
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        boolean first = true;
        for (TimedToken token : this.place.tokens()) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append("(");
            if (token.color().getColorName().equals("")) {
                buffer.append(token.color().toString());
            } else {
                buffer.append(token.color().getColorName());
            }
            buffer.append(", ");
            buffer.append(df.format(token.age()));
            buffer.append(")");
            first = false;
        }
        buffer.append('}');
        return buffer.toString();
    }

    private String getStringOfColoredTokens() {
        StringBuilder buffer = new StringBuilder("{");
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
        boolean first = true;
        for (TimedToken token : this.place.tokens()) {
            if (!first) {
                buffer.append(", ");
            }
            if (token instanceof TimedToken) {
                if (token.color().getColorName().equals("")) {
                    buffer.append(token.color().toString());
                } else {
                    buffer.append(token.color().getColorName());
                }
            }
            first = false;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean isAgeOfTokensShown() {
        return this.ageOfTokensWindow != null && this.ageOfTokensWindow.isVisible();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintTokens(g);
        if (this.place.isShared()) {
            Graphics2D graphics = (Graphics2D)g;
            Stroke oldStroke = graphics.getStroke();
            BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f}, 0.0f);
            graphics.setStroke(dashed);
            int margin = 1;
            graphics.setClip(new Rectangle2D.Double(this.dashedOutline.getBounds().x - margin, this.dashedOutline.getBounds().y - margin, this.dashedOutline.getBounds().width + margin * 2, this.dashedOutline.getBounds().height + margin * 2));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.draw(this.dashedOutline);
            graphics.setStroke(oldStroke);
        }
    }

    protected void paintTokens(Graphics g) {
        String subMarking2;
        String subMarking1;
        DecimalFormat df = new DecimalFormat();
        df.setMinimumFractionDigits(1);
        df.setMaximumFractionDigits(1);
        df.setRoundingMode(RoundingMode.DOWN);
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        List<TimedToken> myTokens = this.place.tokens();
        int marking = this.place.numberOfTokens();
        boolean drawDots = false;
        if (!TAPAALGUI.getAppGui().showTokenAge()) {
            drawDots = marking > 0 && marking < 6;
            for (TimedToken token : myTokens) {
                if (token.age().compareTo(BigDecimal.valueOf(0L)) == 0) continue;
                drawDots = false;
                break;
            }
        }
        if (!this.lens.isTimed()) {
            boolean bl = drawDots = marking > 0 && marking < 6;
        }
        if (drawDots) {
            switch (marking) {
                case 5: {
                    g.fillOval(x + 13, y + 13, 5, 5);
                }
                case 4: {
                    g.fillOval(x + 7, y + 7, 5, 5);
                }
                case 3: {
                    int yPos;
                    int xPos;
                    if (marking == 5 || marking == 4) {
                        xPos = x + 19;
                        yPos = y + 7;
                    } else {
                        xPos = x + 7;
                        yPos = y + 7;
                    }
                    g.fillOval(xPos, yPos, 5, 5);
                }
                case 2: {
                    int yPos;
                    int xPos;
                    if (marking == 5 || marking == 4) {
                        xPos = x + 7;
                        yPos = y + 19;
                    } else if (marking == 3) {
                        xPos = x + 13;
                        yPos = y + 13;
                    } else {
                        xPos = x + 7;
                        yPos = y + 13;
                    }
                    g.fillOval(xPos, yPos, 5, 5);
                }
                case 1: {
                    int yPos;
                    int xPos;
                    if (marking == 5 || marking == 4 || marking == 3) {
                        xPos = x + 19;
                        yPos = y + 19;
                    } else if (marking == 2) {
                        xPos = x + 19;
                        yPos = y + 13;
                    } else {
                        xPos = x + 13;
                        yPos = y + 13;
                    }
                    g.fillOval(xPos, yPos, 5, 5);
                }
            }
        } else if (!this.isColored()) {
            switch (marking) {
                case 2: {
                    if (myTokens.get(1).age().compareTo(BigDecimal.valueOf(9L)) > 0) {
                        g.setFont(new Font("new font", 0, 11));
                        g.drawString(df.format(myTokens.get(1).age()), x + 17 - 12, y + 13 + 1);
                    } else {
                        g.drawString(df.format(myTokens.get(1).age()), x + 17 - 10, y + 13 + 1);
                    }
                }
                case 1: {
                    if (myTokens.get(0).age().compareTo(BigDecimal.valueOf(9L)) > 0) {
                        g.setFont(new Font("new font", 0, 11));
                        g.drawString(df.format(myTokens.get(0).age()), x + 11 - 6, y + 20 + 6);
                        break;
                    }
                    g.drawString(df.format(myTokens.get(0).age()), x + 11 - 4, y + 20 + 6);
                }
                case 0: {
                    break;
                }
                default: {
                    if (marking > 99999999) {
                        subMarking1 = String.valueOf(marking).substring(0, 4);
                        subMarking2 = String.valueOf(marking).substring(4);
                        g.drawString(">" + subMarking1, x - 5, y + 15);
                        g.drawString(subMarking2, x + 4, y + 25);
                        break;
                    }
                    if (marking > 9999) {
                        subMarking1 = String.valueOf(marking).substring(0, 4);
                        subMarking2 = String.valueOf(marking).substring(4);
                        g.drawString("#" + subMarking1, x - 5, y + 15);
                        g.drawString(subMarking2, x + 4, y + 25);
                        break;
                    }
                    if (marking > 999) {
                        g.drawString("#" + marking, x - 5, y + 20);
                        break;
                    }
                    if (marking > 99) {
                        g.drawString("#" + marking, x, y + 20);
                        break;
                    }
                    if (marking > 9) {
                        g.drawString("#" + marking, x + 2, y + 20);
                        break;
                    }
                    g.drawString("#" + marking, x + 6, y + 20);
                    break;
                }
            }
        } else if (marking > 9999) {
            subMarking1 = String.valueOf(marking).substring(0, 4);
            subMarking2 = String.valueOf(marking).substring(4);
            g.drawString("#" + subMarking1, x - 5, y + 15);
            g.drawString(subMarking2, x + 4, y + 25);
        } else if (marking > 999) {
            g.drawString("#" + marking, x - 5, y + 20);
        } else if (marking > 99) {
            g.drawString("#" + marking, x, y + 20);
        } else if (marking > 9) {
            g.drawString("#" + marking, x + 2, y + 20);
        } else if (marking > 0) {
            g.drawString("#" + marking, x + 6, y + 20);
        }
    }

    public void setInvariant(TimeInvariant inv) {
        this.place.setInvariant(inv);
        this.update(true);
    }

    public void showAgeOfTokens(boolean show) {
        if (this.ageOfTokensWindow != null) {
            this.ageOfTokensWindow.dispose();
        }
        if (show && (this.isTimed() || this.isColored())) {
            this.ageOfTokensWindow = new Window(new Frame());
            if (this.isColored() && !this.isTimed()) {
                this.ageOfTokensWindow.add(new JTextArea(this.getStringOfColoredTokens()));
            } else if (!this.isColored() && this.isTimed()) {
                this.ageOfTokensWindow.add(new JTextArea(this.getStringOfTokens()));
            } else {
                this.ageOfTokensWindow.add(new JTextArea(this.getStringOfColoredTimedTokens()));
            }
            this.ageOfTokensWindow.getComponent(0).setBackground(Color.lightGray);
            this.ageOfTokensWindow.pack();
            this.ageOfTokensWindow.setLocationRelativeTo(this);
            int numberOfTokens = this.place.numberOfTokens();
            if (numberOfTokens <= 12) {
                this.ageOfTokensWindow.setLocation(this.ageOfTokensWindow.getLocation().x, this.ageOfTokensWindow.getLocation().y + 31 + numberOfTokens);
            } else if (numberOfTokens > 12 && numberOfTokens < 20) {
                this.ageOfTokensWindow.setLocation(this.ageOfTokensWindow.getLocation().x, this.ageOfTokensWindow.getLocation().y + 40 + numberOfTokens);
            } else if (numberOfTokens >= 20 && numberOfTokens <= 35) {
                this.ageOfTokensWindow.setLocation(this.ageOfTokensWindow.getLocation().x, this.ageOfTokensWindow.getLocation().y + 35 + numberOfTokens);
            } else if (numberOfTokens > 35 && numberOfTokens < 40) {
                this.ageOfTokensWindow.setLocation(this.ageOfTokensWindow.getLocation().x, this.ageOfTokensWindow.getLocation().y + 40 + numberOfTokens);
            } else {
                this.ageOfTokensWindow.setLocation(this.ageOfTokensWindow.getLocation().x, this.ageOfTokensWindow.getLocation().y + 20 + numberOfTokens);
            }
            this.ageOfTokensWindow.setVisible(show);
        } else if (!show || this.isColored()) {
            // empty if block
        }
    }

    @Override
    public void showEditor() {
        EscapableDialog guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit Place", true);
        Container contentPane = guiDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        PlaceEditorPanel placeEditorPanel = new PlaceEditorPanel(guiDialog, guiDialog.getRootPane(), this, new Context(TAPAALGUI.getCurrentTab()));
        contentPane.add(placeEditorPanel);
        guiDialog.setResizable(true);
        guiDialog.pack();
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setVisible(true);
    }

    @Override
    public void update(boolean displayConstantNames, boolean alignToGrid) {
        if (this.place != null) {
            StringBuilder buffer;
            this.getNameLabel().setName(this.place.name());
            if (this.lens == null || this.isTimed()) {
                buffer = new StringBuilder();
                if (!(this.place.invariant().upperBound() instanceof Bound.InfBound)) {
                    buffer.append("\nInv: ");
                    buffer.append(this.place.invariant().toString(displayConstantNames));
                }
                this.getNameLabel().setText(buffer.toString());
            }
            if (this.lens != null && this.isColored()) {
                buffer = new StringBuilder();
                String placeColorType = "[" + this.place.getColorType().getName() + "]";
                buffer.append("\n");
                buffer.append(placeColorType);
                if (this.isTimed()) {
                    if (!(this.place.invariant().upperBound() instanceof Bound.InfBound)) {
                        buffer.append("\nInv: ");
                        buffer.append(this.place.invariant().toString(displayConstantNames));
                    }
                    if (this.place.getCtiList() != null) {
                        for (ColoredTimeInvariant cti : this.place.getCtiList()) {
                            if (cti == null) continue;
                            buffer.append("\n");
                            buffer.append(cti);
                        }
                    }
                }
                if (TAPAALGUI.getAppGui().showColoredTokens() && this.underlyingPlace().getTokensAsExpression() != null) {
                    buffer.append("\n");
                    buffer.append(((AddExpression)this.underlyingPlace().getTokensAsExpression()).toTokenString());
                }
                this.getNameLabel().setText(buffer.toString());
            }
            boolean focusedConstant = false;
            Bound bound = this.place.invariant().upperBound();
            if (bound instanceof ConstantBound) {
                Constant constant = ((ConstantBound)bound).constant();
                if (constant.hasFocus()) {
                    focusedConstant = true;
                }
                this.pnName.setVisible(constant.getVisible());
            }
            if (focusedConstant) {
                this.getNameLabel().setForeground(Constants.SELECTION_TEXT_COLOUR);
            } else {
                this.getNameLabel().setForeground(Constants.ELEMENT_TEXT_COLOUR);
            }
            this.getNameLabel().displayName(this.attributesVisible);
        } else {
            this.getNameLabel().setName("");
            this.getNameLabel().setText("");
        }
        this.repaint();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public TimedPlace underlyingPlace() {
        return this.place;
    }

    public void setUnderlyingPlace(TimedPlace place) {
        if (this.place != null && this.listener != null) {
            this.place.removeTimedPlaceListener(this.listener);
        }
        place.addTimedPlaceListener(this.listener);
        this.place = place;
        this.update(true);
    }

    public int getNumberOfTokens() {
        return this.place.numberOfTokens();
    }

    @Override
    public void setName(String nameInput) {
        this.place.setName(nameInput);
        super.setName(nameInput);
    }

    private static Shape createDashedOutline() {
        return new Ellipse2D.Double(-4.0, -4.0, 38.0, 38.0);
    }

    public TimedPlaceComponent copy(TimedArcPetriNet tapn) {
        TimedPlaceComponent placeComponent = new TimedPlaceComponent(this.getOriginalX(), this.getOriginalY(), this.id, this.getNameOffsetX(), this.getNameOffsetY(), this.lens);
        placeComponent.setUnderlyingPlace(tapn.getPlaceByName(this.place.name()));
        return placeComponent;
    }
}

