/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements.tapn;

import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.tapn.ConstantWeight;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.Weight;
import java.awt.Container;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.Constants;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.Grid;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.editor.GuardDialogue;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.ArcPath;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.undo.ArcTimeIntervalEditCommand;
import pipe.gui.swingcomponents.EscapableDialog;

public class TimedOutputArcComponent
extends Arc {
    private TimedOutputArc outputArc;

    public TimedOutputArcComponent(PlaceTransitionObject sourceInput, PlaceTransitionObject targetInput, int weightInput, String idInput) {
        super(sourceInput, targetInput, idInput);
    }

    public TimedOutputArcComponent(PlaceTransitionObject newSource) {
        super(newSource);
    }

    public TimedOutputArcComponent(TimedOutputArcComponent arc) {
        super(arc.getSource(), arc.getTarget(), null);
        this.myPath = new ArcPath((Arc)this, arc.myPath);
        this.updateBounds();
        this.id = arc.id;
        this.setSource(arc.getSource());
        this.setTarget(arc.getTarget());
        this.setNameOffsetX(arc.getNameOffsetX());
        this.setNameOffsetY(arc.getNameOffsetY());
        this.getNameLabel().setPosition(Grid.align((int)(arc.getNameLabel().getXPosition() + (double)Zoomer.getZoomedValue(this.getNameOffsetX(), this.getZoom())), this.getZoom()), Grid.align((int)(arc.getNameLabel().getYPosition() + (double)Zoomer.getZoomedValue(this.getNameOffsetY(), this.getZoom())), this.getZoom()));
        this.lens = arc.lens;
    }

    public TimedOutputArcComponent(PlaceTransitionObject source, PlaceTransitionObject target, TimedOutputArc modelArc, TAPNLens lens) {
        super(source);
        this.setTarget(target);
        this.setUnderlyingArc(modelArc);
        this.lens = lens;
        this.updateLabel(true);
        this.sealArc();
    }

    public Command setGuardAndWeight(TimeInterval guard, Weight weight) {
        Weight oldWeight = this.getWeight();
        this.setWeight(weight);
        this.updateLabel(true);
        this.repaint();
        return new ArcTimeIntervalEditCommand(this, guard, guard, oldWeight, weight);
    }

    @Override
    public void updateLabel(boolean displayConstantNames) {
        if (this.isColored()) {
            if (this.underlyingArc() != null) {
                if (this.underlyingArc().getExpression() != null) {
                    this.getNameLabel().setText(this.getWeight().toString(displayConstantNames) + "\n" + this.underlyingArc().getExpression().toString());
                    this.setLabelPosition();
                }
            } else {
                this.getNameLabel().setText("");
                this.getNameLabel().setText(this.getWeight().toString(displayConstantNames) + " " + this.getNameLabel().getText());
                this.setLabelPosition();
            }
        } else {
            this.getNameLabel().setText("");
            this.getNameLabel().setText(this.getWeight().toString(displayConstantNames) + " " + this.getNameLabel().getText());
            this.setLabelPosition();
        }
        boolean focusedConstant = false;
        boolean isvisible = true;
        if (this.getWeight() instanceof ConstantWeight) {
            if (((ConstantWeight)this.getWeight()).constant().hasFocus()) {
                focusedConstant = true;
            }
            isvisible = ((ConstantWeight)this.getWeight()).constant().getVisible();
        }
        if (focusedConstant) {
            this.getNameLabel().setForeground(Constants.SELECTION_TEXT_COLOUR);
        } else {
            this.getNameLabel().setForeground(Constants.ELEMENT_TEXT_COLOUR);
        }
        this.pnName.setVisible(isvisible);
    }

    @Override
    protected void showPropertiesEditor() {
        this.showTimeIntervalEditor();
    }

    public void showTimeIntervalEditor() {
        EscapableDialog guiDialog = new EscapableDialog(TAPAALGUI.getApp(), "Edit Arc", true);
        Container contentPane = guiDialog.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        contentPane.add(new GuardDialogue(guiDialog.getRootPane(), this, new Context(TAPAALGUI.getCurrentTab())));
        guiDialog.setResizable(true);
        guiDialog.pack();
        guiDialog.setLocationRelativeTo(null);
        guiDialog.setVisible(true);
    }

    public TimedOutputArc underlyingArc() {
        return this.outputArc;
    }

    public void setUnderlyingArc(TimedOutputArc outputArc) {
        this.outputArc = outputArc;
    }

    public TimedOutputArcComponent copy(TimedArcPetriNet tapn, Hashtable<PlaceTransitionObject, PlaceTransitionObject> oldToNewMapping) {
        TimedOutputArcComponent newCopyArc = new TimedOutputArcComponent(this);
        newCopyArc.setSource(oldToNewMapping.get(this.getSource()));
        newCopyArc.setTarget(oldToNewMapping.get(this.getTarget()));
        newCopyArc.setUnderlyingArc(tapn.getOutputArcFromTransitionAndPlace(tapn.getTransitionByName(this.outputArc.source().name()), tapn.getPlaceByName(this.outputArc.destination().name())));
        return newCopyArc;
    }

    @Override
    public void setWeight(Weight weight) {
        this.outputArc.setWeight(weight);
    }

    @Override
    public Weight getWeight() {
        return this.outputArc.getWeight();
    }

    @Override
    public void setExpression(ArcExpression expr) {
        this.outputArc.setExpression(expr);
    }

    @Override
    public ArcExpression getExpression() {
        return this.outputArc.getExpression();
    }
}

