/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements.tapn;

import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantWeight;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.Weight;
import java.util.Hashtable;
import java.util.List;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.Constants;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.undo.ArcTimeIntervalEditCommand;

public class TimedInputArcComponent
extends TimedOutputArcComponent {
    private TimedInputArc inputArc;

    public TimedInputArcComponent(PlaceTransitionObject source) {
        super(source);
        this.updateLabel(true);
    }

    public TimedInputArcComponent(PlaceTransitionObject source, PlaceTransitionObject target, TimedInputArc modelArc, TAPNLens lens) {
        super(source);
        this.setTarget(target);
        this.setUnderlyingArc(modelArc);
        this.updateLabel(true);
        this.lens = lens;
        this.sealArc();
    }

    public TimedInputArcComponent(TimedOutputArcComponent arc) {
        super(arc);
        this.updateLabel(true);
    }

    public TimedInputArcComponent(TimedOutputArcComponent arc, TAPNLens lens) {
        super(arc);
        this.updateLabel(true);
        this.lens = lens;
    }

    public String getGuardAsString() {
        return this.getGuard().toString();
    }

    public TimeInterval getGuard() {
        return this.inputArc.interval();
    }

    public boolean isUrgentTransition() {
        return this.inputArc.destination().isUrgent();
    }

    @Override
    public Command setGuardAndWeight(TimeInterval guard, Weight weight) {
        TimeInterval oldTimeInterval = this.inputArc.interval();
        this.inputArc.setTimeInterval(guard);
        Weight oldWeight = this.getWeight();
        this.setWeight(weight);
        this.updateLabel(true);
        this.repaint();
        return new ArcTimeIntervalEditCommand(this, oldTimeInterval, this.inputArc.interval(), oldWeight, weight);
    }

    @Override
    public void updateLabel(boolean showConstantNames) {
        if (this.inputArc == null) {
            this.getNameLabel().setText("");
        } else {
            if (this.lens != null && this.lens.isColored()) {
                StringBuilder arcPrint = new StringBuilder();
                if (this.inputArc.getArcExpression() != null) {
                    arcPrint = new StringBuilder(this.inputArc.getArcExpression().toString());
                }
                if (this.lens.isTimed()) {
                    arcPrint.append("\n");
                    if (TAPAALGUI.getAppGui().showZeroToInfinityIntervals() || !this.inputArc.interval().toString(showConstantNames).equals("[0,inf)")) {
                        arcPrint.append(this.inputArc.interval().toString(showConstantNames));
                        arcPrint.append("\n");
                    }
                    List<ColoredTimeInterval> ctiList = this.underlyingTimedInputArc().getColorTimeIntervals();
                    for (ColoredTimeInterval coloredTimeInterval : ctiList) {
                        if (coloredTimeInterval == null) continue;
                        arcPrint.append(coloredTimeInterval);
                        arcPrint.append("\n");
                    }
                }
                this.getNameLabel().setText(arcPrint.toString());
            } else if (!TAPAALGUI.getAppGui().showZeroToInfinityIntervals() || this.lens != null && !this.lens.isTimed()) {
                if (this.inputArc.interval().toString(showConstantNames).equals("[0,inf)")) {
                    this.getNameLabel().setText("");
                } else {
                    this.getNameLabel().setText(this.inputArc.interval().toString(showConstantNames));
                }
            } else {
                this.getNameLabel().setText(this.inputArc.interval().toString(showConstantNames));
            }
            if (this.getNameLabel().getText().contains("inf")) {
                String intervalStringWithInfSymbol = this.getNameLabel().getText().replace("inf", Character.toString('\u221e'));
                this.getNameLabel().setText(intervalStringWithInfSymbol);
            }
            this.getNameLabel().setText(this.getWeight().toString(showConstantNames) + " " + this.getNameLabel().getText());
            boolean focusedConstant = false;
            boolean isvisible = true;
            if (this.inputArc.interval().lowerBound() instanceof ConstantBound) {
                if (((ConstantBound)this.inputArc.interval().lowerBound()).constant().hasFocus()) {
                    focusedConstant = true;
                }
                if (!((ConstantBound)this.inputArc.interval().lowerBound()).constant().getVisible()) {
                    isvisible = false;
                }
            }
            if (this.inputArc.interval().upperBound() instanceof ConstantBound) {
                if (((ConstantBound)this.inputArc.interval().upperBound()).constant().hasFocus()) {
                    focusedConstant = true;
                }
                if (!((ConstantBound)this.inputArc.interval().upperBound()).constant().getVisible()) {
                    isvisible = false;
                }
            }
            if (this.getWeight() instanceof ConstantWeight) {
                if (((ConstantWeight)this.getWeight()).constant().hasFocus()) {
                    focusedConstant = true;
                }
                isvisible = ((ConstantWeight)this.getWeight()).constant().getVisible();
            }
            if (focusedConstant) {
                this.getNameLabel().setForeground(Constants.SELECTION_TEXT_COLOUR);
            } else {
                this.getNameLabel().setForeground(Constants.ELEMENT_TEXT_COLOUR);
            }
            this.pnName.setVisible(isvisible);
        }
        this.setLabelPosition();
    }

    public TimedInputArc underlyingTimedInputArc() {
        return this.inputArc;
    }

    public void setUnderlyingArc(TimedInputArc ia) {
        this.inputArc = ia;
        this.updateLabel(true);
    }

    @Override
    public TimedInputArcComponent copy(TimedArcPetriNet tapn, Hashtable<PlaceTransitionObject, PlaceTransitionObject> oldToNewMapping) {
        TimedInputArcComponent arc = new TimedInputArcComponent(this);
        arc.setSource(oldToNewMapping.get(this.getSource()));
        arc.setTarget(oldToNewMapping.get(this.getTarget()));
        arc.setUnderlyingArc(tapn.getInputArcFromPlaceToTransition(tapn.getPlaceByName(this.inputArc.source().name()), tapn.getTransitionByName(this.inputArc.destination().name())));
        return arc;
    }

    @Override
    public void setWeight(Weight weight) {
        this.inputArc.setWeight(weight);
    }

    @Override
    public Weight getWeight() {
        return this.inputArc.getWeight();
    }

    @Override
    public void setExpression(ArcExpression expr) {
        this.inputArc.setExpression(expr);
    }

    @Override
    public ArcExpression getExpression() {
        return this.inputArc.getArcExpression();
    }

    public void setCtiList(List<ColoredTimeInterval> ctiList) {
        this.inputArc.setColorTimeIntervals(ctiList);
    }

    public List<ColoredTimeInterval> getCtiList() {
        return this.inputArc.getColorTimeIntervals();
    }
}

