/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import pipe.gui.Constants;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.action.ShowHideInfoAction;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;

public abstract class Place
extends PlaceTransitionObject {
    protected static final int DIAMETER = 30;
    protected static final int tWidth = 5;
    protected static final int tHeight = 5;
    protected static final int tLeftX = 7;
    protected static final int tRightX = 19;
    protected static final int tTopY = 7;
    protected static final int tBotY = 19;
    protected static final int tMiddleX = 13;
    protected static final int tMiddleY = 13;
    protected static final Ellipse2D.Double placeEllipse = new Ellipse2D.Double(0.0, 0.0, 30.0, 30.0);
    protected static final Shape proximityPlace = new BasicStroke(25.0f).createStrokedShape(placeEllipse);

    public Place(int positionXInput, int positionYInput, String idInput, int nameOffsetXInput, int nameOffsetYInput) {
        super(30.0, 30.0, positionXInput, positionYInput, idInput, nameOffsetXInput, nameOffsetYInput);
    }

    public Place(int positionXInput, int positionYInput) {
        this(positionXInput, positionYInput, null, 0, 0);
    }

    @Override
    public JPopupMenu getPopup(MouseEvent e) {
        int index = 0;
        JPopupMenu popup = super.getPopup(e);
        JMenuItem menuItem = new JMenuItem("Edit Place");
        menuItem.addActionListener(o -> this.showEditor());
        popup.insert(menuItem, index++);
        menuItem = new JMenuItem(new ShowHideInfoAction(this));
        if (this.getAttributesVisible()) {
            menuItem.setText("Hide Place Name");
        } else {
            menuItem.setText("Show Place Name");
        }
        popup.insert(menuItem, index++);
        popup.insert(new JPopupMenu.Separator(), index);
        return popup;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.selected) {
            g2.setColor(Constants.SELECTION_FILL_COLOUR);
        } else {
            g2.setColor(Constants.ELEMENT_FILL_COLOUR);
        }
        g2.fill(placeEllipse);
        if (this.selected) {
            g2.setPaint(Constants.SELECTION_LINE_COLOUR);
        } else {
            g2.setPaint(Constants.ELEMENT_LINE_COLOUR);
        }
        g2.draw(placeEllipse);
        g2.setStroke(new BasicStroke(1.0f));
    }

    private int getDiameter() {
        return Zoomer.getZoomedValue(30, this.getZoom());
    }

    @Override
    public boolean contains(int x, int y) {
        double unZoomedX = Zoomer.getUnzoomedValue(x - 5, this.getZoom());
        double unZoomedY = Zoomer.getUnzoomedValue(y - 5, this.getZoom());
        if (TAPAALGUI.useExtendedBounds) {
            return proximityPlace.contains((int)unZoomedX, (int)unZoomedY) || placeEllipse.contains((int)unZoomedX, (int)unZoomedY);
        }
        return placeEllipse.contains((int)unZoomedX, (int)unZoomedY);
    }

    @Override
    public void updateEndPoint(Arc arc) {
        double centerX = this.positionX + this.centreOffsetLeft();
        double centerY = this.positionY + this.centreOffsetTop();
        double radius = (double)this.getDiameter() * 0.5;
        boolean isSource = arc.getSource() == this;
        double angle = isSource ? arc.getArcPath().getStartAngle() : arc.getArcPath().getEndAngle();
        double intersectX = centerX - radius * Math.cos(angle);
        double intersectY = centerY + radius * Math.sin(angle);
        if (isSource) {
            arc.setSourceLocation(centerX, centerY);
            arc.setSourceLocation(intersectX, intersectY);
        } else {
            arc.setTargetLocation(centerX, centerY);
            arc.setTargetLocation(intersectX, intersectY);
        }
    }

    @Override
    public void update(boolean displayConstantNames) {
        this.getNameLabel().setText("");
        super.update(displayConstantNames);
        this.repaint();
    }
}

