/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import javax.swing.JLayeredPane;
import pipe.gui.Constants;
import pipe.gui.canvas.Grid;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.graphicElements.NameLabel;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.handler.LabelHandler;

public abstract class PetriNetObjectWithLabel
extends PetriNetObject {
    protected final NameLabel pnName = new NameLabel();
    private int nameOffsetX;
    private int nameOffsetY;

    PetriNetObjectWithLabel(String idInput, int positionXInput, int positionYInput, int nameOffsetX, int nameOffsetY) {
        super(idInput, positionXInput, positionYInput);
        this.nameOffsetX = nameOffsetX;
        this.nameOffsetY = nameOffsetY;
        this.pnName.setPosition(nameOffsetX, nameOffsetY);
        this.pnName.setForeground(Constants.ELEMENT_LINE_COLOUR);
        this.setLabelHandler();
    }

    protected void setLabelHandler() {
        LabelHandler labelHandler = new LabelHandler(this.getNameLabel(), this);
        this.getNameLabel().addMouseListener(labelHandler);
        this.getNameLabel().addMouseMotionListener(labelHandler);
        this.getNameLabel().addMouseWheelListener(labelHandler);
    }

    protected void updateLabelLocation(boolean alignToGrid) {
        if (alignToGrid) {
            this.getNameLabel().setPosition(Grid.align(this.positionX + Zoomer.getZoomedValue(this.nameOffsetX, this.getZoom()), 100), Grid.align(this.positionY + Zoomer.getZoomedValue(this.nameOffsetY, this.getZoom()), 100));
        } else {
            this.getNameLabel().setPosition(this.positionX + Zoomer.getZoomedValue(this.nameOffsetX, this.getZoom()), this.positionY + Zoomer.getZoomedValue(this.nameOffsetY, this.getZoom()));
        }
    }

    @Override
    public void updateOnMoveOrZoom() {
        this.updateLabelLocation(true);
    }

    @Override
    public void addedToGui() {
        this.addLabelToContainer();
    }

    @Override
    public void removedFromGui() {
        this.removeLabelFromContainer();
    }

    public void setNameOffsetX(int nameOffsetXInput) {
        this.nameOffsetX = nameOffsetXInput;
    }

    public void setNameOffsetY(int nameOffsetYInput) {
        this.nameOffsetY = nameOffsetYInput;
    }

    public void translateNameOffsetX(int nameOffsetXInput) {
        this.nameOffsetX += Zoomer.getUnzoomedValue(nameOffsetXInput, this.getZoom());
    }

    public void translateNameOffsetY(int nameOffsetYInput) {
        this.nameOffsetY += Zoomer.getUnzoomedValue(nameOffsetYInput, this.getZoom());
    }

    public int getNameOffsetX() {
        return this.nameOffsetX;
    }

    public int getNameOffsetY() {
        return this.nameOffsetY;
    }

    public NameLabel getNameLabel() {
        return this.pnName;
    }

    public void addLabelToContainer() {
        if (this.getParent() != null && this.pnName.getParent() == null) {
            this.getParent().setLayer(this.pnName, JLayeredPane.DEFAULT_LAYER + this.pnName.getLayerOffset());
            this.getParent().add(this.pnName);
        }
    }

    public void removeLabelFromContainer() {
        if (this.getParent() != null && this.pnName != null) {
            this.getParent().remove(this.pnName);
        }
    }

    @Override
    public void select(boolean shouldRepaint) {
        if (this.selectable && !this.selected) {
            this.selected = true;
            if (this.pnName != null) {
                this.pnName.setForeground(Constants.SELECTION_LINE_COLOUR);
            }
            if (shouldRepaint) {
                this.repaint();
            }
        }
    }

    @Override
    public void deselect() {
        if (this.selected) {
            this.selected = false;
            if (this.pnName != null) {
                this.pnName.setForeground(Constants.ELEMENT_LINE_COLOUR);
            }
            this.repaint();
        }
    }

    @Override
    public void zoomUpdate(int zoom) {
        super.zoomUpdate(zoom);
        if (this.pnName != null) {
            this.pnName.zoomUpdate(zoom);
        }
    }

    @Override
    public void translate(int x, int y) {
        super.translate(x, y);
    }
}

