/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import javax.swing.JTextArea;
import javax.swing.text.DefaultHighlighter;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.Constants;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.undo.AnnotationBorderEditCommand;

public abstract class Note
extends PetriNetObject {
    protected final JTextArea note = new JTextArea();
    protected boolean drawBorder = true;
    protected final RectangularShape noteRect = new Rectangle();

    public Note(int x, int y) {
        super("", x, y);
        this.note.setAlignmentX(0.5f);
        this.note.setAlignmentY(0.5f);
        this.note.setOpaque(false);
        this.note.setEditable(false);
        this.note.setEnabled(false);
        this.note.setLineWrap(true);
        this.note.setWrapStyleWord(true);
        this.note.setText("");
        this.note.setFont(new Font("Helvetica", 0, 12));
        this.note.setSize(this.note.getPreferredSize().width, this.note.getPreferredSize().height);
        this.note.setMinimumSize(this.note.getPreferredSize());
        this.note.setHighlighter(new DefaultHighlighter());
        this.note.setDisabledTextColor(Constants.NOTE_DISABLED_COLOUR);
        this.note.setForeground(Constants.NOTE_EDITING_COLOUR);
        this.add(this.note);
    }

    public Note(String text, int x, int y, int w, int h, boolean border) {
        this(x, y);
        this.note.setText(text);
        this.drawBorder = border;
        this.note.setSize(w, h);
        this.updateBounds();
    }

    public void setInnerNoteSize(Dimension newSize) {
        this.note.setSize((int)newSize.getWidth(), (int)newSize.getHeight());
    }

    public void updateBounds() {
        int newHeight = this.note.getPreferredSize().height;
        if (this.note.getHeight() < newHeight && newHeight >= this.note.getMinimumSize().height) {
            this.note.setSize(this.note.getWidth(), newHeight);
        }
        int rectWidth = this.note.getWidth() + 12;
        int rectHeight = this.note.getHeight() + 12;
        this.noteRect.setFrame(6.0, 6.0, rectWidth, rectHeight);
        this.setSize(rectWidth + 4, rectHeight + 4);
        this.note.setLocation((int)this.noteRect.getX() + (rectWidth - this.note.getWidth()) / 2, (int)this.noteRect.getY() + (rectHeight - this.note.getHeight()) / 2);
        Rectangle bounds = new Rectangle();
        bounds.setBounds(Zoomer.getZoomedValue(this.originalX, this.getZoom()), Zoomer.getZoomedValue(this.originalY, this.getZoom()), (int)((double)(rectWidth + 12 + 4) * Zoomer.getScaleFactor(this.getZoom())), (int)((double)(rectHeight + 12 + 4) * Zoomer.getScaleFactor(this.getZoom())));
        this.setBounds(bounds);
    }

    public abstract void enableEditMode();

    public boolean isShowingBorder() {
        return this.drawBorder;
    }

    public Command showBorder(boolean show) {
        this.drawBorder = show;
        this.repaint();
        return new AnnotationBorderEditCommand(this);
    }

    public JTextArea getNote() {
        return this.note;
    }

    public String getNoteText() {
        return this.note.getText();
    }

    public int getNoteWidth() {
        return this.note.getWidth();
    }

    public int getNoteHeight() {
        return this.note.getHeight();
    }

    public void setPosition(Point point) {
        this.setLocation(point.x, point.y);
        ((Rectangle)this.noteRect).setLocation(point);
        this.originalX = Zoomer.getUnzoomedValue(point.x, this.getZoom());
        this.originalY = Zoomer.getUnzoomedValue(point.y, this.getZoom());
    }

    @Override
    public void translate(int x, int y) {
        this.setLocation(this.getX() + x, this.getY() + y);
        this.originalX += Zoomer.getUnzoomedValue(x, this.getZoom());
        this.originalY += Zoomer.getUnzoomedValue(y, this.getZoom());
        this.updateBounds();
    }

    protected void adjustTop(int dy) {
        if (this.note.getPreferredSize().height <= this.note.getHeight() - dy) {
            this.note.setSize(new Dimension(this.note.getWidth(), this.note.getHeight() - dy));
            this.setLocation(this.getX(), this.getY() + dy);
            this.originalY += dy;
        }
    }

    protected void adjustBottom(int dy) {
        if (this.note.getPreferredSize().height <= this.note.getHeight() + dy) {
            this.note.setSize(new Dimension(this.note.getWidth(), this.note.getHeight() + dy));
        }
    }

    protected void adjustLeft(int dx) {
        if (40 <= this.note.getWidth() - dx) {
            this.note.setSize(new Dimension(this.note.getWidth() - dx, this.note.getHeight()));
            this.setLocation(this.getX() + dx, this.getY());
            this.originalX += dx;
        }
    }

    protected void adjustRight(int dx) {
        if (40 <= this.note.getWidth() + dx) {
            this.note.setSize(new Dimension(this.note.getWidth() + dx, this.note.getHeight()));
        }
    }

    @Override
    public boolean contains(int x, int y) {
        return this.noteRect.contains((double)x / Zoomer.getScaleFactor(this.getZoom()), (double)y / Zoomer.getScaleFactor(this.getZoom()));
    }

    @Override
    public void addedToGui() {
        this.setDeleted(false);
        this.updateBounds();
    }

    @Override
    public void removedFromGui() {
    }

    public void setText(String text) {
        this.note.setText(text);
        this.note.setSize(this.note.getPreferredSize());
    }

    public String getText() {
        return this.note.getText();
    }

    @Override
    public int getLayerOffset() {
        return 10;
    }

    @Override
    public void zoomUpdate(int percent) {
        super.zoomUpdate(percent);
        this.updateBounds();
    }
}

