/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.tapaal.gui.DrawingSurfaceManager.AbstractDrawingSurfaceManager;
import net.tapaal.helpers.Reference.Reference;
import pipe.gui.petrinet.graphicElements.Translatable;
import pipe.gui.petrinet.graphicElements.Zoomable;

public abstract class GraphicalElement
extends JComponent
implements Zoomable,
Translatable {
    protected Reference<AbstractDrawingSurfaceManager> managerRef = null;

    public GraphicalElement() {
        this.addMouseListener(new MouseListener(){
            private boolean rightMouseDown = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GraphicalElement.this.getManagerRef() != null && GraphicalElement.this.getManagerRef().get() != null) {
                    switch (e.getClickCount()) {
                        case 1: {
                            GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.clicked));
                            break;
                        }
                        case 2: {
                            GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.doubleClicked));
                        }
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (GraphicalElement.this.getManagerRef() != null && GraphicalElement.this.getManagerRef().get() != null) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.pressed));
                    } else if (SwingUtilities.isRightMouseButton(e)) {
                        this.rightMouseDown = true;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (GraphicalElement.this.getManagerRef() != null && GraphicalElement.this.getManagerRef().get() != null) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.released));
                    } else if (SwingUtilities.isRightMouseButton(e) && this.rightMouseDown) {
                        GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.rightClicked));
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (GraphicalElement.this.getManagerRef() != null && GraphicalElement.this.getManagerRef().get() != null) {
                    GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.entered));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.rightMouseDown = false;
                if (GraphicalElement.this.getManagerRef() != null && GraphicalElement.this.getManagerRef().get() != null) {
                    GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.exited));
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (GraphicalElement.this.getManagerRef() != null && GraphicalElement.this.getManagerRef().get() != null) {
                    GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.wheel));
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (GraphicalElement.this.getManagerRef() != null && GraphicalElement.this.getManagerRef().get() != null) {
                    GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.dragged));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (GraphicalElement.this.getManagerRef() != null && GraphicalElement.this.getManagerRef().get() != null) {
                    GraphicalElement.this.getManagerRef().get().triggerEvent(new AbstractDrawingSurfaceManager.DrawingSurfaceEvent(GraphicalElement.this, e, AbstractDrawingSurfaceManager.MouseAction.moved));
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
    }

    public abstract int getLayerOffset();

    public Reference<AbstractDrawingSurfaceManager> getManagerRef() {
        return this.managerRef;
    }

    public void setManagerRef(Reference<AbstractDrawingSurfaceManager> manager) {
        this.managerRef = manager;
    }

    public abstract void addedToGui();

    public abstract void removedFromGui();
}

