/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.Constants;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.action.SplitArcPointAction;
import pipe.gui.petrinet.action.ToggleArcPointAction;
import pipe.gui.petrinet.graphicElements.ArcPath;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.undo.AddArcPathPointEditCommand;
import pipe.gui.petrinet.undo.ArcPathPointTypeEditCommand;

public class ArcPathPoint
extends PetriNetObject {
    public static final boolean STRAIGHT = false;
    public static final boolean CURVED = true;
    private int SIZE = 3;
    private static final int SIZE_OFFSET = 1;
    private static final int DELTA = 10;
    private ArcPath myArcPath;
    private final Point2D.Double control1 = new Point2D.Double();
    private final Point2D.Double control2 = new Point2D.Double();
    private boolean pointType;

    private ArcPathPoint() {
        super("", 0, 0);
    }

    public ArcPathPoint(ArcPath a) {
        this();
        this.myArcPath = a;
        this.setPointLocation(0, 0);
    }

    public ArcPathPoint(double x, double y, boolean _pointType, ArcPath a) {
        this();
        this.myArcPath = a;
        this.setOriginalX((int)x);
        this.setOriginalY((int)y);
        this.pointType = _pointType;
    }

    @Override
    public JPopupMenu getPopup(MouseEvent e) {
        JPopupMenu popup = super.getPopup(e);
        if (!this.isDeleteable()) {
            popup.getComponent(0).setEnabled(false);
        }
        popup.insert(new JPopupMenu.Separator(), 0);
        if (this.getIndex() == 0) {
            return popup;
        }
        JMenuItem menuItem = new JMenuItem(new ToggleArcPointAction(this));
        if (!this.getPointType()) {
            menuItem.setText("Change to Curved");
        } else {
            menuItem.setText("Change to Straight");
        }
        popup.insert(menuItem, 0);
        menuItem = new JMenuItem(new SplitArcPointAction(this));
        menuItem.setText("Split Point");
        popup.add((Component)menuItem, 1);
        return popup;
    }

    public ArcPathPoint(Point2D.Double point, boolean _pointType, ArcPath a) {
        this(point.x, point.y, _pointType, a);
    }

    public Point2D.Double getPoint() {
        return new Point2D.Double(this.getPositionX(), this.getPositionY());
    }

    @Override
    public void setOriginalX(int positionXInput) {
        if (this.myArcPath != null && !this.isEndPoint()) {
            super.setOriginalX(positionXInput);
        } else {
            this.originalX = positionXInput;
            this.positionX = Zoomer.getZoomedValue(this.originalX, this.getZoom());
        }
    }

    @Override
    public void setOriginalY(int positionYInput) {
        if (this.myArcPath != null && !this.isEndPoint()) {
            super.setOriginalY(positionYInput);
        } else {
            this.originalY = positionYInput;
            this.positionY = Zoomer.getZoomedValue(this.originalY, this.getZoom());
        }
    }

    public void setPointLocation(int x, int y) {
        this.setPositionX(x);
        this.setPositionY(y);
        this.updateOnMoveOrZoom();
    }

    public boolean getPointType() {
        return this.pointType;
    }

    public void setPointType(boolean type) {
        if (this.pointType != type) {
            this.pointType = type;
            this.myArcPath.createPath();
            this.myArcPath.getArc().updateArcPosition();
        }
    }

    public Command togglePointType() {
        this.pointType = !this.pointType;
        this.myArcPath.createPath();
        this.myArcPath.getArc().updateArcPosition();
        return new ArcPathPointTypeEditCommand(this);
    }

    public void setVisibilityLock(boolean lock) {
        this.myArcPath.setPointVisibilityLock(lock);
    }

    public double getAngle(Point2D.Double p2) {
        double angle = Math.atan2(p2.y - this.getPoint().y, this.getPoint().x - p2.x);
        return angle;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        RectangularShape shape = this.pointType ? new Ellipse2D.Double(0.0, 0.0, 2 * this.SIZE, 2 * this.SIZE) : new Rectangle2D.Double(0.0, 0.0, 2 * this.SIZE, 2 * this.SIZE);
        if (this.selected) {
            g2.setPaint(Constants.SELECTION_FILL_COLOUR);
            g2.fill(shape);
            g2.setPaint(Constants.SELECTION_LINE_COLOUR);
            g2.draw(shape);
        } else {
            g2.setPaint(Constants.ELEMENT_FILL_COLOUR);
            g2.fill(shape);
            g2.setPaint(Constants.ELEMENT_LINE_COLOUR);
            g2.draw(shape);
        }
    }

    public int getIndex() {
        for (int i = 0; i < this.myArcPath.getNumPoints(); ++i) {
            if (this.myArcPath.getPathPoint(i) != this) continue;
            return i;
        }
        return -1;
    }

    public Command splitPoint() {
        int i = this.getIndex();
        ArcPathPoint newPoint = new ArcPathPoint(this.getPositionX() + 10, this.getPositionY(), this.pointType, this.myArcPath);
        this.myArcPath.insertPoint(i + 1, newPoint);
        this.myArcPath.getArc().updateArcPosition();
        return new AddArcPathPointEditCommand(this.myArcPath.getArc(), newPoint, this.myArcPath.getArc().getGuiModel());
    }

    public Point2D.Double getMidPoint(ArcPathPoint target) {
        return new Point2D.Double((target.getPositionX() + this.getPositionX()) / 2, (target.getPositionY() + this.getPositionY()) / 2);
    }

    public boolean isDeleteable() {
        int i = this.getIndex();
        return i > 0 && i != this.myArcPath.getNumPoints() - 1;
    }

    public Point2D.Double getControl1() {
        return this.control1;
    }

    public Point2D.Double getControl2() {
        return this.control2;
    }

    public void setControl1(double _x, double _y) {
        this.control1.x = _x;
        this.control1.y = _y;
    }

    public void setControl2(double _x, double _y) {
        this.control2.x = _x;
        this.control2.y = _y;
    }

    public void setControl1(Point2D.Double p) {
        this.control1.x = p.x;
        this.control1.y = p.y;
    }

    public void setControl2(Point2D.Double p) {
        this.control2.x = p.x;
        this.control2.y = p.y;
    }

    public ArcPath getArcPath() {
        return this.myArcPath;
    }

    @Override
    public void addedToGui() {
    }

    @Override
    public void removedFromGui() {
    }

    @Override
    public int getLayerOffset() {
        return 50;
    }

    @Override
    public void translate(int x, int y) {
        if (!this.isEndPoint()) {
            this.setPositionX(this.positionX + x);
            this.setPositionY(this.positionY + y);
            this.updateOnMoveOrZoom();
            this.myArcPath.updateArc();
        }
    }

    @Override
    public String getName() {
        return this.getArcPath().getArc().getName() + " - Point " + this.getIndex();
    }

    @Override
    public void zoomUpdate(int zoom) {
        this.SIZE = zoom > 213 ? 5 : (zoom > 126 ? 4 : 3);
        super.zoomUpdate(zoom);
    }

    @Override
    public void updateOnMoveOrZoom() {
        int x = Zoomer.getZoomedValue(this.getOriginalX(), this.getZoom());
        int y = Zoomer.getZoomedValue(this.getOriginalY(), this.getZoom());
        this.positionX = x;
        this.positionY = y;
        this.setBounds(x - this.SIZE, y - this.SIZE, 2 * this.SIZE + 1, 2 * this.SIZE + 1);
    }

    public Point2D.Double getRealPoint() {
        return new Point2D.Double(this.getOriginalX(), this.getOriginalY());
    }

    public boolean isEndPoint() {
        return this.getIndex() == 0 || this.getIndex() == this.myArcPath.getEndIndex();
    }

    @Override
    public void select(boolean shouldRepaint) {
        this.setVisible(true);
        super.select(shouldRepaint);
    }

    @Override
    public void deselect() {
        this.setVisible(false);
        super.deselect();
    }
}

