/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.undo.Command;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.ArcPathPoint;
import pipe.gui.petrinet.graphicElements.Cubic;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.undo.AddArcPathPointEditCommand;

public class ArcPath
implements Shape {
    private GeneralPath path = new GeneralPath();
    private final List<ArcPathPoint> pathPoints = new ArrayList<ArcPathPoint>();
    private final Arc myArc;
    private boolean pointLock = false;
    private static final Stroke proximityStroke = new BasicStroke(10.0f);
    private static final Stroke stroke = new BasicStroke(6.0f);
    private Shape shape;
    private Shape proximityShape;
    private int transitionAngle;
    private static final boolean showDebugCurvedControlPoints = false;
    public final Point2D.Double midPoint = new Point2D.Double();

    private ArcPath(Arc a, int transitionAngle) {
        this.myArc = a;
        this.transitionAngle = transitionAngle;
    }

    public ArcPath(Arc a) {
        this(a, 0);
        this.addPoint();
        this.addPoint();
    }

    public ArcPath(Arc a, ArcPath path) {
        this(a, 0);
        for (int i = 0; i <= path.getEndIndex(); ++i) {
            this.addPoint(path.getRealPoint(i).getX(), path.getRealPoint(i).getY(), path.getPointType(i));
        }
    }

    public List<ArcPathPoint> getArcPathPoints() {
        return this.pathPoints;
    }

    public ArcPathPoint getArcPathPoint(int i) {
        return this.pathPoints.get(i);
    }

    public void createPath() {
        int c;
        this.setControlPoints();
        this.path = new GeneralPath();
        ArcPathPoint currentPoint = this.pathPoints.get(0);
        this.path.moveTo(currentPoint.getPoint().x, currentPoint.getPoint().y);
        currentPoint.setPointType(false);
        double length = 0.0;
        for (c = 1; c <= this.getEndIndex(); ++c) {
            ArcPathPoint previousPoint = currentPoint;
            currentPoint = this.pathPoints.get(c);
            if (!currentPoint.getPointType()) {
                this.path.lineTo(currentPoint.getPoint().x, currentPoint.getPoint().y);
            } else if (currentPoint.getPointType()) {
                this.path.curveTo(currentPoint.getControl1().x, currentPoint.getControl1().y, currentPoint.getControl2().x, currentPoint.getControl2().y, currentPoint.getPoint().x, currentPoint.getPoint().y);
            }
            length += this.getMod(currentPoint.getPoint(), previousPoint.getPoint());
        }
        length /= 2.0;
        c = 0;
        currentPoint = this.pathPoints.get(c++);
        if (this.getEndIndex() < 2) {
            this.midPoint.x = (this.pathPoints.get((int)0).getPoint().x + this.pathPoints.get((int)1).getPoint().x) * 0.5;
            this.midPoint.y = (this.pathPoints.get((int)0).getPoint().y + this.pathPoints.get((int)1).getPoint().y) * 0.5;
        } else {
            ArcPathPoint previousPoint;
            double acc = 0.0;
            double percent = 0.0;
            for (c = 1; c <= this.getEndIndex(); ++c) {
                previousPoint = currentPoint;
                currentPoint = this.pathPoints.get(c);
                double inc = this.getMod(currentPoint.getPoint(), previousPoint.getPoint());
                if (acc + inc > length) {
                    percent = (length - acc) / inc;
                    break;
                }
                acc += inc;
            }
            previousPoint = this.pathPoints.get(c - 1);
            this.midPoint.x = previousPoint.getPoint().x + (currentPoint.getPoint().x - previousPoint.getPoint().x) * percent;
            this.midPoint.y = previousPoint.getPoint().y + (currentPoint.getPoint().y - previousPoint.getPoint().y) * percent;
        }
        this.shape = stroke.createStrokedShape(this);
        this.getArc().setLabelPosition();
        this.proximityShape = proximityStroke.createStrokedShape(this);
    }

    private void setControlPoints() {
        this.setCurveControlPoints();
        this.setStraightControlPoints();
        this.setEndControlPoints();
    }

    private Point2D.Double getControlPoint(Point2D.Double A, Point2D.Double B, Point2D.Double C, Point2D.Double D) {
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        double modAB = this.getMod(A, B);
        double modCD = this.getMod(C, D);
        double ABx = (B.x - A.x) / modAB;
        double ABy = (B.y - A.y) / modAB;
        if (modAB < 7.0) {
            p = (Point2D.Double)C.clone();
        } else {
            p.x = C.x + ABx * modCD / 3.0;
            p.y = C.y + ABy * modCD / 3.0;
        }
        return p;
    }

    private double getMod(Point2D.Double A, Point2D.Double B) {
        double ABx = A.x - B.x;
        double ABy = A.y - B.y;
        return Math.sqrt(ABx * ABx + ABy * ABy);
    }

    private void setCurveControlPoints() {
        if (this.pathPoints.size() < 1) {
            return;
        }
        ArcPathPoint myCurrentPoint = this.pathPoints.get(0);
        myCurrentPoint.setPointType(false);
        int endIndex = this.getEndIndex();
        int c = 1;
        while (c <= endIndex) {
            int curveStartIndex = 0;
            int curveEndIndex = 0;
            myCurrentPoint = this.pathPoints.get(c);
            if (myCurrentPoint.getPointType()) {
                int k1;
                curveStartIndex = c - 1;
                while (c <= endIndex && myCurrentPoint.getPointType()) {
                    myCurrentPoint = this.pathPoints.get(c);
                    curveEndIndex = c++;
                }
                int lengthOfCurve = curveEndIndex - curveStartIndex;
                int[] x = new int[lengthOfCurve + 2];
                int[] y = new int[lengthOfCurve + 2];
                Cubic[] X = new Cubic[lengthOfCurve + 2];
                Cubic[] Y = new Cubic[lengthOfCurve + 2];
                for (k1 = 0; k1 <= curveEndIndex - curveStartIndex; ++k1) {
                    x[k1] = (int)this.pathPoints.get((int)(curveStartIndex + k1)).getPoint().x;
                    y[k1] = (int)this.pathPoints.get((int)(curveStartIndex + k1)).getPoint().y;
                }
                x[k1] = x[k1 - 1];
                y[k1] = y[k1 - 1];
                X = this.calcNaturalCubic(k1, x);
                Y = this.calcNaturalCubic(k1, y);
                for (int k2 = 1; k2 <= lengthOfCurve; ++k2) {
                    myCurrentPoint = this.pathPoints.get(k2 + curveStartIndex);
                    myCurrentPoint.setControl1(X[k2 - 1].getX1(), Y[k2 - 1].getX1());
                    myCurrentPoint.setControl2(X[k2 - 1].getX2(), Y[k2 - 1].getX2());
                }
                continue;
            }
            ++c;
        }
    }

    private void setStraightControlPoints() {
        ArcPathPoint myCurrentPoint = this.pathPoints.get(0);
        ArcPathPoint myPreviousButOnePoint = null;
        ArcPathPoint myNextPoint = null;
        ArcPathPoint myPreviousPoint = null;
        for (int c = 1; c <= this.getEndIndex(); ++c) {
            myPreviousPoint = this.pathPoints.get(c - 1);
            myCurrentPoint = this.pathPoints.get(c);
            if (!myCurrentPoint.getPointType()) {
                myCurrentPoint.setControl1(this.getControlPoint(myPreviousPoint.getPoint(), myCurrentPoint.getPoint(), myPreviousPoint.getPoint(), myCurrentPoint.getPoint()));
                myCurrentPoint.setControl2(this.getControlPoint(myCurrentPoint.getPoint(), myPreviousPoint.getPoint(), myCurrentPoint.getPoint(), myPreviousPoint.getPoint()));
                continue;
            }
            if (c > 1 && !myPreviousPoint.getPointType()) {
                myPreviousButOnePoint = this.pathPoints.get(c - 2);
                myCurrentPoint.setControl1(this.getControlPoint(myPreviousButOnePoint.getPoint(), myPreviousPoint.getPoint(), myPreviousPoint.getPoint(), myCurrentPoint.getPoint()));
            }
            if (c >= this.getEndIndex() || (myNextPoint = this.pathPoints.get(c + 1)).getPointType()) continue;
            myCurrentPoint.setControl2(this.getControlPoint(myNextPoint.getPoint(), myCurrentPoint.getPoint(), myCurrentPoint.getPoint(), myPreviousPoint.getPoint()));
        }
    }

    private void setEndControlPoints() {
        PlaceTransitionObject source = this.getArc().getSource();
        PlaceTransitionObject target = this.getArc().getTarget();
        double anAngle = Math.toRadians(this.transitionAngle);
        if (this.getEndIndex() <= 0) {
            return;
        }
        if (source instanceof Transition && this.pathPoints.get(1).getPointType()) {
            ArcPathPoint myPoint = this.pathPoints.get(1);
            ArcPathPoint myLastPoint = this.pathPoints.get(0);
            double distance = this.getMod(myPoint.getPoint(), myLastPoint.getPoint()) / 3.0;
            myPoint.setControl1(myLastPoint.getPoint().x + Math.cos(anAngle) * distance, myLastPoint.getPoint().y + Math.sin(anAngle) * distance);
            myPoint = this.pathPoints.get(this.getEndIndex());
            myPoint.setControl2(this.getControlPoint(myPoint.getPoint(), myPoint.getControl1(), myPoint.getPoint(), myPoint.getControl1()));
        } else if (target != null && source instanceof Place && this.pathPoints.get(this.getEndIndex()).getPointType()) {
            ArcPathPoint myPoint = this.pathPoints.get(this.getEndIndex());
            ArcPathPoint myLastPoint = this.pathPoints.get(this.getEndIndex() - 1);
            double distance = this.getMod(myPoint.getPoint(), myLastPoint.getPoint()) / 3.0;
            myPoint.setControl2(myPoint.getPoint().x + Math.cos(anAngle) * distance, myPoint.getPoint().y + Math.sin(anAngle) * distance);
            myPoint = this.pathPoints.get(1);
            myPoint.setControl1(this.getControlPoint(this.pathPoints.get(0).getPoint(), myPoint.getControl2(), this.pathPoints.get(0).getPoint(), myPoint.getControl2()));
        }
    }

    public void addPoint(int index, double x, double y, boolean type) {
        ArcPathPoint arcpath = new ArcPathPoint(x, y, type, this);
        if (this.myArc != null) {
            arcpath.zoomUpdate(this.myArc.getZoom());
        }
        this.pathPoints.add(index, arcpath);
    }

    public void addPoint(double x, double y, boolean type) {
        ArcPathPoint arcpath = new ArcPathPoint(x, y, type, this);
        if (this.myArc != null) {
            arcpath.zoomUpdate(this.myArc.getZoom());
        }
        this.pathPoints.add(arcpath);
        this.addPointsToGui(this.myArc.getGuiModel());
    }

    public void addPoint() {
        this.pathPoints.add(new ArcPathPoint(this));
    }

    public void deletePoint(ArcPathPoint a) {
        this.pathPoints.remove(a);
    }

    public void updateArc() {
        this.myArc.updateArcPosition();
    }

    @Override
    public boolean contains(double arg0, double arg1) {
        return false;
    }

    public int getEndIndex() {
        return this.pathPoints.size() - 1;
    }

    public void setPointLocation(int index, double x, double y) {
        if (index < this.pathPoints.size() && index >= 0) {
            this.pathPoints.get(index).setPointLocation((int)Math.round(x), (int)Math.round(y));
        }
    }

    public void setPointType(int index, boolean type) {
        this.pathPoints.get(index).setPointType(type);
    }

    public boolean getPointType(int index) {
        return this.pathPoints.get(index).getPointType();
    }

    public void selectPoint(int index) {
        this.pathPoints.get(index).select();
    }

    public void selectAllPoints() {
        for (int i = 0; i < this.pathPoints.size(); ++i) {
            this.selectPoint(i);
        }
    }

    public int getNumPoints() {
        return this.pathPoints.size();
    }

    public Point2D.Double getPoint(int index) {
        return this.pathPoints.get(index).getPoint();
    }

    public Point2D.Double getRealPoint(int index) {
        return this.pathPoints.get(index).getRealPoint();
    }

    public ArcPathPoint getPathPoint(int index) {
        return this.pathPoints.get(index);
    }

    public Arc getArc() {
        return this.myArc;
    }

    public void showPoints() {
        if (!this.pointLock) {
            for (ArcPathPoint pathPoint : this.pathPoints) {
                pathPoint.setVisible(true);
            }
        }
    }

    public void hidePoints() {
        if (!this.pointLock) {
            for (ArcPathPoint pathPoint : this.pathPoints) {
                if (pathPoint.isSelected()) continue;
                pathPoint.setVisible(false);
            }
        }
    }

    public void setPointVisibilityLock(boolean lock) {
        this.pointLock = lock;
    }

    public double getEndAngle() {
        if (this.getEndIndex() > 0) {
            if (this.getArc().getTarget() instanceof Transition) {
                return this.pathPoints.get(this.getEndIndex()).getAngle(this.pathPoints.get(this.getEndIndex()).getControl2());
            }
            return this.pathPoints.get(this.getEndIndex()).getAngle(this.pathPoints.get(this.getEndIndex()).getControl1());
        }
        return 0.0;
    }

    public double getStartAngle() {
        if (this.getEndIndex() > 0) {
            return this.pathPoints.get(0).getAngle(this.pathPoints.get(1).getControl2());
        }
        return 0.0;
    }

    @Override
    public boolean contains(double arg0, double arg1, double arg2, double arg3) {
        return false;
    }

    @Override
    public boolean intersects(double arg0, double arg1, double arg2, double arg3) {
        return false;
    }

    @Override
    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    @Override
    public boolean contains(Point2D p) {
        return this.shape.contains(p);
    }

    public boolean proximityContains(Point2D p) {
        return this.proximityShape.contains(p);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return null;
    }

    @Override
    public boolean contains(Rectangle2D arg0) {
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.shape.intersects(r);
    }

    public boolean proximityIntersects(Rectangle2D r) {
        return this.proximityShape.intersects(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform arg0) {
        return this.path.getPathIterator(arg0);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform arg0, double arg1) {
        return this.path.getPathIterator(arg0, arg1);
    }

    private Cubic[] calcNaturalCubic(int n, int[] x) {
        int i;
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = (double)(3 * (x[1] - x[0])) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = ((double)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
        }
        delta[n] = ((double)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (int i2 = 0; i2 < n; ++i2) {
            C[i2] = new Cubic(x[i2], D[i2], (double)(3 * (x[i2 + 1] - x[i2])) - 2.0 * D[i2] - D[i2 + 1], (double)(2 * (x[i2] - x[i2 + 1])) + D[i2] + D[i2 + 1]);
        }
        return C;
    }

    public void addPointsToGui(DataLayer model) {
        if (model == null) {
            return;
        }
        this.pathPoints.get(0).setDraggable(false);
        this.pathPoints.get(this.pathPoints.size() - 1).setDraggable(false);
        for (ArcPathPoint pathPoint : this.pathPoints) {
            pathPoint.setVisible(false);
            if (model.getPNObjects().contains(pathPoint)) continue;
            model.addPetriNetObject(pathPoint);
        }
    }

    public String[][] getArcPathDetails() {
        int length = this.getEndIndex() + 1;
        String[][] details = new String[length][3];
        for (int c = 0; c < length; ++c) {
            int x = this.pathPoints.get(c).getOriginalX();
            details[c][0] = String.valueOf(x);
            int y = this.pathPoints.get(c).getOriginalY();
            details[c][1] = String.valueOf(y);
            details[c][2] = String.valueOf(this.pathPoints.get(c).getPointType());
        }
        return details;
    }

    public void purgePathPoints() {
        this.pathPoints.clear();
    }

    public void setTransitionAngle(int angle) {
        this.transitionAngle = angle;
        this.transitionAngle %= 360;
    }

    public void insertPoint(int index, ArcPathPoint newpoint) {
        this.pathPoints.add(index, newpoint);
        this.addPointsToGui(this.myArc.getGuiModel());
    }

    public Command insertPoint(Point2D.Double mouseposition, boolean flag) {
        int wantedpoint = this.findPoint(mouseposition);
        ArcPathPoint newPoint = new ArcPathPoint(mouseposition, flag, this);
        this.insertPoint(wantedpoint + 1, newPoint);
        this.createPath();
        this.myArc.updateArcPosition();
        this.showPoints();
        return new AddArcPathPointEditCommand(this.getArc(), newPoint, this.getArc().getGuiModel());
    }

    private int findPoint(Point2D.Double mouseposition) {
        double[] distances = new double[this.pathPoints.size() - 1];
        for (int index = 0; index < this.pathPoints.size() - 1; ++index) {
            ArcPathPoint first = this.pathPoints.get(index);
            ArcPathPoint second = this.pathPoints.get(index + 1);
            Point2D.Double midpoint = first.getMidPoint(second);
            distances[index] = midpoint.distance(mouseposition);
        }
        double shortest = distances[0];
        int wantedpoint = 0;
        for (int index = 0; index < this.pathPoints.size() - 1; ++index) {
            if (!(distances[index] < shortest)) continue;
            shortest = distances[index];
            wantedpoint = index;
        }
        return wantedpoint;
    }
}

