/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.graphicElements;

import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.tapn.Weight;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import net.tapaal.TAPAAL;
import pipe.gui.Constants;
import pipe.gui.canvas.Grid;
import pipe.gui.canvas.Zoomer;
import pipe.gui.petrinet.action.SplitArcAction;
import pipe.gui.petrinet.graphicElements.ArcPath;
import pipe.gui.petrinet.graphicElements.ArcPathPoint;
import pipe.gui.petrinet.graphicElements.PetriNetObjectWithLabel;
import pipe.gui.petrinet.graphicElements.PlaceTransitionObject;

public abstract class Arc
extends PetriNetObjectWithLabel {
    private Shape head = null;
    private boolean fillHead = true;
    private PlaceTransitionObject source = null;
    private PlaceTransitionObject target = null;
    protected ArcPath myPath = new ArcPath(this);
    protected boolean isPrototype = false;
    private static final boolean debugShowArcPathPoints = false;
    protected final int zoomGrow = 10;

    public boolean isPrototype() {
        return this.isPrototype;
    }

    public void sealArc() {
        this.isPrototype = false;
    }

    private Arc(String idInput) {
        super(idInput, 0, 0, 0, 0);
        this.setHead();
    }

    public Arc(PlaceTransitionObject sourceInput, PlaceTransitionObject targetInput, String idInput) {
        this(idInput);
        this.setSource(sourceInput);
        this.setTarget(targetInput);
    }

    public Arc(PlaceTransitionObject newSource) {
        this("");
        this.isPrototype = true;
        this.setSource(newSource);
    }

    protected abstract void showPropertiesEditor();

    @Override
    public JPopupMenu getPopup(MouseEvent e) {
        int popupIndex = 0;
        JPopupMenu popup = super.getPopup(e);
        JMenuItem menuItem = new JMenuItem("Properties");
        menuItem.addActionListener(e1 -> this.showPropertiesEditor());
        popup.insert(menuItem, popupIndex++);
        popup.insert(new JPopupMenu.Separator(), popupIndex);
        menuItem = new JMenuItem(new SplitArcAction(this, e.getPoint()));
        menuItem.setText("Insert Point");
        popup.insert(menuItem, popupIndex++);
        popup.insert(new JPopupMenu.Separator(), popupIndex);
        if (TAPAAL.IS_DEV) {
            JTextArea pane = new JTextArea();
            pane.setEditable(false);
            pane.setText("(Debug) \n  Source: " + this.getSource().getId() + "\n  Target: " + this.getTarget().getId());
            popup.insert(pane, 1);
        }
        return popup;
    }

    public abstract void setWeight(Weight var1);

    public abstract Weight getWeight();

    public abstract void setExpression(ArcExpression var1);

    public abstract ArcExpression getExpression();

    public void setSource(PlaceTransitionObject sourceInput) {
        this.source = sourceInput;
    }

    public void setTarget(PlaceTransitionObject targetInput) {
        this.target = targetInput;
    }

    protected void setLabelPosition() {
        this.getNameLabel().setPosition(Grid.align((int)this.myPath.midPoint.x + Zoomer.getZoomedValue(this.getNameOffsetX(), this.getZoom()), this.getZoom()), Grid.align((int)this.myPath.midPoint.y + Zoomer.getZoomedValue(this.getNameOffsetY(), this.getZoom()), this.getZoom()));
    }

    @Override
    public void updateLabelLocation(boolean alignToGrid) {
        this.setLabelPosition();
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.source != null && this.target != null) {
            return this.source.getId() + " to " + this.target.getId();
        }
        return "";
    }

    @Override
    public String getName() {
        return this.getId();
    }

    public PlaceTransitionObject getSource() {
        return this.source;
    }

    public PlaceTransitionObject getTarget() {
        return this.target;
    }

    public void updateArcPosition() {
        if (this.target != null) {
            this.target.updateEndPoint(this);
        }
        if (this.source != null) {
            this.source.updateEndPoint(this);
        }
        if (this.target != null) {
            this.target.updateEndPoint(this);
        }
        if (this.source != null) {
            this.source.updateEndPoint(this);
        }
        this.myPath.createPath();
    }

    public void setEndPoint(double x, double y, boolean type) {
        this.myPath.setPointLocation(this.myPath.getEndIndex(), x, y);
        this.myPath.setPointType(this.myPath.getEndIndex(), type);
        this.updateArcPosition();
    }

    public void setTargetLocation(double x, double y) {
        this.myPath.setPointLocation(this.myPath.getEndIndex(), x, y);
        this.myPath.createPath();
        this.updateBounds();
        this.repaint();
    }

    public void setSourceLocation(double x, double y) {
        this.myPath.setPointLocation(0, x, y);
        this.myPath.createPath();
        this.updateBounds();
        this.repaint();
    }

    public void updateLabel(boolean displayConstantNames) {
    }

    public void updateBounds() {
        Rectangle bounds = this.myPath.getBounds();
        bounds.grow(15, 15);
        this.setBounds(bounds);
    }

    public ArcPath getArcPath() {
        return this.myPath;
    }

    public void setArcPath(ArcPath newPath) {
        this.myPath = newPath;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(15.0 - this.myPath.getBounds().getX(), 15.0 - this.myPath.getBounds().getY());
        AffineTransform reset = g2.getTransform();
        if (this.selected) {
            g2.setPaint(Constants.SELECTION_LINE_COLOUR);
        } else {
            g2.setPaint(Constants.ELEMENT_LINE_COLOUR);
        }
        g2.setStroke(new BasicStroke(0.01f * (float)this.getZoom()));
        g2.draw(this.myPath);
        g2.translate(this.myPath.getPoint(this.myPath.getEndIndex()).getX(), this.myPath.getPoint(this.myPath.getEndIndex()).getY());
        g2.rotate(-this.myPath.getEndAngle() - 1.5707963267948966);
        g2.setColor(Color.WHITE);
        g2.transform(Zoomer.getTransform(this.getZoom()));
        g2.setPaint(Constants.ELEMENT_LINE_COLOUR);
        if (this.selected) {
            g2.setPaint(Constants.SELECTION_LINE_COLOUR);
        } else {
            g2.setPaint(Constants.ELEMENT_LINE_COLOUR);
        }
        g2.setStroke(new BasicStroke(0.8f));
        if (this.fillHead) {
            g2.fill(this.head);
        } else {
            Paint p = g2.getPaint();
            g2.setColor(Color.WHITE);
            g2.fill(this.head);
            g2.setPaint(p);
            g2.draw(this.head);
        }
        g2.transform(reset);
    }

    private void drawCenteredCircle(Graphics2D g, double x, double y, Color c) {
        int r = 10;
        g.setColor(c);
        g.fillOval((int)(x -= (double)(r / 2)), (int)(y -= (double)(r / 2)), r, r);
    }

    @Override
    public boolean contains(int x, int y) {
        Point2D.Double point = new Point2D.Double((double)x + this.myPath.getBounds().getX() - 5.0 - 10.0, (double)y + this.myPath.getBounds().getY() - 5.0 - 10.0);
        return this.myPath.contains(point);
    }

    @Override
    public void addedToGui() {
        this.setDeleted(false);
        this.myPath.addPointsToGui(this.getGuiModel());
        this.updateArcPosition();
        this.updateLabel(true);
        super.addedToGui();
    }

    @Override
    public void removedFromGui() {
        super.removedFromGui();
        for (ArcPathPoint p : this.myPath.getArcPathPoints()) {
            this.getGuiModel().removePetriNetObject(p);
        }
    }

    public void setPathToTransitionAngle(int angle) {
        this.myPath.setTransitionAngle(angle);
    }

    private void selectPath() {
        if (this.selectable) {
            this.myPath.selectAllPoints();
        }
    }

    @Override
    public void select() {
        super.select();
        this.selectPath();
    }

    @Override
    public int getLayerOffset() {
        return 20;
    }

    @Override
    public void translate(int x, int y) {
    }

    @Override
    public void zoomUpdate(int percent) {
        super.zoomUpdate(percent);
        this.updateArcPosition();
    }

    public void enableDrawingKeyBindings(final Runnable action) {
        InputMap iMap = this.getInputMap(2);
        ActionMap aMap = this.getActionMap();
        iMap.put(KeyStroke.getKeyStroke("ESCAPE"), "deleteArc");
        iMap.put(KeyStroke.getKeyStroke("DELETE"), "deleteArc");
        iMap.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "deleteArc");
        iMap.put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "deleteArc");
        aMap.put("deleteArc", new AbstractAction(this){
            final /* synthetic */ Arc this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
    }

    public void disableDrawingKeyBindings() {
        this.getInputMap().clear();
        this.getActionMap().clear();
    }

    protected final void setHead(Shape head, Boolean fillHead) {
        this.head = head;
        this.fillHead = fillHead;
    }

    protected void setHead() {
        this.setHead(new Polygon(new int[]{0, 5, 0, -5}, new int[]{0, -10, -7, -10}, 4), true);
    }

    @Override
    public void select(boolean shouldRepaint) {
        super.select(shouldRepaint);
        this.myPath.showPoints();
    }

    @Override
    public void deselect() {
        super.deselect();
        this.myPath.hidePoints();
    }
}

