/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.editor;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.util.RequireException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.Template;
import net.tapaal.gui.petrinet.editor.ColorComboBoxRenderer;
import net.tapaal.gui.petrinet.editor.ColorComboboxPanel;
import net.tapaal.gui.petrinet.editor.ColoredTimeInvariantDialogPanel;
import net.tapaal.gui.petrinet.undo.ChangeAllNamesVisibilityCommand;
import net.tapaal.gui.petrinet.undo.ChangedInvariantCommand;
import net.tapaal.gui.petrinet.undo.Colored.ColoredPlaceMarkingEditCommand;
import net.tapaal.gui.petrinet.undo.Colored.SetArcExpressionCommand;
import net.tapaal.gui.petrinet.undo.Colored.SetColoredArcIntervalsCommand;
import net.tapaal.gui.petrinet.undo.Colored.SetTransportArcExpressionsCommand;
import net.tapaal.gui.petrinet.undo.MakePlaceNewSharedCommand;
import net.tapaal.gui.petrinet.undo.MakePlaceNewSharedMultiCommand;
import net.tapaal.gui.petrinet.undo.MakePlaceSharedCommand;
import net.tapaal.gui.petrinet.undo.RenameTimedPlaceCommand;
import net.tapaal.gui.petrinet.undo.TimedPlaceMarkingEditCommand;
import net.tapaal.gui.petrinet.undo.UnsharePlaceCommand;
import net.tapaal.swinghelpers.CustomJSpinner;
import net.tapaal.swinghelpers.GridBagHelper;
import net.tapaal.swinghelpers.SwingHelper;
import net.tapaal.swinghelpers.WidthAdjustingComboBox;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;
import pipe.gui.swingcomponents.EscapableDialog;

public class PlaceEditorPanel
extends JPanel {
    private final JRootPane rootPane;
    private JCheckBox sharedCheckBox;
    private WidthAdjustingComboBox sharedPlacesComboBox;
    private final TimedPlaceComponent place;
    private final Context context;
    private boolean makeNewShared = false;
    private boolean doNewEdit = true;
    private boolean doOKChecked = false;
    private boolean editSharedPlace = false;
    private final PetriNetTab currentTab;
    private final EscapableDialog parent;
    private final JPanel mainPanel;
    private Vector<TimedPlace> sharedPlaces;
    private final int maxNumberOfPlacesToShowAtOnce = 20;
    protected final ArcExpression originalExpression;
    private JCheckBox attributesCheckBox;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel markingLabel;
    private JSpinner markingSpinner;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton okButton;
    private JButton makeSharedButton;
    private JPanel basicPropertiesPanel;
    private JPanel timeInvariantPanel;
    private JPanel invariantGroup;
    private JComboBox<String> invRelationNormal;
    private JComboBox<String> invRelationConstant;
    private JSpinner invariantSpinner;
    private JCheckBox invariantInf;
    private JComboBox<String> invConstantsComboBox;
    private JRadioButton normalInvRadioButton;
    private JRadioButton constantInvRadioButton;
    private JPanel tokenPanel;
    private DefaultListModel<NumberOfExpression> coloredTokenListModel;
    private JList tokenList;
    private JPanel tokenButtonPanel;
    private JButton addColoredTokenButton;
    private JButton removeColoredTokenButton;
    private ColorComboboxPanel tokenColorComboboxPanel;
    private ColorType colorType;
    JPanel timeInvariantColorPanel;
    DefaultListModel<ColoredTimeInvariant> timeConstraintListModel;
    JList<ColoredTimeInvariant> timeConstraintList;
    JComboBox<ColorType> colorTypeComboBox;
    JPanel colorTypePanel;
    JSpinner addTokenSpinner;
    ColoredTimeInvariantDialogPanel invariantEditorPanel;
    JButton addTimeConstraintButton;
    JButton removeTimeConstraintButton;
    ColorComboboxPanel colorInvariantComboboxPanel;

    public PlaceEditorPanel(EscapableDialog parent, JRootPane rootPane, TimedPlaceComponent placeComponent, Context context) {
        this.rootPane = rootPane;
        this.currentTab = context.tabContent();
        this.place = placeComponent;
        this.context = context;
        this.parent = parent;
        this.colorType = this.place.underlyingPlace().getColorType();
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.initComponents();
        this.originalExpression = this.place.underlyingPlace().getTokensAsExpression() != null ? this.place.underlyingPlace().getTokensAsExpression().deepCopy() : null;
        this.hideIrrelevantInformation();
        scrollPane.setViewportView(this.mainPanel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    private void hideIrrelevantInformation() {
        if (!this.place.isTimed()) {
            this.timeInvariantPanel.setVisible(false);
            this.timeInvariantColorPanel.setVisible(false);
        }
        if (!this.place.isColored()) {
            this.timeInvariantColorPanel.setVisible(false);
            this.tokenPanel.setVisible(false);
            this.colorTypePanel.setVisible(false);
        }
        if (this.place.isColored()) {
            this.markingLabel.setVisible(false);
            this.markingSpinner.setVisible(false);
            if (this.place.isTimed()) {
                this.timeInvariantPanel.setBorder(BorderFactory.createTitledBorder("Default Age Invariant"));
            }
        }
    }

    private void initComponents() {
        this.initBasicPropertiesPanel();
        GridBagConstraints gridBagConstraints = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST, GridBagHelper.Fill.HORIZONTAL, new Insets(5, 8, 0, 8));
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.basicPropertiesPanel, gridBagConstraints);
        this.initTimeInvariantPanel();
        gridBagConstraints = GridBagHelper.as(0, 2, GridBagHelper.Anchor.WEST, GridBagHelper.Fill.HORIZONTAL, new Insets(0, 8, 0, 8));
        this.mainPanel.add((Component)this.timeInvariantPanel, gridBagConstraints);
        this.initColorTypePanel();
        this.initColorInvariantPanel();
        this.initTokensPanel();
        this.setInitialComboBoxValue();
        this.writeTokensToList(this.place.underlyingPlace());
        this.setColoredTimeInvariants(this.place.underlyingPlace());
        this.initButtonPanel();
        gridBagConstraints = GridBagHelper.as(0, 5, new Insets(0, 8, 5, 8));
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void initButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.addActionListener(evt -> {
            if (this.doOK()) {
                this.exit();
            }
        });
        this.rootPane.setDefaultButton(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton.addActionListener(evt -> {
            this.place.underlyingPlace().setTokenExpression(this.originalExpression);
            if (this.doOKChecked) {
                this.context.undoManager().undo();
            }
            this.exit();
        });
        GridBagConstraints gridBagConstraints = GridBagHelper.as(0, 0, GridBagHelper.Anchor.EAST, new Insets(5, 5, 5, 5));
        gridBagConstraints.gridwidth = -1;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = GridBagHelper.as(1, 0, GridBagHelper.Anchor.WEST, new Insets(5, 5, 5, 5));
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        this.setupInitialState();
        if (this.place.underlyingPlace().isShared()) {
            this.switchToNameDropDown();
        } else {
            this.switchToNameTextField();
        }
    }

    private void setupInitialState() {
        this.sharedPlaces = new Vector<SharedPlace>(this.context.network().sharedPlaces());
        List<TimedPlace> usedPlaces = this.context.activeModel().places();
        this.sharedPlaces.removeAll(usedPlaces);
        if (this.place.underlyingPlace().isShared()) {
            this.sharedPlaces.add(this.place.underlyingPlace());
        }
        this.sharedPlaces.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        this.sharedPlacesComboBox.setModel(new DefaultComboBoxModel<TimedPlace>(this.sharedPlaces));
        if (this.place.underlyingPlace().isShared()) {
            this.sharedPlacesComboBox.setSelectedItem(this.place.underlyingPlace());
        }
        this.sharedCheckBox.setEnabled(this.sharedPlaces.size() > 0 && !this.hasArcsToSharedTransitions(this.place.underlyingPlace()));
        this.sharedCheckBox.setSelected(this.place.underlyingPlace().isShared());
        this.makeSharedButton.setEnabled(!this.sharedCheckBox.isSelected() && !this.hasArcsToSharedTransitions(this.place.underlyingPlace()));
        this.nameTextField.setText(this.place.underlyingPlace().name());
        this.nameTextField.selectAll();
        this.attributesCheckBox.setSelected(this.place.getAttributesVisible());
        this.setMarking(this.place.underlyingPlace().numberOfTokens());
        this.setInvariantControlsBasedOn(this.place.underlyingPlace().invariant());
    }

    private boolean hasArcsToSharedTransitions(TimedPlace underlyingPlace) {
        for (TimedInputArc timedInputArc : this.context.activeModel().inputArcs()) {
            if (!timedInputArc.source().equals(underlyingPlace) || !timedInputArc.destination().isShared()) continue;
            return true;
        }
        for (TimedOutputArc timedOutputArc : this.context.activeModel().outputArcs()) {
            if (!timedOutputArc.destination().equals(underlyingPlace) || !timedOutputArc.source().isShared()) continue;
            return true;
        }
        for (TransportArc transportArc : this.context.activeModel().transportArcs()) {
            if (transportArc.source().equals(underlyingPlace) && transportArc.transition().isShared()) {
                return true;
            }
            if (!transportArc.destination().equals(underlyingPlace) || !transportArc.transition().isShared()) continue;
            return true;
        }
        for (TimedInhibitorArc timedInhibitorArc : this.context.activeModel().inhibitorArcs()) {
            if (!timedInhibitorArc.source().equals(underlyingPlace) || !timedInhibitorArc.destination().isShared()) continue;
            return true;
        }
        return false;
    }

    private void initBasicPropertiesPanel() {
        this.basicPropertiesPanel = new JPanel();
        this.basicPropertiesPanel.setLayout(new GridBagLayout());
        this.basicPropertiesPanel.setBorder(BorderFactory.createTitledBorder("Place"));
        this.sharedCheckBox = new JCheckBox("Shared");
        this.sharedCheckBox.addActionListener(arg0 -> {
            JCheckBox box = (JCheckBox)arg0.getSource();
            if (box.isSelected()) {
                this.switchToNameDropDown();
                this.makeSharedButton.setEnabled(false);
            } else {
                this.switchToNameTextField();
                this.nameTextField.setText(this.place.underlyingPlace().isShared() ? this.context.nameGenerator().getNewPlaceName(this.context.activeModel()) : this.place.getName());
                this.makeSharedButton.setEnabled(true);
            }
        });
        GridBagConstraints gridBagConstraints = GridBagHelper.as(2, 1, GridBagHelper.Anchor.WEST, new Insets(0, 3, 3, 3));
        this.basicPropertiesPanel.add((Component)this.sharedCheckBox, gridBagConstraints);
        this.makeSharedButton = new JButton();
        this.makeSharedButton.setText("Make shared");
        this.makeSharedButton.setMaximumSize(new Dimension(110, 25));
        this.makeSharedButton.setMinimumSize(new Dimension(110, 25));
        this.makeSharedButton.setPreferredSize(new Dimension(110, 25));
        this.makeSharedButton.addActionListener(evt -> {
            this.makeNewShared = true;
            this.makeSharedButton.setEnabled(false);
            if (this.doOK()) {
                this.setupInitialState();
                this.sharedCheckBox.setEnabled(true);
                this.sharedCheckBox.setSelected(true);
                this.switchToNameDropDown();
                this.sharedPlacesComboBox.setSelectedItem(this.place.underlyingPlace());
            } else {
                this.makeSharedButton.setEnabled(true);
                this.doOKChecked = false;
            }
        });
        gridBagConstraints = GridBagHelper.as(3, 1, GridBagHelper.Anchor.WEST, new Insets(5, 5, 5, 5));
        this.basicPropertiesPanel.add((Component)this.makeSharedButton, gridBagConstraints);
        this.nameLabel = new JLabel("Name:");
        this.nameLabel = new JLabel("Name:");
        gridBagConstraints = GridBagHelper.as(0, 1, GridBagHelper.Anchor.EAST, new Insets(3, 3, 3, 3));
        this.basicPropertiesPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField = new JTextField();
        SwingHelper.setPreferredWidth(this.nameTextField, 290);
        this.sharedPlacesComboBox = new WidthAdjustingComboBox(20);
        SwingHelper.setPreferredWidth(this.sharedPlacesComboBox, 290);
        this.sharedPlacesComboBox.addItemListener(e -> {
            this.editSharedPlace = true;
            SharedPlace place = (SharedPlace)e.getItem();
            if (place.getComponentsUsingThisPlace().size() > 0) {
                if (this.currentTab.lens.isColored()) {
                    this.colorTypeComboBox.setSelectedItem(place.getColorType());
                    this.coloredTokenListModel.clear();
                    ArcExpression expr = place.getTokensAsExpression();
                    if (expr != null) {
                        for (ExprStringPosition child : expr.getChildren()) {
                            if (!(child.getObject() instanceof NumberOfExpression)) continue;
                            this.coloredTokenListModel.addElement((NumberOfExpression)child.getObject());
                        }
                    }
                }
                this.setMarking(place.numberOfTokens());
            }
            this.setInvariantControlsBasedOn(place);
            this.editSharedPlace = false;
        });
        this.markingLabel = new JLabel("Marking:");
        gridBagConstraints = GridBagHelper.as(0, 2, GridBagHelper.Anchor.EAST, new Insets(3, 3, 3, 3));
        this.basicPropertiesPanel.add((Component)this.markingLabel, gridBagConstraints);
        this.markingSpinner = new CustomJSpinner(0, this.okButton);
        gridBagConstraints = GridBagHelper.as(1, 2, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        this.basicPropertiesPanel.add((Component)this.markingSpinner, gridBagConstraints);
        this.attributesCheckBox = new JCheckBox("Show place name");
        this.attributesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.attributesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = GridBagHelper.as(1, 3, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        this.basicPropertiesPanel.add((Component)this.attributesCheckBox, gridBagConstraints);
    }

    private boolean isUrgencyOK() {
        for (TransportArc arc : this.context.activeModel().transportArcs()) {
            if (!arc.destination().equals(this.place.underlyingPlace()) || !arc.transition().isUrgent()) continue;
            JOptionPane.showMessageDialog(this.rootPane, "Transport arcs going through urgent transitions cannot have an invariant at the destination.", "Error", 0);
            return false;
        }
        if (this.place.underlyingPlace().isShared()) {
            for (Template t : this.context.tabContent().allTemplates()) {
                for (TransportArc arc : t.model().transportArcs()) {
                    if (!arc.destination().equals(this.place.underlyingPlace()) || !arc.transition().isUrgent()) continue;
                    JOptionPane.showMessageDialog(this.rootPane, "Transport arcs going through urgent transitions cannot have an invariant at the destination.", "Error", 0);
                    return false;
                }
            }
        }
        return true;
    }

    private void initTimeInvariantPanel() {
        this.timeInvariantPanel = new JPanel();
        this.timeInvariantPanel.setLayout(new GridBagLayout());
        this.timeInvariantPanel.setBorder(BorderFactory.createTitledBorder("Age Invariant"));
        this.invariantGroup = new JPanel(new GridBagLayout());
        this.invRelationNormal = new JComboBox<String>(new String[]{"<=", "<"});
        this.invRelationConstant = new JComboBox<String>(new String[]{"<=", "<"});
        this.invariantSpinner = new CustomJSpinner(0, this.okButton);
        this.invariantSpinner.addChangeListener(e -> {
            if (!this.invariantInf.isSelected()) {
                if ((Integer)this.invariantSpinner.getValue() < 1) {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<="}));
                    this.invRelationNormal.setSelectedItem("<=");
                } else if (this.invRelationNormal.getModel().getSize() == 1) {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<=", "<"}));
                }
            }
        });
        GridBagConstraints gbc = GridBagHelper.as(1, 0, GridBagHelper.Fill.HORIZONTAL, new Insets(3, 3, 3, 3));
        this.invariantGroup.add(this.invRelationNormal, gbc);
        gbc = GridBagHelper.as(1, 1, GridBagHelper.Fill.HORIZONTAL, new Insets(3, 3, 3, 3));
        this.invariantGroup.add(this.invRelationConstant, gbc);
        gbc = GridBagHelper.as(2, 0, new Insets(3, 3, 3, 3));
        this.invariantGroup.add((Component)this.invariantSpinner, gbc);
        this.invariantInf = new JCheckBox(Character.toString('\u221e'));
        this.invariantInf.addActionListener(arg0 -> {
            if (!this.isUrgencyOK()) {
                this.invariantInf.setSelected(true);
                return;
            }
            if (!this.invariantInf.isSelected()) {
                this.invRelationNormal.setEnabled(true);
                this.invariantSpinner.setEnabled(true);
                this.invRelationNormal.setSelectedItem("<=");
                if ((Integer)this.invariantSpinner.getValue() < 1) {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<="}));
                } else {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<=", "<"}));
                }
            } else {
                this.invRelationNormal.setEnabled(false);
                this.invariantSpinner.setEnabled(false);
                this.invRelationNormal.setSelectedItem("<");
                this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<"}));
            }
        });
        gbc = GridBagHelper.as(3, 0);
        this.invariantGroup.add((Component)this.invariantInf, gbc);
        Set<String> constants = this.context.network().getConstantNames();
        String[] constantArray = constants.toArray(new String[0]);
        Arrays.sort(constantArray, String.CASE_INSENSITIVE_ORDER);
        this.invConstantsComboBox = new WidthAdjustingComboBox<String>(20);
        this.invConstantsComboBox.setModel(new DefaultComboBoxModel<String>(constantArray));
        this.invConstantsComboBox.setMaximumRowCount(20);
        this.invConstantsComboBox.setPreferredSize(new Dimension(230, 30));
        this.invConstantsComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setRelationModelForConstants();
            }
        });
        gbc = GridBagHelper.as(2, 1, GridBagHelper.Anchor.WEST);
        this.invariantGroup.add(this.invConstantsComboBox, gbc);
        this.normalInvRadioButton = new JRadioButton("Normal");
        this.normalInvRadioButton.addActionListener(e -> {
            this.disableInvariantComponents();
            this.enableNormalInvariantComponents();
        });
        this.constantInvRadioButton = new JRadioButton("Constant");
        this.constantInvRadioButton.addActionListener(e -> {
            this.disableInvariantComponents();
            this.enableConstantInvariantComponents();
        });
        if (constants.isEmpty()) {
            this.constantInvRadioButton.setEnabled(false);
        }
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.normalInvRadioButton);
        btnGroup.add(this.constantInvRadioButton);
        gbc = GridBagHelper.as(0, 0, GridBagHelper.Anchor.WEST);
        this.invariantGroup.add((Component)this.normalInvRadioButton, gbc);
        gbc = GridBagHelper.as(0, 1, GridBagHelper.Anchor.WEST);
        this.invariantGroup.add((Component)this.constantInvRadioButton, gbc);
        TimeInvariant invariantToSet = this.place.getInvariant();
        if (invariantToSet.isUpperNonstrict()) {
            this.invRelationNormal.setSelectedItem("<=");
        } else {
            this.invRelationNormal.setSelectedItem("<");
        }
        if (invariantToSet.upperBound() instanceof Bound.InfBound) {
            this.invariantSpinner.setEnabled(false);
            this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<"}));
            this.invariantInf.setSelected(true);
            this.invRelationNormal.setSelectedItem("<");
        }
        this.disableInvariantComponents();
        if (invariantToSet.upperBound() instanceof ConstantBound) {
            this.enableConstantInvariantComponents();
            this.constantInvRadioButton.setSelected(true);
            this.invConstantsComboBox.setSelectedItem(((ConstantBound)invariantToSet.upperBound()).name());
            this.invRelationConstant.setSelectedItem(invariantToSet.isUpperNonstrict() ? "<=" : "<");
        } else {
            this.enableNormalInvariantComponents();
            this.normalInvRadioButton.setSelected(true);
            if (invariantToSet.upperBound() instanceof IntBound) {
                if ((Integer)this.invariantSpinner.getValue() < 1) {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<="}));
                } else {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<=", "<"}));
                }
                this.invariantSpinner.setValue(invariantToSet.upperBound().value());
                this.invariantSpinner.setEnabled(true);
                this.invRelationNormal.setSelectedItem(invariantToSet.isUpperNonstrict() ? "<=" : "<");
                this.invariantInf.setSelected(false);
            }
        }
        GridBagConstraints gridBagConstraints = GridBagHelper.as(1, 4, 2, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        this.timeInvariantPanel.add((Component)this.invariantGroup, gridBagConstraints);
    }

    private void setRelationModelForConstants() {
        int value = this.context.network().getConstantValue(Objects.requireNonNull(this.invConstantsComboBox.getSelectedItem()).toString());
        String selected = Objects.requireNonNull(this.invRelationConstant.getSelectedItem()).toString();
        if (value == 0) {
            this.invRelationConstant.setModel(new DefaultComboBoxModel<String>(new String[]{"<="}));
        } else {
            this.invRelationConstant.setModel(new DefaultComboBoxModel<String>(new String[]{"<=", "<"}));
        }
        this.invRelationConstant.setSelectedItem(selected);
    }

    protected void enableConstantInvariantComponents() {
        this.invRelationConstant.setEnabled(true);
        this.invConstantsComboBox.setEnabled(true);
        this.setRelationModelForConstants();
    }

    protected void enableNormalInvariantComponents() {
        this.invRelationNormal.setEnabled(true);
        this.invariantInf.setEnabled(true);
        this.invariantSpinner.setValue(0);
        this.invariantInf.setSelected(true);
        this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<"}));
    }

    protected void disableInvariantComponents() {
        this.invRelationNormal.setEnabled(false);
        this.invRelationConstant.setEnabled(false);
        this.invariantSpinner.setEnabled(false);
        this.invConstantsComboBox.setEnabled(false);
        this.invariantInf.setEnabled(false);
    }

    private void switchToNameTextField() {
        this.basicPropertiesPanel.remove(this.sharedPlacesComboBox);
        GridBagConstraints gbc = GridBagHelper.as(1, 1, GridBagHelper.Fill.HORIZONTAL, new Insets(3, 3, 3, 3));
        this.basicPropertiesPanel.add((Component)this.nameTextField, gbc);
        this.basicPropertiesPanel.validate();
        this.basicPropertiesPanel.repaint();
    }

    private void switchToNameDropDown() {
        this.basicPropertiesPanel.remove(this.nameTextField);
        GridBagConstraints gbc = GridBagHelper.as(1, 1, GridBagHelper.Fill.HORIZONTAL, new Insets(3, 3, 3, 3));
        this.basicPropertiesPanel.add((Component)this.sharedPlacesComboBox, gbc);
        this.basicPropertiesPanel.validate();
        this.basicPropertiesPanel.repaint();
        SharedPlace selected = (SharedPlace)this.sharedPlacesComboBox.getSelectedItem();
        this.setInvariantControlsBasedOn(selected);
        this.setColorControlsBasedOn(selected);
        if (selected.getComponentsUsingThisPlace().size() > 0) {
            this.setMarking(selected.numberOfTokens());
        }
    }

    private void setMarking(int numberOfTokens) {
        this.markingSpinner.setValue(numberOfTokens);
    }

    private void setInvariantControlsBasedOn(TimedPlace place) {
        if (place instanceof SharedPlace && ((SharedPlace)place).getComponentsUsingThisPlace().size() > 0) {
            this.setInvariantControlsBasedOn(place.invariant());
        }
    }

    private void setColorControlsBasedOn(TimedPlace place) {
        if (place instanceof SharedPlace && ((SharedPlace)place).getComponentsUsingThisPlace().size() > 0) {
            this.colorTypeComboBox.setSelectedItem(place.getColorType());
            this.writeTokensToList(place);
            this.setColoredTimeInvariants(place);
        }
    }

    private void setInvariantControlsBasedOn(TimeInvariant invariant) {
        if (invariant.upperBound() instanceof ConstantBound) {
            String[] stringArray;
            this.constantInvRadioButton.setSelected(true);
            if (invariant.upperBound().value() == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "<=";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "<";
                stringArray = stringArray3;
                stringArray3[1] = "<=";
            }
            this.invRelationConstant.setModel(new DefaultComboBoxModel<String>(stringArray));
            this.invRelationConstant.setSelectedItem(invariant.isUpperNonstrict() ? "<=" : "<");
            this.invRelationConstant.setEnabled(true);
            this.invConstantsComboBox.setEnabled(true);
            this.invConstantsComboBox.setSelectedItem(((ConstantBound)invariant.upperBound()).constant());
        } else {
            this.normalInvRadioButton.setSelected(true);
            if (invariant.upperBound() instanceof Bound.InfBound) {
                this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<"}));
                this.invariantSpinner.setValue(0);
                this.invRelationNormal.setEnabled(false);
                this.invariantSpinner.setEnabled(false);
                this.invariantInf.setSelected(true);
            } else {
                if (invariant.upperBound().value() == 0 && !this.invariantInf.isSelected()) {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<="}));
                } else {
                    this.invRelationNormal.setModel(new DefaultComboBoxModel<String>(new String[]{"<", "<="}));
                }
                this.invRelationNormal.setSelectedItem(invariant.isUpperNonstrict() ? "<=" : "<");
                this.invariantSpinner.setValue(invariant.upperBound().value());
                this.invRelationNormal.setEnabled(true);
                this.invariantSpinner.setEnabled(true);
                this.invariantInf.setSelected(false);
            }
        }
    }

    private boolean doOK() {
        if (!this.invariantInf.isSelected() && !this.isUrgencyOK()) {
            return false;
        }
        int newMarking = (Integer)this.markingSpinner.getValue();
        if (this.place.isColored()) {
            newMarking = (Integer)this.addTokenSpinner.getValue();
        }
        if (newMarking > 9999999) {
            JOptionPane.showMessageDialog(this, "It is allowed to have at most 9999999 tokens in a place.", "Error", 0);
            return false;
        }
        if (this.doNewEdit) {
            this.context.undoManager().newEdit();
            this.doNewEdit = false;
        }
        TimedPlace underlyingPlace = this.place.underlyingPlace();
        SharedPlace selectedPlace = (SharedPlace)this.sharedPlacesComboBox.getSelectedItem();
        if (this.sharedCheckBox.isSelected() && !Objects.equals(selectedPlace, underlyingPlace)) {
            MakePlaceSharedCommand command = new MakePlaceSharedCommand(this.context.activeModel(), selectedPlace, this.place.underlyingPlace(), this.place, this.context.tabContent());
            this.context.undoManager().addEdit(command);
            try {
                command.redo();
            }
            catch (RequireException e) {
                this.context.undoManager().undo();
                this.doNewEdit = true;
                JOptionPane.showMessageDialog(this, "Another place in the same component is already shared under that name", "Error", 0);
                return false;
            }
        }
        if (!this.sharedCheckBox.isSelected()) {
            if (underlyingPlace.isShared()) {
                String uniqueName = this.context.nameGenerator().getNewPlaceName(this.context.activeModel());
                UnsharePlaceCommand unshareCmd = new UnsharePlaceCommand(this.context.activeModel(), (SharedPlace)underlyingPlace, new LocalTimedPlace(uniqueName), this.place);
                unshareCmd.redo();
                this.context.undoManager().addEdit(unshareCmd);
            }
            String newName = this.nameTextField.getText();
            String oldName = this.place.underlyingPlace().name();
            if (this.context.activeModel().isNameUsed(newName) && !oldName.equals(newName)) {
                this.context.undoManager().undo();
                this.doNewEdit = true;
                JOptionPane.showMessageDialog(this, "The specified name is already used by another place or transition.", "Error", 0);
                return false;
            }
            if (!oldName.equals(newName)) {
                RenameTimedPlaceCommand renameCommand = new RenameTimedPlaceCommand(this.context.tabContent(), (LocalTimedPlace)this.place.underlyingPlace(), oldName, newName);
                this.context.undoManager().addEdit(renameCommand);
                try {
                    renameCommand.redo();
                }
                catch (RequireException e) {
                    this.context.undoManager().undo();
                    this.doNewEdit = true;
                    JOptionPane.showMessageDialog(this, "Acceptable names for places are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*\n\nNote that \"true\" and \"false\" are reserved keywords.", "Error", 0);
                    return false;
                }
                this.context.nameGenerator().updateIndices(this.context.activeModel(), newName);
            }
            if (this.makeNewShared) {
                MakePlaceNewSharedCommand command = new MakePlaceNewSharedCommand(this.context.activeModel(), newName, this.place.underlyingPlace(), this.place, this.context.tabContent(), false);
                this.context.undoManager().addEdit(command);
                try {
                    command.redo();
                }
                catch (RequireException e) {
                    this.context.undoManager().undo();
                    this.doNewEdit = true;
                    if (this.context.activeModel().parentNetwork().isNameUsedForPlacesOnly(newName)) {
                        int dialogResult = JOptionPane.showConfirmDialog(this, "A place with the specified name already exists in one or more components, or the specified name is invalid.\n\nAcceptable names for places are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*\n\nNote that \"true\" and \"false\" are reserved keywords. \n\nThis place name will be changed into shared one also in all other components.", "Warning", 2);
                        if (dialogResult == 0) {
                            MakePlaceNewSharedMultiCommand cmd = new MakePlaceNewSharedMultiCommand(this.context, newName, this.place);
                            cmd.redo();
                            this.context.undoManager().addNewEdit(cmd);
                        }
                        return false;
                    }
                    JOptionPane.showMessageDialog(this, "A transition with the specified name already exists in one or more components, or the specified name is invalid.\n\nAcceptable names for places are defined by the regular expression:\n[a-zA-Z][_a-zA-Z0-9]*\n\nNote that \"true\" and \"false\" are reserved keywords.", "Warning", 0);
                    return false;
                }
            }
        }
        this.doOkColors(newMarking);
        TimeInvariant newInvariant = this.constructInvariant();
        TimeInvariant oldInvariant = this.place.underlyingPlace().invariant();
        if (!newInvariant.equals(oldInvariant)) {
            this.context.undoManager().addEdit(new ChangedInvariantCommand(this.place.underlyingPlace(), oldInvariant, newInvariant));
            this.place.underlyingPlace().setInvariant(newInvariant);
        }
        if (this.place.getAttributesVisible() && !this.attributesCheckBox.isSelected() || !this.place.getAttributesVisible() && this.attributesCheckBox.isSelected()) {
            this.place.toggleAttributesVisible();
            HashMap<PetriNetObject, Boolean> map = new HashMap<PetriNetObject, Boolean>();
            map.put(this.place, !this.place.getAttributesVisible());
            ChangeAllNamesVisibilityCommand changeVisibility = new ChangeAllNamesVisibilityCommand(this.currentTab, map, null, this.place.getAttributesVisible());
            this.context.undoManager().addEdit(changeVisibility);
        }
        this.place.update(true);
        this.place.repaint();
        this.context.network().buildConstraints();
        this.doOKChecked = true;
        if (this.context.undoManager().currentEditIsEmpty()) {
            this.context.undoManager().removeCurrentEdit();
        }
        return true;
    }

    private void doOkColors(int newMarking) {
        if (!this.place.isColored()) {
            if (newMarking != this.place.underlyingPlace().numberOfTokens()) {
                TimedPlaceMarkingEditCommand command = new TimedPlaceMarkingEditCommand(this.place, newMarking - this.place.underlyingPlace().numberOfTokens());
                command.redo();
                this.context.undoManager().addEdit(command);
                return;
            }
        } else {
            TimedPlace underlyingPlace;
            boolean anyChanges;
            int oldTokenCount = this.place.underlyingPlace().numberOfTokens();
            ArrayList<TimedToken> tokensToAdd = new ArrayList<TimedToken>();
            ArrayList<TimedToken> oldTokenList = new ArrayList<TimedToken>(this.context.activeModel().marking().getTokensFor(this.place.underlyingPlace()));
            ArrayList<ColoredTimeInvariant> ctiList = new ArrayList<ColoredTimeInvariant>();
            Vector<ArcExpression> v = new Vector<ArcExpression>();
            for (int i = 0; i < this.coloredTokenListModel.getSize(); ++i) {
                v.add(this.coloredTokenListModel.getElementAt(i));
            }
            AddExpression newExpression = null;
            if (!v.isEmpty()) {
                newExpression = new AddExpression(v);
                ColorMultiset cm = newExpression.eval(this.context.network().getContext());
                if (cm != null) {
                    tokensToAdd.addAll(cm.getTokens(this.place.underlyingPlace()));
                }
            } else {
                this.place.underlyingPlace().resetNumberOfTokensColor();
            }
            for (int i = 0; i < this.timeConstraintListModel.size(); ++i) {
                ctiList.add(this.timeConstraintListModel.get(i));
            }
            if (!this.colorType.equals(this.place.underlyingPlace().getColorType())) {
                this.updateArcsAccordingToColorType();
            }
            boolean bl = anyChanges = !(underlyingPlace = this.place.underlyingPlace()).getCtiList().equals(ctiList) || !underlyingPlace.getColorType().equals(this.colorType) || !oldTokenList.equals(tokensToAdd) || this.originalExpression != null && !this.originalExpression.equals(newExpression) || oldTokenCount != underlyingPlace.numberOfTokens();
            if (anyChanges) {
                ColoredPlaceMarkingEditCommand command = new ColoredPlaceMarkingEditCommand(oldTokenList, tokensToAdd, this.originalExpression, newExpression, this.context, this.place, ctiList, this.colorType, oldTokenCount, this.place.underlyingPlace().numberOfTokens());
                command.redo();
                this.context.undoManager().addEdit(command);
            }
        }
    }

    private TimeInvariant constructInvariant() {
        if (this.normalInvRadioButton.isSelected()) {
            if (this.invariantInf.isSelected()) {
                return TimeInvariant.LESS_THAN_INFINITY;
            }
            int bound = (Integer)this.invariantSpinner.getValue();
            boolean nonStrict = "<=".equals(this.invRelationNormal.getSelectedItem());
            return new TimeInvariant(nonStrict, new IntBound(bound));
        }
        boolean nonStrict = "<=".equals(this.invRelationConstant.getSelectedItem());
        Constant constant = this.context.network().getConstant((String)this.invConstantsComboBox.getSelectedItem());
        return new TimeInvariant(nonStrict, new ConstantBound(constant));
    }

    private void exit() {
        this.rootPane.getParent().setVisible(false);
    }

    private void initTokensPanel() {
        this.tokenPanel = new JPanel();
        this.tokenButtonPanel = new JPanel(new GridBagLayout());
        this.tokenPanel.setLayout(new GridBagLayout());
        this.tokenPanel.setBorder(BorderFactory.createTitledBorder("Tokens"));
        this.tokenColorComboboxPanel = new ColorComboboxPanel(this.colorType, true){

            @Override
            public void changedColor(JComboBox[] comboBoxes) {
                PlaceEditorPanel.this.updateSpinnerValue(true);
            }
        };
        this.tokenColorComboboxPanel.removeScrollPaneBorder();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        this.tokenPanel.add((Component)this.tokenColorComboboxPanel, gbc);
        this.coloredTokenListModel = new DefaultListModel();
        this.tokenList = new JList<NumberOfExpression>(this.coloredTokenListModel);
        this.tokenList.setSelectionMode(0);
        this.tokenList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting() && !this.tokenList.isSelectionEmpty()) {
                this.tokenColorComboboxPanel.updateSelection(((NumberOfExpression)this.tokenList.getSelectedValue()).getColor().get(0));
                this.updateSpinnerValue(false);
                this.addColoredTokenButton.setText("Modify");
                this.removeColoredTokenButton.setEnabled(true);
            } else if (this.tokenList.isSelectionEmpty()) {
                this.addColoredTokenButton.setText("Add");
                this.removeColoredTokenButton.setEnabled(false);
            }
        });
        JScrollPane tokenListScrollPane = new JScrollPane(this.tokenList);
        tokenListScrollPane.setViewportView(this.tokenList);
        tokenListScrollPane.setVerticalScrollBarPolicy(20);
        Dimension tokenScrollPaneDim = new Dimension(100, 150);
        tokenListScrollPane.setBorder(BorderFactory.createTitledBorder("Tokens in initial marking"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(3, 3, 3, 3);
        tokenListScrollPane.setPreferredSize(tokenScrollPaneDim);
        this.tokenPanel.add((Component)tokenListScrollPane, gbc);
        this.addColoredTokenButton = new JButton("Add");
        Dimension buttonSize = new Dimension(100, 30);
        this.addColoredTokenButton.setPreferredSize(buttonSize);
        this.addColoredTokenButton.setMinimumSize(buttonSize);
        this.addColoredTokenButton.setMaximumSize(buttonSize);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 16;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.tokenButtonPanel.add((Component)this.addColoredTokenButton, gbc);
        this.addColoredTokenButton.addActionListener(actionEvent -> {
            int tokenSpinnerValue = (Integer)this.addTokenSpinner.getValue();
            int tokenListSum = 0;
            for (int i = 0; i < this.coloredTokenListModel.size(); ++i) {
                if (i == this.tokenList.getSelectedIndex()) continue;
                tokenListSum += Integer.parseInt(this.coloredTokenListModel.getElementAt(i).toString().split("'")[0]);
            }
            if ((tokenListSum += tokenSpinnerValue) > 9999999) {
                JOptionPane.showMessageDialog(this, "It is allowed to have at most 9999999 tokens in a place.", "Error", 0);
                return;
            }
            NumberOfExpression exprToAdd = this.buildTokenExpression(tokenSpinnerValue);
            this.addTokenExpression(exprToAdd);
            this.addColoredTokenButton.setText("Modify");
            if (this.tokenList.isSelectionEmpty()) {
                this.tokenList.setSelectedIndex(this.coloredTokenListModel.size() - 1);
            }
        });
        this.addTokenSpinner = new CustomJSpinner(1, 1, Integer.MAX_VALUE);
        this.addTokenSpinner.setPreferredSize(buttonSize);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.tokenPanel.add((Component)this.addTokenSpinner, gbc);
        this.removeColoredTokenButton = new JButton("Remove");
        this.removeColoredTokenButton.setPreferredSize(buttonSize);
        this.removeColoredTokenButton.setMinimumSize(buttonSize);
        this.removeColoredTokenButton.setMaximumSize(buttonSize);
        this.removeColoredTokenButton.addActionListener(actionEvent -> {
            if (this.tokenList.getSelectedIndex() > -1) {
                int index = this.tokenList.getSelectedIndex();
                this.coloredTokenListModel.remove(this.tokenList.getSelectedIndex());
                this.updateTokenSelection(index);
            }
        });
        this.removeColoredTokenButton.setEnabled(this.tokenList.getSelectedIndex() > 0);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 16;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.tokenButtonPanel.add((Component)this.removeColoredTokenButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.tokenPanel.add((Component)this.tokenButtonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.tokenPanel, gbc);
    }

    private void updateTokenSelection(int index) {
        int currentSize = this.tokenList.getModel().getSize();
        if (currentSize > index) {
            this.tokenList.setSelectedIndex(index);
        } else if (currentSize != 0) {
            this.tokenList.setSelectedIndex(currentSize - 1);
        } else {
            this.addColoredTokenButton.setText("Add");
            this.removeColoredTokenButton.setEnabled(false);
        }
    }

    public void initColorInvariantPanel() {
        this.timeInvariantColorPanel = new JPanel(new GridBagLayout());
        this.timeInvariantColorPanel = this.initNonDefaultColorInvariantPanel();
        this.timeInvariantColorPanel.setBorder(BorderFactory.createTitledBorder("Time invariants for specific colors"));
        GridBagConstraints gbc = GridBagHelper.as(0, 3, GridBagHelper.Anchor.WEST, new Insets(3, 3, 3, 3));
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.mainPanel.add((Component)this.timeInvariantColorPanel, gbc);
    }

    private JPanel initNonDefaultColorInvariantPanel() {
        JPanel nonDefaultColorInvariantPanel = new JPanel(new GridBagLayout());
        JPanel colorInvariantEditPanel = new JPanel(new GridBagLayout());
        this.colorInvariantComboboxPanel = new ColorComboboxPanel(this.colorType){

            @Override
            public void changedColor(JComboBox[] comboBoxes) {
                ColoredTimeInvariant timeConstraint;
                if (!(PlaceEditorPanel.this.colorType instanceof ProductType)) {
                    timeConstraint = ColoredTimeInvariant.LESS_THAN_INFINITY_DYN_COLOR((Color)comboBoxes[0].getItemAt(comboBoxes[0].getSelectedIndex()));
                } else {
                    Vector<Color> colors = new Vector<Color>();
                    for (JComboBox comboBox : comboBoxes) {
                        colors.add((Color)comboBox.getItemAt(comboBox.getSelectedIndex()));
                    }
                    Color color = new Color(PlaceEditorPanel.this.colorType, (Integer)0, colors);
                    timeConstraint = ColoredTimeInvariant.LESS_THAN_INFINITY_DYN_COLOR(color);
                }
                boolean alreadyExists = false;
                for (int i = 0; i < PlaceEditorPanel.this.timeConstraintListModel.size(); ++i) {
                    if (!timeConstraint.equalsOnlyColor(PlaceEditorPanel.this.timeConstraintListModel.get(i))) continue;
                    PlaceEditorPanel.this.invariantEditorPanel.setInvariant(PlaceEditorPanel.this.timeConstraintListModel.get(i));
                    PlaceEditorPanel.this.timeConstraintList.setSelectedIndex(i);
                    PlaceEditorPanel.this.addTimeConstraintButton.setText("Modify");
                    alreadyExists = true;
                }
                if (!alreadyExists) {
                    PlaceEditorPanel.this.invariantEditorPanel.setInvariant(timeConstraint);
                    PlaceEditorPanel.this.addTimeConstraintButton.setText("Add");
                }
            }
        };
        this.colorInvariantComboboxPanel.removeScrollPaneBorder();
        this.addTimeConstraintButton = new JButton("Add");
        this.removeTimeConstraintButton = new JButton("Remove");
        Dimension buttonSize = new Dimension(80, 27);
        this.addTimeConstraintButton.setPreferredSize(buttonSize);
        this.removeTimeConstraintButton.setPreferredSize(buttonSize);
        this.timeConstraintListModel = new DefaultListModel();
        this.timeConstraintList = new JList<ColoredTimeInvariant>(this.timeConstraintListModel);
        this.timeConstraintList.setSelectionMode(1);
        this.timeConstraintListModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent arg0) {
            }

            @Override
            public void intervalAdded(ListDataEvent arg0) {
                PlaceEditorPanel.this.timeConstraintList.setSelectedIndex(arg0.getIndex0());
                PlaceEditorPanel.this.timeConstraintList.ensureIndexIsVisible(arg0.getIndex0());
            }

            @Override
            public void intervalRemoved(ListDataEvent arg0) {
                int index = arg0.getIndex0() == 0 ? 0 : arg0.getIndex0() - 1;
                PlaceEditorPanel.this.timeConstraintList.setSelectedIndex(index);
                PlaceEditorPanel.this.timeConstraintList.ensureIndexIsVisible(index);
            }
        });
        this.timeConstraintList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JList source = (JList)listSelectionEvent.getSource();
                if (source.getSelectedIndex() >= 0) {
                    ColoredTimeInvariant cti = (ColoredTimeInvariant)source.getModel().getElementAt(source.getSelectedIndex());
                    this.invariantEditorPanel.setInvariant(cti);
                    this.colorInvariantComboboxPanel.updateSelection(cti.getColor());
                    this.addTimeConstraintButton.setText("Modify");
                }
                this.removeTimeConstraintButton.setEnabled(!this.timeConstraintList.isSelectionEmpty());
            }
        });
        JScrollPane timeConstraintScrollPane = new JScrollPane(this.timeConstraintList);
        timeConstraintScrollPane.setViewportView(this.timeConstraintList);
        timeConstraintScrollPane.setVerticalScrollBarPolicy(20);
        timeConstraintScrollPane.setBorder(BorderFactory.createTitledBorder("Time invariant for colors"));
        this.addTimeConstraintButton.addActionListener(actionEvent -> {
            ColoredTimeInvariant timeConstraint = this.invariantEditorPanel.getInvariant();
            boolean alreadyExists = false;
            for (int i = 0; i < this.timeConstraintListModel.size(); ++i) {
                if (!timeConstraint.equalsOnlyColor(this.timeConstraintListModel.get(i))) continue;
                alreadyExists = true;
                this.timeConstraintListModel.setElementAt(timeConstraint, i);
                this.timeConstraintList.setSelectedIndex(i);
            }
            if (!alreadyExists) {
                this.timeConstraintListModel.addElement(timeConstraint);
                this.timeConstraintList.setSelectedIndex(this.timeConstraintListModel.size() - 1);
            }
        });
        this.removeTimeConstraintButton.setEnabled(!this.timeConstraintList.isSelectionEmpty());
        this.removeTimeConstraintButton.addActionListener(actionEvent -> {
            int index = this.timeConstraintList.getSelectedIndex();
            this.timeConstraintListModel.removeElementAt(index);
            if (this.timeConstraintListModel.isEmpty()) {
                this.addTimeConstraintButton.setText("Add");
            } else {
                this.timeConstraintList.setSelectedIndex(index);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        colorInvariantEditPanel.add((Component)this.colorInvariantComboboxPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(3, 3, 3, 3);
        buttonPanel.add((Component)this.addTimeConstraintButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(3, 3, 3, 3);
        buttonPanel.add((Component)this.removeTimeConstraintButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 10;
        ColoredTimeInvariant cti = this.place.underlyingPlace().getCtiList().isEmpty() ? ColoredTimeInvariant.LESS_THAN_INFINITY_DYN_COLOR(this.place.underlyingPlace().getColorType().getFirstColor()) : this.place.underlyingPlace().getCtiList().get(0);
        this.invariantEditorPanel = new ColoredTimeInvariantDialogPanel(this.rootPane, this.context, cti, this.place);
        colorInvariantEditPanel.add((Component)this.invariantEditorPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 13;
        colorInvariantEditPanel.add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        nonDefaultColorInvariantPanel.add((Component)colorInvariantEditPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        nonDefaultColorInvariantPanel.add((Component)timeConstraintScrollPane, gbc);
        return nonDefaultColorInvariantPanel;
    }

    private void initColorTypePanel() {
        this.colorTypePanel = new JPanel();
        this.colorTypePanel.setLayout(new GridBagLayout());
        this.colorTypePanel.setBorder(new TitledBorder("Color Type"));
        JLabel colortypeLabel = new JLabel();
        colortypeLabel.setText("Color Type:");
        this.colorTypeComboBox = new JComboBox();
        List<ColorType> colorTypes = this.context.network().colorTypes();
        for (ColorType element : colorTypes) {
            this.colorTypeComboBox.addItem(element);
        }
        this.colorTypeComboBox.setRenderer(new ColorComboBoxRenderer(this.colorTypeComboBox));
        this.colorTypeComboBox.setSelectedItem(this.colorType);
        this.colorTypeComboBox.addActionListener(actionEvent -> {
            if (this.colorTypeComboBox.getSelectedItem() != null && this.colorTypeComboBox.getSelectedItem().equals(this.tokenColorComboboxPanel.getColorType())) {
                return;
            }
            if (!(this.editSharedPlace || this.coloredTokenListModel.getSize() < 1 && this.timeConstraintListModel.isEmpty())) {
                int dialogResult = JOptionPane.showConfirmDialog(null, "Are you sure you want to change the color type for this place?\nAll tokens and time invariants for colors will be deleted.", "alert", 0);
                if (dialogResult == 0) {
                    this.setNewColorType(this.colorTypeComboBox.getItemAt(this.colorTypeComboBox.getSelectedIndex()));
                } else {
                    for (int i = 0; i < this.colorTypeComboBox.getItemCount(); ++i) {
                        if (!this.colorType.getName().equals(this.colorTypeComboBox.getItemAt(i).getName())) continue;
                        this.colorTypeComboBox.setSelectedIndex(i);
                    }
                }
            } else {
                this.setNewColorType(this.colorTypeComboBox.getItemAt(this.colorTypeComboBox.getSelectedIndex()));
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.colorTypePanel.add((Component)colortypeLabel, gbc);
        Dimension colorTypeComboBoxSize = new Dimension(500, 30);
        this.colorTypeComboBox.setPreferredSize(colorTypeComboBoxSize);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.colorTypePanel.add(this.colorTypeComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.colorTypePanel, gbc);
    }

    private void updateArcsAccordingToColorType() {
        SetArcExpressionCommand arcExpressionCommand;
        NumberOfExpression numbExpr;
        Vector<ColorExpression> vecColorExpr;
        SetTransportArcExpressionsCommand expressionsCommand;
        NumberOfExpression numbExpr2;
        Vector<ColorExpression> vecColorExpr2;
        TransportArc transportArc;
        for (Arc arc : this.place.getPostset()) {
            if (arc instanceof TimedTransportArcComponent) {
                transportArc = ((TimedTransportArcComponent)arc).underlyingTransportArc();
                vecColorExpr2 = new Vector<ColorExpression>();
                vecColorExpr2.add(this.colorType.createColorExpressionForFirstColor());
                numbExpr2 = new NumberOfExpression(transportArc.getOutputExpression().weight(), vecColorExpr2);
                expressionsCommand = new SetTransportArcExpressionsCommand((TimedTransportArcComponent)arc, transportArc.getInputExpression(), numbExpr2, transportArc.getOutputExpression(), transportArc.getOutputExpression());
                expressionsCommand.redo();
                this.context.undoManager().addEdit(expressionsCommand);
            } else if (!(arc instanceof TimedInhibitorArcComponent)) {
                vecColorExpr = new Vector<ColorExpression>();
                vecColorExpr.add(this.colorType.createColorExpressionForFirstColor());
                numbExpr = new NumberOfExpression(1, vecColorExpr);
                arcExpressionCommand = new SetArcExpressionCommand(arc, arc.getExpression(), numbExpr);
                arcExpressionCommand.redo();
                this.context.undoManager().addEdit(arcExpressionCommand);
            }
            if (arc instanceof TimedInhibitorArcComponent) continue;
            SetColoredArcIntervalsCommand arcIntervalCommand = new SetColoredArcIntervalsCommand((TimedInputArcComponent)arc, ((TimedInputArcComponent)arc).getCtiList(), new ArrayList<ColoredTimeInterval>());
            arcIntervalCommand.redo();
            this.context.undoManager().addEdit(arcIntervalCommand);
        }
        for (Arc arc : this.place.getPreset()) {
            if (arc instanceof TimedTransportArcComponent) {
                transportArc = ((TimedTransportArcComponent)arc).underlyingTransportArc();
                vecColorExpr2 = new Vector();
                vecColorExpr2.add(this.colorType.createColorExpressionForFirstColor());
                numbExpr2 = new NumberOfExpression(transportArc.getInputExpression().weight(), vecColorExpr2);
                expressionsCommand = new SetTransportArcExpressionsCommand((TimedTransportArcComponent)arc, transportArc.getInputExpression(), transportArc.getInputExpression(), transportArc.getOutputExpression(), numbExpr2);
                expressionsCommand.redo();
                this.context.undoManager().addEdit(expressionsCommand);
                continue;
            }
            vecColorExpr = new Vector();
            vecColorExpr.add(this.colorType.createColorExpressionForFirstColor());
            numbExpr = new NumberOfExpression(1, vecColorExpr);
            arcExpressionCommand = new SetArcExpressionCommand(arc, arc.getExpression(), numbExpr);
            arcExpressionCommand.redo();
            this.context.undoManager().addEdit(arcExpressionCommand);
        }
    }

    private void writeTokensToList(TimedPlace tp) {
        this.coloredTokenListModel.clear();
        AddExpression tokenExpression = (AddExpression)tp.getTokensAsExpression();
        if (tokenExpression != null) {
            for (ArcExpression expr : tokenExpression.getAddExpression()) {
                this.addTokenExpression((NumberOfExpression)expr);
            }
        }
        this.updateSpinnerValue(true);
    }

    private void updateSpinnerValue(boolean updateSelection) {
        NumberOfExpression expr = this.buildTokenExpression(1);
        if (this.coloredTokenListModel.getSize() > 0) {
            for (int i = 0; i < this.coloredTokenListModel.getSize(); ++i) {
                NumberOfExpression otherExpr = this.coloredTokenListModel.getElementAt(i);
                if (!expr.equalsColor(otherExpr)) continue;
                this.addTokenSpinner.setValue(otherExpr.getNumber());
                if (updateSelection) {
                    this.tokenList.setSelectedIndex(i);
                }
                return;
            }
        }
        this.addTokenSpinner.setValue(1);
        this.tokenList.clearSelection();
        this.addColoredTokenButton.setText("Add");
    }

    private void setInitialComboBoxValue() {
        List<ColorType> colorTypes = this.context.network().colorTypes();
        if (this.colorType != null) {
            this.colorTypeComboBox.setSelectedIndex(colorTypes.indexOf(this.colorType));
        } else if (colorTypes.size() != 0) {
            this.colorTypeComboBox.setSelectedIndex(0);
        }
    }

    private void setNewColorType(ColorType colorType) {
        this.colorType = colorType;
        this.coloredTokenListModel.clear();
        this.timeConstraintListModel.clear();
        this.tokenColorComboboxPanel.updateColorType(colorType);
        this.colorInvariantComboboxPanel.updateColorType(colorType);
        this.tokenColorComboboxPanel.changedColor(this.tokenColorComboboxPanel.getColorTypeComboBoxesArray());
        this.colorInvariantComboboxPanel.changedColor(this.colorInvariantComboboxPanel.getColorTypeComboBoxesArray());
        this.parent.pack();
    }

    private void setColoredTimeInvariants(TimedPlace tp) {
        this.timeConstraintListModel.clear();
        for (ColoredTimeInvariant timeInvariant : tp.getCtiList()) {
            this.timeConstraintListModel.addElement(timeInvariant);
        }
        this.timeConstraintList.setSelectedIndex(0);
    }

    private void addTokenExpression(NumberOfExpression expr) {
        boolean exists = false;
        for (int i = 0; i < this.coloredTokenListModel.getSize(); ++i) {
            NumberOfExpression otherExpr = this.coloredTokenListModel.getElementAt(i);
            if (!expr.equalsColor(otherExpr)) continue;
            exists = true;
            otherExpr.setNumber(expr.getNumber());
            break;
        }
        if (!exists) {
            this.coloredTokenListModel.addElement(expr);
        }
        this.tokenList.updateUI();
    }

    private NumberOfExpression buildTokenExpression(int number) {
        Vector<ColorExpression> exprVec = new Vector<ColorExpression>();
        if (this.colorType instanceof ProductType) {
            Vector<ColorExpression> tempVec = new Vector<ColorExpression>();
            for (int i = 0; i < this.tokenColorComboboxPanel.getColorTypeComboBoxesArray().length; ++i) {
                ColorExpression expr = this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[i].getItemAt(this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[i].getSelectedIndex()) instanceof String ? new AllExpression(((Color)this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[i].getItemAt(0)).getColorType()) : new UserOperatorExpression((Color)this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[i].getItemAt(this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[i].getSelectedIndex()));
                tempVec.add(expr);
            }
            TupleExpression tupleExpression = new TupleExpression(tempVec);
            exprVec.add(tupleExpression);
        } else {
            ColorExpression expr = this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[0].getItemAt(this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[0].getSelectedIndex()) instanceof String ? new AllExpression(this.colorType) : new UserOperatorExpression((Color)this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[0].getItemAt(this.tokenColorComboboxPanel.getColorTypeComboBoxesArray()[0].getSelectedIndex()));
            exprVec.add(expr);
        }
        return new NumberOfExpression(number, exprVec);
    }
}

