/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.editor;

import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.ConstantBound;
import dk.aau.cs.model.tapn.ConstantWeight;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.Weight;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import net.tapaal.gui.petrinet.Context;
import net.tapaal.gui.petrinet.editor.ColoredArcGuardPanel;
import net.tapaal.swinghelpers.SwingHelper;
import net.tapaal.swinghelpers.WidthAdjustingComboBox;
import pipe.gui.petrinet.graphicElements.PetriNetObject;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedOutputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;
import pipe.gui.petrinet.undo.UndoManager;

public class GuardDialogue
extends JPanel {
    private final JRootPane myRootPane;
    private JPanel guardEditPanel;
    private JPanel weightEditPanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel label;
    private JSpinner weightNumber;
    private JSpinner firstIntervalNumber;
    private JSpinner secondIntervalNumber;
    private JCheckBox inf;
    private JComboBox<String> leftDelimiter;
    private JComboBox<String> rightDelimiter;
    private JCheckBox leftUseConstant;
    private WidthAdjustingComboBox<String> leftConstantsComboBox;
    private JCheckBox rightUseConstant;
    private WidthAdjustingComboBox<String> rightConstantsComboBox;
    private JCheckBox weightUseConstant;
    private WidthAdjustingComboBox<String> weightConstantsComboBox;
    private ColoredArcGuardPanel coloredArcGuardPanel;
    final PetriNetObject objectToBeEdited;
    final Context context;
    final JPanel mainPanel;
    final JScrollPane scrollPane;
    private final int maxNumberOfPlacesToShowAtOnce = 20;

    public GuardDialogue(JRootPane rootPane, PetriNetObject objectToBeEdited, Context context) {
        this.myRootPane = rootPane;
        this.context = context;
        this.objectToBeEdited = objectToBeEdited;
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.mainPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setBorder(null);
        this.initTimeGuardPanel();
        this.guardEditPanel.setVisible(objectToBeEdited.isTimed() && objectToBeEdited instanceof TimedInputArcComponent && !(objectToBeEdited instanceof TimedInhibitorArcComponent));
        if (objectToBeEdited instanceof TimedTransportArcComponent && ((TimedTransportArcComponent)objectToBeEdited).getSource() instanceof Transition) {
            this.guardEditPanel.setVisible(false);
        }
        this.initWeightPanel();
        this.initButtonPanel(objectToBeEdited);
        this.initColoredArcPanel();
        this.myRootPane.setDefaultButton(this.okButton);
        if (objectToBeEdited instanceof TimedInputArcComponent && !(objectToBeEdited instanceof TimedInhibitorArcComponent)) {
            this.setNoncoloredInitialState((TimedInputArcComponent)objectToBeEdited);
        }
        if (objectToBeEdited instanceof TimedOutputArcComponent) {
            TimedOutputArcComponent arc = (TimedOutputArcComponent)objectToBeEdited;
            if (arc.getWeight() instanceof ConstantWeight) {
                this.weightConstantsComboBox.setSelectedItem(((ConstantWeight)arc.getWeight()).constant().name());
                this.weightUseConstant.doClick();
            }
            this.weightNumber.setValue(((TimedOutputArcComponent)objectToBeEdited).getWeight().value());
        }
        this.add((Component)this.scrollPane, "Center");
        this.hideIrrelevantInformation();
    }

    private void hideIrrelevantInformation() {
        if (!this.objectToBeEdited.isTimed() && this.guardEditPanel != null) {
            this.guardEditPanel.setVisible(false);
        }
        if (!this.objectToBeEdited.isColored() || this.objectToBeEdited instanceof TimedInhibitorArcComponent) {
            this.coloredArcGuardPanel.setVisible(false);
        } else {
            if (this.objectToBeEdited.isTimed() && this.guardEditPanel != null) {
                this.guardEditPanel.setBorder(BorderFactory.createTitledBorder("Default Time Interval"));
            }
            this.weightEditPanel.setVisible(false);
        }
    }

    private void initColoredArcPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.coloredArcGuardPanel = new ColoredArcGuardPanel(this.objectToBeEdited, this.context){

            @Override
            public void disableOkButton() {
                GuardDialogue.this.okButton.setEnabled(false);
            }

            @Override
            public void enableOkButton() {
                GuardDialogue.this.okButton.setEnabled(true);
            }
        };
        this.mainPanel.add((Component)this.coloredArcGuardPanel, gridBagConstraints);
    }

    private void initButtonPanel(final PetriNetObject objectToBeEdited) {
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.okButton = new JButton("OK");
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.addActionListener(new ActionListener(){
            final /* synthetic */ GuardDialogue this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimedOutputArcComponent arc = (TimedOutputArcComponent)objectToBeEdited;
                UndoManager undoManager = this.this$0.context.undoManager();
                undoManager.newEdit();
                TimeInterval guard = null;
                if (objectToBeEdited instanceof TimedInputArcComponent && !(objectToBeEdited instanceof TimedInhibitorArcComponent)) {
                    guard = this.composeGuard(((TimedInputArcComponent)arc).getGuard());
                }
                if (objectToBeEdited instanceof TimedInputArcComponent && !(objectToBeEdited instanceof TimedInhibitorArcComponent) && ((TimedInputArcComponent)objectToBeEdited).isUrgentTransition()) {
                    if (!guard.equals(TimeInterval.ZERO_INF)) {
                        JOptionPane.showMessageDialog(this.this$0.myRootPane, "Incoming arcs to urgent transitions must have the interval [0,\u221e)", "Error", 0);
                        return;
                    }
                    for (Object interval : this.this$0.coloredArcGuardPanel.getTimeConstraintModel().toArray()) {
                        if (!(interval instanceof ColoredTimeInterval) || ((ColoredTimeInterval)interval).getInterval().equals(TimeInterval.ZERO_INF.toString())) continue;
                        JOptionPane.showMessageDialog(this.this$0.myRootPane, "Incoming arcs to urgent transitions must have the interval [0,\u221e)", "Error", 0);
                        return;
                    }
                }
                this.this$0.coloredArcGuardPanel.onOkColored(undoManager);
                Weight weight = this.composeWeight();
                undoManager.addEdit(arc.setGuardAndWeight(guard, weight));
                this.this$0.context.network().buildConstraints();
                this.this$0.exit();
            }

            private Weight composeWeight() {
                Weight weight;
                if (this.this$0.weightUseConstant.isSelected()) {
                    String constantName = this.this$0.weightConstantsComboBox.getSelectedItem().toString();
                    weight = new ConstantWeight(this.this$0.context.network().getConstant(constantName));
                } else {
                    weight = new IntWeight((Integer)this.this$0.weightNumber.getValue());
                }
                return weight;
            }

            private TimeInterval composeGuard(TimeInterval oldGuard) {
                String constantName;
                boolean useConstantLeft = this.this$0.leftUseConstant.isSelected();
                boolean useConstantRight = this.this$0.rightUseConstant.isSelected();
                String leftDelim = this.this$0.leftDelimiter.getSelectedItem().toString();
                String rightDelim = this.this$0.rightDelimiter.getSelectedItem().toString();
                Bound leftInterval = null;
                Bound rightInterval = null;
                if (useConstantLeft) {
                    constantName = this.this$0.leftConstantsComboBox.getSelectedItem().toString();
                    leftInterval = new ConstantBound(this.this$0.context.network().getConstant(constantName));
                } else {
                    leftInterval = new IntBound((Integer)this.this$0.firstIntervalNumber.getValue());
                }
                if (useConstantRight) {
                    constantName = this.this$0.rightConstantsComboBox.getSelectedItem().toString();
                    rightInterval = new ConstantBound(this.this$0.context.network().getConstant(constantName));
                } else {
                    rightInterval = this.this$0.inf.isSelected() ? Bound.Infinity : new IntBound((Integer)this.this$0.secondIntervalNumber.getValue());
                }
                if (rightInterval instanceof Bound.InfBound || leftInterval.value() <= rightInterval.value()) {
                    return new TimeInterval(leftDelim.equals("["), leftInterval, rightInterval, rightDelim.equals("]"));
                }
                return oldGuard;
            }
        });
        this.cancelButton.addActionListener(evt -> this.exit());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.mainPanel.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void initWeightPanel() {
        this.weightEditPanel = new JPanel(new GridBagLayout());
        this.weightEditPanel.setBorder(BorderFactory.createTitledBorder("Weight"));
        this.label = new JLabel("Weight:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.weightEditPanel.add((Component)this.label, gridBagConstraints);
        Dimension intervalBoxDims = new Dimension(190, 25);
        this.weightNumber = new JSpinner();
        SwingHelper.setPreferredWidth(this.weightNumber, intervalBoxDims.width);
        this.weightNumber.addChangeListener(e -> {
            if ((Integer)this.weightNumber.getValue() < 1) {
                this.weightNumber.setValue(1);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.weightEditPanel.add((Component)this.weightNumber, gridBagConstraints);
        Set<String> constants = this.context.network().getConstantNames();
        ArrayList<String> filteredConstants = new ArrayList<String>();
        for (String constant : constants) {
            if (this.context.network().getConstantValue(constant) == 0) continue;
            filteredConstants.add(constant);
        }
        String[] constantArray = filteredConstants.toArray(new String[0]);
        Arrays.sort(constantArray, String.CASE_INSENSITIVE_ORDER);
        this.weightConstantsComboBox = new WidthAdjustingComboBox(20);
        this.weightConstantsComboBox.setModel(new DefaultComboBoxModel<String>(constantArray));
        this.weightConstantsComboBox.setMaximumRowCount(20);
        this.weightConstantsComboBox.setVisible(false);
        SwingHelper.setPreferredWidth(this.weightConstantsComboBox, intervalBoxDims.width);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.weightEditPanel.add(this.weightConstantsComboBox, gridBagConstraints);
        boolean enableConstantsCheckBoxes = !filteredConstants.isEmpty();
        this.weightUseConstant = new JCheckBox("Use Constant");
        this.weightUseConstant.setEnabled(enableConstantsCheckBoxes);
        this.weightUseConstant.addActionListener(e -> {
            this.weightConstantsComboBox.setVisible(this.weightUseConstant.isSelected());
            this.weightNumber.setVisible(!this.weightUseConstant.isSelected());
            this.repackIfWindow();
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.weightEditPanel.add((Component)this.weightUseConstant, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.weightEditPanel.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.weightEditPanel, gridBagConstraints);
    }

    private void initTimeGuardPanel() {
        this.guardEditPanel = new JPanel(new GridBagLayout());
        this.guardEditPanel.setBorder(BorderFactory.createTitledBorder("Time Guard"));
        this.label = new JLabel("Time Interval:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.guardEditPanel.add((Component)this.label, gridBagConstraints);
        String[] left = new String[]{"[", "("};
        this.leftDelimiter = new JComboBox();
        Dimension dims = new Dimension(55, 25);
        this.leftDelimiter.setPreferredSize(dims);
        this.leftDelimiter.setMinimumSize(dims);
        this.leftDelimiter.setMaximumSize(dims);
        this.leftDelimiter.setModel(new DefaultComboBoxModel<String>(left));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add(this.leftDelimiter, gridBagConstraints);
        String[] right = new String[]{"]", ")"};
        this.rightDelimiter = new JComboBox();
        this.rightDelimiter.setPreferredSize(dims);
        this.rightDelimiter.setMinimumSize(dims);
        this.rightDelimiter.setMaximumSize(dims);
        this.rightDelimiter.setModel(new DefaultComboBoxModel<String>(right));
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add(this.rightDelimiter, gridBagConstraints);
        this.inf = new JCheckBox(Character.toString('\u221e'), true);
        this.inf.addActionListener(evt -> {
            if (this.inf.isSelected()) {
                this.secondIntervalNumber.setEnabled(false);
                this.rightDelimiter.setEnabled(false);
            } else {
                this.secondIntervalNumber.setEnabled(true);
                this.rightDelimiter.setEnabled(true);
            }
            this.setDelimiterModels();
        });
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add((Component)this.inf, gridBagConstraints);
        this.initNonColoredTimeIntervalControls();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.guardEditPanel, gridBagConstraints);
    }

    private void initNonColoredTimeIntervalControls() {
        Dimension intervalBoxDims = new Dimension(190, 25);
        this.firstIntervalNumber = new JSpinner();
        SwingHelper.setPreferredWidth(this.firstIntervalNumber, intervalBoxDims.width);
        this.firstIntervalNumber.addChangeListener(this::firstSpinnerStateChanged);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.guardEditPanel.add((Component)this.firstIntervalNumber, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add((Component)new JLabel(" , "), gridBagConstraints);
        this.secondIntervalNumber = new JSpinner();
        SwingHelper.setPreferredWidth(this.secondIntervalNumber, intervalBoxDims.width);
        this.secondIntervalNumber.addChangeListener(this::secondSpinnerStateChanged);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add((Component)this.secondIntervalNumber, gridBagConstraints);
        Set<String> constants = this.context.network().getConstantNames();
        String[] constantArray = constants.toArray(new String[0]);
        Arrays.sort(constantArray, String.CASE_INSENSITIVE_ORDER);
        boolean enableConstantsCheckBoxes = !constants.isEmpty();
        this.leftUseConstant = new JCheckBox("Use Constant                    ");
        this.leftUseConstant.setEnabled(enableConstantsCheckBoxes);
        this.leftUseConstant.addActionListener(e -> {
            this.updateLeftComponents();
            this.updateRightConstantComboBox();
            this.setDelimiterModels();
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.guardEditPanel.add((Component)this.leftUseConstant, gridBagConstraints);
        this.leftConstantsComboBox = new WidthAdjustingComboBox(20);
        this.leftConstantsComboBox.setModel(new DefaultComboBoxModel<String>(constantArray));
        this.leftConstantsComboBox.setMaximumRowCount(20);
        this.leftConstantsComboBox.setVisible(false);
        SwingHelper.setPreferredWidth(this.leftConstantsComboBox, intervalBoxDims.width);
        this.leftConstantsComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateRightConstantComboBox();
                this.setDelimiterModels();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add(this.leftConstantsComboBox, gridBagConstraints);
        this.rightUseConstant = new JCheckBox("Use Constant                    ");
        this.rightUseConstant.setEnabled(enableConstantsCheckBoxes);
        this.rightUseConstant.addActionListener(e -> {
            this.updateRightComponents();
            this.updateRightConstantComboBox();
            this.setDelimiterModels();
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.guardEditPanel.add((Component)this.rightUseConstant, gridBagConstraints);
        this.rightConstantsComboBox = new WidthAdjustingComboBox(20);
        this.rightConstantsComboBox.setModel(new DefaultComboBoxModel<String>(constantArray));
        this.rightConstantsComboBox.setMaximumRowCount(20);
        this.rightConstantsComboBox.setVisible(false);
        SwingHelper.setPreferredWidth(this.rightConstantsComboBox, intervalBoxDims.width);
        gridBagConstraints = new GridBagConstraints();
        this.rightConstantsComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setDelimiterModels();
            }
        });
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.guardEditPanel.add(this.rightConstantsComboBox, gridBagConstraints);
    }

    private void setNoncoloredInitialState(TimedInputArcComponent arc) {
        boolean canUseConstants;
        String timeInterval = arc.getGuardAsString();
        String[] partedTimeInterval = timeInterval.split(",");
        String firstNumber = partedTimeInterval[0].substring(1, partedTimeInterval[0].length());
        String secondNumber = partedTimeInterval[1].substring(0, partedTimeInterval[1].length() - 1);
        int first = 0;
        int second = 0;
        boolean firstIsNumber = true;
        boolean secondIsNumber = true;
        try {
            first = Integer.parseInt(firstNumber);
        }
        catch (NumberFormatException e) {
            firstIsNumber = false;
        }
        try {
            second = Integer.parseInt(secondNumber);
        }
        catch (NumberFormatException e) {
            secondIsNumber = false;
        }
        SpinnerNumberModel spinnerModelForFirstNumber = new SpinnerNumberModel(first, 0, Integer.MAX_VALUE, 1);
        SpinnerNumberModel spinnerModelForSecondNumber = null;
        boolean isInf = secondNumber.equals("inf");
        if (isInf) {
            this.inf.setSelected(true);
            this.secondIntervalNumber.setEnabled(false);
            this.rightDelimiter.setEnabled(false);
            spinnerModelForSecondNumber = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        } else {
            this.inf.setSelected(false);
            spinnerModelForSecondNumber = new SpinnerNumberModel(second, 0, Integer.MAX_VALUE, 1);
        }
        this.firstIntervalNumber.setModel(spinnerModelForFirstNumber);
        this.secondIntervalNumber.setModel(spinnerModelForSecondNumber);
        if (!firstIsNumber) {
            this.leftUseConstant.setSelected(true);
            this.leftConstantsComboBox.setSelectedItem(firstNumber);
            this.updateLeftComponents();
        }
        if (!secondIsNumber && !isInf) {
            this.rightUseConstant.setSelected(true);
            this.rightConstantsComboBox.setSelectedItem(secondNumber);
            this.updateRightComponents();
        }
        if (canUseConstants = this.rightUseConstant.isEnabled()) {
            this.updateRightConstantComboBox();
        }
        this.setDelimiterModels();
        if (timeInterval.contains("[")) {
            this.leftDelimiter.setSelectedItem("[");
        } else {
            this.leftDelimiter.setSelectedItem("(");
        }
        if (timeInterval.contains("]")) {
            this.rightDelimiter.setSelectedItem("]");
        } else {
            this.rightDelimiter.setSelectedItem(")");
        }
    }

    private void updateLeftComponents() {
        boolean value = this.leftUseConstant.isSelected();
        this.firstIntervalNumber.setVisible(!value);
        this.leftConstantsComboBox.setVisible(value);
        this.setDelimiterModels();
    }

    private void updateRightComponents() {
        boolean value = this.rightUseConstant.isSelected();
        this.inf.setVisible(!value);
        if (value) {
            this.rightDelimiter.setEnabled(true);
        } else {
            this.rightDelimiter.setEnabled(!this.inf.isSelected());
        }
        this.secondIntervalNumber.setVisible(!value);
        this.rightConstantsComboBox.setVisible(value);
        this.repackIfWindow();
        this.setDelimiterModels();
    }

    public void exit() {
        this.myRootPane.getParent().setVisible(false);
    }

    private void setDelimiterModels() {
        int firstValue = this.getFirstValue();
        int secondValue = this.getSecondValue();
        DefaultComboBoxModel<String> modelRightIncludedOnly = new DefaultComboBoxModel<String>(new String[]{"]"});
        DefaultComboBoxModel<String> modelLeftIncludedOnly = new DefaultComboBoxModel<String>(new String[]{"["});
        DefaultComboBoxModel<String> modelRightBoth = new DefaultComboBoxModel<String>(new String[]{"]", ")"});
        DefaultComboBoxModel<String> modelLeftBoth = new DefaultComboBoxModel<String>(new String[]{"[", "("});
        DefaultComboBoxModel<String> modelRightExcludedOnly = new DefaultComboBoxModel<String>(new String[]{")"});
        if (firstValue > secondValue) {
            this.secondIntervalNumber.setValue(firstValue);
            secondValue = firstValue;
        }
        String leftOldDelim = this.leftDelimiter.getSelectedItem().toString();
        String rightOldDelim = this.rightDelimiter.getSelectedItem().toString();
        if (firstValue == secondValue) {
            this.rightDelimiter.setModel(modelRightIncludedOnly);
            this.leftDelimiter.setModel(modelLeftIncludedOnly);
        } else {
            this.leftDelimiter.setModel(modelLeftBoth);
            if (this.inf.isSelected() && !this.rightUseConstant.isSelected()) {
                this.rightDelimiter.setModel(modelRightExcludedOnly);
            } else {
                this.rightDelimiter.setModel(modelRightBoth);
            }
        }
        this.leftDelimiter.setSelectedItem(leftOldDelim);
        if (this.rightUseConstant.isSelected()) {
            this.rightDelimiter.setSelectedItem("]");
        } else {
            this.rightDelimiter.setSelectedItem(rightOldDelim);
        }
    }

    private int getSecondValue() {
        int secondValue = this.rightUseConstant.isSelected() ? this.context.network().getConstantValue(this.rightConstantsComboBox.getSelectedItem().toString()) : (this.inf.isSelected() ? Integer.MAX_VALUE : Integer.parseInt(String.valueOf(this.secondIntervalNumber.getValue())));
        return secondValue;
    }

    private int getFirstValue() {
        int firstValue = this.leftUseConstant.isSelected() ? this.context.network().getConstantValue(this.leftConstantsComboBox.getSelectedItem().toString()) : Integer.parseInt(String.valueOf(this.firstIntervalNumber.getValue()));
        return firstValue;
    }

    private void updateWeightConstantComboBox() {
        int value = this.getFirstValue();
        String oldWeight = this.weightConstantsComboBox.getSelectedItem() != null ? this.weightConstantsComboBox.getSelectedItem().toString() : null;
        this.weightConstantsComboBox.removeAllItems();
        Collection<Constant> constants = this.context.network().constants();
        ArrayList<Constant> constantList = new ArrayList<Constant>();
        constantList.addAll(constants);
        constantList.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        for (Constant c : constantList) {
            if (c.value() < value) continue;
            this.weightConstantsComboBox.addItem(c.name());
        }
        if (oldWeight != null) {
            this.weightConstantsComboBox.setSelectedItem(oldWeight);
        }
    }

    private void updateRightConstantComboBox() {
        int value = this.getFirstValue();
        String oldRight = this.rightConstantsComboBox.getSelectedItem() != null ? this.rightConstantsComboBox.getSelectedItem().toString() : null;
        this.rightConstantsComboBox.removeAllItems();
        Collection<Constant> constants = this.context.network().constants();
        ArrayList<Constant> constantList = new ArrayList<Constant>();
        constantList.addAll(constants);
        constantList.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        for (Constant c : constantList) {
            if (c.value() < value) continue;
            this.rightConstantsComboBox.addItem(c.name());
        }
        if (this.rightConstantsComboBox.getItemCount() == 0) {
            this.rightUseConstant.setEnabled(false);
            this.rightUseConstant.setSelected(false);
            this.updateRightComponents();
        } else {
            this.rightUseConstant.setEnabled(true);
        }
        if (oldRight != null) {
            this.rightConstantsComboBox.setSelectedItem(oldRight);
        }
    }

    private void firstSpinnerStateChanged(ChangeEvent evt) {
        int firstValue = this.getFirstValue();
        int secondValue = this.getSecondValue();
        if (this.rightUseConstant.isSelected() && firstValue > secondValue) {
            this.rightUseConstant.setSelected(false);
            this.updateRightComponents();
        }
        if (firstValue > this.context.network().getLargestConstantValue()) {
            this.rightUseConstant.setEnabled(false);
        } else {
            this.rightUseConstant.setEnabled(true);
            this.updateRightConstantComboBox();
        }
        this.setDelimiterModels();
    }

    private void secondSpinnerStateChanged(ChangeEvent evt) {
        this.setDelimiterModels();
    }

    private void repackIfWindow() {
        if (this.myRootPane.getParent() instanceof Window) {
            ((Window)this.myRootPane.getParent()).pack();
        }
    }
}

