/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.animation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import pipe.gui.TAPAALGUI;
import pipe.gui.swingcomponents.EscapableDialog;

public class SimulationControl
extends JPanel {
    final JSlider simulationSpeed = new JSlider();
    final JCheckBox randomSimulation = new JCheckBox("Enable automatic random simulation");
    final JCheckBox randomMode = new JCheckBox("Choose next transition randomly");
    final Timer timer = new Timer(this.simulationSpeed.getValue() * 20, e -> TAPAALGUI.getCurrentTab().getTransitionFiringComponent().fireSelectedTransition());
    private static boolean defaultIsRandomTrasition;
    private static SimulationControl instance;
    private static EscapableDialog dialog;

    public static SimulationControl getInstance() {
        if (instance == null) {
            instance = new SimulationControl();
        }
        return instance;
    }

    public void addRandomSimulationActionListener(ActionListener l) {
        this.randomSimulation.addActionListener(l);
    }

    public void showCheckbox(boolean show) {
        this.randomSimulation.setVisible(show);
    }

    private SimulationControl() {
        super(new GridBagLayout());
        this.simulationSpeed.setSnapToTicks(false);
        this.simulationSpeed.setMajorTickSpacing(10);
        this.simulationSpeed.setPaintLabels(false);
        this.simulationSpeed.setPaintTicks(true);
        this.simulationSpeed.setPaintTrack(false);
        this.simulationSpeed.setPreferredSize(new Dimension(340, this.simulationSpeed.getPreferredSize().height));
        this.simulationSpeed.addChangeListener(e -> this.setDelay((100 - this.simulationSpeed.getValue()) * 20));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.randomSimulation, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.randomMode, gbc);
        this.setRandomTransitionMode(defaultIsRandomTrasition);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.add((Component)new JLabel("Set simulation speed:"), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.add((Component)this.simulationSpeed, gbc);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Simulation controller"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.initTimer();
    }

    private void setDelay(int delay) {
        this.timer.setInitialDelay(delay);
        this.timer.setDelay(delay);
        if (this.timer.isRunning()) {
            this.timer.restart();
        }
    }

    private void initTimer() {
        this.timer.setRepeats(true);
    }

    public boolean randomSimulation() {
        return this.randomSimulation.isSelected();
    }

    public void start() {
        this.timer.start();
        TAPAALGUI.getCurrentTab().getTransitionFiringComponent().updateFireButton();
    }

    public void stop() {
        this.timer.stop();
        TAPAALGUI.getCurrentTab().getTransitionFiringComponent().updateFireButton();
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public static void startSimulation() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        JButton stopSimulationButton = new JButton("Stop");
        stopSimulationButton.addActionListener(arg0 -> dialog.setVisible(false));
        SimulationControl.getInstance().showCheckbox(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 3, 0, 3);
        gbc.fill = 1;
        contentPane.add((Component)SimulationControl.getInstance(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(3, 3, 0, 3);
        gbc.gridy = 1;
        gbc.fill = 2;
        contentPane.add((Component)stopSimulationButton, gbc);
        dialog = new EscapableDialog(TAPAALGUI.getApp(), "Simulation controls", true);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                SimulationControl.getInstance().stop();
            }
        });
        SimulationControl.getInstance().start();
        dialog.getRootPane().setDefaultButton(stopSimulationButton);
        dialog.setContentPane(contentPane);
        dialog.pack();
        dialog.setResizable(false);
        int x = TAPAALGUI.getAppGui().getLocation().x + TAPAALGUI.getAppGui().getWidth() - dialog.getWidth() - 30;
        int y = TAPAALGUI.getAppGui().getLocation().y + 30;
        dialog.setLocation(x, y);
        dialog.setVisible(true);
    }

    public static void stopSimulation() {
        if (SimulationControl.getInstance().isRunning() && dialog.isVisible()) {
            dialog.setVisible(false);
        }
    }

    public boolean isRandomTransitionMode() {
        if (SimulationControl.getInstance().randomSimulation()) {
            return true;
        }
        return this.randomMode.isSelected();
    }

    public void setRandomTransitionMode(boolean randomTransition) {
        this.randomMode.setSelected(randomTransition);
    }

    public static boolean isRandomTransition() {
        if (instance != null) {
            return SimulationControl.getInstance().isRandomTransitionMode();
        }
        return defaultIsRandomTrasition;
    }

    public static void setDefaultIsRandomTransition(boolean delayEnabledTransitionIsRandomTransition) {
        defaultIsRandomTrasition = delayEnabledTransitionIsRandomTransition;
    }
}

