/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.animation;

import dk.aau.cs.verification.VerifyTAPN.TraceType;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ToolTipManager;
import net.tapaal.gui.petrinet.Template;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.graphicElements.Transition;

public class AnimationHistoryList
extends JList<String> {
    private TraceType lastShown = TraceType.NOT_EG;
    private final Map<Integer, String> itemTooltips = new HashMap<Integer, String>();
    private static final String deadlockString = "<html><i><font color=red>Deadlock</i></font></html>";
    private static final String delayForeverString = "<html><i><font color=red>Delay forever</i></font></html>";
    private static final String gotoString = "<html><i><font color=red>Goto *</i></font></html>";

    public AnimationHistoryList() {
        this.setModel(new DefaultListModel());
        this.setSelectionMode(0);
        ToolTipManager.sharedInstance().registerComponent(this);
        for (MouseListener mouseListener : this.getMouseListeners()) {
            if (mouseListener.getClass().getName().contains("ToolTipManager")) continue;
            this.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : this.getMouseMotionListeners()) {
            if (eventListener.getClass().getName().contains("ToolTipManager")) continue;
            this.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : this.getKeyListeners()) {
            this.removeKeyListener((KeyListener)eventListener);
        }
        this.setCellRenderer(new TooltipListCellRenderer());
    }

    public void addHistoryItem(String transitionName, boolean isExplicit) {
        if (this.lastShown == TraceType.NOT_EG) {
            this.getListModel().addElement(transitionName);
            this.setSelectedIndex(this.getListModel().size() - 1);
        } else {
            this.getListModel().add(this.getListModel().size() - 1, transitionName);
            this.setSelectedIndex(this.getListModel().size() - 2);
        }
        this.updateAccordingToDeadlock(isExplicit);
    }

    public void clearStepsForward(boolean isExplicit) {
        DefaultListModel<String> listModel = this.getListModel();
        int lastIndex = listModel.size() - 1;
        if (listModel.size() > 1 && this.getSelectedIndex() < lastIndex) {
            listModel.removeRange(this.getSelectedIndex() + 1, lastIndex);
        }
        this.lastShown = TraceType.NOT_EG;
        this.updateAccordingToDeadlock(isExplicit);
    }

    public void stepForward() {
        if (this.isStepForwardAllowed()) {
            int nextIndex = this.getSelectedIndex() + 1;
            this.setSelectedIndex(nextIndex);
        }
        this.layoutAdjustment();
    }

    public void stepBackwards() {
        if (this.isStepBackAllowed()) {
            int indexToMoveTo = this.getSelectedIndex() - 1;
            this.setSelectedIndex(indexToMoveTo);
        }
    }

    public boolean isStepForwardAllowed() {
        this.layoutAdjustment();
        if (this.lastShown != TraceType.EG_DEADLOCK) {
            return this.getSelectedIndex() < this.getListModel().size() - 1;
        }
        return this.getSelectedIndex() < this.getListModel().size() - 2;
    }

    public boolean isStepBackAllowed() {
        return this.getSelectedIndex() > 0;
    }

    public String getCurrentItem() {
        return this.getElement(this.getSelectedIndex());
    }

    public String getElement(int i) {
        return this.getListModel().get(i);
    }

    public DefaultListModel<String> getListModel() {
        return (DefaultListModel)this.getModel();
    }

    @Override
    public void setSelectedIndex(int index) {
        super.setSelectedIndex(index);
        this.ensureIndexIsVisible(index);
    }

    public void setTooltipForIndex(int index, String tooltip) {
        if (index >= 0 && index < this.getListModel().size()) {
            this.itemTooltips.put(index, tooltip);
        }
    }

    public void setTooltipForSelectedItem(String tooltip) {
        this.setTooltipForIndex(this.getSelectedIndex(), tooltip);
    }

    public void reset(boolean isExplicit) {
        this.getListModel().clear();
        this.getListModel().addElement("Initial Marking");
        this.setSelectedIndex(0);
        this.lastShown = TraceType.NOT_EG;
        this.updateAccordingToDeadlock(isExplicit);
        this.itemTooltips.clear();
    }

    public void setLastShown(TraceType tracetype) {
        if (this.lastShown != TraceType.NOT_EG) {
            this.getListModel().remove(this.getListModel().size() - 1);
        }
        this.lastShown = tracetype;
        switch (tracetype) {
            case EG_DEADLOCK: {
                this.getListModel().addElement(deadlockString);
                break;
            }
            case EG_DELAY_FOREVER: {
                this.getListModel().addElement(delayForeverString);
                break;
            }
            case EG_LOOP: {
                this.getListModel().addElement(gotoString);
            }
        }
        this.layoutAdjustment();
    }

    private void layoutAdjustment() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == this.getListModel().getSize() - 2) {
            this.setSelectedIndex(selectedIndex + 1);
            this.setSelectedIndex(selectedIndex);
        }
    }

    private void updateAccordingToDeadlock(boolean isExplicit) {
        if (isExplicit) {
            return;
        }
        if (this.lastShown == TraceType.EG_DELAY_FOREVER) {
            return;
        }
        for (Template t : TAPAALGUI.getCurrentTab().activeTemplates()) {
            for (Transition trans : t.guiModel().getTransitions()) {
                if (!trans.isTransitionEnabled() && !trans.isDelayEnabled()) continue;
                return;
            }
        }
        this.setLastShown(TraceType.EG_DEADLOCK);
    }

    private class TooltipListCellRenderer
    extends DefaultListCellRenderer {
        private TooltipListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (AnimationHistoryList.this.itemTooltips.containsKey(index)) {
                this.setToolTipText(AnimationHistoryList.this.itemTooltips.get(index));
            } else {
                this.setToolTipText(null);
            }
            return c;
        }
    }
}

