/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet.animation;

import dk.aau.cs.model.tapn.simulation.FiringMode;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.util.Require;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.swingcomponents.NonsearchableJComboBox;
import net.tapaal.swinghelpers.DecimalOnlyDocumentFilter;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.animation.Animator;

public class AnimationControlSidePanel
extends JPanel {
    private final Animator animator;
    private JButton okButton;
    private JSlider delaySlider;
    private int delayScale = 10;
    private static final String PRECISION_ERROR_MESSAGE = "The precision is limited to 5 decimal places, the number will be truncated.";
    private static final String PRECISION_ERROR_DIALOG_TITLE = "Precision of Time Delay Exceeded";
    private static final String TRACEBOX_DROPDOWN_TOOL_TIP = "Select a trace.";
    private JPanel sliderPanel;
    private JPanel timedelayPanel;
    JPanel firemode;
    private JComboBox traceBox;
    private JToolBar animationToolBar;
    public final JTextField TimeDelayField = new JTextField();
    final JComboBox<String> firermodebox;

    public AnimationControlSidePanel(Animator animator, TAPNLens lens) {
        Require.notNull((Object)animator, "Animator can't be null");
        this.animator = animator;
        this.setLayout(new GridBagLayout());
        this.firermodebox = new NonsearchableJComboBox<String>(Animator.FIRINGMODES);
        this.updateFiringModeComboBox();
        this.firermodebox.addActionListener(evt -> animator.setFiringmode((String)this.firermodebox.getSelectedItem()));
        this.animationToolBar = new JToolBar();
        this.animationToolBar.setFloatable(false);
        this.animationToolBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.animationToolBar.add(animator.stepbackwardAction);
        this.animationToolBar.add(animator.stepforwardAction);
        this.animationToolBar.setVisible(true);
        this.traceBox = new JComboBox(new DefaultComboBoxModel());
        this.traceBox.setPreferredSize(new Dimension(100, 27));
        this.traceBox.setToolTipText(TRACEBOX_DROPDOWN_TOOL_TIP);
        this.showTraceBox(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.animationToolBar, c);
        this.firemode = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel("Token selection: ");
        this.firemode.add(label);
        this.firemode.add(this.firermodebox);
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.firemode, c);
        this.initDelayTimePanel(this.animationToolBar);
        this.initDelaySlider();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Simulation Control"), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.setPreferredSize(new Dimension(275, 180));
        this.setMinimumSize(new Dimension(275, 180));
        this.initializeDocumentFilterForDelayInput();
        this.hideIrrelevantInformation(lens);
    }

    public void updateTraceBox(Map<String, TAPNNetworkTrace> traceMap) {
        if (traceMap.size() < 2) {
            this.showTraceBox(false);
            return;
        }
        Vector<String> tracesVector = new Vector<String>();
        for (Map.Entry<String, TAPNNetworkTrace> entry : traceMap.entrySet()) {
            tracesVector.add(entry.getKey());
        }
        this.traceBox.setModel(new DefaultComboBoxModel(tracesVector));
        this.traceBox.addItemListener(event -> {
            if (this.traceBox.getSelectedItem() != null && event.getStateChange() == 1) {
                this.animator.changeTrace(this.animator.getTraceMap().get(this.traceBox.getSelectedItem().toString()));
            }
        });
        this.showTraceBox(true);
        if (this.timedelayPanel.isVisible()) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 0.5;
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.insets = new Insets(10, 0, 0, 0);
            this.add((Component)this.traceBox, gbc);
        } else {
            this.animationToolBar.add(Box.createHorizontalStrut(10));
            this.animationToolBar.add(this.traceBox);
        }
        this.remove(this.animationToolBar);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.animationToolBar, c);
    }

    public void resetPlacementOfAnimationToolBar() {
        this.remove(this.animationToolBar);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.animationToolBar, c);
    }

    private void showTraceBox(boolean shouldShow) {
        this.traceBox.setEnabled(shouldShow);
        this.traceBox.setVisible(shouldShow);
    }

    public void resetTraceBox(boolean shouldHideTraceBox) {
        if (shouldHideTraceBox) {
            this.showTraceBox(false);
        }
        this.traceBox.removeAllItems();
    }

    public JComboBox getTraceBox() {
        return this.traceBox;
    }

    private void hideIrrelevantInformation(TAPNLens lens) {
        this.sliderPanel.setVisible(lens.isTimed());
        this.timedelayPanel.setVisible(lens.isTimed());
        this.firemode.setVisible(lens.isTimed());
        if (!lens.isTimed()) {
            this.setPreferredSize(new Dimension(275, 50));
            this.setMinimumSize(new Dimension(275, 50));
        }
    }

    private void initDelaySlider() {
        this.sliderPanel = new JPanel(new FlowLayout(1));
        JButton decrese = new JButton("-");
        decrese.setPreferredSize(new Dimension(20, 30));
        decrese.addActionListener(e -> {
            this.setDelayModeScale(this.delayScale / 2);
            this.delaySlider.setValue(this.delaySlider.getValue() * 2);
        });
        this.sliderPanel.add(decrese);
        this.delaySlider = new JSlider(0, 160);
        this.delaySlider.setSnapToTicks(false);
        this.delaySlider.setMajorTickSpacing(10);
        this.delaySlider.setMinorTickSpacing(0);
        this.delaySlider.setPaintLabels(true);
        this.delaySlider.setPaintTicks(true);
        this.delaySlider.addChangeListener(e -> {
            this.TimeDelayField.setText(Double.toString((double)this.delaySlider.getValue() * (double)this.delayScale / 160.0));
            this.animator.reportBlockingPlaces();
        });
        this.delaySlider.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AnimationControlSidePanel.this.addTimeDelayToHistory();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AnimationControlSidePanel.this.animator.reportBlockingPlaces();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.setDelayModeScale(16);
        this.sliderPanel.add(this.delaySlider);
        JButton increse = new JButton("+");
        increse.setPreferredSize(new Dimension(20, 30));
        increse.addActionListener(e -> {
            this.setDelayModeScale(this.delayScale * 2);
            this.delaySlider.setValue(this.delaySlider.getValue() / 2);
        });
        this.sliderPanel.add(increse);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.sliderPanel, c);
    }

    private void setDelayModeScale(int scale) {
        if (scale == 0) {
            return;
        }
        this.delayScale = scale;
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(0, new JLabel("0"));
        labels.put(160, new JLabel(Integer.toString(this.delayScale)));
        this.delaySlider.setLabelTable(labels);
    }

    private void initDelayTimePanel(JToolBar animationToolBar) {
        this.timedelayPanel = new JPanel(new FlowLayout(0));
        this.okButton = new JButton();
        this.okButton.setText("Time delay");
        this.okButton.setMinimumSize(new Dimension(75, 25));
        this.okButton.addActionListener(evt -> this.addTimeDelayToHistory());
        this.okButton.addMouseListener(new MouseAdapter(){
            final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
            final int defaultInitalDelay = ToolTipManager.sharedInstance().getInitialDelay();
            final int defaultReshowDelay = ToolTipManager.sharedInstance().getReshowDelay();
            final boolean isTooltipEnabled = ToolTipManager.sharedInstance().isEnabled();
            final int dismissDelayMinutes = Integer.MAX_VALUE;

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
                ToolTipManager.sharedInstance().setInitialDelay(0);
                ToolTipManager.sharedInstance().setReshowDelay(0);
                ToolTipManager.sharedInstance().setEnabled(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
                ToolTipManager.sharedInstance().setInitialDelay(this.defaultInitalDelay);
                ToolTipManager.sharedInstance().setReshowDelay(this.defaultReshowDelay);
                ToolTipManager.sharedInstance().setEnabled(this.isTooltipEnabled);
            }
        });
        this.TimeDelayField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AnimationControlSidePanel.this.addTimeDelayToHistory();
                    AnimationControlSidePanel.this.TimeDelayField.getFocusCycleRootAncestor().requestFocus();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                AnimationControlSidePanel.this.animator.reportBlockingPlaces();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.TimeDelayField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                AnimationControlSidePanel.this.setStepShotcutEnabled(true);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                AnimationControlSidePanel.this.setStepShotcutEnabled(false);
            }
        });
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        df.setMinimumFractionDigits(5);
        this.TimeDelayField.setText(df.format(1.0));
        this.TimeDelayField.setColumns(6);
        this.timedelayPanel.add(this.TimeDelayField);
        this.timedelayPanel.add(this.okButton);
        animationToolBar.add(this.timedelayPanel);
    }

    void setStepShotcutEnabled(boolean enabled) {
        if (enabled) {
            this.animator.stepforwardAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("pressed RIGHT"));
            this.animator.stepbackwardAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("pressed LEFT"));
        } else {
            this.animator.stepforwardAction.putValue("AcceleratorKey", null);
            this.animator.stepbackwardAction.putValue("AcceleratorKey", null);
        }
    }

    public void updateFiringModeComboBox() {
        FiringMode currentFiringMode = this.animator.getFiringmode();
        if (currentFiringMode == null) {
            this.firermodebox.setSelectedItem("Manual");
        } else {
            this.firermodebox.setSelectedItem(currentFiringMode.toString());
        }
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    private void addTimeDelayToHistory() {
        try {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(5);
            df.setMinimumFractionDigits(5);
            df.applyLocalizedPattern("#.#");
            DecimalFormat parser = new DecimalFormat();
            parser.setMaximumFractionDigits(5);
            parser.setMinimumFractionDigits(5);
            Number parseTime = parser.parse(this.TimeDelayField.getText());
            BigDecimal timeDelayToSet = new BigDecimal(parseTime.toString(), new MathContext(9));
            if (timeDelayToSet.compareTo(new BigDecimal(0L)) < 0) {
                System.err.println("Illegal value");
            } else {
                this.animator.letTimePass(timeDelayToSet);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.animator.updateAnimationButtonsEnabled();
    }

    public BigDecimal getCurrentDelay() throws NumberFormatException, ParseException {
        String oldText = this.TimeDelayField.getText();
        char localDecimalseparator = DecimalFormatSymbols.getInstance().getDecimalSeparator();
        if (Pattern.matches("^(([1-9]([0-9])*)?|0)(" + Pattern.quote(Character.toString(localDecimalseparator)) + "([0-9]){6,})?$", oldText) && oldText.indexOf(46) != -1) {
            this.TimeDelayField.setText(oldText.substring(0, oldText.indexOf(46) + 6));
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), PRECISION_ERROR_MESSAGE, PRECISION_ERROR_DIALOG_TITLE, 1);
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(5);
        df.setMinimumFractionDigits(5);
        df.applyLocalizedPattern("#.#");
        DecimalFormat parser = new DecimalFormat();
        parser.setMaximumFractionDigits(5);
        parser.setMinimumFractionDigits(5);
        Number parseTime = parser.parse(this.TimeDelayField.getText());
        return new BigDecimal(parseTime.toString(), new MathContext(9));
    }

    private void initializeDocumentFilterForDelayInput() {
        Document doc = this.TimeDelayField.getDocument();
        ((AbstractDocument)doc).setDocumentFilter(new DecimalOnlyDocumentFilter(5));
    }
}

