/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class Searcher<T> {
    private final Collection<T> items;
    private final Function<T, String> nameExtractor;

    public Searcher(Collection<T> items, Function<T, String> nameExtractor) {
        this.items = items;
        this.nameExtractor = nameExtractor;
    }

    public List<T> findAllMatches(String query) {
        if (query == null || query.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> matches = new ArrayList<T>();
        String lowerQuery = query.toLowerCase();
        for (T item : this.items) {
            String name = this.nameExtractor.apply(item);
            String lowerName = name.toLowerCase();
            if (!lowerName.contains(lowerQuery)) continue;
            matches.add(item);
        }
        matches.sort(Comparator.comparing(this.nameExtractor, String.CASE_INSENSITIVE_ORDER));
        return matches;
    }
}

