/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet;

import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.util.Tuple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchBar
extends JPanel {
    private static final String SEARCH_TOOLTIP = "Search for places and transitions in the net";
    private static final Color HIGHLIGHT_COLOR = new Color(230, 230, 250);
    private final JLabel searchLabel;
    private final JTextField searchField;
    private final JPopupMenu resultsPopup;
    private Consumer<String> onSearchTextChanged;
    private Consumer<Tuple<?, String>> onResultSelected;
    private Runnable onFocusGained;
    private Runnable onFocusLost;
    private List<Tuple<?, String>> currentMatches;
    private List<JButton> resultButtons = new ArrayList<JButton>();
    private int selectedIndex = -1;
    private int maxVisibleItems = 10;
    private boolean useSharedPrefix = true;

    public SearchBar() {
        this("");
    }

    public SearchBar(String label) {
        super(new BorderLayout());
        this.searchLabel = new JLabel(label);
        this.searchField = new JTextField();
        this.searchField.setToolTipText(SEARCH_TOOLTIP);
        this.add((Component)this.searchLabel, "West");
        this.add((Component)this.searchField, "Center");
        this.resultsPopup = new JPopupMenu();
        this.resultsPopup.setLayout(new BoxLayout(this.resultsPopup, 1));
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchBar.this.notifySearchTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchBar.this.notifySearchTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchBar.this.notifySearchTextChanged();
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SearchBar.this.resultsPopup.isVisible() && !SearchBar.this.resultButtons.isEmpty()) {
                    if (e.getKeyCode() == 40) {
                        SearchBar.this.selectNextMatch();
                        e.consume();
                    } else if (e.getKeyCode() == 38) {
                        SearchBar.this.selectPreviousMatch();
                        e.consume();
                    } else if (e.getKeyCode() == 10) {
                        if (SearchBar.this.currentMatches != null && !SearchBar.this.currentMatches.isEmpty()) {
                            if (SearchBar.this.selectedIndex >= 0 && SearchBar.this.selectedIndex < SearchBar.this.currentMatches.size()) {
                                if (SearchBar.this.onResultSelected != null) {
                                    SearchBar.this.onResultSelected.accept(SearchBar.this.currentMatches.get(SearchBar.this.selectedIndex));
                                }
                            } else if (!SearchBar.this.currentMatches.isEmpty() && SearchBar.this.onResultSelected != null) {
                                SearchBar.this.onResultSelected.accept(SearchBar.this.currentMatches.get(0));
                            }
                        }
                        e.consume();
                    }
                }
            }
        });
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                int endIdx = SearchBar.this.searchField.getText().length();
                SearchBar.this.searchField.setSelectionStart(endIdx);
                SearchBar.this.searchField.setSelectionEnd(endIdx);
                if (SearchBar.this.onFocusGained != null) {
                    SearchBar.this.onFocusGained.run();
                }
            }

            @Override
            public void focusLost(FocusEvent evt) {
                if (!evt.isTemporary()) {
                    SearchBar.this.hideResults();
                    if (SearchBar.this.onFocusLost != null) {
                        SearchBar.this.onFocusLost.run();
                    }
                }
            }
        });
    }

    private void selectMatch(int direction) {
        int newIndex;
        if (this.resultButtons.isEmpty()) {
            return;
        }
        if (this.selectedIndex >= 0 && this.selectedIndex < this.resultButtons.size()) {
            this.resultButtons.get(this.selectedIndex).setBackground(Color.WHITE);
        }
        if ((newIndex = this.selectedIndex + direction) < 0) {
            newIndex = 0;
        } else if (newIndex >= this.resultButtons.size()) {
            newIndex = this.resultButtons.size() - 1;
        }
        this.selectedIndex = newIndex;
        JButton selected = this.resultButtons.get(this.selectedIndex);
        selected.setBackground(HIGHLIGHT_COLOR);
        JScrollPane scrollPane = null;
        if (this.resultsPopup.getComponentCount() > 0 && this.resultsPopup.getComponent(0) instanceof JScrollPane) {
            scrollPane = (JScrollPane)this.resultsPopup.getComponent(0);
        }
        if (scrollPane != null) {
            Rectangle viewRect = scrollPane.getViewport().getViewRect();
            Rectangle buttonBounds = selected.getBounds();
            if (buttonBounds.y < viewRect.y) {
                scrollPane.getVerticalScrollBar().setValue(buttonBounds.y);
            } else if (buttonBounds.y + buttonBounds.height > viewRect.y + viewRect.height) {
                int newValue = buttonBounds.y + buttonBounds.height - viewRect.height;
                scrollPane.getVerticalScrollBar().setValue(newValue);
            }
        }
    }

    private void selectNextMatch() {
        this.selectMatch(1);
    }

    private void selectPreviousMatch() {
        this.selectMatch(-1);
    }

    public void setOnFocusGained(Runnable callback) {
        this.onFocusGained = callback;
    }

    public void setOnFocusLost(Runnable callback) {
        this.onFocusLost = callback;
    }

    public void setOnSearchTextChanged(Consumer<String> consumer) {
        this.onSearchTextChanged = consumer;
    }

    public void setOnResultSelected(Consumer<Tuple<?, String>> consumer) {
        this.onResultSelected = consumer;
    }

    public String getSearchText() {
        return this.searchField.getText();
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    private void notifySearchTextChanged() {
        if (this.onSearchTextChanged != null) {
            this.onSearchTextChanged.accept(this.searchField.getText());
        }
    }

    public void useSharedPrefix(boolean useSharedPrefix) {
        this.useSharedPrefix = useSharedPrefix;
    }

    public void showResults(List<Tuple<?, String>> matches) {
        this.currentMatches = matches;
        this.resultButtons.clear();
        this.selectedIndex = -1;
        this.resultsPopup.removeAll();
        int width = this.searchField.getWidth();
        if (matches == null || matches.isEmpty()) {
            JPanel noResultsPanel = new JPanel(new BorderLayout());
            noResultsPanel.setBackground(Color.WHITE);
            JLabel noResults = new JLabel("No matches found");
            noResults.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            noResults.setForeground(Color.GRAY);
            noResultsPanel.add((Component)noResults, "West");
            this.resultsPopup.add(noResultsPanel);
            this.resultsPopup.setPreferredSize(new Dimension(width, 30));
        } else {
            JPanel resultsPanel = new JPanel();
            resultsPanel.setLayout(new BoxLayout(resultsPanel, 1));
            resultsPanel.setBackground(Color.WHITE);
            int i = 0;
            while (i < matches.size()) {
                Tuple<?, String> match = matches.get(i);
                Object firstElem = match.value1();
                boolean isShared = firstElem instanceof TimedPlace && ((TimedPlace)firstElem).isShared() || firstElem instanceof TimedTransition && ((TimedTransition)firstElem).isShared();
                String firstElemStr = firstElem.toString();
                if (isShared && firstElem instanceof TimedTransition && firstElemStr.contains(".")) {
                    firstElemStr = firstElemStr.split("\\.")[1];
                }
                String matchStr = firstElem instanceof TimedTransition ? (isShared ? (String)(this.useSharedPrefix ? match.value2() + "." : "") + firstElemStr + " (shared transition)" : firstElemStr + " (transition)") : (isShared ? (String)(this.useSharedPrefix ? match.value2() + "." : "") + firstElemStr + " (shared place)" : firstElemStr + " (place)");
                final JButton resultButton = new JButton(matchStr);
                this.resultButtons.add(resultButton);
                resultButton.setHorizontalAlignment(2);
                resultButton.setBorderPainted(false);
                resultButton.setBackground(Color.WHITE);
                resultButton.setFocusPainted(false);
                resultButton.setOpaque(true);
                resultButton.setFocusable(false);
                resultButton.addActionListener(e -> {
                    if (this.onResultSelected != null) {
                        this.onResultSelected.accept(match);
                    }
                });
                final int index = i++;
                resultButton.addMouseListener(new MouseAdapter(this){
                    final /* synthetic */ SearchBar this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (this.this$0.selectedIndex >= 0 && this.this$0.selectedIndex < this.this$0.resultButtons.size()) {
                            this.this$0.resultButtons.get(this.this$0.selectedIndex).setBackground(Color.WHITE);
                        }
                        resultButton.setBackground(HIGHLIGHT_COLOR);
                        this.this$0.selectedIndex = index;
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (this.this$0.selectedIndex != index) {
                            resultButton.setBackground(Color.WHITE);
                        }
                    }
                });
                resultButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, resultButton.getPreferredSize().height));
                resultsPanel.add(resultButton);
            }
            int itemHeight = this.resultButtons.get((int)0).getPreferredSize().height;
            int itemCount = matches.size();
            boolean needsScrolling = itemCount > this.maxVisibleItems;
            int visibleItems = needsScrolling ? this.maxVisibleItems : itemCount;
            int height = visibleItems * itemHeight + 4;
            if (needsScrolling) {
                JScrollPane scrollPane = new JScrollPane(resultsPanel);
                scrollPane.setBorder(null);
                scrollPane.setHorizontalScrollBarPolicy(31);
                scrollPane.setVerticalScrollBarPolicy(20);
                this.resultsPopup.add(scrollPane);
            } else {
                this.resultsPopup.add(resultsPanel);
            }
            this.resultsPopup.setPreferredSize(new Dimension(width, height));
        }
        if (this.resultsPopup.getComponentCount() > 0) {
            this.resultsPopup.pack();
            this.resultsPopup.show(this.searchField, 0, this.searchField.getHeight());
            SwingUtilities.invokeLater(() -> {
                this.searchField.requestFocusInWindow();
                if (!this.resultButtons.isEmpty()) {
                    this.selectedIndex = 0;
                    this.resultButtons.get(0).setBackground(HIGHLIGHT_COLOR);
                }
            });
        } else {
            this.hideResults();
        }
    }

    public void hideResults() {
        this.resultsPopup.setVisible(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.searchField.setEnabled(enabled);
    }

    @Override
    public boolean isFocusOwner() {
        return this.searchField.isFocusOwner();
    }

    public void clear() {
        this.searchField.setText("");
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.searchField.requestFocusInWindow();
    }

    public void setMaxVisibleItems(int maxVisibleItems) {
        this.maxVisibleItems = maxVisibleItems;
    }
}

