/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.petrinet;

import dk.aau.cs.TCTL.CTLParsing.TAPAALCTLQueryParser;
import dk.aau.cs.TCTL.HyperLTLParsing.TAPAALHyperLTLQueryParser;
import dk.aau.cs.TCTL.LTLParsing.TAPAALLTLQueryParser;
import dk.aau.cs.TCTL.TCTLAbstractProperty;
import dk.aau.cs.TCTL.TCTLPathPlaceHolder;
import dk.aau.cs.TCTL.visitors.CTLQueryVisitor;
import dk.aau.cs.TCTL.visitors.HyperLTLQueryVisitor;
import dk.aau.cs.TCTL.visitors.LTLQueryVisitor;
import dk.aau.cs.TCTL.visitors.RenameAllPlacesVisitor;
import dk.aau.cs.TCTL.visitors.RenameAllTransitionsVisitor;
import dk.aau.cs.TCTL.visitors.SMCQueryVisitor;
import dk.aau.cs.io.PNMLWriter;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNExporter;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.tapaal.export.TikZExporter;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import org.w3c.dom.DOMException;
import pipe.gui.MessengerImpl;
import pipe.gui.TAPAALGUI;
import pipe.gui.canvas.DrawingSurfaceImpl;
import pipe.gui.canvas.Grid;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.swingcomponents.filebrowser.FileBrowser;

public class Export {
    public static final int PNG = 1;
    public static final int POSTSCRIPT = 2;
    public static final int PRINTER = 3;
    public static final int TIKZ = 5;
    public static final int PNML = 6;
    public static final int QUERY = 7;

    private static void toPnml(DrawingSurfaceImpl g, String filename, PetriNetTab tab) throws NullPointerException, DOMException, IOException, ParserConfigurationException, TransformerException {
        NetworkMarking currentMarking = null;
        if (tab.isInAnimationMode()) {
            currentMarking = tab.network().marking();
            tab.network().setMarking(tab.getAnimator().getInitialMarking());
        }
        PNMLWriter tapnWriter = new PNMLWriter(tab.network(), tab.getGuiModels(), tab.getLens());
        tapnWriter.savePNML(new File(filename));
        if (tab.isInAnimationMode()) {
            tab.network().setMarking(currentMarking);
        }
    }

    private static void toQueryXML(String filename, TAPNLens lens, PetriNetTab tab) {
        Export.toQueryXML(tab.network(), filename, tab.queries(), lens);
    }

    public static void toQueryXML(TimedArcPetriNetNetwork network, String filename, Iterable<net.tapaal.gui.petrinet.verification.TAPNQuery> queries, TAPNLens lens) {
        try {
            TAPNComposer composer = new TAPNComposer(new MessengerImpl(), true);
            NameMapping mapping = composer.transformModel(network).value2();
            Iterator<net.tapaal.gui.petrinet.verification.TAPNQuery> queryIterator = queries.iterator();
            PrintStream queryStream = new PrintStream(filename);
            LTLQueryVisitor LTLXMLVisitor = new LTLQueryVisitor();
            HyperLTLQueryVisitor HyperLTLXMLVisitor = new HyperLTLQueryVisitor();
            CTLQueryVisitor CTLXMLVisitor = new CTLQueryVisitor();
            SMCQueryVisitor SMCXMLVisitor = new SMCQueryVisitor();
            while (queryIterator.hasNext()) {
                TCTLAbstractProperty newProperty;
                boolean isCTL = false;
                boolean isHyperLTL = false;
                boolean isSMC = false;
                net.tapaal.gui.petrinet.verification.TAPNQuery clonedQuery = queryIterator.next().copy();
                try {
                    if (clonedQuery.getCategory().equals((Object)TAPNQuery.QueryCategory.LTL)) {
                        newProperty = TAPAALLTLQueryParser.parse(clonedQuery.getProperty().toString());
                    } else if (clonedQuery.getCategory().equals((Object)TAPNQuery.QueryCategory.HyperLTL)) {
                        isHyperLTL = true;
                        newProperty = TAPAALHyperLTLQueryParser.parse(clonedQuery.getProperty().toString());
                    } else if (clonedQuery.getCategory().equals((Object)TAPNQuery.QueryCategory.SMC)) {
                        isSMC = true;
                        newProperty = TAPAALLTLQueryParser.parse(clonedQuery.getProperty().toString());
                    } else {
                        newProperty = TAPAALCTLQueryParser.parse(clonedQuery.getProperty().toString());
                        isCTL = true;
                    }
                }
                catch (Throwable ex) {
                    newProperty = clonedQuery == null ? new TCTLPathPlaceHolder() : clonedQuery.getProperty();
                }
                ((TCTLAbstractProperty)newProperty).accept(new RenameAllPlacesVisitor(mapping), null);
                ((TCTLAbstractProperty)newProperty).accept(new RenameAllTransitionsVisitor(mapping), null);
                if (isHyperLTL) {
                    HyperLTLXMLVisitor.buildXMLQuery(newProperty, clonedQuery.getName());
                    continue;
                }
                if (isSMC) {
                    SMCXMLVisitor.buildXMLQuery(newProperty, clonedQuery.getName(), clonedQuery.getSmcSettings());
                    continue;
                }
                if (!isCTL) {
                    LTLXMLVisitor.buildXMLQuery(newProperty, clonedQuery.getName());
                    continue;
                }
                CTLXMLVisitor.buildXMLQuery(newProperty, clonedQuery.getName(), lens != null && lens.isGame());
            }
            queryStream.append(HyperLTLXMLVisitor.getFormatted(LTLXMLVisitor.getXMLQuery(), CTLXMLVisitor.getXMLQuery()));
            queryStream.close();
        }
        catch (FileNotFoundException e) {
            System.err.append("An error occurred while exporting the queries to XML.");
        }
    }

    public static void toVerifyTAPN(TimedArcPetriNetNetwork network, Iterable<net.tapaal.gui.petrinet.verification.TAPNQuery> queries, String modelFile, String queryFile, boolean isDTAPN) {
        VerifyTAPNExporter exporter = new VerifyTAPNExporter();
        TAPNComposer composer = new TAPNComposer(new MessengerImpl(), false);
        Tuple<TimedArcPetriNet, NameMapping> transformedModel = composer.transformModel(network);
        TimedArcPetriNet model = transformedModel.value1();
        TAPNLens lens = new TAPNLens(!model.isUntimed(), model.hasUncontrollableTransitions(), model.isColored(), model.isStochastic());
        RenameAllPlacesVisitor visitor = new RenameAllPlacesVisitor(transformedModel.value2());
        int i = 0;
        for (net.tapaal.gui.petrinet.verification.TAPNQuery query : queries) {
            query.getProperty().accept(visitor, null);
            ++i;
            if (lens.isGame() && isDTAPN) {
                exporter.export(model, new TAPNQuery(query.getProperty(), 0, query.getSmcSettings()), new File(modelFile), new File(queryFile + i + ".xml"), null, lens, transformedModel.value2(), composer.getGuiModel());
                continue;
            }
            exporter.export(model, new TAPNQuery(query.getProperty(), 0, query.getSmcSettings()), new File(modelFile), new File(queryFile + i + ".xml"), null, new TAPNLens(true, false, lens.isColored(), lens.isStochastic()), transformedModel.value2(), composer.getGuiModel());
        }
    }

    public static void toPostScript(Object g, String filename) throws PrintException, IOException {
        DocFlavor.SERVICE_FORMATTED flavour = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavour, psMimeType);
        if (factories.length == 0) {
            throw new RuntimeException("No suitable factory found for export to PS");
        }
        FileOutputStream f = new FileOutputStream(filename);
        factories[0].getPrintService(f).createPrintJob().print(new SimpleDoc(g, flavour, null), new HashPrintRequestAttributeSet());
        f.close();
    }

    public static void toPNG(DrawingSurfaceImpl g, String filename) throws IOException {
        Iterator<ImageWriter> i = ImageIO.getImageWritersBySuffix("png");
        if (!i.hasNext()) {
            throw new RuntimeException("No ImageIO exporters can handle PNG");
        }
        File f = new File(filename);
        BufferedImage img = new BufferedImage(g.getPreferredSize().width, g.getPreferredSize().height, 5);
        g.print(img.getGraphics());
        Rectangle r = g.calculateBoundingRectangle();
        BufferedImage croppedImg = img.getSubimage(r.x, r.y, r.width, r.height);
        ImageIO.write((RenderedImage)croppedImg, "png", f);
    }

    private static void toPrinter(DrawingSurfaceImpl g) throws PrintException {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat pf = pjob.defaultPage();
        pjob.setPrintable(g, pf);
        if (pjob.printDialog()) {
            try {
                pjob.print();
            }
            catch (PrinterException e) {
                throw new PrintException(e);
            }
        }
    }

    public static void exportGuiView(DrawingSurfaceImpl g, int format, DataLayer model, TAPNLens lens, PetriNetTab tab) {
        if (g.getComponentCount() == 0) {
            return;
        }
        Object filename = null;
        filename = tab.getTabTitle();
        int dotpos = ((String)filename).lastIndexOf(46);
        if (dotpos > ((String)filename).lastIndexOf(System.getProperty("file.separator"))) {
            filename = ((String)filename).substring(0, dotpos + 1);
            switch (format) {
                case 1: {
                    filename = (String)filename + "png";
                    break;
                }
                case 2: {
                    filename = (String)filename + "ps";
                    break;
                }
                case 5: {
                    filename = (String)filename + "tex";
                    break;
                }
                case 6: {
                    filename = (String)filename + "pnml";
                    break;
                }
                case 7: {
                    filename = ((String)filename).substring(0, dotpos);
                    filename = (String)filename + "-queries.xml";
                }
            }
        }
        boolean gridEnabled = Grid.isEnabled();
        Export.setupViewForExport(g, gridEnabled);
        try {
            switch (format) {
                case 1: {
                    filename = FileBrowser.constructor("PNG image", "png", (String)filename).saveFile();
                    if (filename == null) break;
                    Export.toPNG(g, (String)filename);
                    break;
                }
                case 2: {
                    filename = FileBrowser.constructor("PostScript file", "ps", (String)filename).saveFile();
                    if (filename == null) break;
                    Export.toPostScript(g, (String)filename);
                    break;
                }
                case 3: {
                    Export.toPrinter(g);
                    break;
                }
                case 5: {
                    Object[] possibilities = new Object[]{"Only the TikZ figure", "Full compilable LaTex including your figure"};
                    String figureOptions = (String)JOptionPane.showInputDialog(TAPAALGUI.getApp(), "Choose how you would like your TikZ figure outputted: \n", "Export to TikZ", -1, null, possibilities, "Only the TikZ figure");
                    TikZExporter.TikZOutputOption tikZOption = TikZExporter.TikZOutputOption.FIGURE_ONLY;
                    if (figureOptions == null) break;
                    if (figureOptions == possibilities[0]) {
                        tikZOption = TikZExporter.TikZOutputOption.FIGURE_ONLY;
                    }
                    if (figureOptions == possibilities[1]) {
                        tikZOption = TikZExporter.TikZOutputOption.FULL_LATEX;
                    }
                    if ((filename = FileBrowser.constructor("TikZ figure", "tex", (String)filename).saveFile()) == null) break;
                    TikZExporter output = new TikZExporter(model, (String)filename, tikZOption);
                    output.ExportToTikZ();
                    break;
                }
                case 6: {
                    filename = FileBrowser.constructor("PNML file", "pnml", (String)filename).saveFile();
                    if (filename == null) break;
                    Export.toPnml(g, (String)filename, tab);
                    break;
                }
                case 7: {
                    filename = FileBrowser.constructor("Query XML file", "xml", (String)filename).saveFile((String)filename);
                    if (filename == null) break;
                    Export.toQueryXML((String)filename, lens, tab);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(TAPAALGUI.getApp(), "There were errors performing the requested action:\n" + String.valueOf(e), "Error", 0);
        }
        Export.resetViewAfterExport(g, gridEnabled);
    }

    private static void resetViewAfterExport(DrawingSurfaceImpl g, boolean gridEnabled) {
        if (gridEnabled) {
            Grid.enableGrid();
        }
        g.repaint();
    }

    private static void setupViewForExport(DrawingSurfaceImpl g, boolean gridEnabled) {
        g.updatePreferredSize();
        if (gridEnabled) {
            Grid.disableGrid();
        }
    }
}

