/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.graph;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.WrapLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import pipe.gui.TAPAALGUI;
import pipe.gui.graph.ColorGenerator;
import pipe.gui.graph.DraggableChartPanel;
import pipe.gui.graph.Graph;
import pipe.gui.graph.GraphDialog;
import pipe.gui.graph.GraphExporter;
import pipe.gui.graph.GraphPoint;
import pipe.gui.graph.MultiGraph;
import pipe.gui.swingcomponents.EscapableDialog;

public class ObservationGraphDialog
extends EscapableDialog
implements GraphDialog {
    private final List<MultiGraph> multiGraphs;
    private final boolean showGlobalAverages;
    private final boolean isSimulate;
    private final Map<String, JCheckBox> observationCheckboxes = new HashMap<String, JCheckBox>();
    private final Map<String, JCheckBox> propertyCheckboxes = new HashMap<String, JCheckBox>();
    private JFreeChart currentChart;
    private String currentView;

    private ObservationGraphDialog(List<MultiGraph> multiGraphs, String title, boolean showGlobalAverages, boolean isSimulate) {
        super(TAPAALGUI.getAppGui(), title, true);
        this.multiGraphs = multiGraphs;
        this.showGlobalAverages = showGlobalAverages;
        this.isSimulate = isSimulate;
    }

    @Override
    public void display() {
        if (this.multiGraphs.isEmpty()) {
            return;
        }
        this.resetState();
        this.displayMultiView();
        this.setupDialog();
    }

    private void resetState() {
        this.observationCheckboxes.clear();
        this.propertyCheckboxes.clear();
        this.currentChart = null;
        this.currentView = null;
        this.getContentPane().removeAll();
    }

    private void displayMultiView() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        CardLayout cardLayout = new CardLayout();
        JPanel cardPanel = new JPanel(cardLayout);
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel observationPanel = new JPanel((LayoutManager)new WrapLayout(1));
        JPanel buttonPanel = new JPanel();
        observationPanel.setBackground(Color.WHITE);
        buttonPanel.setBackground(Color.WHITE);
        TreeSet<String> observationNames = new TreeSet<String>();
        for (MultiGraph multiGraph : this.multiGraphs) {
            observationNames.addAll(multiGraph.getMultiGraphMap().keySet());
        }
        String firstObservation = (String)observationNames.iterator().next();
        for (String string : observationNames) {
            JCheckBox obsCheckBox = new JCheckBox(string);
            obsCheckBox.setBackground(Color.WHITE);
            obsCheckBox.setSelected(string.equals(firstObservation));
            obsCheckBox.addActionListener(e -> this.updateVisibility());
            this.observationCheckboxes.put(string, obsCheckBox);
            observationPanel.add(obsCheckBox);
        }
        MultiGraph multiGraph = this.multiGraphs.get(0);
        this.currentView = multiGraph.getButtonText();
        for (MultiGraph multiGraph2 : this.multiGraphs) {
            JFreeChart chart = this.createChart(multiGraph2);
            DraggableChartPanel chartPanel = this.createChartPanel(chart);
            String buttonText = multiGraph2.getButtonText();
            cardPanel.add((Component)((Object)chartPanel), buttonText);
            this.addButton(buttonPanel, cardLayout, cardPanel, buttonText);
        }
        if (!this.isSimulate) {
            for (String label : List.of("Avg", "Min", "Max")) {
                JCheckBox checkBox = new JCheckBox(label);
                checkBox.setBackground(Color.WHITE);
                checkBox.setSelected(label.equals("Avg"));
                checkBox.addActionListener(e -> this.updateVisibility());
                this.propertyCheckboxes.put(label, checkBox);
                buttonPanel.add(checkBox);
            }
        }
        JScrollPane jScrollPane = new JScrollPane(observationPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JPanel buttonPanelWrapper = new JPanel(new BorderLayout());
        buttonPanelWrapper.setBackground(Color.WHITE);
        JPanel exportPanel = new JPanel(new BorderLayout());
        JButton exportButton = new JButton("Export to TikZ");
        exportButton.addActionListener(e -> {
            MultiGraph currentMultiGraph = this.getCurrentMultiGraph();
            if (currentMultiGraph != null) {
                MultiGraph exportGraph = currentMultiGraph.copy();
                Map<String, Map<String, Graph>> multiGraphMap = exportGraph.getMultiGraphMap();
                multiGraphMap.entrySet().removeIf(entry -> {
                    String observation = (String)entry.getKey();
                    ((Map)entry.getValue()).entrySet().removeIf(propertyEntry -> {
                        String property = (String)propertyEntry.getKey();
                        String seriesKey = observation + " - " + property;
                        return !this.isSeriesVisible(seriesKey);
                    });
                    return ((Map)entry.getValue()).isEmpty();
                });
                GraphExporter.exportToTikz(exportGraph, this, this.getBaseColors(this.currentChart.getXYPlot().getDataset()));
            }
        });
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        buttonWrapper.setBackground(Color.WHITE);
        buttonWrapper.add(exportButton);
        exportPanel.add((Component)buttonWrapper, "East");
        exportPanel.setBackground(Color.WHITE);
        buttonPanelWrapper.add((Component)buttonPanel, "Center");
        buttonPanelWrapper.add((Component)exportPanel, "South");
        southPanel.add((Component)jScrollPane, "North");
        southPanel.add((Component)buttonPanelWrapper, "South");
        mainPanel.add((Component)cardPanel, "Center");
        mainPanel.add((Component)southPanel, "South");
        this.add((Component)mainPanel, "Center");
        this.currentChart = ((ChartPanel)cardPanel.getComponent(0)).getChart();
        this.updateVisibility();
        XYPlot plot = this.currentChart.getXYPlot();
        XYDataset dataset = plot.getDataset();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        plot.setFixedLegendItems(this.createCustomLegendItems(dataset, renderer, this.multiGraphs.get(0)));
    }

    private void updateVisibility() {
        XYPlot plot = this.currentChart.getXYPlot();
        XYDataset dataset = plot.getDataset();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        float lineThickness = 3.0f;
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            String seriesKey = (String)((Object)dataset.getSeriesKey(i));
            boolean visible = this.isSeriesVisible(seriesKey);
            renderer.setSeriesVisible(i, Boolean.valueOf(visible));
            renderer.setSeriesStroke(i, (Stroke)this.createStrokeForSeries(seriesKey, lineThickness));
        }
        renderer.setDrawSeriesLineAsPath(true);
        Map<String, Color> baseColors = this.getBaseColors(dataset);
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            String seriesKey = (String)((Object)dataset.getSeriesKey(i));
            String baseName = seriesKey.split(" - ")[0];
            if (!baseColors.containsKey(baseName)) continue;
            renderer.setSeriesPaint(i, (Paint)baseColors.get(baseName));
        }
    }

    private Map<String, Color> getBaseColors(XYDataset dataset) {
        HashMap<String, Color> baseColors = new HashMap<String, Color>();
        HashSet<String> uniqueBaseNames = new HashSet<String>();
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            String seriesKey = (String)((Object)dataset.getSeriesKey(i));
            String baseName = seriesKey.split(" - ")[0];
            uniqueBaseNames.add(baseName);
        }
        ColorGenerator colorGenerator = new ColorGenerator();
        for (String baseName : uniqueBaseNames) {
            baseColors.put(baseName, colorGenerator.nextColor());
        }
        return baseColors;
    }

    private BasicStroke createStrokeForSeries(String seriesKey, float lineThickness) {
        if (seriesKey.contains("Min")) {
            return new BasicStroke(lineThickness, 0, 0, 10.0f, new float[]{6.0f, 6.0f}, 0.0f);
        }
        if (seriesKey.contains("Max")) {
            return new BasicStroke(lineThickness, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
        }
        return new BasicStroke(lineThickness);
    }

    private boolean isSeriesVisible(String seriesKey) {
        String[] parts = seriesKey.split(" - ");
        String observation = parts[0];
        String property = parts[1];
        boolean obsSelected = this.observationCheckboxes.get(observation).isSelected();
        boolean propSelected = false;
        if (this.isSimulate) {
            return obsSelected;
        }
        String currentView = this.getCurrentView();
        for (Map.Entry<String, JCheckBox> entry : this.propertyCheckboxes.entrySet()) {
            String expectedProperty;
            if (!entry.getValue().isSelected() || !property.equals(expectedProperty = entry.getKey() + " " + currentView)) continue;
            propSelected = true;
            break;
        }
        return obsSelected && propSelected;
    }

    private String getCurrentView() {
        return this.currentView;
    }

    private MultiGraph getCurrentMultiGraph() {
        return this.multiGraphs.stream().filter(multiGraph -> multiGraph.getButtonText().equals(this.getCurrentView())).findFirst().orElse(null);
    }

    private DraggableChartPanel createChartPanel(JFreeChart chart) {
        DraggableChartPanel chartPanel = new DraggableChartPanel(chart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    private JFreeChart createChart(MultiGraph multiGraph) {
        XYDataset dataset = this.constructDataset(multiGraph);
        JFreeChart chart = ChartFactory.createXYLineChart((String)multiGraph.getName(), (String)multiGraph.getXAxisLabel(), (String)multiGraph.getYAxisLabel(), (XYDataset)dataset);
        XYPlot plot = chart.getXYPlot();
        float lineThickness = 3.0f;
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            String seriesKey = (String)((Object)dataset.getSeriesKey(i));
            renderer.setSeriesStroke(i, (Stroke)this.createStrokeForSeries(seriesKey, lineThickness));
        }
        Map<String, Color> baseColors = this.getBaseColors(dataset);
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            String seriesKey = (String)((Object)dataset.getSeriesKey(i));
            String baseName = seriesKey.split(" - ")[0];
            if (!baseColors.containsKey(baseName)) continue;
            renderer.setSeriesPaint(i, (Paint)baseColors.get(baseName));
        }
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.BLACK);
        plot.setDomainGridlinePaint((Paint)Color.BLACK);
        return chart;
    }

    private LegendItemCollection createCustomLegendItems(XYDataset dataset, XYLineAndShapeRenderer renderer, MultiGraph multiGraph) {
        LegendItemCollection legendItems = new LegendItemCollection();
        HashMap<String, Color> baseColors = new HashMap<String, Color>();
        HashSet<String> uniqueBaseNames = new HashSet<String>();
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            String seriesKey = (String)((Object)dataset.getSeriesKey(i));
            String baseName = seriesKey.split(" - ")[0];
            uniqueBaseNames.add(baseName);
        }
        ColorGenerator colorGenerator = new ColorGenerator();
        for (String baseName : uniqueBaseNames) {
            baseColors.put(baseName, colorGenerator.nextColor());
        }
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            String key;
            String seriesKey = (String)((Object)dataset.getSeriesKey(i));
            String baseName = seriesKey.split(" - ")[0];
            if (!seriesKey.contains("Avg") || !seriesKey.contains(this.getCurrentView())) continue;
            Color Color2 = (Color)baseColors.get(baseName);
            Object legendText = baseName;
            Map<String, Double> globalAvgMap = multiGraph.getMultiGraphGlobalAvgMap();
            if (globalAvgMap.containsKey(key = baseName + " Avg " + this.getCurrentView()) && this.showGlobalAverages) {
                legendText = (String)legendText + " (avg=" + String.valueOf(globalAvgMap.get(key)) + ")";
            }
            LegendItem legendItem = new LegendItem((String)legendText, (Paint)Color2);
            legendItems.add(legendItem);
        }
        return legendItems;
    }

    private XYDataset constructDataset(MultiGraph multiGraph) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (Map.Entry<String, Map<String, Graph>> entry : multiGraph.getMultiGraphMap().entrySet()) {
            String observationName = entry.getKey();
            Map<String, Graph> propertyGraphs = entry.getValue();
            for (Map.Entry<String, Graph> propertyGraph : propertyGraphs.entrySet()) {
                String property = propertyGraph.getKey();
                Graph graph = propertyGraph.getValue();
                String seriesKey = observationName + " - " + property;
                XYSeries series = new XYSeries((Comparable)((Object)seriesKey));
                for (GraphPoint point : graph.getPoints()) {
                    series.add(point.getX(), point.getY());
                }
                dataset.addSeries(series);
            }
        }
        return dataset;
    }

    private void setupDialog() {
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    private void addButton(JPanel buttonPanel, CardLayout cardLayout, JPanel cardPanel, String buttonText) {
        JButton button = new JButton(buttonText);
        button.addActionListener(e -> {
            cardLayout.show(cardPanel, buttonText);
            this.currentView = buttonText;
            for (Component comp : cardPanel.getComponents()) {
                if (!(comp instanceof ChartPanel) || !comp.isVisible()) continue;
                this.currentChart = ((ChartPanel)comp).getChart();
                break;
            }
            this.updateVisibility();
            XYPlot plot = this.currentChart.getXYPlot();
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
            plot.setFixedLegendItems(this.createCustomLegendItems(plot.getDataset(), renderer, this.getCurrentMultiGraph()));
        });
        buttonPanel.add(button);
        buttonPanel.setBackground(Color.WHITE);
    }

    public static class GraphDialogBuilder {
        private List<MultiGraph> multiGraphs = new ArrayList<MultiGraph>();
        private String title = "";
        private boolean showGlobalAverages;
        private boolean isSimulate;

        public GraphDialogBuilder addMultiGraphs(List<MultiGraph> multiGraphs) {
            this.multiGraphs.addAll(multiGraphs);
            return this;
        }

        public GraphDialogBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public GraphDialogBuilder showGlobalAverages(boolean showGlobalAverages) {
            this.showGlobalAverages = true;
            return this;
        }

        public GraphDialogBuilder isSimulate(boolean isSimulate) {
            this.isSimulate = isSimulate;
            return this;
        }

        public ObservationGraphDialog build() {
            return new ObservationGraphDialog(this.multiGraphs, this.title, this.showGlobalAverages, this.isSimulate);
        }
    }
}

