/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.graph;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import pipe.gui.graph.AbstractGraph;
import pipe.gui.graph.Graph;

public class MultiGraph
extends AbstractGraph {
    private final Map<String, Map<String, Graph>> multiGraphMap;
    private final Map<String, Double> multiGraphGlobalAvgMap;

    public MultiGraph(String name, String xAxisLabel, String yAxisLabel, String buttonText) {
        this.name = name;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
        this.buttonText = buttonText;
        this.multiGraphMap = new HashMap<String, Map<String, Graph>>();
        this.multiGraphGlobalAvgMap = new HashMap<String, Double>();
    }

    public void addGraph(String observation, String property, Graph graph) {
        this.multiGraphMap.computeIfAbsent(observation, k -> new HashMap()).put(property, graph);
    }

    public void addGlobalAvg(String key, double value) {
        this.multiGraphGlobalAvgMap.put(key, value);
    }

    @Override
    public boolean isEmpty() {
        return this.multiGraphMap.values().stream().allMatch(Map::isEmpty);
    }

    public Map<String, Map<String, Graph>> getMultiGraphMap() {
        return this.multiGraphMap;
    }

    public Map<String, Double> getMultiGraphGlobalAvgMap() {
        return this.multiGraphGlobalAvgMap;
    }

    public List<Graph> getGraphs() {
        return this.multiGraphMap.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(propertyEntry -> {
            Graph graph = (Graph)propertyEntry.getValue();
            graph.setName((String)entry.getKey() + " - " + (String)propertyEntry.getKey());
            return graph;
        })).collect(Collectors.toList());
    }

    public MultiGraph copy() {
        MultiGraph copy = new MultiGraph(this.name, this.xAxisLabel, this.yAxisLabel, this.buttonText);
        this.multiGraphMap.forEach((observation, propertyMap) -> propertyMap.forEach((property, graph) -> copy.addGraph((String)observation, (String)property, (Graph)graph)));
        this.multiGraphGlobalAvgMap.forEach(copy::addGlobalAvg);
        return copy;
    }
}

