/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.graph;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public class DraggableChartPanel
extends ChartPanel {
    private int lastX;
    private int lastY;

    public DraggableChartPanel(JFreeChart chart) {
        super(chart);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DraggableChartPanel.this.lastX = e.getX();
                DraggableChartPanel.this.lastY = e.getY();
                DraggableChartPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                DraggableChartPanel.this.setDomainZoomable(false);
                DraggableChartPanel.this.setRangeZoomable(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DraggableChartPanel.this.setCursor(Cursor.getDefaultCursor());
                DraggableChartPanel.this.setDomainZoomable(true);
                DraggableChartPanel.this.setRangeZoomable(true);
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int deltaX = e.getX() - DraggableChartPanel.this.lastX;
                int deltaY = e.getY() - DraggableChartPanel.this.lastY;
                DraggableChartPanel.this.moveChart(deltaX, deltaY);
                DraggableChartPanel.this.lastX = e.getX();
                DraggableChartPanel.this.lastY = e.getY();
            }
        });
    }

    private void moveChart(int deltaX, int deltaY) {
        Plot plot = this.getChart().getPlot();
        if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            ValueAxis domainAxis = xyPlot.getDomainAxis();
            ValueAxis rangeAxis = xyPlot.getRangeAxis();
            double domainShift = domainAxis.getRange().getLength() * (double)deltaX / (double)this.getWidth();
            double rangeShift = rangeAxis.getRange().getLength() * (double)deltaY / (double)this.getHeight();
            domainAxis.setRange(domainAxis.getLowerBound() - domainShift, domainAxis.getUpperBound() - domainShift);
            rangeAxis.setRange(rangeAxis.getLowerBound() + rangeShift, rangeAxis.getUpperBound() + rangeShift);
        }
    }
}

