/*
 * Decompiled with CFR 0.152.
 */
package pipe.gui.canvas;

import java.awt.geom.AffineTransform;

public class Zoomer {
    private int percent;

    public Zoomer() {
        this(100);
    }

    public Zoomer(int pct) {
        this.percent = pct;
    }

    public boolean zoomOut() {
        return this.setPercent(this.percent - 10);
    }

    public boolean zoomIn() {
        return this.setPercent(this.percent + 10);
    }

    private boolean validZoom(int newPercent) {
        return newPercent <= 300 && newPercent >= 20;
    }

    public int getPercent() {
        return this.percent;
    }

    private boolean setPercent(int newPercent) {
        if (this.validZoom(newPercent)) {
            this.percent = newPercent;
            return true;
        }
        return false;
    }

    public boolean setZoom(int newPercent) {
        return this.setPercent(newPercent);
    }

    public static AffineTransform getTransform(int zoom) {
        return AffineTransform.getScaleInstance((double)zoom * 0.01, (double)zoom * 0.01);
    }

    public static double getScaleFactor(int zoom) {
        return (double)zoom * 0.01;
    }

    public static int getZoomedValue(int x, int zoom) {
        return (int)Math.round((double)(x * zoom) * 0.01);
    }

    @Deprecated
    public static int getZoomedValue(double x, int zoom) {
        return (int)Math.round(x * (double)zoom * 0.01);
    }

    public static int getUnzoomedValue(int x, int zoom) {
        return (int)Math.round((double)x / ((double)zoom * 0.01));
    }

    @Deprecated
    public static int getUnzoomedValue(double x, int zoom) {
        return (int)Math.round(x / ((double)zoom * 0.01));
    }
}

